/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.swift.util;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.swift.exceptions.SwiftConfigurationException;
import org.apache.hadoop.fs.swift.util.SwiftUtils;
import org.junit.Assert;
import org.junit.internal.AssumptionViolatedException;

public class SwiftTestUtils
extends Assert {
    private static final Log LOG = LogFactory.getLog(SwiftTestUtils.class);
    public static final String TEST_FS_SWIFT = "test.fs.swift.name";
    public static final String IO_FILE_BUFFER_SIZE = "io.file.buffer.size";

    public static URI getServiceURI(Configuration conf) throws SwiftConfigurationException {
        String instance = conf.get(TEST_FS_SWIFT);
        if (instance == null) {
            throw new SwiftConfigurationException("Missing configuration entry test.fs.swift.name");
        }
        try {
            return new URI(instance);
        }
        catch (URISyntaxException e) {
            throw new SwiftConfigurationException("Bad URI: " + instance);
        }
    }

    public static boolean hasServiceURI(Configuration conf) {
        String instance = conf.get(TEST_FS_SWIFT);
        return instance != null;
    }

    public static void assertPropertyEquals(Properties props, String key, String expected) {
        String val = props.getProperty(key);
        if (expected == null) {
            SwiftTestUtils.assertNull((String)("Non null property " + key + " = " + val), (Object)val);
        } else {
            SwiftTestUtils.assertEquals((String)("property " + key + " = " + val), (Object)expected, (Object)val);
        }
    }

    public static void writeAndRead(FileSystem fs, Path path, byte[] src, int len, int blocksize, boolean overwrite, boolean delete) throws IOException {
        fs.mkdirs(path.getParent());
        SwiftTestUtils.writeDataset(fs, path, src, len, blocksize, overwrite);
        byte[] dest = SwiftTestUtils.readDataset(fs, path, len);
        SwiftTestUtils.compareByteArrays(src, dest, len);
        if (delete) {
            boolean deleted = fs.delete(path, false);
            SwiftTestUtils.assertTrue((String)"Deleted", (boolean)deleted);
            SwiftTestUtils.assertPathDoesNotExist(fs, "Cleanup failed", path);
        }
    }

    public static void writeDataset(FileSystem fs, Path path, byte[] src, int len, int blocksize, boolean overwrite) throws IOException {
        SwiftTestUtils.assertTrue((String)("Not enough data in source array to write " + len + " bytes"), (src.length >= len ? 1 : 0) != 0);
        FSDataOutputStream out = fs.create(path, overwrite, fs.getConf().getInt(IO_FILE_BUFFER_SIZE, 4096), (short)1, (long)blocksize);
        out.write(src, 0, len);
        out.close();
        SwiftTestUtils.assertFileHasLength(fs, path, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readDataset(FileSystem fs, Path path, int len) throws IOException {
        byte[] dest = new byte[len];
        try (FSDataInputStream in = fs.open(path);){
            in.readFully(0L, dest);
        }
        return dest;
    }

    public static void compareByteArrays(byte[] src, byte[] dest, int len) {
        SwiftTestUtils.assertEquals((String)"Number of bytes read != number written", (long)len, (long)dest.length);
        int errors = 0;
        int first_error_byte = -1;
        for (int i = 0; i < len; ++i) {
            if (src[i] == dest[i]) continue;
            if (errors == 0) {
                first_error_byte = i;
            }
            ++errors;
        }
        if (errors > 0) {
            String message = String.format(" %d errors in file of length %d", errors, len);
            LOG.warn((Object)message);
            int overlap = 10;
            for (int i = Math.max(0, first_error_byte - 10); i < Math.min(first_error_byte + 10, len); ++i) {
                byte actual = dest[i];
                byte expected = src[i];
                String letter = SwiftTestUtils.toChar(actual);
                String line = String.format("[%04d] %2x %s\n", i, actual, letter);
                if (expected != actual) {
                    line = String.format("[%04d] %2x %s -expected %2x %s\n", i, actual, letter, expected, SwiftTestUtils.toChar(expected));
                }
                LOG.warn((Object)line);
            }
            SwiftTestUtils.fail((String)message);
        }
    }

    public static String toChar(byte b) {
        if (b >= 32) {
            return Character.toString((char)b);
        }
        return String.format("%02x", b);
    }

    public static String toChar(byte[] buffer) {
        StringBuilder builder = new StringBuilder(buffer.length);
        for (byte b : buffer) {
            builder.append(SwiftTestUtils.toChar(b));
        }
        return builder.toString();
    }

    public static byte[] toAsciiByteArray(String s) {
        char[] chars = s.toCharArray();
        int len = chars.length;
        byte[] buffer = new byte[len];
        for (int i = 0; i < len; ++i) {
            buffer[i] = (byte)(chars[i] & 0xFF);
        }
        return buffer;
    }

    public static void cleanupInTeardown(FileSystem fileSystem, String cleanupPath) {
        SwiftTestUtils.cleanup("TEARDOWN", fileSystem, cleanupPath);
    }

    public static void cleanup(String action, FileSystem fileSystem, String cleanupPath) {
        SwiftTestUtils.noteAction(action);
        try {
            if (fileSystem != null) {
                fileSystem.delete(new Path(cleanupPath).makeQualified(fileSystem), true);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Error deleting in " + action + " - " + cleanupPath + ": " + e), (Throwable)e);
        }
    }

    public static void noteAction(String action) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==============  " + action + " ============="));
        }
    }

    public static void downgrade(String message, Throwable failure) {
        LOG.warn((Object)("Downgrading test " + message), failure);
        AssumptionViolatedException ave = new AssumptionViolatedException((Object)failure, null);
        throw ave;
    }

    public static void unsupported(String message) {
        throw new AssumptionViolatedException(message);
    }

    public static void skip(String message) {
        throw new AssumptionViolatedException(message);
    }

    public static void assertFileHasLength(FileSystem fs, Path path, int expected) throws IOException {
        FileStatus status = fs.getFileStatus(path);
        SwiftTestUtils.assertEquals((String)("Wrong file length of file " + path + " status: " + status), (long)expected, (long)status.getLen());
    }

    public static void assertIsDirectory(FileSystem fs, Path path) throws IOException {
        FileStatus fileStatus = fs.getFileStatus(path);
        SwiftTestUtils.assertIsDirectory(fileStatus);
    }

    public static void assertIsDirectory(FileStatus fileStatus) {
        SwiftTestUtils.assertTrue((String)("Should be a dir -but isn't: " + fileStatus), (boolean)fileStatus.isDir());
    }

    public static byte[] writeTextFile(FileSystem fs, Path path, String text, boolean overwrite) throws IOException {
        FSDataOutputStream stream = fs.create(path, overwrite);
        byte[] bytes = new byte[]{};
        if (text != null) {
            bytes = SwiftTestUtils.toAsciiByteArray(text);
            stream.write(bytes);
        }
        stream.close();
        return bytes;
    }

    public static void touch(FileSystem fs, Path path) throws IOException {
        fs.delete(path, true);
        SwiftTestUtils.writeTextFile(fs, path, null, false);
    }

    public static void assertDeleted(FileSystem fs, Path file, boolean recursive) throws IOException {
        SwiftTestUtils.assertPathExists(fs, "about to be deleted file", file);
        boolean deleted = fs.delete(file, recursive);
        String dir = SwiftTestUtils.ls(fs, file.getParent());
        SwiftTestUtils.assertTrue((String)("Delete failed on " + file + ": " + dir), (boolean)deleted);
        SwiftTestUtils.assertPathDoesNotExist(fs, "Deleted file", file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readBytesToString(FileSystem fs, Path path, int length) throws IOException {
        try (FSDataInputStream in = fs.open(path);){
            byte[] buf = new byte[length];
            in.readFully(0L, buf);
            String string = SwiftTestUtils.toChar(buf);
            return string;
        }
    }

    public static String getDefaultWorkingDirectory() {
        return "/user/" + System.getProperty("user.name");
    }

    public static String ls(FileSystem fileSystem, Path path) throws IOException {
        return SwiftUtils.ls(fileSystem, path);
    }

    public static String dumpStats(String pathname, FileStatus[] stats) {
        return pathname + SwiftUtils.fileStatsToString(stats, "\n");
    }

    public static void assertIsFile(FileSystem fileSystem, Path filename) throws IOException {
        SwiftTestUtils.assertPathExists(fileSystem, "Expected file", filename);
        FileStatus status = fileSystem.getFileStatus(filename);
        String fileInfo = filename + "  " + status;
        SwiftTestUtils.assertFalse((String)("File claims to be a directory " + fileInfo), (boolean)status.isDir());
    }

    public static byte[] dataset(int len, int base, int modulo) {
        byte[] dataset = new byte[len];
        for (int i = 0; i < len; ++i) {
            dataset[i] = (byte)(base + i % modulo);
        }
        return dataset;
    }

    public static void assertPathExists(FileSystem fileSystem, String message, Path path) throws IOException {
        if (!fileSystem.exists(path)) {
            SwiftTestUtils.fail((String)(message + ": not found " + path + " in " + path.getParent()));
            SwiftTestUtils.ls(fileSystem, path.getParent());
        }
    }

    public static void assertPathDoesNotExist(FileSystem fileSystem, String message, Path path) throws IOException {
        try {
            FileStatus status = fileSystem.getFileStatus(path);
            SwiftTestUtils.fail((String)(message + ": unexpectedly found " + path + " as  " + status));
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    public static void assertListStatusFinds(FileSystem fs, Path dir, Path subdir) throws IOException {
        FileStatus[] stats = fs.listStatus(dir);
        boolean found = false;
        StringBuilder builder = new StringBuilder();
        for (FileStatus stat : stats) {
            builder.append(stat.toString()).append('\n');
            if (!stat.getPath().equals((Object)subdir)) continue;
            found = true;
        }
        SwiftTestUtils.assertTrue((String)("Path " + subdir + " not found in directory " + dir + ":" + builder), (boolean)found);
    }
}

