/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.tools;

import com.google.gson.Gson;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.persistence.FlushModeType;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.cli.CLIParser;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.store.StoreException;

public class OozieDBImportCLI {
    private static final String[] HELP_INFO = new String[]{"", "OozieDBImportCLI reads Oozie database from a zip file."};
    private static final String IMPORT_CMD = "import";
    private static final String HELP_CMD = "help";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws ParseException {
        CLIParser parser = new CLIParser("oozie-setup.sh", HELP_INFO);
        parser.addCommand(HELP_CMD, "", "display usage for all commands or specified command", new Options(), false);
        parser.addCommand(IMPORT_CMD, "", "imports the contents of the Oozie database from the specified file", new Options(), true);
        try {
            CLIParser.Command command = parser.parse(args);
            if (command.getName().equals(IMPORT_CMD)) {
                Services services = new Services();
                services.getConf().set("oozie.services", JPAService.class.getName());
                services.getConf().set("oozie.services.ext", "");
                services.init();
                System.out.println("==========================================================");
                System.out.println(Arrays.toString(command.getCommandLine().getArgs()));
                OozieDBImportCLI.importAllDBTables(command.getCommandLine().getArgs()[0]);
            } else if (command.getName().equals(HELP_CMD)) {
                parser.showHelp(command.getCommandLine());
            }
        }
        catch (ParseException pex) {
            System.err.println("Invalid sub-command: " + pex.getMessage());
            System.err.println();
            System.err.println(parser.shortHelp());
            System.exit(1);
        }
        catch (Throwable e) {
            System.err.println();
            System.err.println("Error: " + e.getMessage());
            System.err.println();
            System.err.println("Stack trace for the error was (for debug purposes):");
            System.err.println("--------------------------------------");
            e.printStackTrace(System.err);
            System.err.println("--------------------------------------");
            System.err.println();
            System.exit(1);
        }
        finally {
            if (Services.get() != null) {
                Services.get().destroy();
            }
        }
    }

    private static void importAllDBTables(String zipFileName) throws StoreException, IOException, JPAExecutorException {
        EntityManager entityManager = null;
        ZipFile zipFile = null;
        try {
            entityManager = ((JPAService)Services.get().get(JPAService.class)).getEntityManager();
            entityManager.setFlushMode(FlushModeType.COMMIT);
            zipFile = new ZipFile(zipFileName);
            OozieDBImportCLI.checkDBVersion(entityManager, zipFile);
            OozieDBImportCLI.importFrom(entityManager, zipFile, "WF_JOBS", WorkflowJobBean.class, "ooziedb_wf.json");
            OozieDBImportCLI.importFrom(entityManager, zipFile, "WF_ACTIONS", WorkflowActionBean.class, "ooziedb_ac.json");
            OozieDBImportCLI.importFrom(entityManager, zipFile, "COORD_JOBS", CoordinatorJobBean.class, "ooziedb_cj.json");
            OozieDBImportCLI.importFrom(entityManager, zipFile, "COORD_ACTIONS", CoordinatorActionBean.class, "ooziedb_ca.json");
            OozieDBImportCLI.importFrom(entityManager, zipFile, "BUNDLE_JOBS", BundleJobBean.class, "ooziedb_bnj.json");
            OozieDBImportCLI.importFrom(entityManager, zipFile, "BUNDLE_ACTIONS", BundleActionBean.class, "ooziedb_bna.json");
            OozieDBImportCLI.importFrom(entityManager, zipFile, "SLA_REGISTRATION", SLARegistrationBean.class, "ooziedb_slareg.json");
            OozieDBImportCLI.importFrom(entityManager, zipFile, "SLA_SUMMARY", SLASummaryBean.class, "ooziedb_slasum.json");
        }
        finally {
            if (entityManager != null) {
                entityManager.close();
            }
            if (zipFile != null) {
                zipFile.close();
            }
        }
    }

    private static void checkDBVersion(EntityManager entityManager, ZipFile zipFile) throws IOException {
        try {
            String line;
            String currentDBVersion = (String)entityManager.createNativeQuery("select data from OOZIE_SYS where name='db.version'").getSingleResult();
            String dumpDBVersion = null;
            ZipEntry entry = zipFile.getEntry("ooziedb_sysinfo.json");
            BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry), "UTF-8"));
            Gson gson = new Gson();
            while ((line = reader.readLine()) != null) {
                List info = (List)gson.fromJson(line, List.class);
                if (info.size() <= 1 || !"db.version".equals(info.get(0))) continue;
                dumpDBVersion = (String)info.get(1);
            }
            reader.close();
            if (currentDBVersion.equals(dumpDBVersion)) {
                System.out.println("Loading to Oozie database version " + currentDBVersion);
            } else {
                System.err.println("ERROR Oozie database version mismatch.");
                System.err.println("Oozie DB version:\t" + currentDBVersion);
                System.err.println("Dump DB version:\t" + dumpDBVersion);
                System.exit(1);
            }
        }
        catch (Exception e) {
            System.err.println();
            System.err.println("Error during DB version check: " + e.getMessage());
            System.err.println();
            System.err.println("Stack trace for the error was (for debug purposes):");
            System.err.println("--------------------------------------");
            e.printStackTrace(System.err);
            System.err.println("--------------------------------------");
            System.err.println();
        }
    }

    private static void importFrom(EntityManager entityManager, ZipFile zipFile, String table, Class<?> clazz, String fileName) throws JPAExecutorException, IOException {
        EntityTransaction transaction = entityManager.getTransaction();
        transaction.begin();
        try {
            int size = OozieDBImportCLI.importFromJSONtoDB(entityManager, zipFile, fileName, clazz);
            transaction.commit();
            System.out.println(size + " rows imported to " + table);
        }
        catch (Exception e) {
            if (transaction.isActive()) {
                transaction.rollback();
            }
            throw new RuntimeException("Import failed to table " + table + ".", e);
        }
    }

    private static <E> int importFromJSONtoDB(EntityManager entityManager, ZipFile zipFile, String filename, Class<E> clazz) throws JPAExecutorException, IOException {
        int wfjSize = 0;
        Gson gson = new Gson();
        ZipEntry entry = zipFile.getEntry(filename);
        if (entry != null) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                Object workflow = gson.fromJson(line, clazz);
                entityManager.persist(workflow);
                ++wfjSize;
            }
            reader.close();
        }
        return wfjSize;
    }
}

