/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.PreconditionException;
import org.apache.oozie.command.StatusTransitXCommand;
import org.apache.oozie.command.bundle.BundleKillXCommand;
import org.apache.oozie.executor.jpa.BundleActionQueryExecutor;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.util.LogUtils;
import org.apache.oozie.util.StatusUtils;

public class BundleStatusTransitXCommand
extends StatusTransitXCommand {
    private String jobId;
    private List<BundleActionBean> bundleActions;
    private BundleJobBean bundleJob;
    private boolean foundPending;
    private HashMap<Job.Status, Integer> bundleActionStatus = new HashMap();

    public BundleStatusTransitXCommand(String id) {
        super("bundle_status_transit", "bundle_status_transit", 0);
        this.jobId = id;
    }

    @Override
    public String getEntityKey() {
        return this.jobId;
    }

    @Override
    protected void loadState() throws CommandException {
        try {
            this.bundleJob = BundleJobQueryExecutor.getInstance().get(BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_ID_STATUS_PENDING_MOD_PAUSE_SUSPEND_TIME, this.jobId);
            this.bundleActions = BundleActionQueryExecutor.getInstance().getList(BundleActionQueryExecutor.BundleActionQuery.GET_BUNDLE_UNIGNORED_ACTION_STATUS_PENDING_FOR_BUNDLE, this.jobId);
            for (BundleActionBean bAction : this.bundleActions) {
                int counter = 0;
                counter = this.bundleActionStatus.containsKey(bAction.getStatus()) ? this.getActionStatusCount(bAction.getStatus()) + 1 : ++counter;
                this.bundleActionStatus.put(bAction.getStatus(), counter);
                if (bAction.getCoordId() == null && (bAction.getStatus() == Job.Status.FAILED || bAction.getStatus() == Job.Status.KILLED)) {
                    new BundleKillXCommand(this.jobId).call();
                    this.bundleJob = BundleJobQueryExecutor.getInstance().get(BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_ID_STATUS_PENDING_MOD_PAUSE_SUSPEND_TIME, this.jobId);
                    this.bundleJob.setStatus(Job.Status.FAILED);
                    this.bundleJob.setLastModifiedTime(new Date());
                    BundleJobQueryExecutor.getInstance().executeUpdate(BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS, this.bundleJob);
                }
                if (!bAction.isPending()) continue;
                this.LOG.debug(bAction + " has pending flag set");
                this.foundPending = true;
            }
            LogUtils.setLogInfo(this.bundleJob);
        }
        catch (JPAExecutorException e) {
            throw new CommandException(ErrorCode.E1322, e);
        }
    }

    @Override
    protected Job.Status getJobStatus() throws CommandException {
        Job.Status jobStatus = super.getJobStatus();
        if (jobStatus == null && this.isPrepRunningState()) {
            return this.getPrepRunningStatus();
        }
        return jobStatus;
    }

    @Override
    protected boolean isTerminalState() {
        return !this.foundPending && this.bundleActions.size() == this.getActionStatusCount(Job.Status.SUCCEEDED) + this.getActionStatusCount(Job.Status.FAILED) + this.getActionStatusCount(Job.Status.KILLED) + this.getActionStatusCount(Job.Status.DONEWITHERROR);
    }

    @Override
    protected Job.Status getTerminalStatus() {
        if (this.bundleJob.getStatus().equals((Object)Job.Status.KILLED)) {
            return Job.Status.KILLED;
        }
        if (this.bundleActions.size() == this.getActionStatusCount(Job.Status.SUCCEEDED)) {
            return Job.Status.SUCCEEDED;
        }
        if (this.bundleActions.size() == this.getActionStatusCount(Job.Status.KILLED)) {
            return Job.Status.KILLED;
        }
        if (this.bundleActions.size() == this.getActionStatusCount(Job.Status.FAILED)) {
            return Job.Status.FAILED;
        }
        return Job.Status.DONEWITHERROR;
    }

    @Override
    protected boolean isPausedState() {
        if (this.bundleJob.getStatus() == Job.Status.PAUSED || this.bundleJob.getStatus() == Job.Status.PAUSEDWITHERROR && this.bundleJob.getPauseTime() != null) {
            return true;
        }
        return this.getBottomUpPauseStatus() != null;
    }

    @Override
    protected Job.Status getPausedState() {
        if (this.bundleJob.getStatus() == Job.Status.PAUSED || this.bundleJob.getStatus() == Job.Status.PAUSEDWITHERROR) {
            if (this.hasTerminatedActions() || this.bundleActionStatus.containsKey(Job.Status.SUSPENDEDWITHERROR) || this.bundleActionStatus.containsKey(Job.Status.RUNNINGWITHERROR) || this.bundleActionStatus.containsKey(Job.Status.PAUSEDWITHERROR)) {
                return Job.Status.PAUSEDWITHERROR;
            }
            return Job.Status.PAUSED;
        }
        return this.getBottomUpPauseStatus();
    }

    @Override
    protected boolean isSuspendedState() {
        if ((this.bundleJob.getStatus() == Job.Status.SUSPENDED || this.bundleJob.getStatus() == Job.Status.SUSPENDEDWITHERROR) && this.bundleJob.getSuspendedTimestamp() != null) {
            return true;
        }
        return this.getBottomUpSuspendedState() != null;
    }

    @Override
    protected Job.Status getSuspendedStatus() {
        if (this.bundleJob.getStatus() == Job.Status.SUSPENDED || this.bundleJob.getStatus() == Job.Status.SUSPENDEDWITHERROR) {
            if (this.hasTerminatedActions() || this.bundleActionStatus.containsKey(Job.Status.SUSPENDEDWITHERROR) || this.bundleActionStatus.containsKey(Job.Status.PAUSEDWITHERROR)) {
                return Job.Status.SUSPENDEDWITHERROR;
            }
            return Job.Status.SUSPENDED;
        }
        return this.getBottomUpSuspendedState();
    }

    @Override
    protected boolean isRunningState() {
        return true;
    }

    @Override
    protected Job.Status getRunningState() {
        if (this.bundleJob.getStatus() != Job.Status.PREP) {
            return this.getRunningStatus(this.bundleActionStatus);
        }
        return null;
    }

    @Override
    protected void updateJobStatus(Job.Status bundleStatus) throws JPAExecutorException {
        this.LOG.info("Set bundle job [" + this.jobId + "] status to '" + bundleStatus + "' from '" + this.bundleJob.getStatus() + "'");
        String jobId = this.bundleJob.getId();
        this.bundleJob.setStatus(StatusUtils.getStatusIfBackwardSupportTrue(bundleStatus));
        this.bundleJob.setLastModifiedTime(new Date());
        if (this.foundPending) {
            this.bundleJob.setPending();
            this.LOG.info("Bundle job [" + jobId + "] Pending set to TRUE");
        } else {
            this.bundleJob.resetPending();
            this.LOG.info("Bundle job [" + jobId + "] Pending set to FALSE");
        }
        BundleJobQueryExecutor.getInstance().executeUpdate(BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING_MODTIME, this.bundleJob);
    }

    private Job.Status getBottomUpPauseStatus() {
        if (this.bundleActionStatus.containsKey(Job.Status.PAUSED) && this.bundleActions.size() == this.getActionStatusCount(Job.Status.PAUSED)) {
            return Job.Status.PAUSED;
        }
        if (this.bundleActionStatus.containsKey(Job.Status.PAUSEDWITHERROR) && this.bundleActions.size() == this.getActionStatusCount(Job.Status.PAUSED) + this.getActionStatusCount(Job.Status.PAUSEDWITHERROR)) {
            return Job.Status.PAUSEDWITHERROR;
        }
        return null;
    }

    private Job.Status getBottomUpSuspendedState() {
        if (!this.foundPending && this.bundleActionStatus.containsKey(Job.Status.SUSPENDED) || this.bundleActionStatus.containsKey(Job.Status.SUSPENDEDWITHERROR)) {
            if (this.bundleActions.size() == this.getActionStatusCount(Job.Status.SUSPENDED) + this.getActionStatusCount(Job.Status.SUCCEEDED)) {
                return Job.Status.SUSPENDED;
            }
            if (this.bundleActions.size() == this.getActionStatusCount(Job.Status.SUSPENDEDWITHERROR) + this.getActionStatusCount(Job.Status.SUSPENDED) + this.getActionStatusCount(Job.Status.SUCCEEDED) + this.getActionStatusCount(Job.Status.KILLED) + this.getActionStatusCount(Job.Status.FAILED) + this.getActionStatusCount(Job.Status.DONEWITHERROR)) {
                return Job.Status.SUSPENDEDWITHERROR;
            }
        }
        return null;
    }

    private boolean hasTerminatedActions() {
        return this.bundleActionStatus.containsKey(Job.Status.KILLED) || this.bundleActionStatus.containsKey(Job.Status.FAILED) || this.bundleActionStatus.containsKey(Job.Status.DONEWITHERROR);
    }

    private boolean isPrepRunningState() {
        return !this.foundPending && this.bundleActionStatus.containsKey(Job.Status.PREP) && this.bundleActions.size() > this.getActionStatusCount(Job.Status.PREP);
    }

    private Job.Status getPrepRunningStatus() {
        return this.getRunningStatus(this.bundleActionStatus);
    }

    private int getActionStatusCount(Job.Status status) {
        if (this.bundleActionStatus.containsKey(status)) {
            return this.bundleActionStatus.get(status);
        }
        return 0;
    }

    private Job.Status getRunningStatus(HashMap<Job.Status, Integer> actionStatus) {
        if (actionStatus.containsKey(Job.Status.FAILED) || actionStatus.containsKey(Job.Status.KILLED) || actionStatus.containsKey(Job.Status.DONEWITHERROR) || actionStatus.containsKey(Job.Status.RUNNINGWITHERROR)) {
            return Job.Status.RUNNINGWITHERROR;
        }
        return Job.Status.RUNNING;
    }

    @Override
    protected void verifyPrecondition() throws CommandException, PreconditionException {
    }
}

