/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.workflow.lite;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.util.ELUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.ParameterVerifier;
import org.apache.oozie.util.ParameterVerifierException;
import org.apache.oozie.util.WritableUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowException;
import org.apache.oozie.workflow.lite.ActionNodeDef;
import org.apache.oozie.workflow.lite.ActionNodeHandler;
import org.apache.oozie.workflow.lite.ControlNodeHandler;
import org.apache.oozie.workflow.lite.DecisionNodeDef;
import org.apache.oozie.workflow.lite.DecisionNodeHandler;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.ForkNodeDef;
import org.apache.oozie.workflow.lite.JoinNodeDef;
import org.apache.oozie.workflow.lite.KillNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.LiteWorkflowValidator;
import org.apache.oozie.workflow.lite.StartNodeDef;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.xml.sax.SAXException;

public class LiteWorkflowAppParser {
    private static final String DECISION_E = "decision";
    private static final String ACTION_E = "action";
    private static final String END_E = "end";
    private static final String START_E = "start";
    private static final String JOIN_E = "join";
    private static final String FORK_E = "fork";
    private static final Object KILL_E = "kill";
    private static final String SLA_INFO = "info";
    private static final String CREDENTIALS = "credentials";
    private static final String GLOBAL = "global";
    private static final String PARAMETERS = "parameters";
    private static final String NAME_A = "name";
    private static final String CRED_A = "cred";
    private static final String USER_RETRY_MAX_A = "retry-max";
    private static final String USER_RETRY_INTERVAL_A = "retry-interval";
    private static final String TO_A = "to";
    private static final String USER_RETRY_POLICY_A = "retry-policy";
    private static final String FORK_PATH_E = "path";
    private static final String FORK_START_A = "start";
    private static final String ACTION_OK_E = "ok";
    private static final String ACTION_ERROR_E = "error";
    private static final String DECISION_SWITCH_E = "switch";
    private static final String DECISION_CASE_E = "case";
    private static final String DECISION_DEFAULT_E = "default";
    private static final String SUBWORKFLOW_E = "sub-workflow";
    private static final String KILL_MESSAGE_E = "message";
    public static final String VALIDATE_FORK_JOIN = "oozie.validate.ForkJoin";
    public static final String WF_VALIDATE_FORK_JOIN = "oozie.wf.validate.ForkJoin";
    public static final String DEFAULT_NAME_NODE = "oozie.actions.default.name-node";
    public static final String DEFAULT_JOB_TRACKER = "oozie.actions.default.job-tracker";
    public static final String OOZIE_GLOBAL = "oozie.wf.globalconf";
    private static final String JOB_TRACKER = "job-tracker";
    private static final String NAME_NODE = "name-node";
    private static final String JOB_XML = "job-xml";
    private static final String CONFIGURATION = "configuration";
    private Schema schema;
    private Class<? extends ControlNodeHandler> controlNodeHandler;
    private Class<? extends DecisionNodeHandler> decisionHandlerClass;
    private Class<? extends ActionNodeHandler> actionHandlerClass;
    private String defaultNameNode;
    private String defaultJobTracker;

    public LiteWorkflowAppParser(Schema schema, Class<? extends ControlNodeHandler> controlNodeHandler, Class<? extends DecisionNodeHandler> decisionHandlerClass, Class<? extends ActionNodeHandler> actionHandlerClass) throws WorkflowException {
        this.schema = schema;
        this.controlNodeHandler = controlNodeHandler;
        this.decisionHandlerClass = decisionHandlerClass;
        this.actionHandlerClass = actionHandlerClass;
        this.defaultNameNode = ConfigurationService.get(DEFAULT_NAME_NODE);
        if (this.defaultNameNode != null) {
            this.defaultNameNode = this.defaultNameNode.trim();
            if (this.defaultNameNode.isEmpty()) {
                this.defaultNameNode = null;
            }
        }
        this.defaultJobTracker = ConfigurationService.get(DEFAULT_JOB_TRACKER);
        if (this.defaultJobTracker != null) {
            this.defaultJobTracker = this.defaultJobTracker.trim();
            if (this.defaultJobTracker.isEmpty()) {
                this.defaultJobTracker = null;
            }
        }
    }

    public LiteWorkflowApp validateAndParse(Reader reader, Configuration jobConf) throws WorkflowException {
        return this.validateAndParse(reader, jobConf, null);
    }

    public LiteWorkflowApp validateAndParse(Reader reader, Configuration jobConf, Configuration configDefault) throws WorkflowException {
        try {
            StringWriter writer = new StringWriter();
            IOUtils.copyCharStream(reader, writer);
            String strDef = writer.toString();
            if (this.schema != null) {
                Validator validator = this.schema.newValidator();
                validator.validate(new StreamSource(new StringReader(strDef)));
            }
            Element wfDefElement = XmlUtils.parseXml(strDef);
            ParameterVerifier.verifyParameters(jobConf, wfDefElement);
            LiteWorkflowApp app = this.parse(strDef, wfDefElement, configDefault, jobConf);
            boolean validateForkJoin = false;
            if (jobConf.getBoolean(WF_VALIDATE_FORK_JOIN, true) && ConfigurationService.getBoolean(VALIDATE_FORK_JOIN)) {
                validateForkJoin = true;
            }
            LiteWorkflowValidator validator = new LiteWorkflowValidator();
            validator.validateWorkflow(app, validateForkJoin);
            return app;
        }
        catch (ParameterVerifierException ex) {
            throw new WorkflowException(ex);
        }
        catch (JDOMException ex) {
            throw new WorkflowException(ErrorCode.E0700, new Object[]{ex.getMessage(), ex});
        }
        catch (SAXException ex) {
            throw new WorkflowException(ErrorCode.E0701, ex.getMessage(), ex);
        }
        catch (IOException ex) {
            throw new WorkflowException(ErrorCode.E0702, ex.getMessage(), ex);
        }
    }

    private LiteWorkflowApp parse(String strDef, Element root, Configuration configDefault, Configuration jobConf) throws WorkflowException {
        Namespace ns = root.getNamespace();
        LiteWorkflowApp def = null;
        GlobalSectionData gData = jobConf.get(OOZIE_GLOBAL) == null ? null : this.getGlobalFromString(jobConf.get(OOZIE_GLOBAL));
        boolean serializedGlobalConf = false;
        for (Element eNode : root.getChildren()) {
            if (eNode.getName().equals("start")) {
                def = new LiteWorkflowApp(root.getAttributeValue(NAME_A), strDef, new StartNodeDef(this.controlNodeHandler, eNode.getAttributeValue(TO_A)));
                continue;
            }
            if (eNode.getName().equals(END_E)) {
                def.addNode(new EndNodeDef(eNode.getAttributeValue(NAME_A), this.controlNodeHandler));
                continue;
            }
            if (eNode.getName().equals(KILL_E)) {
                def.addNode(new KillNodeDef(eNode.getAttributeValue(NAME_A), eNode.getChildText(KILL_MESSAGE_E, ns), this.controlNodeHandler));
                continue;
            }
            if (eNode.getName().equals(FORK_E)) {
                ArrayList<String> paths = new ArrayList<String>();
                for (Object tran : eNode.getChildren(FORK_PATH_E, ns)) {
                    paths.add(tran.getAttributeValue("start"));
                }
                def.addNode(new ForkNodeDef(eNode.getAttributeValue(NAME_A), this.controlNodeHandler, paths));
                continue;
            }
            if (eNode.getName().equals(JOIN_E)) {
                def.addNode(new JoinNodeDef(eNode.getAttributeValue(NAME_A), this.controlNodeHandler, eNode.getAttributeValue(TO_A)));
                continue;
            }
            if (eNode.getName().equals(DECISION_E)) {
                Object tran;
                Element eSwitch = eNode.getChild(DECISION_SWITCH_E, ns);
                ArrayList<String> transitions = new ArrayList<String>();
                tran = eSwitch.getChildren(DECISION_CASE_E, ns).iterator();
                while (tran.hasNext()) {
                    Element e = (Element)tran.next();
                    transitions.add(e.getAttributeValue(TO_A));
                }
                transitions.add(eSwitch.getChild(DECISION_DEFAULT_E, ns).getAttributeValue(TO_A));
                String switchStatement = XmlUtils.prettyPrint(eSwitch).toString();
                def.addNode(new DecisionNodeDef(eNode.getAttributeValue(NAME_A), switchStatement, this.decisionHandlerClass, (List<String>)transitions));
                continue;
            }
            if (ACTION_E.equals(eNode.getName())) {
                String[] transitions = new String[2];
                Element eActionConf = null;
                for (Element elem : eNode.getChildren()) {
                    if (ACTION_OK_E.equals(elem.getName())) {
                        transitions[0] = elem.getAttributeValue(TO_A);
                        continue;
                    }
                    if (ACTION_ERROR_E.equals(elem.getName())) {
                        transitions[1] = elem.getAttributeValue(TO_A);
                        continue;
                    }
                    if (SLA_INFO.equals(elem.getName()) || CREDENTIALS.equals(elem.getName())) continue;
                    if (!serializedGlobalConf && elem.getName().equals(SUBWORKFLOW_E) && elem.getChild("propagate-configuration", ns) != null && gData != null) {
                        serializedGlobalConf = true;
                        jobConf.set(OOZIE_GLOBAL, this.getGlobalString(gData));
                    }
                    eActionConf = elem;
                    if (SUBWORKFLOW_E.equals(elem.getName())) {
                        this.handleDefaultsAndGlobal(gData, null, elem);
                        continue;
                    }
                    this.handleDefaultsAndGlobal(gData, configDefault, elem);
                }
                String credStr = eNode.getAttributeValue(CRED_A);
                String userRetryMaxStr = eNode.getAttributeValue(USER_RETRY_MAX_A);
                String userRetryIntervalStr = eNode.getAttributeValue(USER_RETRY_INTERVAL_A);
                String userRetryPolicyStr = eNode.getAttributeValue(USER_RETRY_POLICY_A);
                try {
                    if (!StringUtils.isEmpty((String)userRetryMaxStr)) {
                        userRetryMaxStr = ELUtils.resolveAppName(userRetryMaxStr, jobConf);
                    }
                    if (!StringUtils.isEmpty((String)userRetryIntervalStr)) {
                        userRetryIntervalStr = ELUtils.resolveAppName(userRetryIntervalStr, jobConf);
                    }
                    if (!StringUtils.isEmpty((String)userRetryPolicyStr)) {
                        userRetryPolicyStr = ELUtils.resolveAppName(userRetryPolicyStr, jobConf);
                    }
                }
                catch (Exception e) {
                    throw new WorkflowException(ErrorCode.E0703, e.getMessage());
                }
                String actionConf = XmlUtils.prettyPrint(eActionConf).toString();
                def.addNode(new ActionNodeDef(eNode.getAttributeValue(NAME_A), actionConf, this.actionHandlerClass, transitions[0], transitions[1], credStr, userRetryMaxStr, userRetryIntervalStr, userRetryPolicyStr));
                continue;
            }
            if (SLA_INFO.equals(eNode.getName()) || CREDENTIALS.equals(eNode.getName())) continue;
            if (eNode.getName().equals(GLOBAL)) {
                if (jobConf.get(OOZIE_GLOBAL) != null) {
                    gData = this.getGlobalFromString(jobConf.get(OOZIE_GLOBAL));
                    this.handleDefaultsAndGlobal(gData, null, eNode);
                }
                gData = this.parseGlobalSection(ns, eNode);
                continue;
            }
            if (eNode.getName().equals(PARAMETERS)) continue;
            throw new WorkflowException(ErrorCode.E0703, eNode.getName());
        }
        return def;
    }

    private GlobalSectionData getGlobalFromString(String globalStr) throws WorkflowException {
        GlobalSectionData globalSectionData = new GlobalSectionData();
        try {
            byte[] data = Base64.decodeBase64((String)globalStr);
            Inflater inflater = new Inflater();
            DataInputStream ois = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(data), inflater));
            globalSectionData.readFields(ois);
            ois.close();
        }
        catch (Exception ex) {
            throw new WorkflowException(ErrorCode.E0700, "Error while processing global section conf");
        }
        return globalSectionData;
    }

    private String getGlobalString(GlobalSectionData globalSectionData) throws WorkflowException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream oos = null;
        try {
            Deflater def = new Deflater();
            oos = new DataOutputStream(new DeflaterOutputStream((OutputStream)baos, def));
            globalSectionData.write(oos);
            oos.close();
        }
        catch (IOException e) {
            throw new WorkflowException(ErrorCode.E0700, "Error while processing global section conf");
        }
        return Base64.encodeBase64String((byte[])baos.toByteArray());
    }

    private void addChildElement(Element parent, Namespace ns, String childName, String childValue) {
        Element child = new Element(childName, ns);
        child.setText(childValue);
        parent.addContent((Content)child);
    }

    private GlobalSectionData parseGlobalSection(Namespace ns, Element global) throws WorkflowException {
        GlobalSectionData gData = null;
        if (global != null) {
            String globalJobTracker = null;
            Element globalJobTrackerElement = global.getChild(JOB_TRACKER, ns);
            if (globalJobTrackerElement != null) {
                globalJobTracker = globalJobTrackerElement.getValue();
            }
            String globalNameNode = null;
            Element globalNameNodeElement = global.getChild(NAME_NODE, ns);
            if (globalNameNodeElement != null) {
                globalNameNode = globalNameNodeElement.getValue();
            }
            ArrayList<String> globalJobXmls = null;
            List globalJobXmlElements = global.getChildren(JOB_XML, ns);
            if (!globalJobXmlElements.isEmpty()) {
                globalJobXmls = new ArrayList<String>(globalJobXmlElements.size());
                for (Element jobXmlElement : globalJobXmlElements) {
                    globalJobXmls.add(jobXmlElement.getText());
                }
            }
            XConfiguration globalConf = null;
            Element globalConfigurationElement = global.getChild(CONFIGURATION, ns);
            if (globalConfigurationElement != null) {
                try {
                    globalConf = new XConfiguration(new StringReader(XmlUtils.prettyPrint(globalConfigurationElement).toString()));
                }
                catch (IOException ioe) {
                    throw new WorkflowException(ErrorCode.E0700, "Error while processing global section conf");
                }
            }
            gData = new GlobalSectionData(globalJobTracker, globalNameNode, globalJobXmls, globalConf);
        }
        return gData;
    }

    private void handleDefaultsAndGlobal(GlobalSectionData gData, Configuration configDefault, Element actionElement) throws WorkflowException {
        ActionExecutor ae = Services.get().get(ActionService.class).getExecutor(actionElement.getName());
        if (ae == null && !GLOBAL.equals(actionElement.getName())) {
            throw new WorkflowException(ErrorCode.E0723, actionElement.getName(), ActionService.class.getName());
        }
        Namespace actionNs = actionElement.getNamespace();
        if (SUBWORKFLOW_E.equals(actionElement.getName()) || "fs".equals(actionElement.getName()) || GLOBAL.equals(actionElement.getName()) || ae.requiresNameNodeJobTracker()) {
            if (actionElement.getChild(NAME_NODE, actionNs) == null) {
                if (gData != null && gData.nameNode != null) {
                    this.addChildElement(actionElement, actionNs, NAME_NODE, gData.nameNode);
                } else if (this.defaultNameNode != null) {
                    this.addChildElement(actionElement, actionNs, NAME_NODE, this.defaultNameNode);
                } else if (!(SUBWORKFLOW_E.equals(actionElement.getName()) || "fs".equals(actionElement.getName()) || GLOBAL.equals(actionElement.getName()))) {
                    throw new WorkflowException(ErrorCode.E0701, "No name-node defined");
                }
            }
            if (actionElement.getChild(JOB_TRACKER, actionNs) == null && !"fs".equals(actionElement.getName())) {
                if (gData != null && gData.jobTracker != null) {
                    this.addChildElement(actionElement, actionNs, JOB_TRACKER, gData.jobTracker);
                } else if (this.defaultJobTracker != null) {
                    this.addChildElement(actionElement, actionNs, JOB_TRACKER, this.defaultJobTracker);
                } else if (!SUBWORKFLOW_E.equals(actionElement.getName()) && !GLOBAL.equals(actionElement.getName())) {
                    throw new WorkflowException(ErrorCode.E0701, "No job-tracker defined");
                }
            }
        }
        if (GLOBAL.equals(actionElement.getName()) || ae.supportsConfigurationJobXML()) {
            List actionJobXmls = actionElement.getChildren(JOB_XML, actionNs);
            if (gData != null && gData.jobXmls != null) {
                for (String gJobXml : gData.jobXmls) {
                    boolean alreadyExists = false;
                    for (Element actionXml : actionJobXmls) {
                        if (!gJobXml.equals(actionXml.getText())) continue;
                        alreadyExists = true;
                        break;
                    }
                    if (alreadyExists) continue;
                    Element ejobXml = new Element(JOB_XML, actionNs);
                    ejobXml.setText(gJobXml);
                    actionElement.addContent((Content)ejobXml);
                }
            }
            try {
                Element actionConfiguration;
                XConfiguration actionConf = new XConfiguration();
                if (configDefault != null) {
                    XConfiguration.copy(configDefault, actionConf);
                }
                if (gData != null && gData.conf != null) {
                    XConfiguration.copy(gData.conf, actionConf);
                }
                if ((actionConfiguration = actionElement.getChild(CONFIGURATION, actionNs)) != null) {
                    XConfiguration.copy(new XConfiguration(new StringReader(XmlUtils.prettyPrint(actionConfiguration).toString())), actionConf);
                }
                int position = actionElement.indexOf((Content)actionConfiguration);
                actionElement.removeContent((Content)actionConfiguration);
                Element eConfXml = XmlUtils.parseXml(actionConf.toXmlString(false));
                eConfXml.detach();
                eConfXml.setNamespace(actionNs);
                if (position > 0) {
                    actionElement.addContent(position, (Content)eConfXml);
                } else {
                    actionElement.addContent((Content)eConfXml);
                }
            }
            catch (IOException e) {
                throw new WorkflowException(ErrorCode.E0700, "Error while processing action conf");
            }
            catch (JDOMException e) {
                throw new WorkflowException(ErrorCode.E0700, "Error while processing action conf");
            }
        }
    }

    private class GlobalSectionData
    implements Writable {
        String jobTracker;
        String nameNode;
        List<String> jobXmls;
        Configuration conf;

        public GlobalSectionData() {
        }

        public GlobalSectionData(String jobTracker, String nameNode, List<String> jobXmls, Configuration conf) {
            this.jobTracker = jobTracker;
            this.nameNode = nameNode;
            this.jobXmls = jobXmls;
            this.conf = conf;
        }

        public void write(DataOutput dataOutput) throws IOException {
            WritableUtils.writeStr(dataOutput, this.jobTracker);
            WritableUtils.writeStr(dataOutput, this.nameNode);
            if (this.jobXmls != null && !this.jobXmls.isEmpty()) {
                dataOutput.writeInt(this.jobXmls.size());
                for (String content : this.jobXmls) {
                    WritableUtils.writeStr(dataOutput, content);
                }
            } else {
                dataOutput.writeInt(0);
            }
            if (this.conf != null) {
                WritableUtils.writeStr(dataOutput, XmlUtils.prettyPrint(this.conf).toString());
            } else {
                WritableUtils.writeStr(dataOutput, null);
            }
        }

        public void readFields(DataInput dataInput) throws IOException {
            String confString;
            this.jobTracker = WritableUtils.readStr(dataInput);
            this.nameNode = WritableUtils.readStr(dataInput);
            int length = dataInput.readInt();
            if (length > 0) {
                this.jobXmls = new ArrayList<String>();
                for (int i = 0; i < length; ++i) {
                    this.jobXmls.add(WritableUtils.readStr(dataInput));
                }
            }
            if ((confString = WritableUtils.readStr(dataInput)) != null) {
                this.conf = new XConfiguration(new StringReader(confString));
            }
        }
    }
}

