/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;

public class ForTestingActionExecutor
extends ActionExecutor {
    public static final String TEST_ERROR = "TEST_ERROR";

    protected ForTestingActionExecutor() {
        super("test");
    }

    public void initActionType() {
    }

    private Element getConfiguration(String strConf) throws ActionExecutorException {
        try {
            return XmlUtils.parseXml((String)strConf);
        }
        catch (JDOMException ex) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, TEST_ERROR, ex.getMessage(), new Object[]{ex});
        }
    }

    public void start(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        Namespace ns;
        Element eConf = this.getConfiguration(action.getConf());
        String error = eConf.getChild("error", ns = eConf.getNamespace()).getText().trim();
        if ("start.transient".equals(error)) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.TRANSIENT, TEST_ERROR, "start");
        }
        if ("start.non-transient".equals(error)) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.NON_TRANSIENT, TEST_ERROR, "start");
        }
        if ("start.error".equals(error)) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, TEST_ERROR, "start");
        }
        String externalStatus = eConf.getChild("external-status", ns).getText().trim();
        String runningMode = "sync";
        Element runningModeElement = eConf.getChild("running-mode", ns);
        if (null != runningModeElement && runningModeElement.getText().trim().equals("async")) {
            runningMode = "async";
        }
        if (runningMode.equals("async")) {
            context.setStartData("blah", "blah", "blah");
            return;
        }
        boolean callSetExecutionData = true;
        Element setStartData = eConf.getChild("avoid-set-execution-data", ns);
        if (null != setStartData && setStartData.getText().trim().equals("true")) {
            callSetExecutionData = false;
        }
        if (callSetExecutionData) {
            context.setExecutionData(externalStatus, null);
        }
    }

    public void end(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        Namespace ns;
        Element eConf = this.getConfiguration(action.getConf());
        String error = eConf.getChild("error", ns = eConf.getNamespace()).getText().trim();
        if ("end.transient".equals(error)) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.TRANSIENT, TEST_ERROR, "end");
        }
        if ("end.non-transient".equals(error)) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.NON_TRANSIENT, TEST_ERROR, "end");
        }
        if ("end.error".equals(error)) {
            throw new ActionExecutorException(ActionExecutorException.ErrorType.ERROR, TEST_ERROR, "end");
        }
        String signalValue = eConf.getChild("signal-value", ns).getText().trim();
        String externalStatus = action.getExternalStatus();
        WorkflowAction.Status status = null;
        status = externalStatus.equals("ok") ? WorkflowAction.Status.OK : WorkflowAction.Status.ERROR;
        if (signalValue.equals("based_on_action_status")) {
            signalValue = status.toString();
        }
        boolean callSetEndData = true;
        Element setEndData = eConf.getChild("avoid-set-end-data", ns);
        if (null != setEndData && setEndData.getText().trim().equals("true")) {
            callSetEndData = false;
        }
        if (callSetEndData) {
            context.setEndData(status, signalValue);
        }
    }

    public void check(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
        context.setExecutionData("ok", null);
    }

    public void kill(ActionExecutor.Context context, WorkflowAction action) throws ActionExecutorException {
    }

    public boolean isCompleted(String externalStatus) {
        return false;
    }
}

