/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import junit.framework.TestCase;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.BundleEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.WorkflowJob;

public class TestBundleEngineSimple
extends TestCase {
    public void testGetCoordJob1() {
        BundleEngine be = new BundleEngine();
        try {
            CoordinatorJob cj = be.getCoordJob("foo");
            TestBundleEngineSimple.fail((String)"Expected BundleEngineException was not thrown.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((Object)ErrorCode.E0301, (Object)bee.getErrorCode());
        }
    }

    public void testGetCoordJob4() {
        BundleEngine be = new BundleEngine();
        try {
            CoordinatorJob cj = be.getCoordJob("foo", "filter", 0, 1, false);
            TestBundleEngineSimple.fail((String)"Expected BundleEngineException was not thrown.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((Object)ErrorCode.E0301, (Object)bee.getErrorCode());
        }
    }

    public void testGetJob1() {
        BundleEngine be = new BundleEngine();
        try {
            WorkflowJob wj = be.getJob("foo");
            TestBundleEngineSimple.fail((String)"Expected BundleEngineException was not thrown.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((Object)ErrorCode.E0301, (Object)bee.getErrorCode());
        }
    }

    public void testGetJob3() {
        BundleEngine be = new BundleEngine();
        try {
            WorkflowJob wj = be.getJob("foo", 0, 1);
            TestBundleEngineSimple.fail((String)"Expected BundleEngineException was not thrown.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((Object)ErrorCode.E0301, (Object)bee.getErrorCode());
        }
    }

    public void testReRun2() {
        BundleEngine be = new BundleEngine();
        try {
            Configuration c = new Configuration();
            be.reRun("foo", c);
            TestBundleEngineSimple.fail((String)"Expected BundleEngineException was not thrown.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((Object)ErrorCode.E0301, (Object)bee.getErrorCode());
        }
    }

    public void testGetJobForExternalId() throws BundleEngineException {
        BundleEngine be = new BundleEngine();
        String job = be.getJobIdForExternalId("externalFoo");
        TestBundleEngineSimple.assertNull((Object)job);
    }

    public void testParseFilterNegative() {
        BundleEngine be = new BundleEngine();
        try {
            be.parseFilter("winniethepooh");
            TestBundleEngineSimple.fail((String)"BundleEngineException expected.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            be.parseFilter("xx=yy=zz");
            TestBundleEngineSimple.fail((String)"BundleEngineException expected.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            be.parseFilter("foo=moo");
            TestBundleEngineSimple.fail((String)"BundleEngineException expected.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            be.parseFilter("status=foo");
            TestBundleEngineSimple.fail((String)"BundleEngineException expected.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
    }

    public void testParseBulkFilterNegative() {
        try {
            BundleEngine.parseBulkFilter((String)"xx=yy=zz");
            TestBundleEngineSimple.fail((String)"BundleEngineException expected.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((String)bee.toString(), (Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            BundleEngine.parseBulkFilter((String)"winniethepooh");
            TestBundleEngineSimple.fail((String)"BundleEngineException expected.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((String)bee.toString(), (Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            BundleEngine.parseBulkFilter((String)"bundle=aaa, ,bbb");
            TestBundleEngineSimple.fail((String)"BundleEngineException expected.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((String)bee.toString(), (Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            BundleEngine.parseBulkFilter((String)"startcreatedtime=blah-blah");
            TestBundleEngineSimple.fail((String)"BundleEngineException expected.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((String)bee.toString(), (Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            BundleEngine.parseBulkFilter((String)"actionstatus=foo");
            TestBundleEngineSimple.fail((String)"BundleEngineException expected.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((String)bee.toString(), (Object)ErrorCode.E0420, (Object)bee.getErrorCode());
        }
        try {
            BundleEngine.parseBulkFilter((String)"filterlevel=foo");
            TestBundleEngineSimple.fail((String)"BundleEngineException expected.");
        }
        catch (BundleEngineException bee) {
            TestBundleEngineSimple.assertEquals((String)bee.toString(), (Object)ErrorCode.E0305, (Object)bee.getErrorCode());
        }
    }
}

