/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;

public class TestCoordinatorJobBean
extends XTestCase {
    private static final Date ct = new Date(1L);
    private static final Date et = new Date(2L);
    private static final Date st = new Date(3L);
    private static final Date lat = new Date(4L);
    private static final Date lmt = new Date(5L);
    private static final Date nmt = new Date(6L);
    private static final Date pt = new Date(7L);
    private static final Date spt = new Date(8L);
    private static final List<CoordinatorActionBean> actionList = Collections.singletonList(new CoordinatorActionBean());
    private static final CoordinatorJob.Execution execution = CoordinatorJob.Execution.LIFO;

    private void set(CoordinatorJobBean bean) {
        bean.setActions(actionList);
        bean.setAppName("an");
        bean.setAppNamespace("ans");
        bean.setAppPath("ap");
        bean.setBundleId("bi");
        bean.setConcurrency(2);
        bean.setConf("c");
        bean.setConsoleUrl("cu");
        bean.setCreatedTime(ct);
        bean.setDoneMaterialization();
        bean.setEndTime(et);
        bean.setEndTimestamp(DateUtils.convertDateToTimestamp((Date)et));
        bean.setExecutionOrder(execution);
        bean.setExternalId("ei");
        bean.setFrequency("3");
        bean.setGroup("group");
        bean.setId("id");
        bean.setJobXml("jx");
        bean.setLastActionNumber(4);
        bean.setLastActionTime(lat);
        bean.setLastActionTimestamp(DateUtils.convertDateToTimestamp((Date)lat));
        bean.setLastModifiedTime(lmt);
        bean.setLastModifiedTimestamp(DateUtils.convertDateToTimestamp((Date)lmt));
        bean.setMatThrottling(10);
        bean.setNextMaterializedTime(nmt);
        bean.setNextMaterializedTimestamp(DateUtils.convertDateToTimestamp((Date)nmt));
        bean.setOrigJobXml("ojx");
        bean.setPauseTime(pt);
        bean.setPending();
        bean.setSlaXml("sx");
        bean.setStartTime(st);
        bean.setStartTimestamp(DateUtils.convertDateToTimestamp((Date)st));
        bean.setStatus(Job.Status.KILLED);
        bean.setSuspendedTime(spt);
        bean.setSuspendedTimestamp(DateUtils.convertDateToTimestamp((Date)spt));
        bean.setTimeout(11);
        bean.setTimeUnit(CoordinatorJob.Timeunit.MINUTE);
        bean.setTimeZone("GMT");
        bean.setUser("u");
    }

    public void testSetGet() {
        CoordinatorJobBean bean = new CoordinatorJobBean();
        this.set(bean);
        this._testGet(bean, true);
    }

    private void _testGet(CoordinatorJobBean bean, boolean checkDeserialization) {
        if (checkDeserialization) {
            TestCoordinatorJobBean.assertEquals(actionList, (Object)bean.getActions());
        }
        TestCoordinatorJobBean.assertEquals((String)"an", (String)bean.getAppName());
        TestCoordinatorJobBean.assertEquals((String)"ans", (String)bean.getAppNamespace());
        TestCoordinatorJobBean.assertEquals((String)"ap", (String)bean.getAppPath());
        if (checkDeserialization) {
            TestCoordinatorJobBean.assertEquals((String)"bi", (String)bean.getBundleId());
        }
        TestCoordinatorJobBean.assertEquals((int)2, (int)bean.getConcurrency());
        TestCoordinatorJobBean.assertEquals((String)"c", (String)bean.getConf());
        if (checkDeserialization) {
            TestCoordinatorJobBean.assertEquals((String)"cu", (String)bean.getConsoleUrl());
            TestCoordinatorJobBean.assertEquals((Object)ct, (Object)bean.getCreatedTime());
        }
        TestCoordinatorJobBean.assertEquals((boolean)true, (boolean)bean.isDoneMaterialization());
        TestCoordinatorJobBean.assertEquals((Object)et, (Object)bean.getEndTime());
        TestCoordinatorJobBean.assertEquals((Object)DateUtils.convertDateToTimestamp((Date)et), (Object)bean.getEndTimestamp());
        if (checkDeserialization) {
            TestCoordinatorJobBean.assertEquals((String)execution.toString(), (String)bean.getExecution());
        }
        TestCoordinatorJobBean.assertEquals((Object)execution, (Object)bean.getExecutionOrder());
        TestCoordinatorJobBean.assertEquals((String)"ei", (String)bean.getExternalId());
        TestCoordinatorJobBean.assertEquals((String)"3", (String)bean.getFrequency());
        TestCoordinatorJobBean.assertEquals((String)"group", (String)bean.getGroup());
        TestCoordinatorJobBean.assertEquals((String)"id", (String)bean.getId());
        if (checkDeserialization) {
            TestCoordinatorJobBean.assertEquals((String)"jx", (String)bean.getJobXml());
            TestCoordinatorJobBean.assertEquals((int)4, (int)bean.getLastActionNumber());
        }
        TestCoordinatorJobBean.assertEquals((Object)lat, (Object)bean.getLastActionTime());
        TestCoordinatorJobBean.assertEquals((Object)DateUtils.convertDateToTimestamp((Date)lat), (Object)bean.getLastActionTimestamp());
        if (checkDeserialization) {
            TestCoordinatorJobBean.assertEquals((Object)lmt, (Object)bean.getLastModifiedTime());
            TestCoordinatorJobBean.assertEquals((Object)DateUtils.convertDateToTimestamp((Date)lmt), (Object)bean.getLastModifiedTimestamp());
        }
        TestCoordinatorJobBean.assertEquals((int)10, (int)bean.getMatThrottling());
        TestCoordinatorJobBean.assertEquals((Object)nmt, (Object)bean.getNextMaterializedTime());
        TestCoordinatorJobBean.assertEquals((Object)DateUtils.convertDateToTimestamp((Date)nmt), (Object)bean.getNextMaterializedTimestamp());
        if (checkDeserialization) {
            TestCoordinatorJobBean.assertEquals((String)"ojx", (String)bean.getOrigJobXml());
            TestCoordinatorJobBean.assertEquals((Object)pt, (Object)bean.getPauseTime());
        }
        TestCoordinatorJobBean.assertEquals((boolean)true, (boolean)bean.isPending());
        if (checkDeserialization) {
            TestCoordinatorJobBean.assertEquals((String)"sx", (String)bean.getSlaXml());
        }
        TestCoordinatorJobBean.assertEquals((Object)st, (Object)bean.getStartTime());
        TestCoordinatorJobBean.assertEquals((Object)DateUtils.convertDateToTimestamp((Date)st), (Object)bean.getStartTimestamp());
        TestCoordinatorJobBean.assertEquals((Object)Job.Status.KILLED, (Object)bean.getStatus());
        if (checkDeserialization) {
            TestCoordinatorJobBean.assertEquals((Object)spt, (Object)bean.getSuspendedTime());
            TestCoordinatorJobBean.assertEquals((Object)DateUtils.convertDateToTimestamp((Date)spt), (Object)bean.getSuspendedTimestamp());
        }
        TestCoordinatorJobBean.assertEquals((int)11, (int)bean.getTimeout());
        TestCoordinatorJobBean.assertEquals((Object)CoordinatorJob.Timeunit.MINUTE, (Object)bean.getTimeUnit());
        TestCoordinatorJobBean.assertEquals((String)"GMT", (String)bean.getTimeZone());
        TestCoordinatorJobBean.assertEquals((String)"u", (String)bean.getUser());
    }

    public void testSerialization() throws IOException {
        CoordinatorJobBean bean = new CoordinatorJobBean();
        this.set(bean);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        bean.write((DataOutput)dos);
        dos.close();
        CoordinatorJobBean bean2 = new CoordinatorJobBean();
        bean2.readFields((DataInput)new DataInputStream(new ByteArrayInputStream(baos.toByteArray())));
        this._testGet(bean2, false);
    }
}

