/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.DagELFunctions;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.ActionEndXCommand;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ELService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;

public class TestDagELFunctions
extends XDataTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Services services = new Services();
        services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testFunctions() throws Exception {
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", "appPath");
        conf.set("user.name", "user");
        conf.set("a", "A");
        LiteWorkflowApp def = new LiteWorkflowApp("name", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        LiteWorkflowInstance job = new LiteWorkflowInstance(def, (Configuration)conf, "wfId");
        WorkflowJobBean wf = new WorkflowJobBean();
        wf.setId(job.getId());
        wf.setAppName("name");
        wf.setAppPath("appPath");
        wf.setUser("user");
        wf.setGroup("group");
        wf.setWorkflowInstance((WorkflowInstance)job);
        wf.setRun(2);
        wf.setProtoActionConf(conf.toXmlString());
        WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setName("actionName");
        action.setErrorInfo("ec", "em");
        action.setData("b=B");
        action.setExternalId("ext");
        action.setTrackerUri("tracker");
        action.setExternalStatus("externalStatus");
        ELEvaluator eval = ((ELService)Services.get().get(ELService.class)).createEvaluator("workflow");
        DagELFunctions.configureEvaluator((ELEvaluator)eval, (WorkflowJobBean)wf, (WorkflowActionBean)action);
        TestDagELFunctions.assertEquals((String)"wfId", (String)((String)eval.evaluate("${wf:id()}", String.class)));
        TestDagELFunctions.assertEquals((String)"name", (String)((String)eval.evaluate("${wf:name()}", String.class)));
        TestDagELFunctions.assertEquals((String)"appPath", (String)((String)eval.evaluate("${wf:appPath()}", String.class)));
        TestDagELFunctions.assertEquals((String)"A", (String)((String)eval.evaluate("${wf:conf('a')}", String.class)));
        TestDagELFunctions.assertEquals((String)"A", (String)((String)eval.evaluate("${a}", String.class)));
        TestDagELFunctions.assertEquals((String)"user", (String)((String)eval.evaluate("${wf:user()}", String.class)));
        TestDagELFunctions.assertEquals((String)"group", (String)((String)eval.evaluate("${wf:group()}", String.class)));
        TestDagELFunctions.assertTrue((boolean)((String)eval.evaluate("${wf:callback('XX')}", String.class)).contains("id=actionId"));
        TestDagELFunctions.assertTrue((boolean)((String)eval.evaluate("${wf:callback('XX')}", String.class)).contains("status=XX"));
        TestDagELFunctions.assertTrue((boolean)((String)eval.evaluate("${wf:callback('XX')}", String.class)).contains("status=XX"));
        TestDagELFunctions.assertEquals((int)2, (int)((Integer)eval.evaluate("${wf:run()}", Integer.class)));
        action.setStatus(WorkflowAction.Status.ERROR);
        System.out.println("WorkflowInstance " + wf.getWorkflowInstance().getStatus().toString());
        WorkflowInstance wfInstance = wf.getWorkflowInstance();
        DagELFunctions.setActionInfo((WorkflowInstance)wfInstance, (WorkflowAction)action);
        wf.setWorkflowInstance(wfInstance);
        TestDagELFunctions.assertEquals((String)"actionName", (String)((String)eval.evaluate("${wf:lastErrorNode()}", String.class)));
        TestDagELFunctions.assertEquals((String)"ec", (String)((String)eval.evaluate("${wf:errorCode('actionName')}", String.class)));
        TestDagELFunctions.assertEquals((String)"em", (String)((String)eval.evaluate("${wf:errorMessage('actionName')}", String.class)));
        TestDagELFunctions.assertEquals((String)"B", (String)((String)eval.evaluate("${wf:actionData('actionName')['b']}", String.class)));
        String expected = XmlUtils.escapeCharsForXML((String)"{\"b\":\"B\"}");
        TestDagELFunctions.assertEquals((String)expected, (String)((String)eval.evaluate("${toJsonStr(wf:actionData('actionName'))}", String.class)));
        expected = XmlUtils.escapeCharsForXML((String)"b=B");
        TestDagELFunctions.assertTrue((boolean)((String)eval.evaluate("${toPropertiesStr(wf:actionData('actionName'))}", String.class)).contains(expected));
        conf = new XConfiguration();
        conf.set("b", "B");
        expected = XmlUtils.escapeCharsForXML((String)XmlUtils.prettyPrint((Configuration)conf).toString());
        TestDagELFunctions.assertTrue((boolean)((String)eval.evaluate("${toConfigurationStr(wf:actionData('actionName'))}", String.class)).contains(expected));
        TestDagELFunctions.assertEquals((String)"ext", (String)((String)eval.evaluate("${wf:actionExternalId('actionName')}", String.class)));
        TestDagELFunctions.assertEquals((String)"tracker", (String)((String)eval.evaluate("${wf:actionTrackerUri('actionName')}", String.class)));
        TestDagELFunctions.assertEquals((String)"externalStatus", (String)((String)eval.evaluate("${wf:actionExternalStatus('actionName')}", String.class)));
    }

    public void testLastErrorNodeWithRetrySucceed() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.END_RETRY, true);
        action.setType("java");
        action.setExternalStatus("FAILED");
        action.setErrorInfo("JA018", "some error occurred");
        WorkflowActionQueryExecutor.getInstance().executeUpdate((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION, (Object)action);
        new ActionEndXCommandIgnoreSignalException(action.getId(), action.getType()).call();
        ELEvaluator eval = ((ELService)Services.get().get(ELService.class)).createEvaluator("workflow");
        job = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{job.getId()});
        action = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{action.getId()});
        DagELFunctions.configureEvaluator((ELEvaluator)eval, (WorkflowJobBean)job, (WorkflowActionBean)action);
        TestDagELFunctions.assertEquals((String)"", (String)((String)eval.evaluate("${wf:lastErrorNode()}", String.class)));
        action.setExternalStatus("SUCCEEDED");
        action.setStatus(WorkflowAction.Status.DONE);
        WorkflowActionQueryExecutor.getInstance().executeUpdate((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION, (Object)action);
        new ActionEndXCommandIgnoreSignalException(action.getId(), action.getType()).call();
        job = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{job.getId()});
        action = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{action.getId()});
        TestDagELFunctions.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        DagELFunctions.configureEvaluator((ELEvaluator)eval, (WorkflowJobBean)job, (WorkflowActionBean)action);
        TestDagELFunctions.assertEquals((String)"", (String)((String)eval.evaluate("${wf:lastErrorNode()}", String.class)));
    }

    public void testLastErrorNodeWithRetryFail() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.END_RETRY, true);
        action.setType("java");
        action.setExternalStatus("FAILED");
        action.setErrorInfo("JA018", "some error occurred");
        WorkflowActionQueryExecutor.getInstance().executeUpdate((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION, (Object)action);
        new ActionEndXCommandIgnoreSignalException(action.getId(), action.getType()).call();
        ELEvaluator eval = ((ELService)Services.get().get(ELService.class)).createEvaluator("workflow");
        job = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{job.getId()});
        action = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{action.getId()});
        DagELFunctions.configureEvaluator((ELEvaluator)eval, (WorkflowJobBean)job, (WorkflowActionBean)action);
        TestDagELFunctions.assertEquals((String)"", (String)((String)eval.evaluate("${wf:lastErrorNode()}", String.class)));
        action.setExternalStatus("FAILED");
        action.setErrorInfo("JA018", "some error occurred");
        action.setStatus(WorkflowAction.Status.END_RETRY);
        action.setUserRetryCount(action.getUserRetryMax());
        WorkflowActionQueryExecutor.getInstance().executeUpdate((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION, (Object)action);
        new ActionEndXCommandIgnoreSignalException(action.getId(), action.getType()).call();
        job = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{job.getId()});
        action = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{action.getId()});
        TestDagELFunctions.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)action.getStatus());
        DagELFunctions.configureEvaluator((ELEvaluator)eval, (WorkflowJobBean)job, (WorkflowActionBean)action);
        TestDagELFunctions.assertEquals((String)action.getName(), (String)((String)eval.evaluate("${wf:lastErrorNode()}", String.class)));
    }

    private class ActionEndXCommandIgnoreSignalException
    extends ActionEndXCommand {
        public ActionEndXCommandIgnoreSignalException(String actionId, String type) {
            super(actionId, type);
        }

        protected Void execute() throws CommandException {
            try {
                return super.execute();
            }
            catch (CommandException ce) {
                if (!(ce.getCause() instanceof IllegalArgumentException) || !ce.getMessage().equals("E0607: Other error in operation [signal], executionPath cannot be empty")) {
                    throw ce;
                }
                return null;
            }
        }
    }
}

