/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.DagEngine;
import org.apache.oozie.ForTestingActionExecutor;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;

public class TestDagEngine
extends XTestCase {
    private EmbeddedServletContainer container;
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        CallbackServlet.reset();
        this.container = new EmbeddedServletContainer("oozie");
        this.container.addServletEndpoint("/callback", CallbackServlet.class);
        this.container.start();
        this.setSystemProperty("oozie.service.SchemaService.wf.ext.schemas", "wf-ext-schema.xsd");
        this.services = new Services();
        this.services.init();
        ((ActionService)this.services.get(ActionService.class)).registerAndInitExecutor(ForTestingActionExecutor.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        this.container.stop();
        super.tearDown();
    }

    public void testSubmit() throws Exception {
        String workflowPath = this.getTestCaseFileUri("workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        FileOutputStream os = new FileOutputStream(new File(this.getTestCaseDir(), "config-default.xml"));
        XConfiguration defaultConf = new XConfiguration();
        defaultConf.set("a", "AA");
        defaultConf.set("b", "BB");
        defaultConf.set("e", "${d}${d}");
        defaultConf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        DagEngine engine = new DagEngine(TestDagEngine.getTestUser());
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", workflowPath);
        conf.set("user.name", TestDagEngine.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("oozie.wf.action.notification.url", this.container.getServletURL("/callback") + "?jobId=$jobId&status=$status&nodeName=$nodeName");
        conf.set("signal-value", "OK");
        conf.set("external-status", "ok");
        conf.set("error", "end.error");
        conf.set("b", "B");
        conf.set("c", "C");
        conf.set("d", "${c}${c}");
        conf.set("f", "${e}${e}");
        final String jobId1 = engine.submitJob((Configuration)conf, true);
        WorkflowJob wf = engine.getJob(jobId1);
        XConfiguration wfConf = new XConfiguration((Reader)new StringReader(wf.getConf()));
        TestDagEngine.assertEquals((String)"AA", (String)wfConf.get("a"));
        TestDagEngine.assertEquals((String)"B", (String)wfConf.get("b"));
        TestDagEngine.assertEquals((String)"C", (String)conf.get("c"));
        TestDagEngine.assertEquals((String)"CC", (String)conf.get("d"));
        TestDagEngine.assertEquals((String)"CCCC", (String)conf.get("e"));
        TestDagEngine.assertEquals((String)"CCCCCCCC", (String)conf.get("f"));
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJobBean bean = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create().getWorkflow(jobId1, false);
                return bean.getWorkflowInstance().getStatus().isEndState();
            }
        });
        TestDagEngine.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)engine.getJob(jobId1).getStatus());
        this.waitFor(10000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return CallbackServlet.JOB_ID != null;
            }
        });
        TestDagEngine.assertEquals((String)wf.getId(), (String)CallbackServlet.JOB_ID);
        TestDagEngine.assertTrue(("kill".equals(CallbackServlet.NODE_NAME) || "a".equals(CallbackServlet.NODE_NAME) ? 1 : 0) != 0);
        TestDagEngine.assertTrue(("T:null".equals(CallbackServlet.STATUS) || "T:kill".equals(CallbackServlet.STATUS) ? 1 : 0) != 0);
    }

    public void testJobDefinition() throws Exception {
        String workflowPath = this.getTestCaseFileUri("workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        DagEngine engine = new DagEngine(TestDagEngine.getTestUser());
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", workflowPath);
        conf.set("user.name", TestDagEngine.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("signal-value", "OK");
        conf.set("external-status", "ok");
        conf.set("error", "end.error");
        String jobId1 = engine.submitJob((Configuration)conf, false);
        String def = engine.getDefinition(jobId1);
        TestDagEngine.assertNotNull((Object)def);
    }

    public void testGetJobs() throws Exception {
        String workflowPath = this.getTestCaseFileUri("workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        DagEngine engine = new DagEngine(TestDagEngine.getTestUser());
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", workflowPath);
        conf.set("user.name", TestDagEngine.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("signal-value", "OK");
        conf.set("external-status", "ok");
        conf.set("error", "end.error");
        String jobId1 = engine.submitJob((Configuration)conf, true);
        String jobId2 = engine.submitJob((Configuration)conf, false);
    }

    public static class CallbackServlet
    extends HttpServlet {
        public static volatile String JOB_ID = null;
        public static String NODE_NAME = null;
        public static String STATUS = null;

        public static void reset() {
            JOB_ID = null;
            NODE_NAME = null;
            STATUS = null;
        }

        protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
            JOB_ID = req.getParameter("jobId");
            NODE_NAME = req.getParameter("nodeName");
            STATUS = req.getParameter("status");
            resp.setStatus(200);
        }
    }
}

