/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestLocalOozieClientCoord
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        this.services.destroy();
        super.tearDown();
    }

    public void testGetOozieUrl() {
        OozieClient client = LocalOozie.getCoordClient();
        TestLocalOozieClientCoord.assertEquals((String)"localoozie", (String)client.getOozieUrl());
    }

    public void testGetProtocolUrl() throws IOException, OozieClientException {
        OozieClient client = LocalOozie.getCoordClient();
        TestLocalOozieClientCoord.assertEquals((String)"localoozie", (String)client.getProtocolUrl());
    }

    public void testValidateWSVersion() throws IOException, OozieClientException {
        OozieClient client = LocalOozie.getCoordClient();
        client.validateWSVersion();
    }

    public void testHeaderMethods() {
        OozieClient client = LocalOozie.getCoordClient();
        client.setHeader("h", "v");
        TestLocalOozieClientCoord.assertNull((Object)client.getHeader("h"));
        Iterator hit = client.getHeaderNames();
        TestLocalOozieClientCoord.assertFalse((boolean)hit.hasNext());
        try {
            hit.next();
            TestLocalOozieClientCoord.fail((String)"NoSuchElementException expected.");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        client.removeHeader("h");
        TestLocalOozieClientCoord.assertNull((Object)client.getHeader("h"));
    }

    public void testGetJobsInfo() {
        OozieClient client = LocalOozie.getCoordClient();
        try {
            client.getJobsInfo("foo");
            TestLocalOozieClientCoord.fail((String)"OozieClientException expected.");
        }
        catch (OozieClientException oce) {
            TestLocalOozieClientCoord.assertEquals((String)ErrorCode.E0301.toString(), (String)oce.getErrorCode());
        }
        try {
            client.getJobsInfo("foo", 0, 5);
            TestLocalOozieClientCoord.fail((String)"OozieClientException expected.");
        }
        catch (OozieClientException oce) {
            TestLocalOozieClientCoord.assertEquals((String)ErrorCode.E0301.toString(), (String)oce.getErrorCode());
        }
        try {
            client.getJobInfo("foo-id");
            TestLocalOozieClientCoord.fail((String)"OozieClientException expected.");
        }
        catch (OozieClientException oce) {
            TestLocalOozieClientCoord.assertEquals((String)ErrorCode.E0301.toString(), (String)oce.getErrorCode());
        }
    }

    public void testReRun2() {
        OozieClient client = LocalOozie.getCoordClient();
        try {
            client.reRun("foo-id", client.createConfiguration());
            TestLocalOozieClientCoord.fail((String)"OozieClientException expected.");
        }
        catch (OozieClientException oce) {
            TestLocalOozieClientCoord.assertEquals((String)ErrorCode.E0301.toString(), (String)oce.getErrorCode());
        }
    }

    private void writeToFile(String appXml, String appPath) throws Exception {
        File wf = new File(new URI(appPath).getPath());
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(wf));
            out.println(appXml);
        }
    }

    public void testJobMethods() throws Exception {
        OozieClient client = LocalOozie.getCoordClient();
        List list0 = client.getCoordJobsInfo("", 1, 100);
        TestLocalOozieClientCoord.assertEquals((int)0, (int)list0.size());
        Properties conf = client.createConfiguration();
        String appPath = this.getTestCaseFileUri("coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:minutes(20)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.1\"> <controls> <timeout>10</timeout> <concurrency>1</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:minutes(20)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template> </dataset> <dataset name=\"local_a\" frequency=\"${coord:minutes(20)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template> </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPath);
        conf.setProperty("oozie.coord.application.path", appPath);
        String jobId0 = client.submit(conf);
        client.kill(jobId0);
        String jobId = client.run(conf);
        client.suspend(jobId);
        client.resume(jobId);
        client.kill(jobId);
        CoordinatorJob job = client.getCoordJobInfo(jobId);
        String appName = job.getAppName();
        TestLocalOozieClientCoord.assertEquals((String)"NAME", (String)appName);
        List list = client.getCoordJobsInfo("", 1, 5);
        TestLocalOozieClientCoord.assertEquals((int)2, (int)list.size());
    }
}

