/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V1JobsServlet;
import org.apache.oozie.test.XDataTestCase;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Ignore;

public class TestV1JobsServletBundleEngine
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;
    private Services services;
    private final XDataTestCase1 xDataTestCase = new XDataTestCase1();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.xDataTestCase.setName(this.getName());
        this.xDataTestCase.setUpPub();
        new Services().init();
        this.services = Services.get();
        this.services.setService(UUIDService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.services != null) {
            this.services.destroy();
        }
        this.xDataTestCase.tearDownPub();
        super.tearDown();
    }

    public void testGetBundleJobs() throws Exception {
        final BundleJobBean bundleJobBean = this.xDataTestCase.addRecordToBundleJobTable(Job.Status.PREP, false);
        this.runTest("/v1/jobs", V1JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("jobtype", "bundle");
                params.put("filter", "status=PREP;name=BUNDLE-TEST;user=" + TestV1JobsServletBundleEngine.getTestUser());
                URL url = TestV1JobsServletBundleEngine.this.createURL("", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                Assert.assertEquals((int)200, (int)conn.getResponseCode());
                Assert.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                Assert.assertEquals((Object)1L, (Object)json.get((Object)"total"));
                JSONArray array = (JSONArray)json.get((Object)"bundlejobs");
                JSONObject jo = (JSONObject)array.get(0);
                Assert.assertEquals((Object)bundleJobBean.getId(), (Object)jo.get((Object)"bundleJobId"));
                return null;
            }
        });
    }

    static {
        new V1JobsServlet();
    }

    @Ignore
    private static class XDataTestCase1
    extends XDataTestCase {
        private XDataTestCase1() {
        }
    }
}

