/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.util.IOUtils;

public class SharelibUtils {
    private static String findDir(String name) throws Exception {
        return SharelibUtils.findDir(new File("foo").getAbsoluteFile().getParent(), name);
    }

    private static String findDir(String baseDir, String name) throws Exception {
        File dir = new File(baseDir, name).getAbsoluteFile();
        if (!dir.exists()) {
            File parent = dir.getParentFile().getParentFile();
            if (parent != null) {
                return SharelibUtils.findDir(parent.getAbsolutePath(), name);
            }
            throw new RuntimeException("Sharelib dir not found: " + name);
        }
        return dir.getAbsolutePath();
    }

    private static String findClasspathFile(String sharelib) throws Exception {
        String classpathFile = null;
        String sharelibDir = SharelibUtils.findDir("sharelib");
        if (sharelibDir != null) {
            File file = new File(new File(new File(sharelibDir, sharelib), "target"), "classpath");
            if (file.exists()) {
                classpathFile = file.getAbsolutePath();
            } else {
                throw new RuntimeException("Sharelib classpath file for '" + sharelib + "' not found, Run 'mvn generate-test-resources' from Oozie source root");
            }
        }
        return classpathFile;
    }

    private static String[] getSharelibJars(String sharelib) throws Exception {
        String classpathFile = SharelibUtils.findClasspathFile(sharelib);
        BufferedReader br = new BufferedReader(new FileReader(classpathFile));
        String line = br.readLine();
        br.close();
        return line.split(System.getProperty("path.separator"));
    }

    private static Path[] copySharelibJarsToFileSytem(String sharelib, FileSystem fs, Path targetDir) throws Exception {
        String[] jars = SharelibUtils.getSharelibJars(sharelib);
        ArrayList<Path> paths = new ArrayList<Path>();
        for (String jar : jars) {
            if (!jar.endsWith(".jar")) continue;
            Path targetPath = new Path(targetDir, new File(jar).getName());
            FileInputStream is = new FileInputStream(jar);
            FSDataOutputStream os = fs.create(targetPath);
            IOUtils.copyStream((InputStream)is, (OutputStream)os);
            paths.add(targetPath);
        }
        return paths.toArray(new Path[paths.size()]);
    }

    public static void addToDistributedCache(String sharelib, FileSystem fs, Path targetDir, Configuration conf) throws Exception {
        Path[] paths;
        for (Path path : paths = SharelibUtils.copySharelibJarsToFileSytem(sharelib, fs, targetDir)) {
            DistributedCache.addFileToClassPath((Path)path, (Configuration)conf, (FileSystem)fs);
        }
    }
}

