/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.action.hadoop.LauncherException;
import org.apache.oozie.action.hadoop.LauncherMain;
import org.apache.oozie.action.hadoop.LauncherMainException;
import org.apache.oozie.action.hadoop.LauncherMainTester;
import org.apache.oozie.action.hadoop.LauncherMapper;
import org.apache.oozie.action.hadoop.LauncherMapperHelper;
import org.apache.oozie.action.hadoop.LauncherSecurityManager;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;

public class TestLauncher
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    private RunningJob _test(String ... arg) throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        File jar = IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)"launcher.jar", (Class[])new Class[]{LauncherMapper.class, LauncherMainException.class, LauncherSecurityManager.class, LauncherException.class, LauncherMainTester.class});
        FileSystem fs = this.getFileSystem();
        Path launcherJar = new Path(actionDir, "launcher.jar");
        fs.copyFromLocalFile(new Path(jar.toString()), launcherJar);
        JobConf jobConf = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobConf(new URI(this.getNameNodeUri()).getAuthority());
        jobConf.set("user.name", TestLauncher.getTestUser());
        jobConf.setInt("mapred.map.tasks", 1);
        jobConf.setInt("mapred.map.max.attempts", 1);
        jobConf.setInt("mapred.reduce.max.attempts", 1);
        jobConf.set("mapreduce.framework.name", "yarn");
        jobConf.set("mapred.job.tracker", this.getJobTrackerUri());
        jobConf.set("fs.default.name", this.getNameNodeUri());
        LauncherMapperHelper.setupMainClass((Configuration)jobConf, (String)LauncherMainTester.class.getName());
        LauncherMapperHelper.setupMainArguments((Configuration)jobConf, (String[])arg);
        XConfiguration actionConf = new XConfiguration();
        LauncherMapperHelper.setupLauncherInfo((JobConf)jobConf, (String)"1", (String)"1@a", (Path)actionDir, (String)"1@a-0", (Configuration)actionConf, (String)"");
        LauncherMapperHelper.setupYarnRestartHandling((JobConf)jobConf, (Configuration)jobConf, (String)"1@a", (long)System.currentTimeMillis());
        TestLauncher.assertEquals((String)"1", (String)actionConf.get("oozie.job.id"));
        TestLauncher.assertEquals((String)"1@a", (String)actionConf.get("oozie.action.id"));
        DistributedCache.addFileToClassPath((Path)new Path(launcherJar.toUri().getPath()), (Configuration)jobConf);
        JobClient jobClient = this.createJobClient();
        final RunningJob runningJob = jobClient.submitJob(jobConf);
        System.out.println("Action Dir: " + actionDir);
        System.out.println("LauncherMapper ID: " + runningJob.getJobID().toString());
        this.waitFor(180000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return runningJob.isComplete();
            }
        });
        TestLauncher.assertTrue((boolean)jobConf.get("oozie.action.prepare.xml").equals(""));
        return runningJob;
    }

    public void testEmpty() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        final RunningJob runningJob = this._test(new String[0]);
        this.waitFor(2000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return runningJob.isComplete();
            }
        });
        TestLauncher.assertTrue((boolean)runningJob.isSuccessful());
        XConfiguration conf = new XConfiguration();
        conf.set("user.name", TestLauncher.getTestUser());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)fs, (Path)actionDir, (Configuration)conf);
        TestLauncher.assertFalse((boolean)fs.exists(LauncherMapperHelper.getActionDataSequenceFilePath((Path)actionDir)));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainSuccessful((RunningJob)runningJob));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasOutputData((Map)actionData));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
    }

    public void testExit0() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        final RunningJob runningJob = this._test("exit0");
        this.waitFor(2000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return runningJob.isComplete();
            }
        });
        TestLauncher.assertTrue((boolean)runningJob.isSuccessful());
        XConfiguration conf = new XConfiguration();
        conf.set("user.name", TestLauncher.getTestUser());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)fs, (Path)actionDir, (Configuration)conf);
        TestLauncher.assertFalse((boolean)fs.exists(LauncherMapperHelper.getActionDataSequenceFilePath((Path)actionDir)));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainSuccessful((RunningJob)runningJob));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasOutputData((Map)actionData));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
    }

    public void testExit1() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        final RunningJob runningJob = this._test("exit1");
        this.waitFor(2000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return runningJob.isComplete();
            }
        });
        TestLauncher.assertTrue((boolean)runningJob.isSuccessful());
        XConfiguration conf = new XConfiguration();
        conf.set("user.name", TestLauncher.getTestUser());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)fs, (Path)actionDir, (Configuration)conf);
        TestLauncher.assertTrue((boolean)fs.exists(LauncherMapperHelper.getActionDataSequenceFilePath((Path)actionDir)));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.isMainSuccessful((RunningJob)runningJob));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasOutputData((Map)actionData));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
        TestLauncher.assertTrue((boolean)actionData.containsKey("error.properties"));
    }

    public void testException() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        final RunningJob runningJob = this._test("exception");
        this.waitFor(2000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return runningJob.isComplete();
            }
        });
        TestLauncher.assertTrue((boolean)runningJob.isSuccessful());
        XConfiguration conf = new XConfiguration();
        conf.set("user.name", TestLauncher.getTestUser());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)fs, (Path)actionDir, (Configuration)conf);
        TestLauncher.assertTrue((boolean)fs.exists(LauncherMapperHelper.getActionDataSequenceFilePath((Path)actionDir)));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.isMainSuccessful((RunningJob)runningJob));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasOutputData((Map)actionData));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
    }

    public void testThrowable() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        final RunningJob runningJob = this._test("throwable");
        this.waitFor(2000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return runningJob.isComplete();
            }
        });
        TestLauncher.assertTrue((boolean)runningJob.isSuccessful());
        XConfiguration conf = new XConfiguration();
        conf.set("user.name", TestLauncher.getTestUser());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)fs, (Path)actionDir, (Configuration)conf);
        TestLauncher.assertTrue((boolean)fs.exists(LauncherMapperHelper.getActionDataSequenceFilePath((Path)actionDir)));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.isMainSuccessful((RunningJob)runningJob));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasOutputData((Map)actionData));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
    }

    public void testOutput() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        final RunningJob runningJob = this._test("out");
        this.waitFor(2000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return runningJob.isComplete();
            }
        });
        TestLauncher.assertTrue((boolean)runningJob.isSuccessful());
        XConfiguration conf = new XConfiguration();
        conf.set("user.name", TestLauncher.getTestUser());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)fs, (Path)actionDir, (Configuration)conf);
        TestLauncher.assertTrue((boolean)fs.exists(LauncherMapperHelper.getActionDataSequenceFilePath((Path)actionDir)));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainSuccessful((RunningJob)runningJob));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.hasOutputData((Map)actionData));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
    }

    public void testNewId() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        final RunningJob runningJob = this._test("id");
        this.waitFor(2000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return runningJob.isComplete();
            }
        });
        TestLauncher.assertTrue((boolean)runningJob.isSuccessful());
        XConfiguration conf = new XConfiguration();
        conf.set("user.name", TestLauncher.getTestUser());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)fs, (Path)actionDir, (Configuration)conf);
        TestLauncher.assertTrue((boolean)fs.exists(LauncherMapperHelper.getActionDataSequenceFilePath((Path)actionDir)));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainSuccessful((RunningJob)runningJob));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasOutputData((Map)actionData));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
    }

    public void testSecurityManager() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        final RunningJob runningJob = this._test("securityManager");
        this.waitFor(2000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return runningJob.isComplete();
            }
        });
        TestLauncher.assertTrue((boolean)runningJob.isSuccessful());
        XConfiguration conf = new XConfiguration();
        conf.set("user.name", TestLauncher.getTestUser());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)fs, (Path)actionDir, (Configuration)conf);
        TestLauncher.assertFalse((boolean)fs.exists(LauncherMapperHelper.getActionDataSequenceFilePath((Path)actionDir)));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainSuccessful((RunningJob)runningJob));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasOutputData((Map)actionData));
        TestLauncher.assertFalse((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
        TestLauncher.assertTrue((boolean)LauncherMapperHelper.isMainDone((RunningJob)runningJob));
    }

    public void testSetupLauncherInfoWithEmptyPrepareXML() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        JobConf jobConf = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobConf(new URI(this.getNameNodeUri()).getAuthority());
        jobConf.set("user.name", TestLauncher.getTestUser());
        jobConf.set("fs.default.name", this.getNameNodeUri());
        XConfiguration actionConf = new XConfiguration();
        String prepareBlock = "";
        LauncherMapperHelper.setupLauncherInfo((JobConf)jobConf, (String)"1", (String)"1@a", (Path)actionDir, (String)"1@a-0", (Configuration)actionConf, (String)prepareBlock);
        TestLauncher.assertTrue((boolean)jobConf.get("oozie.action.prepare.xml").equals(""));
    }

    public void testSetupLauncherInfoWithNonEmptyPrepareXML() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        FileSystem fs = this.getFileSystem();
        Path newDir = new Path(actionDir, "newDir");
        JobConf jobConf = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobConf(new URI(this.getNameNodeUri()).getAuthority());
        jobConf.set("user.name", TestLauncher.getTestUser());
        jobConf.set("fs.default.name", this.getNameNodeUri());
        XConfiguration actionConf = new XConfiguration();
        String prepareBlock = "<prepare><mkdir path='" + newDir + "'/></prepare>";
        LauncherMapperHelper.setupLauncherInfo((JobConf)jobConf, (String)"1", (String)"1@a", (Path)actionDir, (String)"1@a-0", (Configuration)actionConf, (String)prepareBlock);
        TestLauncher.assertTrue((boolean)jobConf.get("oozie.action.prepare.xml").equals(prepareBlock));
    }

    public void testSetupMainClass() throws Exception {
        Configuration conf = new Configuration(false);
        LauncherMapperHelper.setupMainClass((Configuration)conf, (String)"");
        TestLauncher.assertNull((Object)conf.get("oozie.launcher.action.main.class"));
        conf = new Configuration(false);
        LauncherMapperHelper.setupMainClass((Configuration)conf, (String)"org.blah.myclass1");
        TestLauncher.assertEquals((String)conf.get("oozie.launcher.action.main.class"), (String)"org.blah.myclass1");
        conf = new Configuration(false);
        conf.set("oozie.launcher.action.main.class", "org.blah.myclass2");
        LauncherMapperHelper.setupMainClass((Configuration)conf, (String)"");
        TestLauncher.assertEquals((String)conf.get("oozie.launcher.action.main.class"), (String)"org.blah.myclass2");
        conf = new Configuration(false);
        conf.set("oozie.launcher.action.main.class", "org.blah.myclass2");
        LauncherMapperHelper.setupMainClass((Configuration)conf, (String)"org.blah.myclass1");
        TestLauncher.assertEquals((String)conf.get("oozie.launcher.action.main.class"), (String)"org.blah.myclass1");
    }

    public void testSetupLauncherInfoHadoop2_0_2_alphaWorkaround() throws Exception {
        Path actionDir = this.getFsTestCaseDir();
        JobConf jobConf = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobConf(new URI(this.getNameNodeUri()).getAuthority());
        jobConf.set("user.name", TestLauncher.getTestUser());
        jobConf.set("fs.default.name", this.getNameNodeUri());
        XConfiguration actionConf = new XConfiguration();
        actionConf.set("mapreduce.job.cache.files", "a.jar,aa.jar#aa.jar");
        LauncherMapperHelper.setupLauncherInfo((JobConf)jobConf, (String)"1", (String)"1@a", (Path)actionDir, (String)"1@a-0", (Configuration)actionConf, (String)"");
        TestLauncher.assertFalse((boolean)jobConf.getBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", false));
        TestLauncher.assertEquals((String)"a.jar,aa.jar#aa.jar", (String)actionConf.get("mapreduce.job.cache.files"));
        Services.get().getConf().setBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", true);
        actionConf = new XConfiguration();
        actionConf.set("mapreduce.job.cache.files", "a.jar,aa.jar#aa.jar");
        LauncherMapperHelper.setupLauncherInfo((JobConf)jobConf, (String)"1", (String)"1@a", (Path)actionDir, (String)"1@a-0", (Configuration)actionConf, (String)"");
        TestLauncher.assertTrue((boolean)jobConf.getBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", false));
        TestLauncher.assertEquals((String)"aa.jar#aa.jar", (String)actionConf.get("mapreduce.job.cache.files"));
    }

    public void testCopyFileMultiplex() throws Exception {
        File[] dsts;
        String contents = "Hello World!\nThis is Oozie";
        File src = new File(this.getTestCaseDir(), "src.txt");
        FileWriter w = new FileWriter(src);
        w.write(contents);
        ((Writer)w).close();
        for (File dst : dsts = new File[]{new File("dst1.txt"), new File("dist2.txt"), new File("dist3.txt")}) {
            dst.delete();
            TestLauncher.assertFalse((boolean)dst.exists());
        }
        LauncherMain.copyFileMultiplex((File)src, (File[])dsts);
        for (File dst : dsts) {
            TestLauncher.assertTrue((boolean)dst.exists());
            TestLauncher.assertEquals((String)contents, (String)FileUtils.readFileToString((File)dst));
        }
    }
}

