/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.action.hadoop.LauncherURIHandler;
import org.apache.oozie.action.hadoop.LauncherURIHandlerFactory;
import org.apache.oozie.dependency.FSURIHandler;
import org.apache.oozie.dependency.HCatURIHandler;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.test.XHCatTestCase;
import org.junit.Test;

public class TestLauncherHCatURIHandler
extends XHCatTestCase {
    private Services services;
    private URIHandlerService uriService;
    private JobConf conf;
    private static final String db = "db1";
    private static final String table = "table1";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.getConf().set("oozie.service.URIHandlerService.uri.handlers", FSURIHandler.class.getName() + "," + HCatURIHandler.class.getName());
        this.services.setService(HCatAccessorService.class);
        this.services.init();
        this.conf = this.createJobConf();
        this.uriService = (URIHandlerService)Services.get().get(URIHandlerService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private void createTestTable() throws Exception {
        this.dropTable(db, table, true);
        this.dropDatabase(db, true);
        this.createDatabase(db);
        this.createTable(db, table, "year,month,dt,country");
    }

    private void dropTestTable() throws Exception {
        this.dropTable(db, table, false);
        this.dropDatabase(db, false);
    }

    @Test
    public void testDelete() throws Exception {
        this.createTestTable();
        String location1 = this.getPartitionDir(db, table, "year=2012;month=12;dt=02;country=us");
        String location2 = this.getPartitionDir(db, table, "year=2012;month=12;dt=03;country=us");
        this.createPartitionForTestDelete(true, true);
        URI hcatURI = this.getHCatURI(db, table, "year=2012;month=12;dt=02;country=us");
        URIHandler uriHandler = this.uriService.getURIHandler(hcatURI);
        TestLauncherHCatURIHandler.assertTrue((boolean)uriHandler.exists(hcatURI, (Configuration)this.conf, TestLauncherHCatURIHandler.getTestUser()));
        LauncherURIHandlerFactory uriHandlerFactory = new LauncherURIHandlerFactory(this.uriService.getLauncherConfig());
        LauncherURIHandler handler = uriHandlerFactory.getURIHandler(hcatURI);
        handler.delete(hcatURI, (Configuration)this.conf);
        TestLauncherHCatURIHandler.assertFalse((boolean)this.getFileSystem().exists(new Path(location1)));
        TestLauncherHCatURIHandler.assertTrue((boolean)this.getFileSystem().exists(new Path(location2)));
        TestLauncherHCatURIHandler.assertEquals((int)0, (int)this.getPartitions(db, table, "year=2012;month=12;dt=02;country=us").size());
        TestLauncherHCatURIHandler.assertEquals((int)1, (int)this.getPartitions(db, table, "year=2012;month=12;dt=03;country=us").size());
        this.createPartitionForTestDelete(true, false);
        hcatURI = this.getHCatURI(db, table, "year=2012;month=12");
        handler.delete(hcatURI, (Configuration)this.conf);
        TestLauncherHCatURIHandler.assertFalse((boolean)this.getFileSystem().exists(new Path(location1)));
        TestLauncherHCatURIHandler.assertFalse((boolean)this.getFileSystem().exists(new Path(location2)));
        TestLauncherHCatURIHandler.assertEquals((int)0, (int)this.getPartitions(db, table, "year=2012;month=12;dt=02;country=us").size());
        TestLauncherHCatURIHandler.assertEquals((int)0, (int)this.getPartitions(db, table, "year=2012;month=12;dt=03;country=us").size());
        this.createPartitionForTestDelete(true, true);
        hcatURI = this.getHCatURI(db, table, "month=12;country=us");
        handler.delete(hcatURI, (Configuration)this.conf);
        TestLauncherHCatURIHandler.assertFalse((boolean)this.getFileSystem().exists(new Path(location1)));
        TestLauncherHCatURIHandler.assertFalse((boolean)this.getFileSystem().exists(new Path(location2)));
        TestLauncherHCatURIHandler.assertEquals((int)0, (int)this.getPartitions(db, table, "year=2012;month=12;dt=02;country=us").size());
        TestLauncherHCatURIHandler.assertEquals((int)0, (int)this.getPartitions(db, table, "year=2012;month=12;dt=03;country=us").size());
        this.createPartitionForTestDelete(true, true);
        hcatURI = this.getHCatURI(db, table, "country=us");
        handler.delete(hcatURI, (Configuration)this.conf);
        TestLauncherHCatURIHandler.assertFalse((boolean)this.getFileSystem().exists(new Path(location1)));
        TestLauncherHCatURIHandler.assertFalse((boolean)this.getFileSystem().exists(new Path(location2)));
        TestLauncherHCatURIHandler.assertEquals((int)0, (int)this.getPartitions(db, table, "year=2012;month=12;dt=02;country=us").size());
        TestLauncherHCatURIHandler.assertEquals((int)0, (int)this.getPartitions(db, table, "year=2012;month=12;dt=03;country=us").size());
        this.createPartitionForTestDelete(true, true);
        hcatURI = this.getHCatURI(db, table, "dt=03");
        handler.delete(hcatURI, (Configuration)this.conf);
        TestLauncherHCatURIHandler.assertTrue((boolean)this.getFileSystem().exists(new Path(location1)));
        TestLauncherHCatURIHandler.assertFalse((boolean)this.getFileSystem().exists(new Path(location2)));
        TestLauncherHCatURIHandler.assertEquals((int)1, (int)this.getPartitions(db, table, "year=2012;month=12;dt=02;country=us").size());
        TestLauncherHCatURIHandler.assertEquals((int)0, (int)this.getPartitions(db, table, "year=2012;month=12;dt=03;country=us").size());
        this.createPartitionForTestDelete(false, true);
        hcatURI = this.getHCatURI(db, table, "dt=09");
        handler.delete(hcatURI, (Configuration)this.conf);
        TestLauncherHCatURIHandler.assertTrue((boolean)this.getFileSystem().exists(new Path(location1)));
        TestLauncherHCatURIHandler.assertTrue((boolean)this.getFileSystem().exists(new Path(location2)));
        TestLauncherHCatURIHandler.assertEquals((int)1, (int)this.getPartitions(db, table, "year=2012;month=12;dt=02;country=us").size());
        TestLauncherHCatURIHandler.assertEquals((int)1, (int)this.getPartitions(db, table, "year=2012;month=12;dt=03;country=us").size());
        this.dropTestTable();
    }

    private void createPartitionForTestDelete(boolean partition1, boolean partition2) throws Exception {
        String location;
        if (partition1) {
            location = this.addPartition(db, table, "year=2012;month=12;dt=02;country=us");
            TestLauncherHCatURIHandler.assertTrue((boolean)this.getFileSystem().exists(new Path(location)));
        }
        if (partition2) {
            location = this.addPartition(db, table, "year=2012;month=12;dt=03;country=us");
            TestLauncherHCatURIHandler.assertTrue((boolean)this.getFileSystem().exists(new Path(location)));
        }
    }
}

