/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.ActionExecutorTestCase;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.action.hadoop.MapReduceActionExecutor;
import org.apache.oozie.action.hadoop.MapperReducerForTest;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class TestMapReduceActionError
extends ActionExecutorTestCase {
    @Override
    protected void setSystemProps() throws Exception {
        super.setSystemProps();
        this.setSystemProperty("oozie.service.ActionService.executor.classes", MapReduceActionExecutor.class.getName());
    }

    private ActionExecutorTestCase.Context createContext(String actionXml) throws Exception {
        JavaActionExecutor ae = new JavaActionExecutor();
        Path appJarPath = new Path("lib/test.jar");
        File jarFile = IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)"test.jar", (Class[])new Class[]{MapperReducerForTest.class});
        FileInputStream is = new FileInputStream(jarFile);
        FSDataOutputStream os = this.getFileSystem().create(new Path(this.getAppPath(), "lib/test.jar"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestMapReduceActionError.getTestUser());
        protoConf.setStrings("oozie.wf.application.lib", new String[]{appJarPath.toString()});
        WorkflowJobBean wf = this.createBaseWorkflow(protoConf, "mr-action");
        WorkflowActionBean action = (WorkflowActionBean)wf.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        return new ActionExecutorTestCase.Context(wf, action);
    }

    private RunningJob submitAction(ActionExecutorTestCase.Context context) throws Exception {
        MapReduceActionExecutor ae = new MapReduceActionExecutor();
        WorkflowAction action = context.getAction();
        ae.prepareActionDir(this.getFileSystem(), (ActionExecutor.Context)context);
        ae.submitLauncher(this.getFileSystem(), (ActionExecutor.Context)context, action);
        String jobId = action.getExternalId();
        String jobTracker = action.getTrackerUri();
        String consoleUrl = action.getConsoleUrl();
        TestMapReduceActionError.assertNotNull((Object)jobId);
        TestMapReduceActionError.assertNotNull((Object)jobTracker);
        TestMapReduceActionError.assertNotNull((Object)consoleUrl);
        Element e = XmlUtils.parseXml((String)action.getConf());
        XConfiguration conf = new XConfiguration((Reader)new StringReader(XmlUtils.prettyPrint((Element)e.getChild("configuration")).toString()));
        conf.set("mapred.job.tracker", e.getChildTextTrim("job-tracker"));
        conf.set("fs.default.name", e.getChildTextTrim("name-node"));
        conf.set("user.name", context.getProtoActionConf().get("user.name"));
        conf.set("group.name", TestMapReduceActionError.getTestGroup());
        conf.set("mapreduce.framework.name", "yarn");
        JobConf jobConf = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobConf(jobTracker);
        XConfiguration.copy((Configuration)conf, (Configuration)jobConf);
        String user = jobConf.get("user.name");
        String group = jobConf.get("group.name");
        JobClient jobClient = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobClient(user, jobConf);
        RunningJob runningJob = jobClient.getJob(JobID.forName((String)jobId));
        TestMapReduceActionError.assertNotNull((Object)runningJob);
        return runningJob;
    }

    private void _testSubmit(String actionXml) throws Exception {
        ActionExecutorTestCase.Context context = this.createContext(actionXml);
        final RunningJob launcherJob = this.submitAction(context);
        String launcherId = context.getAction().getExternalId();
        this.waitFor(60000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return launcherJob.isComplete();
            }
        });
        MapReduceActionExecutor ae = new MapReduceActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        JobConf conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, XmlUtils.parseXml((String)actionXml));
        String user = conf.get("user.name");
        String group = conf.get("group.name");
        JobClient jobClient = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobClient(user, conf);
        final RunningJob mrJob = jobClient.getJob(JobID.forName((String)context.getAction().getExternalId()));
        this.waitFor(60000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return mrJob.isComplete();
            }
        });
        ae.check((ActionExecutor.Context)context, context.getAction());
        TestMapReduceActionError.assertEquals((String)"FAILED/KILLED", (String)context.getAction().getExternalStatus());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestMapReduceActionError.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)context.getAction().getStatus());
        TestMapReduceActionError.assertTrue((boolean)context.getAction().getErrorMessage().contains("already exists"));
    }

    public void testMapReduce() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path inputDir = new Path(this.getFsTestCaseDir(), "input");
        Path outputDir = new Path(this.getFsTestCaseDir(), "output1");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
        w.write("dummy\n");
        w.write("dummy\n");
        OutputStreamWriter ow = new OutputStreamWriter((OutputStream)fs.create(new Path(outputDir, "data.txt")));
        ow.write("dummy\n");
        ow.write("dummy\n");
        ((Writer)ow).close();
        String actionXml = "<map-reduce><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>mapred.mapper.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.reducer.class</name><value>" + MapperReducerForTest.class.getName() + "</value></property><property><name>mapred.input.dir</name><value>" + inputDir + "</value></property><property><name>mapred.output.dir</name><value>" + outputDir + "</value></property></configuration></map-reduce>";
        this._testSubmit(actionXml);
    }
}

