/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.action.hadoop.MainTestCase;
import org.apache.oozie.action.hadoop.PipesMain;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;

public class TestPipesMain
extends MainTestCase {
    @Override
    public Void call() throws Exception {
        Path programPath = new Path(this.getFsTestCaseDir(), "wordcount-simple");
        FileSystem fs = this.getFileSystem();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("wordcount-simple");
        if (is != null) {
            Object os = fs.create(programPath);
            IOUtils.copyStream((InputStream)is, (OutputStream)os);
            Path inputDir = new Path(this.getFsTestCaseDir(), "input");
            fs.mkdirs(inputDir);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(inputDir, "data.txt")));
            writer.write("hello");
            ((Writer)writer).close();
            Path outputDir = new Path(this.getFsTestCaseDir(), "output");
            XConfiguration jobConf = new XConfiguration();
            XConfiguration.copy((Configuration)this.createJobConf(), (Configuration)jobConf);
            jobConf.set("user.name", TestPipesMain.getTestUser());
            jobConf.setInt("mapred.map.tasks", 1);
            jobConf.setInt("mapred.map.max.attempts", 1);
            jobConf.setInt("mapred.reduce.max.attempts", 1);
            jobConf.set("mapred.input.dir", inputDir.toString());
            jobConf.set("mapred.output.dir", outputDir.toString());
            jobConf.set("oozie.pipes.program", programPath.toUri().getPath());
            jobConf.setBoolean("hadoop.pipes.java.recordreader", true);
            DistributedCache.addCacheFile((URI)new URI(programPath.toUri().getPath()), (Configuration)fs.getConf());
            File actionXml = new File(this.getTestCaseDir(), "action.xml");
            os = new FileOutputStream(actionXml);
            jobConf.writeXml((OutputStream)os);
            ((OutputStream)os).close();
            File newId = new File(this.getTestCaseDir(), "newId");
            System.setProperty("oozie.action.conf.xml", actionXml.getAbsolutePath());
            System.setProperty("oozie.action.newId", newId.getAbsolutePath());
            String[] args = new String[]{};
            PipesMain.main((String[])args);
            TestPipesMain.assertTrue((boolean)newId.exists());
            is = new FileInputStream(newId);
            Properties props = new Properties();
            props.load(is);
            is.close();
            TestPipesMain.assertTrue((boolean)props.containsKey("id"));
        } else {
            System.out.println("SKIPPING TEST: TestPipesMain, binary 'wordcount-simple' not available in the classpath");
        }
        return null;
    }
}

