/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.hadoop;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.util.Shell;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.ActionExecutorTestCase;
import org.apache.oozie.action.hadoop.LauncherMapperHelper;
import org.apache.oozie.action.hadoop.ShellActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.junit.Assert;

public class TestShellActionExecutor
extends ActionExecutorTestCase {
    private static final String SHELL_EXEC = Shell.WINDOWS ? "cmd.exe" : "sh";
    private static final String SHELL_PARAM = Shell.WINDOWS ? "/c" : "-c";
    private static final String SHELL_SCRIPTNAME = Shell.WINDOWS ? "script.cmd" : "script.sh";
    private static final String SHELL_SCRIPT_CONTENT = Shell.WINDOWS ? "dir /s /b\necho %1 %2\necho %PATH%\ntype %0" : "ls -ltr\necho $1 $2\necho $PATH\npwd\ntype sh";
    private static final String SHELL_SCRIPT_CONTENT_ENVVAR = Shell.WINDOWS ? "dir /s /b\necho var1=%var1%\necho var2=%var2%" : "ls -ltr\necho var1=$var1\necho var2=$var2";
    private static final String SHELL_SCRIPT_CONTENT_ERROR = Shell.WINDOWS ? "dir /s /b\necho %1 %2\nexit 1" : "ls -ltr\necho $1 $2\nexit 1";
    private static final String PERL_SCRIPT_CONTENT = "print \"MY_VAR=TESTING\";";
    private static final String SHELL_SCRIPT_HADOOP_CONF_DIR_CONTENT = Shell.WINDOWS ? "echo OOZIE_ACTION_CONF_XML=%OOZIE_ACTION_CONF_XML%\necho HADOOP_CONF_DIR=%HADOOP_CONF_DIR%\n" : "echo OOZIE_ACTION_CONF_XML=$OOZIE_ACTION_CONF_XML\necho HADOOP_CONF_DIR=$HADOOP_CONF_DIR\n";
    private static final String SHELL_SCRIPT_YARN_CONF_DIR_CONTENT = Shell.WINDOWS ? "echo YARN_CONF_DIR=%YARN_CONF_DIR%\n" : "echo YARN_CONF_DIR=$YARN_CONF_DIR\n";
    private static final String SHELL_SCRIPT_LOG4J_EXISTENCE_CHECKER = Shell.WINDOWS ? "IF EXIST %HADOOP_CONF_DIR%\\log4j.properties echo L4J_EXISTS=yes\n" : "if [ -f $HADOOP_CONF_DIR/log4j.properties ]; then echo L4J_EXISTS=yes; fi\n";
    private static final String SHELL_SCRIPT_LOG4J_CONTENT_COUNTER = Shell.WINDOWS ? "SET COMMAND=\"type %HADOOP_CONF_DIR%\\log4j.properties | FIND /c /v \"~DOESNOTMATCH~\"\"\nFOR /f %%i IN (' %COMMAND% ') DO SET L4J_LC=%%i\necho L4J_WC=%L4J_LC%\n" : "echo L4J_LC=$(cat $HADOOP_CONF_DIR/log4j.properties | wc -l)\n";

    public void testSetupMethods() throws Exception {
        ShellActionExecutor ae = new ShellActionExecutor();
        TestShellActionExecutor.assertNull((Object)ae.getLauncherClasses());
        Element actionXml = XmlUtils.parseXml((String)("<shell><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><exec>SCRIPT</exec><argument>a=A</argument><argument>b=B</argument></shell>"));
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestShellActionExecutor.getTestUser());
        WorkflowJobBean wf = this.createBaseWorkflow(protoConf, "pig-action");
        WorkflowActionBean action = (WorkflowActionBean)wf.getActions().get(0);
        action.setType(ae.getType());
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(wf, action);
        JobConf conf = ae.createBaseHadoopConf((ActionExecutor.Context)context, actionXml);
        ae.setupActionConf((Configuration)conf, (ActionExecutor.Context)context, actionXml, this.getFsTestCaseDir());
        TestShellActionExecutor.assertEquals((String)"SCRIPT", (String)conf.get("oozie.shell.exec"));
        TestShellActionExecutor.assertEquals((String)"2", (String)conf.get("oozie.shell.args.size"));
        TestShellActionExecutor.assertEquals((String)"a=A", (String)conf.get("oozie.shell.args.0"));
        TestShellActionExecutor.assertEquals((String)"b=B", (String)conf.get("oozie.shell.args.1"));
        TestShellActionExecutor.assertEquals((String)"Expected HADOOP_CONF_DIR setup switch to be disabled", (String)"false", (String)conf.get("oozie.action.shell.setup.hadoop.conf.dir"));
        TestShellActionExecutor.assertEquals((String)"Expected log4j.properties write switch to be enabled", (String)"true", (String)conf.get("oozie.action.shell.setup.hadoop.conf.dir.write.log4j.properties"));
        TestShellActionExecutor.assertNotNull((String)"Expected a default config to exist for log4j.properties", (Object)conf.get("oozie.action.shell.setup.hadoop.conf.dir.log4j.content"));
    }

    public void testShellScript() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path script = new Path(this.getAppPath(), SHELL_SCRIPTNAME);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(script));
        w.write(SHELL_SCRIPT_CONTENT);
        ((Writer)w).close();
        String actionXml = "<shell><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><exec>" + SHELL_EXEC + "</exec><argument>" + SHELL_PARAM + "</argument><argument>" + SHELL_SCRIPTNAME + "</argument><argument>A</argument><argument>B</argument><env-var>var1=val1</env-var><env-var>var2=val2</env-var><file>" + script.toString() + "#" + script.getName() + "</file></shell>";
        this._testSubmit(actionXml, true, "");
    }

    public void testShellScriptHadoopConfDir() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path script = new Path(this.getAppPath(), SHELL_SCRIPTNAME);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(script));
        w.write(SHELL_SCRIPT_HADOOP_CONF_DIR_CONTENT);
        w.write(SHELL_SCRIPT_YARN_CONF_DIR_CONTENT);
        w.write(SHELL_SCRIPT_LOG4J_EXISTENCE_CHECKER);
        w.write(SHELL_SCRIPT_LOG4J_CONTENT_COUNTER);
        ((Writer)w).close();
        String actionXml = "<shell><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.action.shell.setup.hadoop.conf.dir</name><value>true</value></property></configuration><exec>" + SHELL_EXEC + "</exec><argument>" + SHELL_PARAM + "</argument><argument>" + SHELL_SCRIPTNAME + "</argument><file>" + script.toString() + "#" + script.getName() + "</file><capture-output/></shell>";
        WorkflowAction action = this._testSubmit(actionXml, true, "");
        String oozieActionConfXml = PropertiesUtils.stringToProperties((String)action.getData()).getProperty("OOZIE_ACTION_CONF_XML");
        String hadoopConfDir = PropertiesUtils.stringToProperties((String)action.getData()).getProperty("HADOOP_CONF_DIR");
        String yarnConfDir = PropertiesUtils.stringToProperties((String)action.getData()).getProperty("YARN_CONF_DIR");
        String log4jExists = PropertiesUtils.stringToProperties((String)action.getData()).getProperty("L4J_EXISTS");
        String log4jFileLineCount = PropertiesUtils.stringToProperties((String)action.getData()).getProperty("L4J_LC");
        TestShellActionExecutor.assertNotNull((Object)oozieActionConfXml);
        TestShellActionExecutor.assertNotNull((Object)hadoopConfDir);
        String s = new File(oozieActionConfXml).getParent() + File.separator + "oozie-hadoop-conf-";
        Assert.assertTrue((String)("Expected HADOOP_CONF_DIR to start with " + s + " but was " + hadoopConfDir), (boolean)hadoopConfDir.startsWith(s));
        Assert.assertTrue((String)("Expected YARN_CONF_DIR to start with " + s + " but was " + yarnConfDir), (boolean)yarnConfDir.startsWith(s));
        Assert.assertEquals((String)"Expected log4j.properties file to exist", (Object)log4jExists, (Object)"yes");
        Assert.assertTrue((String)("Expected log4j.properties to have non-zero line count, but has: " + log4jFileLineCount), (Integer.parseInt(log4jFileLineCount) > 0 ? 1 : 0) != 0);
    }

    public void testShellScriptHadoopConfDirWithNoL4J() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path script = new Path(this.getAppPath(), SHELL_SCRIPTNAME);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(script));
        w.write(SHELL_SCRIPT_LOG4J_EXISTENCE_CHECKER);
        ((Writer)w).close();
        String actionXml = "<shell><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><configuration><property><name>oozie.action.shell.setup.hadoop.conf.dir</name><value>true</value></property><property><name>oozie.action.shell.setup.hadoop.conf.dir.write.log4j.properties</name><value>false</value></property></configuration><exec>" + SHELL_EXEC + "</exec><argument>" + SHELL_PARAM + "</argument><argument>" + SHELL_SCRIPTNAME + "</argument><file>" + script.toString() + "#" + script.getName() + "</file><capture-output/></shell>";
        WorkflowAction action = this._testSubmit(actionXml, true, "");
        String log4jExists = PropertiesUtils.stringToProperties((String)action.getData()).getProperty("L4J_EXISTS");
        Assert.assertNull((String)"Expected no log4j.properties file to exist", (Object)log4jExists);
    }

    public void testShellScriptError() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path script = new Path(this.getAppPath(), SHELL_SCRIPTNAME);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(script));
        w.write(SHELL_SCRIPT_CONTENT_ERROR);
        ((Writer)w).close();
        String actionXml = "<shell><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><exec>" + SHELL_EXEC + "</exec><argument>" + SHELL_PARAM + "</argument><argument>" + SHELL_SCRIPTNAME + "</argument><argument>A</argument><argument>B</argument><file>" + script.toString() + "#" + script.getName() + "</file></shell>";
        this._testSubmit(actionXml, false, "");
    }

    public void testPerlScript() throws Exception {
        if (Shell.WINDOWS) {
            System.out.println("Windows cannot natively execute perl. Skipping test");
            return;
        }
        FileSystem fs = this.getFileSystem();
        Path script = new Path(this.getAppPath(), "script.pl");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(script));
        w.write(PERL_SCRIPT_CONTENT);
        ((Writer)w).close();
        String actionXml = "<shell><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><exec>perl</exec><argument>script.pl</argument><argument>A</argument><argument>B</argument><env-var>my_var1=my_val1</env-var><file>" + script.toString() + "#" + script.getName() + "</file><capture-output/></shell>";
        this._testSubmit(actionXml, true, "TESTING");
    }

    public void testEnvVar() throws Exception {
        Services.get().destroy();
        Services services = new Services();
        services.getConf().setInt("oozie.action.max.output.data", 8336);
        services.init();
        FileSystem fs = this.getFileSystem();
        Path script = new Path(this.getAppPath(), SHELL_SCRIPTNAME);
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(script));
        w.write(SHELL_SCRIPT_CONTENT_ENVVAR);
        ((Writer)w).close();
        String envValueHavingEqualSign = "a=b;c=d";
        String actionXml = "<shell><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><exec>" + SHELL_EXEC + "</exec><argument>" + SHELL_PARAM + "</argument><argument>" + SHELL_SCRIPTNAME + "</argument><argument>A</argument><argument>B</argument><env-var>var1=val1</env-var><env-var>var2=" + envValueHavingEqualSign + "</env-var><file>" + script.toString() + "#" + script.getName() + "</file><capture-output /></shell>";
        ActionExecutorTestCase.Context context = this.createContext(actionXml);
        final RunningJob launcherJob = this.submitAction(context);
        this.waitFor(180000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return launcherJob.isComplete();
            }
        });
        ShellActionExecutor ae = new ShellActionExecutor();
        WorkflowAction action = context.getAction();
        ae.check((ActionExecutor.Context)context, action);
        ae.end((ActionExecutor.Context)context, action);
        TestShellActionExecutor.assertEquals((String)envValueHavingEqualSign, (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("var2"));
    }

    private WorkflowAction _testSubmit(String actionXml, boolean checkForSuccess, String capture_output) throws Exception {
        ActionExecutorTestCase.Context context = this.createContext(actionXml);
        final RunningJob launcherJob = this.submitAction(context);
        String launcherId = context.getAction().getExternalId();
        this.waitFor(180000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return launcherJob.isComplete();
            }
        });
        TestShellActionExecutor.assertTrue((boolean)launcherJob.isSuccessful());
        this.sleep(2000);
        XConfiguration conf = new XConfiguration();
        conf.set("user.name", TestShellActionExecutor.getTestUser());
        Map actionData = LauncherMapperHelper.getActionData((FileSystem)this.getFileSystem(), (Path)context.getActionDir(), (Configuration)conf);
        TestShellActionExecutor.assertFalse((boolean)LauncherMapperHelper.hasIdSwap((Map)actionData));
        ShellActionExecutor ae = new ShellActionExecutor();
        ae.check((ActionExecutor.Context)context, context.getAction());
        ae.end((ActionExecutor.Context)context, context.getAction());
        TestShellActionExecutor.assertTrue((boolean)launcherId.equals(context.getAction().getExternalId()));
        if (checkForSuccess) {
            TestShellActionExecutor.assertEquals((String)"SUCCEEDED", (String)context.getAction().getExternalStatus());
            if (capture_output != null && capture_output.length() > 0) {
                TestShellActionExecutor.assertEquals((String)capture_output, (String)PropertiesUtils.stringToProperties((String)context.getAction().getData()).getProperty("MY_VAR"));
            }
        } else {
            TestShellActionExecutor.assertEquals((String)"FAILED/KILLED", (String)context.getAction().getExternalStatus());
            TestShellActionExecutor.assertNotNull((Object)context.getAction().getErrorMessage());
        }
        if (checkForSuccess) {
            TestShellActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)context.getAction().getStatus());
        } else {
            TestShellActionExecutor.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)context.getAction().getStatus());
        }
        return context.getAction();
    }

    private ActionExecutorTestCase.Context createContext(String actionXml) throws Exception {
        ShellActionExecutor ae = new ShellActionExecutor();
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestShellActionExecutor.getTestUser());
        WorkflowJobBean wf = this.createBaseWorkflow(protoConf, "shell-action");
        WorkflowActionBean action = (WorkflowActionBean)wf.getActions().get(0);
        action.setType(ae.getType());
        action.setConf(actionXml);
        return new ActionExecutorTestCase.Context(wf, action);
    }

    private RunningJob submitAction(ActionExecutorTestCase.Context context) throws Exception {
        ShellActionExecutor ae = new ShellActionExecutor();
        WorkflowAction action = context.getAction();
        ae.prepareActionDir(this.getFileSystem(), (ActionExecutor.Context)context);
        ae.submitLauncher(this.getFileSystem(), (ActionExecutor.Context)context, action);
        String jobId = action.getExternalId();
        String jobTracker = action.getTrackerUri();
        String consoleUrl = action.getConsoleUrl();
        TestShellActionExecutor.assertNotNull((Object)jobId);
        TestShellActionExecutor.assertNotNull((Object)jobTracker);
        TestShellActionExecutor.assertNotNull((Object)consoleUrl);
        Element e = XmlUtils.parseXml((String)action.getConf());
        XConfiguration conf = new XConfiguration();
        conf.set("mapred.job.tracker", e.getChildTextTrim("job-tracker"));
        conf.set("fs.default.name", e.getChildTextTrim("name-node"));
        conf.set("user.name", context.getProtoActionConf().get("user.name"));
        conf.set("group.name", TestShellActionExecutor.getTestGroup());
        JobConf jobConf = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobConf(jobTracker);
        XConfiguration.copy((Configuration)conf, (Configuration)jobConf);
        String user = jobConf.get("user.name");
        String group = jobConf.get("group.name");
        JobClient jobClient = ((HadoopAccessorService)Services.get().get(HadoopAccessorService.class)).createJobClient(user, jobConf);
        RunningJob runningJob = jobClient.getJob(JobID.forName((String)jobId));
        TestShellActionExecutor.assertNotNull((Object)runningJob);
        return runningJob;
    }

    public void testShellMainPathInUber() throws Exception {
        Services.get().getConf().setBoolean("oozie.action.shell.launcher.mapreduce.job.ubertask.enable", true);
        Element actionXml = XmlUtils.parseXml((String)("<shell><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><exec>script.sh</exec><argument>a=A</argument><argument>b=B</argument></shell>"));
        ShellActionExecutor ae = new ShellActionExecutor();
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestShellActionExecutor.getTestUser());
        WorkflowJobBean wf = this.createBaseWorkflow(protoConf, "action");
        WorkflowActionBean action = (WorkflowActionBean)wf.getActions().get(0);
        action.setType(ae.getType());
        ActionExecutorTestCase.Context context = new ActionExecutorTestCase.Context(wf, action);
        JobConf launcherConf = new JobConf();
        launcherConf = ae.createLauncherConf(this.getFileSystem(), (ActionExecutor.Context)context, (WorkflowAction)action, actionXml, (Configuration)launcherConf);
        TestShellActionExecutor.assertEquals((String)"PATH=.:$PATH", (String)launcherConf.get("yarn.app.mapreduce.am.env"));
    }
}

