/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.action.ssh;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.ActionExecutorException;
import org.apache.oozie.action.ssh.SshActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.CallbackService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.PropertiesUtils;
import org.apache.oozie.util.XConfiguration;
import org.mockito.Mockito;

public class TestSshActionExecutor
extends XFsTestCase {
    private Services services;
    private String ECHO_ARGS_SCRIPT = "count=1\nfor var in \"$@\";\ndo\n     echo \"prop$count=$var\"\n     count=$((count + 1))\ndone";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        XConfiguration conf = new XConfiguration();
        conf.setStrings("user.name", new String[]{TestSshActionExecutor.getTestUser()});
        Path path = new Path(this.getNameNodeUri(), this.getTestCaseDir());
        FileSystem fs = this.getFileSystem();
        fs.delete(path, true);
    }

    protected String getActionXMLSchema() {
        return "uri:oozie-workflow:0.1";
    }

    public void testJobStart() throws ActionExecutorException {
        String baseDir = this.getTestCaseDir();
        Path appPath = new Path(this.getNameNodeUri(), baseDir);
        XConfiguration protoConf = new XConfiguration();
        protoConf.setStrings("user.name", new String[]{TestSshActionExecutor.getTestUser()});
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("oozie.wf.application.path", appPath.toString());
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setConf(wfConf.toXmlString());
        workflow.setAppPath(wfConf.get("oozie.wf.application.path"));
        workflow.setProtoActionConf(protoConf.toXmlString());
        workflow.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.WORKFLOW));
        final WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'><host>localhost</host><command>echo</command><capture-output/><args>\"prop1=something\"</args></ssh>");
        action.setName("ssh");
        final SshActionExecutor ssh = new SshActionExecutor();
        final Context context = new Context(workflow, action);
        ssh.start((ActionExecutor.Context)context, (WorkflowAction)action);
        this.waitFor(30000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                ssh.check((ActionExecutor.Context)context, (WorkflowAction)action);
                return WorkflowAction.Status.DONE == action.getStatus();
            }
        });
        ssh.end((ActionExecutor.Context)context, (WorkflowAction)action);
        TestSshActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        TestSshActionExecutor.assertEquals((String)"something", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop1"));
    }

    public void testJobRecover() throws ActionExecutorException, InterruptedException {
        String baseDir = this.getTestCaseDir();
        Path appPath = new Path(this.getNameNodeUri(), baseDir);
        XConfiguration protoConf = new XConfiguration();
        protoConf.setStrings("user.name", new String[]{TestSshActionExecutor.getTestUser()});
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("oozie.wf.application.path", appPath.toString());
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setConf(wfConf.toXmlString());
        workflow.setAppPath(wfConf.get("oozie.wf.application.path"));
        workflow.setProtoActionConf(protoConf.toXmlString());
        workflow.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.WORKFLOW));
        WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'><host>localhost</host><command>echo</command><capture-output/><args>\"prop1=something\"</args></ssh>");
        action.setName("ssh");
        final SshActionExecutor ssh = new SshActionExecutor();
        Context context = new Context(workflow, action);
        ssh.start((ActionExecutor.Context)context, (WorkflowAction)action);
        this.sleep(200);
        final WorkflowActionBean action1 = new WorkflowActionBean();
        action1.setId("actionId");
        action1.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'><host>localhost</host><command>echo</command><capture-output/><args>\"prop1=nothing\"</args></ssh>");
        action1.setName("ssh");
        SshActionExecutor ssh1 = new SshActionExecutor();
        final Context context1 = new Context(workflow, action1);
        this.sleep(500);
        ssh1.start((ActionExecutor.Context)context1, (WorkflowAction)action1);
        TestSshActionExecutor.assertEquals((String)action1.getExternalId(), (String)action.getExternalId());
        this.waitFor(30000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                ssh.check((ActionExecutor.Context)context1, (WorkflowAction)action1);
                return WorkflowAction.Status.DONE == action1.getStatus();
            }
        });
        ssh1.end((ActionExecutor.Context)context1, (WorkflowAction)action1);
        TestSshActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action1.getStatus());
        TestSshActionExecutor.assertEquals((String)"something", (String)PropertiesUtils.stringToProperties((String)action1.getData()).getProperty("prop1"));
    }

    public void testConnectionErrors() throws ActionExecutorException {
        String baseDir = this.getTestCaseDir();
        Path appPath = new Path(this.getNameNodeUri(), baseDir);
        XConfiguration protoConf = new XConfiguration();
        protoConf.setStrings("user.name", new String[]{TestSshActionExecutor.getTestUser()});
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("oozie.wf.application.path", appPath.toString());
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setConf(wfConf.toXmlString());
        workflow.setAppPath(wfConf.get("oozie.wf.application.path"));
        workflow.setProtoActionConf(protoConf.toXmlString());
        workflow.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.WORKFLOW));
        WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'><host>blabla</host><command>echo</command><args>\"prop1=something\"</args></ssh>");
        action.setName("ssh");
        SshActionExecutor ssh = new SshActionExecutor();
        Context context = new Context(workflow, action);
        try {
            ssh.start((ActionExecutor.Context)context, (WorkflowAction)action);
        }
        catch (ActionExecutorException ex) {
            System.out.println("Testing COULD_NOT_RESOLVE_HOST");
            TestSshActionExecutor.assertEquals((String)"COULD_NOT_RESOLVE_HOST", (String)ex.getErrorCode());
            TestSshActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.TRANSIENT, (Object)ex.getErrorType());
        }
        action.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'><host>11.11.11.11</host><command>echo</command><args>\"prop1=something\"</args></ssh>");
        try {
            ssh.start((ActionExecutor.Context)context, (WorkflowAction)action);
        }
        catch (ActionExecutorException ex) {
            System.out.println("Testing COULD_NOT_CONNECT");
            TestSshActionExecutor.assertEquals((String)"COULD_NOT_CONNECT", (String)ex.getErrorCode());
            TestSshActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.TRANSIENT, (Object)ex.getErrorType());
        }
        action.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'><host>y@localhost</host><command>echo</command><args>\"prop1=something\"</args></ssh>");
        try {
            ssh.start((ActionExecutor.Context)context, (WorkflowAction)action);
        }
        catch (ActionExecutorException ex) {
            System.out.println("Testing AUTH_FAILED");
            TestSshActionExecutor.assertEquals((String)"AUTH_FAILED", (String)ex.getErrorCode());
            TestSshActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.NON_TRANSIENT, (Object)ex.getErrorType());
        }
    }

    public void testSpaceInArgs() throws Exception {
        String baseDir = this.getTestCaseDir();
        Path appPath = new Path(this.getNameNodeUri(), baseDir);
        Path script = new Path(baseDir, "script.sh");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.createJobConf());
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(script));
        w.write(this.ECHO_ARGS_SCRIPT);
        ((Writer)w).close();
        XConfiguration protoConf = new XConfiguration();
        protoConf.setStrings("user.name", new String[]{TestSshActionExecutor.getTestUser()});
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("oozie.wf.application.path", appPath.toString());
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setConf(wfConf.toXmlString());
        workflow.setAppPath(wfConf.get("oozie.wf.application.path"));
        workflow.setProtoActionConf(protoConf.toXmlString());
        workflow.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.WORKFLOW));
        final WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'><host>localhost</host><command>" + script.toString() + "</command><capture-output/><args>something</args><args>Hello World</args><args>\"Goodbye Planet\"</args><args>'Greetings Globe'</args></ssh>");
        action.setName("ssh");
        final SshActionExecutor ssh = new SshActionExecutor();
        final Context context = new Context(workflow, action);
        ssh.start((ActionExecutor.Context)context, (WorkflowAction)action);
        this.waitFor(30000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                ssh.check((ActionExecutor.Context)context, (WorkflowAction)action);
                return WorkflowAction.Status.DONE == action.getStatus();
            }
        });
        ssh.end((ActionExecutor.Context)context, (WorkflowAction)action);
        TestSshActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        TestSshActionExecutor.assertEquals((String)"something", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop1"));
        TestSshActionExecutor.assertEquals((String)"Hello", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop2"));
        TestSshActionExecutor.assertEquals((String)"World", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop3"));
        TestSshActionExecutor.assertEquals((String)"Goodbye", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop4"));
        TestSshActionExecutor.assertEquals((String)"Planet", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop5"));
        TestSshActionExecutor.assertEquals((String)"Greetings", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop6"));
        TestSshActionExecutor.assertEquals((String)"Globe", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop7"));
        TestSshActionExecutor.assertEquals((int)7, (int)PropertiesUtils.stringToProperties((String)action.getData()).size());
    }

    public void testSpaceInArg() throws Exception {
        String baseDir = this.getTestCaseDir();
        Path appPath = new Path(this.getNameNodeUri(), baseDir);
        Path script = new Path(baseDir, "script.sh");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.createJobConf());
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(script));
        w.write(this.ECHO_ARGS_SCRIPT);
        ((Writer)w).close();
        XConfiguration protoConf = new XConfiguration();
        protoConf.setStrings("user.name", new String[]{TestSshActionExecutor.getTestUser()});
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("oozie.wf.application.path", appPath.toString());
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setConf(wfConf.toXmlString());
        workflow.setAppPath(wfConf.get("oozie.wf.application.path"));
        workflow.setProtoActionConf(protoConf.toXmlString());
        workflow.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.WORKFLOW));
        final WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'><host>localhost</host><command>" + script.toString() + "</command><capture-output/><arg>something</arg><arg>Hello World</arg><arg>\"Goodbye Planet\"</arg><arg>'Greetings Globe'</arg></ssh>");
        action.setName("ssh");
        final SshActionExecutor ssh = new SshActionExecutor();
        final Context context = new Context(workflow, action);
        ssh.start((ActionExecutor.Context)context, (WorkflowAction)action);
        this.waitFor(30000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                ssh.check((ActionExecutor.Context)context, (WorkflowAction)action);
                return WorkflowAction.Status.DONE == action.getStatus();
            }
        });
        ssh.end((ActionExecutor.Context)context, (WorkflowAction)action);
        TestSshActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        TestSshActionExecutor.assertEquals((String)"something", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop1"));
        TestSshActionExecutor.assertEquals((String)"Hello World", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop2"));
        TestSshActionExecutor.assertEquals((String)"Goodbye Planet", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop3"));
        TestSshActionExecutor.assertEquals((String)"Greetings Globe", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop4"));
        TestSshActionExecutor.assertEquals((int)4, (int)PropertiesUtils.stringToProperties((String)action.getData()).size());
    }

    public void testNoArgsNorArg() throws Exception {
        String baseDir = this.getTestCaseDir();
        Path appPath = new Path(this.getNameNodeUri(), baseDir);
        Path script = new Path(baseDir, "script.sh");
        LocalFileSystem fs = FileSystem.getLocal((Configuration)this.createJobConf());
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)fs.create(script));
        w.write("echo \"prop1=something\"");
        ((Writer)w).close();
        XConfiguration protoConf = new XConfiguration();
        protoConf.setStrings("user.name", new String[]{TestSshActionExecutor.getTestUser()});
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("oozie.wf.application.path", appPath.toString());
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setConf(wfConf.toXmlString());
        workflow.setAppPath(wfConf.get("oozie.wf.application.path"));
        workflow.setProtoActionConf(protoConf.toXmlString());
        workflow.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.WORKFLOW));
        final WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'><host>localhost</host><command>" + script.toString() + "</command><capture-output/></ssh>");
        action.setName("ssh");
        final SshActionExecutor ssh = new SshActionExecutor();
        final Context context = new Context(workflow, action);
        ssh.start((ActionExecutor.Context)context, (WorkflowAction)action);
        this.waitFor(30000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                ssh.check((ActionExecutor.Context)context, (WorkflowAction)action);
                return WorkflowAction.Status.DONE == action.getStatus();
            }
        });
        ssh.end((ActionExecutor.Context)context, (WorkflowAction)action);
        TestSshActionExecutor.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        TestSshActionExecutor.assertEquals((String)"something", (String)PropertiesUtils.stringToProperties((String)action.getData()).getProperty("prop1"));
    }

    public void testSshCheckWithInvalidXml() throws Exception {
        String baseDir = this.getTestCaseDir();
        Path appPath = new Path(this.getNameNodeUri(), baseDir);
        XConfiguration protoConf = new XConfiguration();
        protoConf.setStrings("user.name", new String[]{TestSshActionExecutor.getTestUser()});
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("oozie.wf.application.path", appPath.toString());
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setConf(wfConf.toXmlString());
        workflow.setAppPath(wfConf.get("oozie.wf.application.path"));
        workflow.setProtoActionConf(protoConf.toXmlString());
        workflow.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.WORKFLOW));
        WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'> invalid body ");
        action.setName("ssh");
        SshActionExecutor ssh = new SshActionExecutor();
        Context context = new Context(workflow, action);
        try {
            ssh.check((ActionExecutor.Context)context, (WorkflowAction)action);
            TestSshActionExecutor.fail((String)"testSshCheckWithInvalidXml expected ex error");
        }
        catch (ActionExecutorException aex) {
            TestSshActionExecutor.assertEquals((String)"ERR_XML_PARSE_FAILED", (String)aex.getErrorCode());
            TestSshActionExecutor.assertEquals((Object)ActionExecutorException.ErrorType.ERROR, (Object)aex.getErrorType());
        }
    }

    public void testSshStartWithInvalidXml() throws Exception {
        String baseDir = this.getTestCaseDir();
        Path appPath = new Path(this.getNameNodeUri(), baseDir);
        XConfiguration protoConf = new XConfiguration();
        protoConf.setStrings("user.name", new String[]{TestSshActionExecutor.getTestUser()});
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("oozie.wf.application.path", appPath.toString());
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setConf(wfConf.toXmlString());
        workflow.setAppPath(wfConf.get("oozie.wf.application.path"));
        workflow.setProtoActionConf(protoConf.toXmlString());
        workflow.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.WORKFLOW));
        WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'> invalid body ");
        action.setName("ssh");
        SshActionExecutor ssh = new SshActionExecutor();
        Context context = new Context(workflow, action);
        try {
            ssh.start((ActionExecutor.Context)context, (WorkflowAction)action);
            TestSshActionExecutor.fail((String)"testSshStartWithInvalidXml expected ex error");
        }
        catch (ActionExecutorException actionExecutorException) {
            // empty catch block
        }
    }

    public void testJobStartAndKill() throws Exception {
        String baseDir = this.getTestCaseDir();
        Path appPath = new Path(this.getNameNodeUri(), baseDir);
        XConfiguration protoConf = new XConfiguration();
        protoConf.setStrings("user.name", new String[]{TestSshActionExecutor.getTestUser()});
        XConfiguration wfConf = new XConfiguration();
        wfConf.set("oozie.wf.application.path", appPath.toString());
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setConf(wfConf.toXmlString());
        workflow.setAppPath(wfConf.get("oozie.wf.application.path"));
        workflow.setProtoActionConf(protoConf.toXmlString());
        workflow.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.WORKFLOW));
        WorkflowActionBean action = new WorkflowActionBean();
        action.setId("actionId");
        action.setConf("<ssh xmlns='" + this.getActionXMLSchema() + "'><host>localhost</host><command>top</command><capture-output/></ssh>");
        action.setName("ssh");
        SshActionExecutor ssh = new SshActionExecutor();
        Context context = new Context(workflow, action);
        ssh.start((ActionExecutor.Context)context, (WorkflowAction)action);
        Context contextMock = (Context)Mockito.mock(Context.class);
        ssh.kill((ActionExecutor.Context)contextMock, (WorkflowAction)action);
        ((Context)Mockito.verify((Object)contextMock)).setEndData(WorkflowAction.Status.KILLED, "ERROR");
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private class Context
    implements ActionExecutor.Context {
        private WorkflowActionBean action;
        private WorkflowJobBean workflow;

        public Context(WorkflowJobBean workflow, WorkflowActionBean action) {
            this.workflow = workflow;
            this.action = action;
        }

        public Configuration getProtoActionConf() {
            String s = this.workflow.getProtoActionConf();
            try {
                return new XConfiguration((Reader)new StringReader(s));
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }

        public WorkflowJob getWorkflow() {
            return this.workflow;
        }

        public ELEvaluator getELEvaluator() {
            throw new UnsupportedOperationException();
        }

        public void setVar(String name, String value) {
            throw new UnsupportedOperationException();
        }

        public String getVar(String name) {
            throw new UnsupportedOperationException();
        }

        public boolean isRetry() {
            throw new UnsupportedOperationException();
        }

        public void setExternalStatus(String externalStatus) {
            this.action.setExternalStatus(externalStatus);
        }

        public void setEndData(WorkflowAction.Status status, String signalValue) {
            this.action.setEndData(status, signalValue);
        }

        public void setExecutionData(String externalStatus, Properties actionData) {
            this.action.setExecutionData(externalStatus, actionData);
        }

        public void setExecutionStats(String jsonStats) {
            this.action.setExecutionStats(jsonStats);
        }

        public void setExternalChildIDs(String externalChildIDs) {
            this.action.setExternalChildIDs(externalChildIDs);
        }

        public void setStartData(String externalId, String trackerUri, String consoleUrl) {
            this.action.setStartData(externalId, trackerUri, consoleUrl);
        }

        public String getCallbackUrl(String externalStatusVar) {
            return ((CallbackService)Services.get().get(CallbackService.class)).createCallBackUrl(this.action.getId(), externalStatusVar);
        }

        public String getRecoveryId() {
            return this.action.getId();
        }

        public Path getActionDir() throws URISyntaxException, IOException {
            String name = this.getWorkflow().getId() + "/" + this.action.getName() + "--" + this.action.getType();
            FileSystem fs = this.getAppFileSystem();
            String actionDirPath = Services.get().getSystemId() + "/" + name;
            Path fqActionDir = new Path(fs.getHomeDirectory(), actionDirPath);
            return fqActionDir;
        }

        public FileSystem getAppFileSystem() throws IOException, URISyntaxException {
            return TestSshActionExecutor.this.getFileSystem();
        }

        public void setErrorInfo(String str, String exMsg) {
        }
    }
}

