/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Properties;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.cli.CLIParser;
import org.apache.oozie.cli.OozieCLI;
import org.apache.oozie.client.HeaderTestingVersionServlet;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.MetricsInstrumentationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ShareLibService;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockCoordinatorEngineService;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V1AdminServlet;
import org.apache.oozie.servlet.V1JobServlet;
import org.apache.oozie.servlet.V1JobsServlet;
import org.apache.oozie.servlet.V2AdminServlet;
import org.apache.oozie.servlet.V2JobServlet;
import org.apache.oozie.servlet.V2ValidateServlet;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;

public class TestOozieCLI
extends DagServletTestCase {
    static final boolean IS_SECURITY_ENABLED = false;
    static final String VERSION = "/v2";
    static final String[] END_POINTS;
    static final Class[] SERVLET_CLASSES;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        MockDagEngineService.reset();
        MockCoordinatorEngineService.reset();
    }

    private String createConfigFile(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".xml";
        Configuration conf = new Configuration(false);
        conf.set("oozie.wf.application.path", appPath);
        conf.set("oozie.wf.rerun.skip.nodes", "node");
        FileOutputStream os = new FileOutputStream(path);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        return path;
    }

    private String createCoodrConfigFile(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".xml";
        Configuration conf = new Configuration(false);
        conf.set("oozie.coord.application.path", appPath);
        FileOutputStream os = new FileOutputStream(path);
        conf.writeXml((OutputStream)os);
        ((OutputStream)os).close();
        return path;
    }

    private String createPropertiesFile(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".properties";
        Properties props = new Properties();
        props.setProperty("user.name", TestOozieCLI.getTestUser());
        props.setProperty("group.name", TestOozieCLI.getTestGroup());
        props.setProperty("oozie.wf.application.path", appPath);
        props.setProperty("oozie.wf.rerun.skip.nodes", "node");
        props.setProperty("a", "A");
        FileOutputStream os = new FileOutputStream(path);
        props.store(os, "");
        ((OutputStream)os).close();
        return path;
    }

    private String createPropertiesFileWithTrailingSpaces(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".properties";
        Properties props = new Properties();
        props.setProperty("user.name", TestOozieCLI.getTestUser());
        props.setProperty("group.name", TestOozieCLI.getTestGroup());
        props.setProperty("oozie.wf.application.path", appPath);
        props.setProperty("oozie.wf.rerun.skip.nodes ", " node ");
        FileOutputStream os = new FileOutputStream(path);
        props.store(os, "");
        ((OutputStream)os).close();
        return path;
    }

    private String createPigPropertiesFile(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".properties";
        Properties props = new Properties();
        props.setProperty("user.name", TestOozieCLI.getTestUser());
        props.setProperty("fs.default.name", "localhost:9000");
        props.setProperty("mapred.job.tracker", "localhost:9001");
        props.setProperty("oozie.libpath", appPath);
        props.setProperty("mapred.output.dir", appPath);
        props.setProperty("a", "A");
        FileOutputStream os = new FileOutputStream(path);
        props.store(os, "");
        ((OutputStream)os).close();
        return path;
    }

    private String createMRProperties(String appPath, boolean useNewAPI) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".properties";
        Properties props = new Properties();
        props.setProperty("user.name", TestOozieCLI.getTestUser());
        props.setProperty("group.name", TestOozieCLI.getTestGroup());
        props.setProperty("oozie.wf.application.path", appPath);
        props.setProperty("oozie.wf.rerun.skip.nodes", "node");
        props.setProperty("fs.default.name", "localhost:9000");
        props.setProperty("mapred.job.tracker", "localhost:9001");
        if (useNewAPI) {
            props.setProperty("mapreduce.map.class", "mapper.class");
            props.setProperty("mapreduce.reduce.class", "reducer.class");
        } else {
            props.setProperty("mapred.mapper.class", "mapper.class");
            props.setProperty("mapred.reducer.class", "reducer.class");
        }
        props.setProperty("mapred.input.dir", "input");
        props.setProperty("mapred.output.dir", "output");
        props.setProperty("oozie.libpath", appPath);
        props.setProperty("a", "A");
        FileOutputStream os = new FileOutputStream(path);
        props.store(os, "");
        ((OutputStream)os).close();
        return path;
    }

    private String createPigScript(String appPath) throws Exception {
        String path = this.getTestCaseDir() + "/" + this.getName() + ".properties";
        DataOutputStream dos = new DataOutputStream(new FileOutputStream(path));
        String pigScript = "A = load '/user/data' using PigStorage(:);\nB = foreach A generate $0dumb B;";
        dos.writeBytes(pigScript);
        dos.close();
        return path;
    }

    public void testSubmit() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String[] args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString())};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"submit", (String)MockDagEngineService.did);
                Assert.assertFalse((boolean)MockDagEngineService.started.get(wfCount));
                args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createPropertiesFile(appPath.toString())};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"submit", (String)MockDagEngineService.did);
                Assert.assertFalse((boolean)MockDagEngineService.started.get(++wfCount));
                MockDagEngineService.reset();
                wfCount = 4;
                args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createPropertiesFile(appPath.toString()) + "x"};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertEquals(null, (String)MockDagEngineService.did);
                try {
                    MockDagEngineService.started.get(wfCount);
                    Assert.fail();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    public void testSubmitPig() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                String[] args = new String[]{"pig", "-oozie", oozieUrl, "-file", TestOozieCLI.this.createPigScript(appPath.toString()), "-config", TestOozieCLI.this.createPigPropertiesFile(appPath.toString())};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"submitPig", (String)MockDagEngineService.did);
                Assert.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testSubmitMapReduce() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                String[] args = new String[]{"mapreduce", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createMRProperties(appPath.toString(), false)};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"submitMR", (String)MockDagEngineService.did);
                Assert.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testSubmitMapReduce2() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                String[] args = new String[]{"mapreduce", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createMRProperties(appPath.toString(), true)};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"submitMR", (String)MockDagEngineService.did);
                Assert.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testSubmitDoAs() throws Exception {
        this.setSystemProperty("oozie.authentication.simple.anonymous.allowed", "false");
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String[] args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-doas", TestOozieCLI.getTestUser2()};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"submit", (String)MockDagEngineService.did);
                Assert.assertEquals((String)TestOozieCLI.getTestUser2(), (String)MockDagEngineService.user);
                return null;
            }
        });
    }

    public void testSubmitWithPropertyArguments() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String[] args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-Da=X", "-Db=B"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"submit", (String)MockDagEngineService.did);
                Assert.assertFalse((boolean)MockDagEngineService.started.get(wfCount));
                Assert.assertEquals((String)"X", (String)MockDagEngineService.submittedConf.get("a"));
                Assert.assertEquals((String)"B", (String)MockDagEngineService.submittedConf.get("b"));
                return null;
            }
        });
    }

    public void testRun() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                String[] args = new String[]{"job", "-run", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString())};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"submit", (String)MockDagEngineService.did);
                Assert.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testRunWithDebug() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                int wfCount = 4;
                String[] args = new String[]{"job", "-run", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-debug"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"submit", (String)MockDagEngineService.did);
                Assert.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testStart() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-start", "job-1-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"start", (String)MockDagEngineService.did);
                Assert.assertTrue((boolean)MockDagEngineService.started.get(1));
                args = new String[]{"job", "-oozie", oozieUrl, "-start", "job-" + (MockDagEngineService.workflows.size() + 1)};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                return null;
            }
        });
    }

    public void testSuspend() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-suspend", "job-1-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"suspend", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-suspend", "job-" + (MockDagEngineService.workflows.size() + 1)};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                return null;
            }
        });
    }

    public void testResume() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-resume", "job-1-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"resume", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-resume", "job-" + (MockDagEngineService.workflows.size() + 1)};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                return null;
            }
        });
    }

    public void testKill() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-kill", "job-1-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"kill", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-kill", "job-" + (MockDagEngineService.workflows.size() + 1)};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                return null;
            }
        });
    }

    public void testBulkSuspendResumeKill1() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"jobs", "-oozie", oozieUrl, "-suspend", "-filter", "name=workflow-1"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"jobs", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-resume", "-filter", "name=workflow-1"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"jobs", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-kill", "-filter", "name=workflow-1"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"jobs", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testBulkSuspendResumeKill2() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"jobs", "-oozie", oozieUrl, "-suspend", "-filter", "name=coordinator", "-jobtype", "coordinator"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"jobs", (String)MockCoordinatorEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-resume", "-filter", "name=coordinator", "-jobtype", "coordinator"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"jobs", (String)MockCoordinatorEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-kill", "-filter", "name=coordinator", "-jobtype", "coordinator"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"jobs", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testBulkCommandWithoutFilterNegative() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"jobs", "-oozie", oozieUrl, "-suspend", "-jobtype", "coordinator"};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertNull((Object)MockCoordinatorEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-resume", "-jobtype", "coordinator"};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertNull((Object)MockCoordinatorEngineService.did);
                args = new String[]{"jobs", "-oozie", oozieUrl, "-kill", "-jobtype", "coordinator"};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertNull((Object)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testCoordActionKill1() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-kill", "coord-job-C-1", "-action", "1"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"kill", (String)MockCoordinatorEngineService.did);
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testCoordActionKill2() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-kill", "coord-job-C-1", "-date", "2009-12-15T01:00Z::2009-12-16T01:00Z"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"kill", (String)MockCoordinatorEngineService.did);
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testReRun() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-rerun", "job-1-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"rerun", (String)MockDagEngineService.did);
                Assert.assertTrue((boolean)MockDagEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testCoordReRun1() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-1", "-action", "1"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"coord-rerun", (String)MockCoordinatorEngineService.did);
                Assert.assertTrue((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testCoordReRun2() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-1", "-date", "2009-12-15T01:00Z::2009-12-16T01:00Z"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"coord-rerun", (String)MockCoordinatorEngineService.did);
                Assert.assertTrue((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testCoordReRun3() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-0", "-action", "0", "-refresh"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"coord-rerun", (String)MockCoordinatorEngineService.did);
                Assert.assertTrue((boolean)MockCoordinatorEngineService.started.get(0));
                return null;
            }
        });
    }

    public void testCoordReRun4() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-0", "-action", "0", "-nocleanup"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"coord-rerun", (String)MockCoordinatorEngineService.did);
                Assert.assertTrue((boolean)MockCoordinatorEngineService.started.get(0));
                return null;
            }
        });
    }

    public void testCoordReRunNeg1() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-1-W", "-date", "2009-12-15T01:00Z", "-action", "1"};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertNull((Object)MockCoordinatorEngineService.did);
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testCoordReRunNeg2() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-rerun", "coord-job-C-1-W"};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertNull((Object)MockCoordinatorEngineService.did);
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testCoordReRunNeg3() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-rerun", "coord-job-C-0"};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertNull((Object)MockCoordinatorEngineService.did);
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testCoordReRunNeg4() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createConfigFile(appPath.toString()), "-rerun", "coord-job-C-0", "-date", "2009-12-15T01:00Z", "-action", "1"};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertNull((Object)MockCoordinatorEngineService.did);
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testCoordJobIgnore() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-ignore", "coord-job-C-1"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                Assert.assertTrue((boolean)MockCoordinatorEngineService.started.get(1));
                MockCoordinatorEngineService.reset();
                args = new String[]{"job", "-oozie", oozieUrl, "ignore", "job-" + (MockCoordinatorEngineService.coordJobs.size() + 1)};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertNull((Object)MockCoordinatorEngineService.did);
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testCoordActionsIgnore() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-ignore", "coord-job-C-1", "-action", "1"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"ignore", (String)MockCoordinatorEngineService.did);
                Assert.assertTrue((boolean)MockCoordinatorEngineService.started.get(1));
                MockCoordinatorEngineService.reset();
                args = new String[]{"job", "-oozie", oozieUrl, "ignore", "job-" + (MockCoordinatorEngineService.coordJobs.size() + 1), "-action", "1"};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertNull((Object)MockCoordinatorEngineService.did);
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                MockCoordinatorEngineService.reset();
                args = new String[]{"job", "-oozie", oozieUrl, "-ignore", "coord-job-C-", "-action", ""};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertNull((Object)MockCoordinatorEngineService.did);
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testJobStatus() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                MockDagEngineService.reset();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-0-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-localtime", "-oozie", oozieUrl, "-info", "job-1-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-timezone", "PST", "-oozie", oozieUrl, "-info", "job-1-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-2-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-" + (MockDagEngineService.workflows.size() + 1)};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                return null;
            }
        });
    }

    public void testJobsStatus() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"jobs", "-len", "3", "-offset", "2", "-oozie", oozieUrl, "-filter", "name=x"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-localtime", "-len", "3", "-offset", "2", "-oozie", oozieUrl, "-filter", "name=x"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-timezone", "PST", "-len", "3", "-offset", "2", "-oozie", oozieUrl, "-filter", "name=x"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-jobtype", "coord", "-filter", "status=FAILED", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "startcreatedtime=2014-04-01T00:00Z;endcreatedtime=2014-05-01T00:00Z", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "startcreatedtime=-10d;endcreatedtime=-20m", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "sortby=lastmodifiedtime", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "sortby=lastmodifiedtime", "-jobtype", "coord", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "sortby=lastmodifiedtime", "-jobtype", "bundle", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "startcreatedtime=-10d;endcreatedtime=-20m", "-jobtype", "coord", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"filter", (String)MockDagEngineService.did);
                args = new String[]{"jobs", "-filter", "startcreatedtime=-10d;endcreatedtime=-20m", "-jobtype", "bundle", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"filter", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testHeaderPropagation() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                TestOozieCLI.this.setSystemProperty("header:header", "test");
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-start", "job-1-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"start", (String)MockDagEngineService.did);
                Assert.assertTrue((boolean)HeaderTestingVersionServlet.OOZIE_HEADERS.containsKey("header"));
                Assert.assertTrue((boolean)HeaderTestingVersionServlet.OOZIE_HEADERS.containsValue("test"));
                return null;
            }
        });
    }

    public void testOozieStatus() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-status", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertEquals((String)("System mode: NORMAL" + SYSTEM_LINE_SEPARATOR), (String)out);
                args = new String[]{"admin", "-oozie", oozieUrl, "-systemmode", "NORMAL"};
                out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertEquals((String)("System mode: NORMAL" + SYSTEM_LINE_SEPARATOR), (String)out);
                return null;
            }
        });
    }

    public void testServerBuildVersion() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-version", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertEquals((String)("Oozie server build version: " + BuildInfo.getBuildInfo().getProperty("build.version") + SYSTEM_LINE_SEPARATOR), (String)out);
                return null;
            }
        });
    }

    public void testClientBuildVersion() throws Exception {
        String[] args = new String[]{"version"};
        String out = this.runOozieCLIAndGetStdout(args);
        TestOozieCLI.assertEquals((String)("Oozie client build version: " + BuildInfo.getBuildInfo().getProperty("build.version") + SYSTEM_LINE_SEPARATOR), (String)out);
    }

    public void testJobInfo() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                MockDagEngineService.reset();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-0-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-1-W", "-len", "3", "-offset", "1"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-2-W", "-len", "2"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "job-3-W", "-offset", "3"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"info", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "coord-job-C-1-C"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                Assert.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(1));
                Assert.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(1000));
                MockCoordinatorEngineService.reset();
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "coord-job-C-1-C", "-len", "10", "-offset", "5", "-order", "desc", "-filter", "status=FAILED"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                Assert.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(5));
                Assert.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(10));
                Assert.assertEquals((String)MockCoordinatorEngineService.order, (String)"desc");
                Assert.assertEquals((String)MockCoordinatorEngineService.filter, (String)"status=FAILED");
                MockCoordinatorEngineService.reset();
                args = new String[]{"job", "-oozie", oozieUrl, "-info", "coord-job-C-1-C", "-len", "10", "-offset", "5", "-order", "desc", "-filter", "status!=FAILED"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                Assert.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(5));
                Assert.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(10));
                Assert.assertEquals((String)MockCoordinatorEngineService.order, (String)"desc");
                Assert.assertEquals((String)MockCoordinatorEngineService.filter, (String)"status!=FAILED");
                return null;
            }
        });
    }

    public void testJobPoll() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                MockDagEngineService.reset();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-poll", "job-1-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"status", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-poll", "job-1-W", "-interval", "10"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"status", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-poll", "job-1-W", "-timeout", "60"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"status", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-poll", "job-1-W", "-interval", "10", "-timeout", "60"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"status", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testJobLog() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                MockDagEngineService.reset();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-log", "job-0-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"log", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-log", "coord-job-C-0"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"log", (String)MockDagEngineService.did);
                args = new String[]{"job", "-oozie", oozieUrl, "-log", "coord-job-C-0", "-action", "0", "-date", "2009-12-16T01:00Z"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"log", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testJobDefinition() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestOozieCLI.this.getContextURL();
                MockDagEngineService.reset();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-definition", "job-0-W"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"definition", (String)MockDagEngineService.did);
                return null;
            }
        });
    }

    public void testPropertiesWithTrailingSpaces() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "workflow.xml")).close();
                String[] args = new String[]{"job", "-submit", "-oozie", oozieUrl, "-config", TestOozieCLI.this.createPropertiesFileWithTrailingSpaces(appPath.toString())};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"submit", (String)MockDagEngineService.did);
                String confStr = MockDagEngineService.workflows.get(4).getConf();
                XConfiguration conf = new XConfiguration((Reader)new StringReader(confStr));
                Assert.assertNotNull((Object)conf.get("oozie.wf.rerun.skip.nodes"));
                Assert.assertEquals((String)"node", (String)conf.get("oozie.wf.rerun.skip.nodes"));
                return null;
            }
        });
    }

    public void testAdminQueueDump() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-queuedump", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("Server Queue Dump"));
                return null;
            }
        });
    }

    public void testInfo() throws Exception {
        String[] args = new String[]{"info"};
        TestOozieCLI.assertEquals((int)0, (int)new OozieCLI().run(args));
        args = new String[]{"info", "-timezones"};
        String out = this.runOozieCLIAndGetStdout(args);
        TestOozieCLI.assertTrue((boolean)out.contains("Available Time Zones"));
    }

    public void testValidateWorkFlowCommand() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String validFileName = "test-workflow-app.xml";
                String invalidFileName = "test-invalid-workflow-app.xml";
                String validContent = "<workflow-app xmlns=\"uri:oozie:workflow:0.2\" name=\"no-op-wf\">  <start to=\"end\"/> <end name=\"end\"/> </workflow-app>";
                String invalidContent = "<workflow-app xmlns=\"uri:oozie:workflow:0.2\" name=\"f\">  <tag=\"end\"/> <tag=\"end\"/> </workflow-app>";
                File validfile = new File(validFileName);
                File invalidfile = new File(invalidFileName);
                validfile.delete();
                invalidfile.delete();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                IOUtils.copyCharStream((Reader)new StringReader(validContent), (Writer)new FileWriter(validfile));
                String[] args = new String[]{"validate", "-oozie", oozieUrl, validfile.getAbsolutePath()};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("Valid"));
                IOUtils.copyCharStream((Reader)new StringReader(invalidContent), (Writer)new FileWriter(invalidfile));
                args = new String[]{"validate", "-oozie", oozieUrl, invalidfile.getAbsolutePath()};
                out = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                Assert.assertTrue((boolean)out.contains("XML schema error"));
                return null;
            }
        });
    }

    public void testChangeValue() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl, "-change", "coord-job-C-0", "-value", "concurrency=10"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testSlaEvents() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"sla", "-oozie", oozieUrl, "-len", "1"};
                String out = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                Assert.assertTrue((boolean)out.contains("Could not authenticate, Authentication failed, status: 404, message: Not Found"));
                return null;
            }
        });
    }

    public void testshareLibUpdate() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Services.get().setService(ShareLibService.class);
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-sharelibupdate", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("ShareLib update status"));
                return null;
            }
        });
    }

    public void testshareLibUpdate_withSecurity() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, true, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-sharelibupdate", "-oozie", oozieUrl, "-auth", "simple"};
                String out = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                Assert.assertEquals((String)"Error: E0503 : E0503: User [test] does not have admin privileges\n", (String)out);
                return null;
            }
        });
    }

    public void testGetShareLib() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Services.get().setService(ShareLibService.class);
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-shareliblist", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("Available ShareLib"));
                return null;
            }
        });
    }

    public void testGetShareLib_withKey() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Services.get().setService(ShareLibService.class);
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-shareliblist", "pig", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("Available ShareLib"));
                return null;
            }
        });
    }

    public void testJobDryrun() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Path appPath = new Path(TestOozieCLI.this.getFsTestCaseDir(), "app");
                TestOozieCLI.this.getFileSystem().mkdirs(appPath);
                TestOozieCLI.this.getFileSystem().create(new Path(appPath, "coordinator.xml")).close();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-dryrun", "-config", TestOozieCLI.this.createCoodrConfigFile(appPath.toString()), "-oozie", oozieUrl, "-Doozie.proxysubmission=true"};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)MockCoordinatorEngineService.did, (String)"dryrun");
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testUpdate() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-update", "aaa", "-oozie", oozieUrl};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)MockCoordinatorEngineService.did, (String)"update");
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testUpdateWithDryrun() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-update", "aaa", "-dryrun", "-oozie", oozieUrl};
                Assert.assertEquals((int)-1, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)MockCoordinatorEngineService.did, (String)"update&dryrun");
                Assert.assertFalse((boolean)MockCoordinatorEngineService.started.get(1));
                return null;
            }
        });
    }

    public void testFailNoArg() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStderr(args);
                Assert.assertTrue((boolean)out.contains("Invalid sub-command"));
                return null;
            }
        });
    }

    public void testRetryForTimeout() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = "http://localhost:11/oozie";
                String[] args = new String[]{"job", "-update", "aaa", "-dryrun", "-oozie", oozieUrl, "-debug"};
                OozieCLI cli = new OozieCLI();
                CLIParser parser = cli.getCLIParser();
                try {
                    CLIParser.Command command = parser.parse(args);
                    cli.processCommand(parser, command);
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)e.getMessage().contains("Error while connecting Oozie server. No of retries = 4. Exception = Connection refused"));
                }
                return null;
            }
        });
    }

    public void testNoRetryForError() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-info", "aaa", "-oozie", oozieUrl, "-debug"};
                OozieCLI cli = new OozieCLI();
                CLIParser parser = cli.getCLIParser();
                try {
                    CLIParser.Command command = parser.parse(args);
                    cli.processCommand(parser, command);
                }
                catch (Exception e) {
                    Assert.assertFalse((boolean)e.getMessage().contains("Error while connecting Oozie server"));
                    Assert.assertTrue((boolean)e.getMessage().contains("invalid job id [aaa]"));
                }
                return null;
            }
        });
    }

    public void testRetryWithRetryCount() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = "http://localhost:11/oozie";
                String[] args = new String[]{"job", "-update", "aaa", "-dryrun", "-oozie", oozieUrl, "-debug"};
                OozieCLI cli = new OozieCLI(){

                    protected void setRetryCount(OozieClient wc) {
                        wc.setRetryCount(2);
                    }

                    public CLIParser getCLIParser() {
                        return super.getCLIParser();
                    }
                };
                CLIParser parser = cli.getCLIParser();
                try {
                    CLIParser.Command command = parser.parse(args);
                    cli.processCommand(parser, command);
                }
                catch (Exception e) {
                    Assert.assertTrue((boolean)e.getMessage().contains("Error while connecting Oozie server. No of retries = 2. Exception = Connection refused"));
                }
                return null;
            }
        });
    }

    public void testAdminConfiguration() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-configuration", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("oozie.base.url"));
                return null;
            }
        });
    }

    public void testAdminOsEnv() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-osenv", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("JAVA_HOME"));
                return null;
            }
        });
    }

    public void testAdminJavaSystemProperties() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-javasysprops", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("java.vendor"));
                return null;
            }
        });
    }

    public void testAdminInstrumentation() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Services.get().setService(InstrumentationService.class);
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-instrumentation", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("webservices.version-GET"));
                args = new String[]{"admin", "-metrics", "-oozie", oozieUrl};
                out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("Metrics are unavailable"));
                return null;
            }
        });
    }

    public void testAdminMetrics() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                Services.get().setService(MetricsInstrumentationService.class);
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"admin", "-metrics", "-oozie", oozieUrl};
                String out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("webservices.version-GET"));
                args = new String[]{"admin", "-instrumentation", "-oozie", oozieUrl};
                out = TestOozieCLI.this.runOozieCLIAndGetStdout(args);
                Assert.assertTrue((boolean)out.contains("Instrumentation is unavailable"));
                return null;
            }
        });
    }

    public void testSlaEnable() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-slaenable", "aaa-C", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)MockCoordinatorEngineService.did, (String)"sla-enable");
                return null;
            }
        });
    }

    public void testSlaDisable() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-sladisable", "aaa-C", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)MockCoordinatorEngineService.did, (String)"sla-disable");
                return null;
            }
        });
    }

    public void testSlaChange() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HeaderTestingVersionServlet.OOZIE_HEADERS.clear();
                String oozieUrl = TestOozieCLI.this.getContextURL();
                String[] args = new String[]{"job", "-slachange", "aaa-C", "-oozie", oozieUrl};
                Assert.assertEquals((int)0, (int)new OozieCLI().run(args));
                Assert.assertEquals((String)MockCoordinatorEngineService.did, (String)"sla-change");
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runOozieCLIAndGetStdout(String[] args) {
        PrintStream original = System.out;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        String outStr = null;
        System.out.flush();
        try {
            System.setOut(ps);
            TestOozieCLI.assertEquals((int)0, (int)new OozieCLI().run(args));
            System.out.flush();
            outStr = baos.toString();
        }
        catch (Throwable throwable) {
            System.setOut(original);
            if (outStr != null) {
                System.out.print(outStr);
            }
            System.out.flush();
            throw throwable;
        }
        System.setOut(original);
        if (outStr != null) {
            System.out.print(outStr);
        }
        System.out.flush();
        return outStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String runOozieCLIAndGetStderr(String[] args) {
        PrintStream original = System.err;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        String outStr = null;
        System.err.flush();
        try {
            System.setErr(ps);
            TestOozieCLI.assertEquals((int)-1, (int)new OozieCLI().run(args));
            System.err.flush();
            outStr = baos.toString();
        }
        catch (Throwable throwable) {
            System.setErr(original);
            if (outStr != null) {
                System.err.print(outStr);
            }
            System.err.flush();
            throw throwable;
        }
        System.setErr(original);
        if (outStr != null) {
            System.err.print(outStr);
        }
        System.err.flush();
        return outStr;
    }

    static {
        new HeaderTestingVersionServlet();
        new V1JobServlet();
        new V1JobsServlet();
        new V1AdminServlet();
        new V2AdminServlet();
        new V2JobServlet();
        new V2ValidateServlet();
        END_POINTS = new String[]{"/versions", "/v2/jobs", "/v2/job/*", "/v2/admin/*", "/v2/validate/*"};
        SERVLET_CLASSES = new Class[]{HeaderTestingVersionServlet.class, V1JobsServlet.class, V2JobServlet.class, V2AdminServlet.class, V2ValidateServlet.class, V2JobServlet.class, V2AdminServlet.class};
    }
}

