/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.BulkResponse;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.JMSConnectionInfo;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.rest.BulkResponseImpl;
import org.apache.oozie.client.rest.JsonTags;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestOozieClientWithFakeServlet {
    private int answer = 0;
    private boolean check = true;

    @Test
    public void testGetJMSTopicName() throws Exception {
        this.answer = 0;
        this.check = true;
        FakeOozieClient client = new FakeOozieClient("http://url");
        String answer = client.getJMSTopicName("jobId");
        Assert.assertEquals((Object)"topicName", (Object)answer);
    }

    @Test
    public void testGetJMSConnectionInfo() throws Exception {
        this.answer = 1;
        this.check = true;
        FakeOozieClient client = new FakeOozieClient("http://url");
        JMSConnectionInfo answer = client.getJMSConnectionInfo();
        Assert.assertNotNull((Object)answer);
    }

    @Test
    public void testGetCoordActionInfo() throws Exception {
        this.answer = 1;
        this.check = true;
        FakeOozieClient client = new FakeOozieClient("http://url");
        CoordinatorAction answer = client.getCoordActionInfo("actiomId");
        Assert.assertNotNull((Object)answer);
    }

    @Test
    public void testGetBundleJobsInfo() throws Exception {
        this.answer = 2;
        this.check = true;
        FakeOozieClient client = new FakeOozieClient("http://url");
        List answer = client.getBundleJobsInfo("", 0, 10);
        Assert.assertNotNull((Object)answer);
        Assert.assertEquals((long)1L, (long)answer.size());
    }

    @Test
    public void testGetBulkInfo() throws Exception {
        this.answer = 3;
        this.check = true;
        FakeOozieClient client = new FakeOozieClient("http://url");
        List answer = client.getBulkInfo("", 0, 10);
        Assert.assertNotNull((Object)answer);
        Assert.assertEquals((long)2L, (long)answer.size());
        Assert.assertEquals((Object)CoordinatorAction.Status.READY, (Object)((BulkResponse)answer.get(0)).getAction().getStatus());
    }

    @Test
    public void testBundleRerun() throws Exception {
        this.answer = 1;
        this.check = true;
        FakeOozieClient client = new FakeOozieClient("http://url");
        Void answer = client.reRunBundle("jobId", "", "", true, true);
        Assert.assertNull((Object)answer);
    }

    private class FakeOozieClient
    extends OozieClient {
        public FakeOozieClient(String oozieUrl) {
            super(oozieUrl);
        }

        protected HttpURLConnection createConnection(URL url, String method) throws IOException, OozieClientException {
            HttpURLConnection result = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
            Mockito.when((Object)result.getResponseCode()).thenReturn((Object)200);
            Mockito.when((Object)result.getInputStream()).thenReturn((Object)this.getIs());
            return result;
        }

        private InputStream getIs() {
            ArrayList<Object> jsonWorkflows;
            JSONObject json;
            ByteArrayInputStream result = new ByteArrayInputStream("".getBytes());
            if (TestOozieClientWithFakeServlet.this.check) {
                JSONArray array = new JSONArray();
                array.add((Object)2L);
                String s = JSONValue.toJSONString((Object)array);
                result = new ByteArrayInputStream(s.getBytes());
                TestOozieClientWithFakeServlet.this.check = false;
                return result;
            }
            if (TestOozieClientWithFakeServlet.this.answer == 0) {
                json = new JSONObject();
                json.put((Object)"jmsTopicName", (Object)"topicName");
                result = new ByteArrayInputStream(json.toJSONString().getBytes());
            }
            if (TestOozieClientWithFakeServlet.this.answer == 1) {
                json = new JSONObject();
                result = new ByteArrayInputStream(json.toJSONString().getBytes());
            }
            if (TestOozieClientWithFakeServlet.this.answer == 2) {
                json = new JSONObject();
                jsonWorkflows = new ArrayList<Object>();
                jsonWorkflows.add(new WorkflowJobBean());
                json.put(JsonTags.BUNDLE_JOBS, (Object)WorkflowJobBean.toJSONArray(jsonWorkflows, (String)"GMT"));
                result = new ByteArrayInputStream(json.toJSONString().getBytes());
            }
            if (TestOozieClientWithFakeServlet.this.answer == 3) {
                json = new JSONObject();
                jsonWorkflows = new ArrayList();
                BulkResponseImpl bulk = new BulkResponseImpl();
                bulk.setBundle(new BundleJobBean());
                bulk.setCoordinator(new CoordinatorJobBean());
                CoordinatorActionBean action = new CoordinatorActionBean();
                action.setStatus(CoordinatorAction.Status.READY);
                bulk.setAction(action);
                jsonWorkflows.add(bulk);
                jsonWorkflows.add(bulk);
                json.put(JsonTags.BULK_RESPONSES, (Object)BulkResponseImpl.toJSONArray(jsonWorkflows, (String)"GMT"));
                result = new ByteArrayInputStream(json.toJSONString().getBytes());
            }
            return result;
        }
    }
}

