/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.Properties;
import java.util.concurrent.Callable;
import junit.framework.Assert;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.client.HeaderTestingVersionServlet;
import org.apache.oozie.client.XOozieClient;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V1AdminServlet;
import org.apache.oozie.servlet.V1JobsServlet;

public class TestWorkflowXClient
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;
    static final String VERSION = "/v2";
    static final String[] END_POINTS;
    static final Class[] SERVLET_CLASSES;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        MockDagEngineService.reset();
    }

    public void testSubmitPig() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowXClient.this.getContextURL();
                int wfCount = 4;
                XOozieClient wc = new XOozieClient(oozieUrl);
                Properties conf = wc.createConfiguration();
                Path libPath = new Path(TestWorkflowXClient.this.getFsTestCaseDir(), "lib");
                TestWorkflowXClient.this.getFileSystem().mkdirs(libPath);
                conf.setProperty("oozie.libpath", libPath.toString());
                conf.setProperty("mapred.job.tracker", "localhost:9001");
                conf.setProperty("fs.default.name", "hdfs://localhost:9000");
                String[] params = new String[]{"INPUT=input.txt"};
                String pigScriptFile = TestWorkflowXClient.this.getTestCaseDir() + "/test";
                BufferedWriter writer = new BufferedWriter(new FileWriter(pigScriptFile));
                writer.write("a = load '${INPUT}';\n dump a;");
                writer.close();
                Assert.assertEquals((String)("job-" + wfCount + "-W"), (String)wc.submitScriptLanguage(conf, pigScriptFile, null, params, "pig"));
                Assert.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testSubmitHive() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowXClient.this.getContextURL();
                int wfCount = 4;
                XOozieClient wc = new XOozieClient(oozieUrl);
                Properties conf = wc.createConfiguration();
                Path libPath = new Path(TestWorkflowXClient.this.getFsTestCaseDir(), "lib");
                TestWorkflowXClient.this.getFileSystem().mkdirs(libPath);
                System.out.println(libPath.toString());
                conf.setProperty("oozie.libpath", libPath.toString());
                conf.setProperty("mapred.job.tracker", "localhost:9001");
                conf.setProperty("fs.default.name", "hdfs://localhost:9000");
                String[] params = new String[]{"NAME=test"};
                String hiveScriptFile = TestWorkflowXClient.this.getTestCaseDir() + "/test";
                System.out.println(hiveScriptFile);
                BufferedWriter writer = new BufferedWriter(new FileWriter(hiveScriptFile));
                writer.write("CREATE EXTERNAL TABLE ${NAME} (a INT);");
                writer.close();
                Assert.assertEquals((String)("job-" + wfCount + "-W"), (String)wc.submitScriptLanguage(conf, hiveScriptFile, null, params, "hive"));
                Assert.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testSubmitSqoop() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowXClient.this.getContextURL();
                int wfCount = 4;
                XOozieClient wc = new XOozieClient(oozieUrl);
                Properties conf = wc.createConfiguration();
                Path libPath = new Path(TestWorkflowXClient.this.getFsTestCaseDir(), "lib");
                TestWorkflowXClient.this.getFileSystem().mkdirs(libPath);
                System.out.println(libPath.toString());
                conf.setProperty("oozie.libpath", libPath.toString());
                conf.setProperty("mapred.job.tracker", "localhost:9001");
                conf.setProperty("fs.default.name", "hdfs://localhost:9000");
                Assert.assertEquals((String)("job-" + wfCount + "-W"), (String)wc.submitSqoop(conf, new String[]{"import", "--connect", "jdbc:mysql://localhost:3306/oozie"}, null));
                Assert.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testSubmitMR() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowXClient.this.getContextURL();
                int wfCount = 4;
                XOozieClient wc = new XOozieClient(oozieUrl);
                Properties conf = wc.createConfiguration();
                Path libPath = new Path(TestWorkflowXClient.this.getFsTestCaseDir(), "lib");
                TestWorkflowXClient.this.getFileSystem().mkdirs(libPath);
                String localPath = libPath.toUri().getPath();
                int startPosition = libPath.toString().indexOf(localPath);
                String nn = libPath.toString().substring(0, startPosition);
                try {
                    wc.submitMapReduce(conf);
                    Assert.fail((String)"submit client without JT should throw exception");
                }
                catch (RuntimeException exception) {
                    Assert.assertEquals((String)"java.lang.RuntimeException: jobtracker is not specified in conf", (String)exception.toString());
                }
                conf.setProperty("mapred.job.tracker", "localhost:9001");
                try {
                    wc.submitMapReduce(conf);
                    Assert.fail((String)"submit client without NN should throw exception");
                }
                catch (RuntimeException exception) {
                    Assert.assertEquals((String)"java.lang.RuntimeException: namenode is not specified in conf", (String)exception.toString());
                }
                conf.setProperty("fs.default.name", nn);
                try {
                    wc.submitMapReduce(conf);
                    Assert.fail((String)"submit client without LIBPATH should throw exception");
                }
                catch (RuntimeException exception) {
                    Assert.assertEquals((String)"java.lang.RuntimeException: libpath is not specified in conf", (String)exception.toString());
                }
                conf.remove("fs.default.name");
                conf.setProperty("fs.defaultFS", nn);
                try {
                    wc.submitMapReduce(conf);
                    Assert.fail((String)"submit client without LIBPATH should throw exception");
                }
                catch (RuntimeException exception) {
                    Assert.assertEquals((String)"java.lang.RuntimeException: libpath is not specified in conf", (String)exception.toString());
                }
                conf.setProperty("oozie.libpath", localPath.substring(1));
                try {
                    wc.submitMapReduce(conf);
                    Assert.fail((String)"lib path can not be relative");
                }
                catch (RuntimeException e) {
                    Assert.assertEquals((String)"java.lang.RuntimeException: libpath should be absolute", (String)e.toString());
                }
                conf.setProperty("oozie.libpath", localPath);
                Assert.assertEquals((String)("job-" + wfCount + "-W"), (String)wc.submitMapReduce(conf));
                Assert.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                return null;
            }
        });
    }

    public void testSomeMethods() throws Exception {
        this.runTest(END_POINTS, SERVLET_CLASSES, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String oozieUrl = TestWorkflowXClient.this.getContextURL();
                XOozieClient wc = new XOozieClient(oozieUrl);
                Properties configuration = wc.createConfiguration();
                try {
                    wc.addFile(configuration, null);
                }
                catch (IllegalArgumentException e) {
                    Assert.assertEquals((String)"file cannot be null", (String)e.getMessage());
                }
                wc.addFile(configuration, "file1");
                wc.addFile(configuration, "file2");
                Assert.assertEquals((Object)"file1,file2", (Object)configuration.get("oozie.files"));
                try {
                    wc.addArchive(configuration, null);
                }
                catch (IllegalArgumentException e) {
                    Assert.assertEquals((String)"file cannot be null", (String)e.getMessage());
                }
                wc.addArchive(configuration, "archive1");
                wc.addArchive(configuration, "archive2");
                Assert.assertEquals((Object)"archive1,archive2", (Object)configuration.get("oozie.archives"));
                return null;
            }
        });
    }

    static {
        new HeaderTestingVersionServlet();
        new V1JobsServlet();
        new V1AdminServlet();
        END_POINTS = new String[]{"/versions", "/v2/jobs", "/v2/admin/*"};
        SERVLET_CLASSES = new Class[]{HeaderTestingVersionServlet.class, V1JobsServlet.class, V1AdminServlet.class};
    }
}

