/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.client.rest;

import junit.framework.TestCase;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.rest.JsonUtils;

public class TestJsonCoordinatorAction
extends TestCase {
    static String CREATE_TIME = "Sat, 05 Sep 2009 00:00:00 GMT";
    static String LAST_MODIFIED_TIME = "Sat, 05 Sep 2009 00:00:00 GMT";
    static String missingDependencies = "a:a, a/a, a//a";
    static String pushMissingDependencies = "hcat://a/b/c/d/f, hcat://1/2/3/4/5";

    static CoordinatorActionBean createAppAction() {
        CoordinatorActionBean app = new CoordinatorActionBean();
        app.setJobId("a");
        app.setId("c");
        app.setActionNumber(1);
        app.setRunConf("cc");
        app.setCreatedConf("cc");
        app.setExternalId("c_e");
        app.setCreatedTime(JsonUtils.parseDateRfc822((String)CREATE_TIME));
        app.setLastModifiedTime(JsonUtils.parseDateRfc822((String)LAST_MODIFIED_TIME));
        app.setStatus(CoordinatorAction.Status.WAITING);
        app.setConsoleUrl("http://consoleurl:8080");
        app.setMissingDependencies(missingDependencies);
        app.setPushMissingDependencies(pushMissingDependencies);
        return app;
    }

    public void testProperties() {
        CoordinatorActionBean app = TestJsonCoordinatorAction.createAppAction();
        TestJsonCoordinatorAction.assertEquals((String)"a", (String)app.getJobId());
        TestJsonCoordinatorAction.assertEquals((String)"c", (String)app.getId());
        TestJsonCoordinatorAction.assertEquals((int)1, (int)app.getActionNumber());
        TestJsonCoordinatorAction.assertEquals((String)"cc", (String)app.getRunConf());
        TestJsonCoordinatorAction.assertEquals((String)"cc", (String)app.getCreatedConf());
        TestJsonCoordinatorAction.assertEquals((String)"c_e", (String)app.getExternalId());
        TestJsonCoordinatorAction.assertEquals((Object)JsonUtils.parseDateRfc822((String)CREATE_TIME), (Object)app.getCreatedTime());
        TestJsonCoordinatorAction.assertEquals((Object)JsonUtils.parseDateRfc822((String)LAST_MODIFIED_TIME), (Object)app.getLastModifiedTime());
        TestJsonCoordinatorAction.assertEquals((Object)CoordinatorAction.Status.WAITING, (Object)app.getStatus());
        TestJsonCoordinatorAction.assertEquals((String)"http://consoleurl:8080", (String)app.getConsoleUrl());
        TestJsonCoordinatorAction.assertEquals((String)missingDependencies, (String)app.getMissingDependencies());
        TestJsonCoordinatorAction.assertEquals((String)pushMissingDependencies, (String)app.getPushMissingDependencies());
    }
}

