/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.PurgeXCommand;
import org.apache.oozie.executor.jpa.BundleActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;

public class TestPurgeXCommand
extends XDataTestCase {
    private Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testSucJobPurgeXCommand() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.OK);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(job.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.SUCCEEDED);
        TestPurgeXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.OK);
        WorkflowInstance wfInstance = job.getWorkflowInstance();
        TestPurgeXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.SUCCEEDED);
        new PurgeXCommand(7, 1, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testFailJobPurgeXCommand() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.FAILED, WorkflowInstance.Status.FAILED);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.FAILED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(job.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.FAILED);
        TestPurgeXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.FAILED);
        WorkflowInstance wfInstance = job.getWorkflowInstance();
        TestPurgeXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.FAILED);
        new PurgeXCommand(7, 1, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testKillJobPurgeXCommand() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.KILLED, WorkflowInstance.Status.KILLED);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.KILLED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(job.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.KILLED);
        TestPurgeXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.KILLED);
        WorkflowInstance wfInstance = job.getWorkflowInstance();
        TestPurgeXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.KILLED);
        new PurgeXCommand(7, 1, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testPurgeXCommandFailed() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTableForNegCase(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean action = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.RUNNING);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(job.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(action.getId());
        job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        action = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)job.getStatus(), (Object)WorkflowJob.Status.RUNNING);
        TestPurgeXCommand.assertEquals((Object)action.getStatus(), (Object)WorkflowAction.Status.RUNNING);
        WorkflowInstance wfInstance = job.getWorkflowInstance();
        TestPurgeXCommand.assertEquals((Object)wfInstance.getStatus(), (Object)WorkflowInstance.Status.RUNNING);
        new PurgeXCommand(7, 1, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException ce) {
            TestPurgeXCommand.fail((String)"Workflow Action should have been purged");
        }
    }

    public void testSucCoordPurgeXCommand() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetExecutor = new CoordJobGetJPAExecutor(job.getId());
        CoordActionGetJPAExecutor coordActionGetExecutor = new CoordActionGetJPAExecutor(action.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetExecutor);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetExecutor);
        TestPurgeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCEEDED);
        TestPurgeXCommand.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        new PurgeXCommand(1, 7, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetExecutor);
            TestPurgeXCommand.fail((String)"Coordinator Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetExecutor);
            TestPurgeXCommand.fail((String)"Coordinator Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testFailCoordPurgeXCommand() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.FAILED, false, false);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.FAILED, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetExecutor = new CoordJobGetJPAExecutor(job.getId());
        CoordActionGetJPAExecutor coordActionGetExecutor = new CoordActionGetJPAExecutor(action.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetExecutor);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetExecutor);
        TestPurgeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.FAILED);
        TestPurgeXCommand.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.FAILED);
        new PurgeXCommand(1, 7, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetExecutor);
            TestPurgeXCommand.fail((String)"Coordinator Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetExecutor);
            TestPurgeXCommand.fail((String)"Coordinator Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testKillCoordPurgeXCommand() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.KILLED, false, false);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetExecutor = new CoordJobGetJPAExecutor(job.getId());
        CoordActionGetJPAExecutor coordActionGetExecutor = new CoordActionGetJPAExecutor(action.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetExecutor);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetExecutor);
        TestPurgeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.KILLED);
        TestPurgeXCommand.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.KILLED);
        new PurgeXCommand(1, 7, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetExecutor);
            TestPurgeXCommand.fail((String)"Coordinator Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetExecutor);
            TestPurgeXCommand.fail((String)"Coordinator Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testCoordPurgeXCommandFailed() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetExecutor = new CoordJobGetJPAExecutor(job.getId());
        CoordActionGetJPAExecutor coordActionGetExecutor = new CoordActionGetJPAExecutor(action.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetExecutor);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetExecutor);
        TestPurgeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
        TestPurgeXCommand.assertEquals((Object)action.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        new PurgeXCommand(1, 7, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetExecutor);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetExecutor);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action should not have been purged");
        }
    }

    public void testSucBundlePurgeXCommand() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        this.addRecordToBundleActionTable(job.getId(), "action1", 0, Job.Status.SUCCEEDED);
        this.addRecordToBundleActionTable(job.getId(), "action2", 0, Job.Status.SUCCEEDED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)job.getStatus());
        BundleActionGetJPAExecutor bundleActionGetExecutor1 = new BundleActionGetJPAExecutor(job.getId(), "action1");
        BundleActionBean action1 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetExecutor1);
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)action1.getStatus());
        BundleActionGetJPAExecutor bundleActionGetExecutor2 = new BundleActionGetJPAExecutor(job.getId(), "action2");
        BundleActionBean action2 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetExecutor2);
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)action2.getStatus());
        new PurgeXCommand(1, 1, 7, 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetExecutor);
            TestPurgeXCommand.fail((String)"Bundle Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetExecutor1);
            TestPurgeXCommand.fail((String)"Bundle Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetExecutor2);
            TestPurgeXCommand.fail((String)"Bundle Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testFailBundlePurgeXCommand() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.DONEWITHERROR, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        this.addRecordToBundleActionTable(job.getId(), "action1", 0, Job.Status.FAILED);
        this.addRecordToBundleActionTable(job.getId(), "action2", 0, Job.Status.SUCCEEDED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestPurgeXCommand.assertEquals((Object)Job.Status.DONEWITHERROR, (Object)job.getStatus());
        BundleActionGetJPAExecutor bundleActionGetExecutor1 = new BundleActionGetJPAExecutor(job.getId(), "action1");
        BundleActionBean action1 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetExecutor1);
        TestPurgeXCommand.assertEquals((Object)Job.Status.FAILED, (Object)action1.getStatus());
        BundleActionGetJPAExecutor bundleActionGetExecutor2 = new BundleActionGetJPAExecutor(job.getId(), "action2");
        BundleActionBean action2 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetExecutor2);
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)action2.getStatus());
        new PurgeXCommand(1, 1, 7, 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetExecutor);
            TestPurgeXCommand.fail((String)"Bundle Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetExecutor1);
            TestPurgeXCommand.fail((String)"Bundle Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetExecutor2);
            TestPurgeXCommand.fail((String)"Bundle Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testKillBundlePurgeXCommand() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.KILLED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        this.addRecordToBundleActionTable(job.getId(), "action1", 0, Job.Status.KILLED);
        this.addRecordToBundleActionTable(job.getId(), "action2", 0, Job.Status.KILLED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestPurgeXCommand.assertEquals((Object)Job.Status.KILLED, (Object)job.getStatus());
        BundleActionGetJPAExecutor bundleActionGetExecutor1 = new BundleActionGetJPAExecutor(job.getId(), "action1");
        BundleActionBean action1 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetExecutor1);
        TestPurgeXCommand.assertEquals((Object)Job.Status.KILLED, (Object)action1.getStatus());
        BundleActionGetJPAExecutor bundleActionGetExecutor2 = new BundleActionGetJPAExecutor(job.getId(), "action2");
        BundleActionBean action2 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetExecutor2);
        TestPurgeXCommand.assertEquals((Object)Job.Status.KILLED, (Object)action2.getStatus());
        new PurgeXCommand(1, 1, 7, 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetExecutor);
            TestPurgeXCommand.fail((String)"Bundle Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetExecutor1);
            TestPurgeXCommand.fail((String)"Bundle Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetExecutor2);
            TestPurgeXCommand.fail((String)"Bundle Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testBundlePurgeXCommandFailed() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.RUNNING, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        this.addRecordToBundleActionTable(job.getId(), "action1", 0, Job.Status.RUNNING);
        this.addRecordToBundleActionTable(job.getId(), "action2", 0, Job.Status.SUCCEEDED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetExecutor = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        TestPurgeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
        BundleActionGetJPAExecutor bundleActionGetExecutor1 = new BundleActionGetJPAExecutor(job.getId(), "action1");
        BundleActionBean action1 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetExecutor1);
        TestPurgeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)action1.getStatus());
        BundleActionGetJPAExecutor bundleActionGetExecutor2 = new BundleActionGetJPAExecutor(job.getId(), "action2");
        BundleActionBean action2 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetExecutor2);
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)action2.getStatus());
        new PurgeXCommand(1, 1, 7, 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetExecutor);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetExecutor1);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetExecutor2);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action should not have been purged");
        }
    }

    public void testPurgeCoordWithWFChild1() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        new PurgeXCommand(7, TestPurgeXCommand.getNumDaysToNotBePurged(coordJob.getLastModifiedTime()), 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action should not have been purged");
        }
    }

    public void testPurgeLongRunningCoordWithWFChild() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        new PurgeXCommand(7, TestPurgeXCommand.getNumDaysToNotBePurged(coordJob.getLastModifiedTime()), 1, 10, true).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testPurgeLongRunningCoordWithWFChildNegative() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        new PurgeXCommand(7, TestPurgeXCommand.getNumDaysToNotBePurged(coordJob.getLastModifiedTime()), 1, 10, false).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action should not have been purged");
        }
    }

    public void testPurgeCoordWithWFChild2() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        new PurgeXCommand(TestPurgeXCommand.getNumDaysToNotBePurged(wfJob.getEndTime()), 7, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action should not have been purged");
        }
    }

    public void testPurgeCoordWithWFChild2MoreThanLimit() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob3 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob4 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob5 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction1 = this.addRecordToWfActionTable(wfJob1.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction2 = this.addRecordToWfActionTable(wfJob2.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction3 = this.addRecordToWfActionTable(wfJob3.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction4 = this.addRecordToWfActionTable(wfJob4.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction5 = this.addRecordToWfActionTable(wfJob5.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction1 = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob1.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction2 = this.addRecordToCoordActionTable(coordJob.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob2.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction3 = this.addRecordToCoordActionTable(coordJob.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob3.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction4 = this.addRecordToCoordActionTable(coordJob.getId(), 4, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob4.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction5 = this.addRecordToCoordActionTable(coordJob.getId(), 5, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob5.getId(), "SUCCEEDED", 0);
        WorkflowJobGetJPAExecutor wfJob1GetCmd = new WorkflowJobGetJPAExecutor(wfJob1.getId());
        WorkflowJobGetJPAExecutor wfJob2GetCmd = new WorkflowJobGetJPAExecutor(wfJob2.getId());
        WorkflowJobGetJPAExecutor wfJob3GetCmd = new WorkflowJobGetJPAExecutor(wfJob3.getId());
        WorkflowJobGetJPAExecutor wfJob4GetCmd = new WorkflowJobGetJPAExecutor(wfJob4.getId());
        WorkflowJobGetJPAExecutor wfJob5GetCmd = new WorkflowJobGetJPAExecutor(wfJob5.getId());
        WorkflowActionGetJPAExecutor wfAction1GetCmd = new WorkflowActionGetJPAExecutor(wfAction1.getId());
        WorkflowActionGetJPAExecutor wfAction2GetCmd = new WorkflowActionGetJPAExecutor(wfAction2.getId());
        WorkflowActionGetJPAExecutor wfAction3GetCmd = new WorkflowActionGetJPAExecutor(wfAction3.getId());
        WorkflowActionGetJPAExecutor wfAction4GetCmd = new WorkflowActionGetJPAExecutor(wfAction4.getId());
        WorkflowActionGetJPAExecutor wfAction5GetCmd = new WorkflowActionGetJPAExecutor(wfAction5.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordAction1GetCmd = new CoordActionGetJPAExecutor(coordAction1.getId());
        CoordActionGetJPAExecutor coordAction2GetCmd = new CoordActionGetJPAExecutor(coordAction2.getId());
        CoordActionGetJPAExecutor coordAction3GetCmd = new CoordActionGetJPAExecutor(coordAction3.getId());
        CoordActionGetJPAExecutor coordAction4GetCmd = new CoordActionGetJPAExecutor(coordAction4.getId());
        CoordActionGetJPAExecutor coordAction5GetCmd = new CoordActionGetJPAExecutor(coordAction5.getId());
        wfJob1 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob1GetCmd);
        wfJob2 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob2GetCmd);
        wfJob3 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob3GetCmd);
        wfJob4 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob4GetCmd);
        wfJob5 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob5GetCmd);
        wfAction1 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction1GetCmd);
        wfAction2 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction2GetCmd);
        wfAction3 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction3GetCmd);
        wfAction4 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction4GetCmd);
        wfAction5 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction5GetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction1 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction1GetCmd);
        coordAction2 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction2GetCmd);
        coordAction3 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction3GetCmd);
        coordAction4 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction4GetCmd);
        coordAction5 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction5GetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob5.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction5.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction5.getStatus());
        new PurgeXCommand(TestPurgeXCommand.getNumDaysToNotBePurged(wfJob1.getEndTime()), 7, 1, 3).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordAction1GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action 1 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordAction2GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action 2 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordAction3GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action 3 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordAction4GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action 4 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordAction5GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action 5 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJob1GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job 1 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJob2GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job 2 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJob3GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job 3 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJob4GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job 4 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJob5GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job 5 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction1GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 1 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction2GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 2 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction3GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 3 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction4GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 4 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction5GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 5 should not have been purged");
        }
    }

    public void testPurgeCoordWithWFChild3() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        new PurgeXCommand(7, 7, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testPurgeCoordWithWFChild3MoreThanLimit() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob3 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob4 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob5 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction1 = this.addRecordToWfActionTable(wfJob1.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction2 = this.addRecordToWfActionTable(wfJob2.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction3 = this.addRecordToWfActionTable(wfJob3.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction4 = this.addRecordToWfActionTable(wfJob4.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction5 = this.addRecordToWfActionTable(wfJob5.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction1 = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob1.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction2 = this.addRecordToCoordActionTable(coordJob.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob2.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction3 = this.addRecordToCoordActionTable(coordJob.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob3.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction4 = this.addRecordToCoordActionTable(coordJob.getId(), 4, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob4.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction5 = this.addRecordToCoordActionTable(coordJob.getId(), 5, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob5.getId(), "SUCCEEDED", 0);
        WorkflowJobGetJPAExecutor wfJob1GetCmd = new WorkflowJobGetJPAExecutor(wfJob1.getId());
        WorkflowJobGetJPAExecutor wfJob2GetCmd = new WorkflowJobGetJPAExecutor(wfJob2.getId());
        WorkflowJobGetJPAExecutor wfJob3GetCmd = new WorkflowJobGetJPAExecutor(wfJob3.getId());
        WorkflowJobGetJPAExecutor wfJob4GetCmd = new WorkflowJobGetJPAExecutor(wfJob4.getId());
        WorkflowJobGetJPAExecutor wfJob5GetCmd = new WorkflowJobGetJPAExecutor(wfJob5.getId());
        WorkflowActionGetJPAExecutor wfAction1GetCmd = new WorkflowActionGetJPAExecutor(wfAction1.getId());
        WorkflowActionGetJPAExecutor wfAction2GetCmd = new WorkflowActionGetJPAExecutor(wfAction2.getId());
        WorkflowActionGetJPAExecutor wfAction3GetCmd = new WorkflowActionGetJPAExecutor(wfAction3.getId());
        WorkflowActionGetJPAExecutor wfAction4GetCmd = new WorkflowActionGetJPAExecutor(wfAction4.getId());
        WorkflowActionGetJPAExecutor wfAction5GetCmd = new WorkflowActionGetJPAExecutor(wfAction5.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordAction1GetCmd = new CoordActionGetJPAExecutor(coordAction1.getId());
        CoordActionGetJPAExecutor coordAction2GetCmd = new CoordActionGetJPAExecutor(coordAction2.getId());
        CoordActionGetJPAExecutor coordAction3GetCmd = new CoordActionGetJPAExecutor(coordAction3.getId());
        CoordActionGetJPAExecutor coordAction4GetCmd = new CoordActionGetJPAExecutor(coordAction4.getId());
        CoordActionGetJPAExecutor coordAction5GetCmd = new CoordActionGetJPAExecutor(coordAction5.getId());
        wfJob1 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob1GetCmd);
        wfJob2 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob2GetCmd);
        wfJob3 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob3GetCmd);
        wfJob4 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob4GetCmd);
        wfJob5 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob5GetCmd);
        wfAction1 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction1GetCmd);
        wfAction2 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction2GetCmd);
        wfAction3 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction3GetCmd);
        wfAction4 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction4GetCmd);
        wfAction5 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction5GetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction1 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction1GetCmd);
        coordAction2 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction2GetCmd);
        coordAction3 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction3GetCmd);
        coordAction4 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction4GetCmd);
        coordAction5 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction5GetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob5.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction5.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction5.getStatus());
        new PurgeXCommand(7, 7, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordAction1GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action 1 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordAction2GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action 2 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordAction3GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action 3 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordAction4GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action 4 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordAction5GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action 5 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJob1GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job 1 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJob2GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job 2 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJob3GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job 3 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJob4GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job 4 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJob5GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job 5 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction1GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 1 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction2GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 2 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction3GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 3 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction4GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 4 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction5GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 5 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testPurgeBundleWithCoordChildWithWFChild1() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob.getId(), coordJob.getAppName(), 0, Job.Status.SUCCEEDED);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(bundleJob.getId());
        BundleActionGetJPAExecutor bundleActionGetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob.getAppName());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        bundleAction = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction.getStatus());
        new PurgeXCommand(7, 7, TestPurgeXCommand.getNumDaysToNotBePurged(bundleJob.getLastModifiedTime()), 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action should not have been purged");
        }
    }

    public void testPurgeBundleWithCoordChildWithWFChild2() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob.getId(), coordJob.getAppName(), 0, Job.Status.SUCCEEDED);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(bundleJob.getId());
        BundleActionGetJPAExecutor bundleActionGetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob.getAppName());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        bundleAction = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction.getStatus());
        new PurgeXCommand(TestPurgeXCommand.getNumDaysToNotBePurged(wfJob.getEndTime()), TestPurgeXCommand.getNumDaysToNotBePurged(coordJob.getLastModifiedTime()), 7, 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action should not have been purged");
        }
    }

    public void testPurgeBundleWithCoordChildWithWFChild2MoreThanLimit() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        CoordinatorJobBean coordJob1 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorJobBean coordJob2 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob2.setAppName("coord2");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob2);
        CoordinatorJobBean coordJob3 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob3.setAppName("coord3");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob3);
        CoordinatorJobBean coordJob4 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob4.setAppName("coord4");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob4);
        CoordinatorJobBean coordJob5 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob5.setAppName("coord5");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob5);
        WorkflowJobBean wfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob3 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob4 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob5 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction1 = this.addRecordToWfActionTable(wfJob1.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction2 = this.addRecordToWfActionTable(wfJob2.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction3 = this.addRecordToWfActionTable(wfJob3.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction4 = this.addRecordToWfActionTable(wfJob4.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction5 = this.addRecordToWfActionTable(wfJob5.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction1 = this.addRecordToCoordActionTable(coordJob1.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob1.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction2 = this.addRecordToCoordActionTable(coordJob2.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob2.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction3 = this.addRecordToCoordActionTable(coordJob3.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob3.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction4 = this.addRecordToCoordActionTable(coordJob4.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob4.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction5 = this.addRecordToCoordActionTable(coordJob5.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob5.getId(), "SUCCEEDED", 0);
        BundleActionBean bundleAction1 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob1.getId(), coordJob1.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction2 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob2.getId(), coordJob2.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction3 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob3.getId(), coordJob3.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction4 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob4.getId(), coordJob4.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction5 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob5.getId(), coordJob5.getAppName(), 0, Job.Status.SUCCEEDED);
        WorkflowJobGetJPAExecutor wfJob1GetCmd = new WorkflowJobGetJPAExecutor(wfJob1.getId());
        WorkflowJobGetJPAExecutor wfJob2GetCmd = new WorkflowJobGetJPAExecutor(wfJob2.getId());
        WorkflowJobGetJPAExecutor wfJob3GetCmd = new WorkflowJobGetJPAExecutor(wfJob3.getId());
        WorkflowJobGetJPAExecutor wfJob4GetCmd = new WorkflowJobGetJPAExecutor(wfJob4.getId());
        WorkflowJobGetJPAExecutor wfJob5GetCmd = new WorkflowJobGetJPAExecutor(wfJob5.getId());
        WorkflowActionGetJPAExecutor wfAction1GetCmd = new WorkflowActionGetJPAExecutor(wfAction1.getId());
        WorkflowActionGetJPAExecutor wfAction2GetCmd = new WorkflowActionGetJPAExecutor(wfAction2.getId());
        WorkflowActionGetJPAExecutor wfAction3GetCmd = new WorkflowActionGetJPAExecutor(wfAction3.getId());
        WorkflowActionGetJPAExecutor wfAction4GetCmd = new WorkflowActionGetJPAExecutor(wfAction4.getId());
        WorkflowActionGetJPAExecutor wfAction5GetCmd = new WorkflowActionGetJPAExecutor(wfAction5.getId());
        CoordJobGetJPAExecutor coordJob1GetCmd = new CoordJobGetJPAExecutor(coordJob1.getId());
        CoordJobGetJPAExecutor coordJob2GetCmd = new CoordJobGetJPAExecutor(coordJob2.getId());
        CoordJobGetJPAExecutor coordJob3GetCmd = new CoordJobGetJPAExecutor(coordJob3.getId());
        CoordJobGetJPAExecutor coordJob4GetCmd = new CoordJobGetJPAExecutor(coordJob4.getId());
        CoordJobGetJPAExecutor coordJob5GetCmd = new CoordJobGetJPAExecutor(coordJob5.getId());
        CoordActionGetJPAExecutor coordAction1GetCmd = new CoordActionGetJPAExecutor(coordAction1.getId());
        CoordActionGetJPAExecutor coordAction2GetCmd = new CoordActionGetJPAExecutor(coordAction2.getId());
        CoordActionGetJPAExecutor coordAction3GetCmd = new CoordActionGetJPAExecutor(coordAction3.getId());
        CoordActionGetJPAExecutor coordAction4GetCmd = new CoordActionGetJPAExecutor(coordAction4.getId());
        CoordActionGetJPAExecutor coordAction5GetCmd = new CoordActionGetJPAExecutor(coordAction5.getId());
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(bundleJob.getId());
        BundleActionGetJPAExecutor bundleAction1GetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob1.getAppName());
        BundleActionGetJPAExecutor bundleAction2GetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob2.getAppName());
        BundleActionGetJPAExecutor bundleAction3GetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob3.getAppName());
        BundleActionGetJPAExecutor bundleAction4GetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob4.getAppName());
        BundleActionGetJPAExecutor bundleAction5GetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob5.getAppName());
        wfJob1 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob1GetCmd);
        wfJob2 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob2GetCmd);
        wfJob3 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob3GetCmd);
        wfJob4 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob4GetCmd);
        wfJob5 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob5GetCmd);
        wfAction1 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction1GetCmd);
        wfAction2 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction2GetCmd);
        wfAction3 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction3GetCmd);
        wfAction4 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction4GetCmd);
        wfAction5 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction5GetCmd);
        coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJob1GetCmd);
        coordJob2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJob2GetCmd);
        coordJob3 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJob3GetCmd);
        coordJob4 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJob4GetCmd);
        coordJob5 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJob5GetCmd);
        coordAction1 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction1GetCmd);
        coordAction2 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction2GetCmd);
        coordAction3 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction3GetCmd);
        coordAction4 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction4GetCmd);
        coordAction5 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction5GetCmd);
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        bundleAction1 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleAction1GetCmd);
        bundleAction2 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleAction2GetCmd);
        bundleAction3 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleAction3GetCmd);
        bundleAction4 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleAction4GetCmd);
        bundleAction5 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleAction5GetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob5.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction5.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob1.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob2.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob3.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob4.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob5.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction5.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction5.getStatus());
        new PurgeXCommand(TestPurgeXCommand.getNumDaysToNotBePurged(wfJob1.getEndTime()), TestPurgeXCommand.getNumDaysToNotBePurged(coordJob1.getLastModifiedTime()), 7, 3).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleAction1GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action 1 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleAction2GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action 2 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleAction3GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action 3 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleAction4GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action 4 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleAction5GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action 5 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJob1GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job 1 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJob2GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job 2 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJob3GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job 3 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJob4GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job 4 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJob5GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job 5 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordAction1GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action 1 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordAction2GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action 2 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordAction3GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action 3 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordAction4GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action 4 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordAction5GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action 5 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJob1GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job 1 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJob2GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job 2 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJob3GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job 3 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJob4GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job 4 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJob5GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job 5 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction1GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 1 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction2GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 2 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction3GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 3 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction4GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 4 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction5GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 5 should not have been purged");
        }
    }

    public void testPurgeBundleWithCoordChildWithWFChild3() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob.getId(), coordJob.getAppName(), 0, Job.Status.SUCCEEDED);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(bundleJob.getId());
        BundleActionGetJPAExecutor bundleActionGetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob.getAppName());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        bundleAction = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction.getStatus());
        new PurgeXCommand(7, 7, 7, 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetCmd);
            TestPurgeXCommand.fail((String)"Bundle Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetCmd);
            TestPurgeXCommand.fail((String)"Bundle Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testPurgeBundleWithCoordChildWithWFChild3MoreThanLimit() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        CoordinatorJobBean coordJob1 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorJobBean coordJob2 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob2.setAppName("coord2");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob2);
        CoordinatorJobBean coordJob3 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob3.setAppName("coord3");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob3);
        CoordinatorJobBean coordJob4 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob4.setAppName("coord4");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob4);
        CoordinatorJobBean coordJob5 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        coordJob5.setAppName("coord5");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob5);
        WorkflowJobBean wfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob3 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob4 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowJobBean wfJob5 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction1 = this.addRecordToWfActionTable(wfJob1.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction2 = this.addRecordToWfActionTable(wfJob2.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction3 = this.addRecordToWfActionTable(wfJob3.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction4 = this.addRecordToWfActionTable(wfJob4.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction5 = this.addRecordToWfActionTable(wfJob5.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction1 = this.addRecordToCoordActionTable(coordJob1.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob1.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction2 = this.addRecordToCoordActionTable(coordJob2.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob2.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction3 = this.addRecordToCoordActionTable(coordJob3.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob3.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction4 = this.addRecordToCoordActionTable(coordJob4.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob4.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordAction5 = this.addRecordToCoordActionTable(coordJob5.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob5.getId(), "SUCCEEDED", 0);
        BundleActionBean bundleAction1 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob1.getId(), coordJob1.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction2 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob2.getId(), coordJob2.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction3 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob3.getId(), coordJob3.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction4 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob4.getId(), coordJob4.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleAction5 = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob5.getId(), coordJob5.getAppName(), 0, Job.Status.SUCCEEDED);
        WorkflowJobGetJPAExecutor wfJob1GetCmd = new WorkflowJobGetJPAExecutor(wfJob1.getId());
        WorkflowJobGetJPAExecutor wfJob2GetCmd = new WorkflowJobGetJPAExecutor(wfJob2.getId());
        WorkflowJobGetJPAExecutor wfJob3GetCmd = new WorkflowJobGetJPAExecutor(wfJob3.getId());
        WorkflowJobGetJPAExecutor wfJob4GetCmd = new WorkflowJobGetJPAExecutor(wfJob4.getId());
        WorkflowJobGetJPAExecutor wfJob5GetCmd = new WorkflowJobGetJPAExecutor(wfJob5.getId());
        WorkflowActionGetJPAExecutor wfAction1GetCmd = new WorkflowActionGetJPAExecutor(wfAction1.getId());
        WorkflowActionGetJPAExecutor wfAction2GetCmd = new WorkflowActionGetJPAExecutor(wfAction2.getId());
        WorkflowActionGetJPAExecutor wfAction3GetCmd = new WorkflowActionGetJPAExecutor(wfAction3.getId());
        WorkflowActionGetJPAExecutor wfAction4GetCmd = new WorkflowActionGetJPAExecutor(wfAction4.getId());
        WorkflowActionGetJPAExecutor wfAction5GetCmd = new WorkflowActionGetJPAExecutor(wfAction5.getId());
        CoordJobGetJPAExecutor coordJob1GetCmd = new CoordJobGetJPAExecutor(coordJob1.getId());
        CoordJobGetJPAExecutor coordJob2GetCmd = new CoordJobGetJPAExecutor(coordJob2.getId());
        CoordJobGetJPAExecutor coordJob3GetCmd = new CoordJobGetJPAExecutor(coordJob3.getId());
        CoordJobGetJPAExecutor coordJob4GetCmd = new CoordJobGetJPAExecutor(coordJob4.getId());
        CoordJobGetJPAExecutor coordJob5GetCmd = new CoordJobGetJPAExecutor(coordJob5.getId());
        CoordActionGetJPAExecutor coordAction1GetCmd = new CoordActionGetJPAExecutor(coordAction1.getId());
        CoordActionGetJPAExecutor coordAction2GetCmd = new CoordActionGetJPAExecutor(coordAction2.getId());
        CoordActionGetJPAExecutor coordAction3GetCmd = new CoordActionGetJPAExecutor(coordAction3.getId());
        CoordActionGetJPAExecutor coordAction4GetCmd = new CoordActionGetJPAExecutor(coordAction4.getId());
        CoordActionGetJPAExecutor coordAction5GetCmd = new CoordActionGetJPAExecutor(coordAction5.getId());
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(bundleJob.getId());
        BundleActionGetJPAExecutor bundleAction1GetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob1.getAppName());
        BundleActionGetJPAExecutor bundleAction2GetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob2.getAppName());
        BundleActionGetJPAExecutor bundleAction3GetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob3.getAppName());
        BundleActionGetJPAExecutor bundleAction4GetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob4.getAppName());
        BundleActionGetJPAExecutor bundleAction5GetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob5.getAppName());
        wfJob1 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob1GetCmd);
        wfJob2 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob2GetCmd);
        wfJob3 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob3GetCmd);
        wfJob4 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob4GetCmd);
        wfJob5 = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJob5GetCmd);
        wfAction1 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction1GetCmd);
        wfAction2 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction2GetCmd);
        wfAction3 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction3GetCmd);
        wfAction4 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction4GetCmd);
        wfAction5 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction5GetCmd);
        coordJob1 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJob1GetCmd);
        coordJob2 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJob2GetCmd);
        coordJob3 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJob3GetCmd);
        coordJob4 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJob4GetCmd);
        coordJob5 = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJob5GetCmd);
        coordAction1 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction1GetCmd);
        coordAction2 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction2GetCmd);
        coordAction3 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction3GetCmd);
        coordAction4 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction4GetCmd);
        coordAction5 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordAction5GetCmd);
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        bundleAction1 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleAction1GetCmd);
        bundleAction2 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleAction2GetCmd);
        bundleAction3 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleAction3GetCmd);
        bundleAction4 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleAction4GetCmd);
        bundleAction5 = (BundleActionBean)jpaService.execute((JPAExecutor)bundleAction5GetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob5.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction5.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob1.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob2.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob3.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob4.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob5.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction5.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction5.getStatus());
        new PurgeXCommand(7, 7, 7, 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetCmd);
            TestPurgeXCommand.fail((String)"Bundle Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleAction1GetCmd);
            TestPurgeXCommand.fail((String)"Bundle Action 1 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleAction2GetCmd);
            TestPurgeXCommand.fail((String)"Bundle Action 2 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleAction3GetCmd);
            TestPurgeXCommand.fail((String)"Bundle Action 3 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleAction4GetCmd);
            TestPurgeXCommand.fail((String)"Bundle Action 4 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleAction5GetCmd);
            TestPurgeXCommand.fail((String)"Bundle Action 5 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordJob1GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Job 1 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordJob2GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Job 2 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordJob3GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Job 3 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordJob4GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Job 4 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordJob5GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Job 5 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordAction1GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action 1 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordAction2GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action 2 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordAction3GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action 3 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordAction4GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action 4 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordAction5GetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action 5 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJob1GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job 1 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJob2GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job 2 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJob3GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job 3 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJob4GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job 4 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJob5GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job 5 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction1GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 1 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction2GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 2 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction3GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 3 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction4GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 4 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction5GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 5 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testPurgeWFWithSubWF1() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        WorkflowJobBean wfJob = this.addRecordToWfJobTableForNegCase(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowActionBean subwfAction = this.addRecordToWfActionTable(subwfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        WorkflowJobGetJPAExecutor subwfJobGetCmd = new WorkflowJobGetJPAExecutor(subwfJob.getId());
        WorkflowActionGetJPAExecutor subwfActionGetCmd = new WorkflowActionGetJPAExecutor(subwfAction.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        subwfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobGetCmd);
        subwfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction.getStatus());
        new PurgeXCommand(7, 1, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action should not have been purged");
        }
    }

    public void testPurgeWFWithSubWF2() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        WorkflowJobBean wfJob = this.addRecordToWfJobTableForNegCase(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJob = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING, wfJob.getId());
        WorkflowActionBean subwfAction = this.addRecordToWfActionTable(subwfJob.getId(), "1", WorkflowAction.Status.RUNNING);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        WorkflowJobGetJPAExecutor subwfJobGetCmd = new WorkflowJobGetJPAExecutor(subwfJob.getId());
        WorkflowActionGetJPAExecutor subwfActionGetCmd = new WorkflowActionGetJPAExecutor(subwfAction.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        subwfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobGetCmd);
        subwfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)subwfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)subwfAction.getStatus());
        new PurgeXCommand(7, 1, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action should not have been purged");
        }
    }

    public void testPurgeWFWithSubWF2MoreThanLimit() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        WorkflowJobBean wfJob = this.addRecordToWfJobTableForNegCase(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction1 = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction2 = this.addRecordToWfActionTable(wfJob.getId(), "2", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction3 = this.addRecordToWfActionTable(wfJob.getId(), "3", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction4 = this.addRecordToWfActionTable(wfJob.getId(), "4", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction5 = this.addRecordToWfActionTable(wfJob.getId(), "5", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING, wfJob.getId());
        WorkflowJobBean subwfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING, wfJob.getId());
        WorkflowJobBean subwfJob3 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING, wfJob.getId());
        WorkflowJobBean subwfJob4 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING, wfJob.getId());
        WorkflowJobBean subwfJob5 = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING, wfJob.getId());
        WorkflowActionBean subwfAction1 = this.addRecordToWfActionTable(subwfJob1.getId(), "1", WorkflowAction.Status.RUNNING);
        WorkflowActionBean subwfAction2 = this.addRecordToWfActionTable(subwfJob2.getId(), "1", WorkflowAction.Status.RUNNING);
        WorkflowActionBean subwfAction3 = this.addRecordToWfActionTable(subwfJob3.getId(), "1", WorkflowAction.Status.RUNNING);
        WorkflowActionBean subwfAction4 = this.addRecordToWfActionTable(subwfJob4.getId(), "1", WorkflowAction.Status.RUNNING);
        WorkflowActionBean subwfAction5 = this.addRecordToWfActionTable(subwfJob5.getId(), "1", WorkflowAction.Status.RUNNING);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfAction1GetCmd = new WorkflowActionGetJPAExecutor(wfAction1.getId());
        WorkflowActionGetJPAExecutor wfAction2GetCmd = new WorkflowActionGetJPAExecutor(wfAction2.getId());
        WorkflowActionGetJPAExecutor wfAction3GetCmd = new WorkflowActionGetJPAExecutor(wfAction3.getId());
        WorkflowActionGetJPAExecutor wfAction4GetCmd = new WorkflowActionGetJPAExecutor(wfAction4.getId());
        WorkflowActionGetJPAExecutor wfAction5GetCmd = new WorkflowActionGetJPAExecutor(wfAction5.getId());
        WorkflowJobGetJPAExecutor subwfJob1GetCmd = new WorkflowJobGetJPAExecutor(subwfJob1.getId());
        WorkflowJobGetJPAExecutor subwfJob2GetCmd = new WorkflowJobGetJPAExecutor(subwfJob2.getId());
        WorkflowJobGetJPAExecutor subwfJob3GetCmd = new WorkflowJobGetJPAExecutor(subwfJob3.getId());
        WorkflowJobGetJPAExecutor subwfJob4GetCmd = new WorkflowJobGetJPAExecutor(subwfJob4.getId());
        WorkflowJobGetJPAExecutor subwfJob5GetCmd = new WorkflowJobGetJPAExecutor(subwfJob5.getId());
        WorkflowActionGetJPAExecutor subwfAction1GetCmd = new WorkflowActionGetJPAExecutor(subwfAction1.getId());
        WorkflowActionGetJPAExecutor subwfAction2GetCmd = new WorkflowActionGetJPAExecutor(subwfAction2.getId());
        WorkflowActionGetJPAExecutor subwfAction3GetCmd = new WorkflowActionGetJPAExecutor(subwfAction3.getId());
        WorkflowActionGetJPAExecutor subwfAction4GetCmd = new WorkflowActionGetJPAExecutor(subwfAction4.getId());
        WorkflowActionGetJPAExecutor subwfAction5GetCmd = new WorkflowActionGetJPAExecutor(subwfAction5.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction1 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction1GetCmd);
        wfAction2 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction2GetCmd);
        wfAction3 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction3GetCmd);
        wfAction4 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction4GetCmd);
        wfAction5 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction5GetCmd);
        subwfJob1 = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJob1GetCmd);
        subwfJob2 = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJob2GetCmd);
        subwfJob3 = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJob3GetCmd);
        subwfJob4 = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJob4GetCmd);
        subwfJob5 = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJob5GetCmd);
        subwfAction1 = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfAction1GetCmd);
        subwfAction2 = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfAction2GetCmd);
        subwfAction3 = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfAction3GetCmd);
        subwfAction4 = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfAction4GetCmd);
        subwfAction5 = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfAction5GetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction5.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)subwfJob1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)subwfJob2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)subwfJob3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)subwfJob4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)subwfJob5.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)subwfAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)subwfAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)subwfAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)subwfAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)subwfAction5.getStatus());
        new PurgeXCommand(7, 1, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction1GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 1 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction2GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 2 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction3GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 3 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction4GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 4 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfAction5GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action 5 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJob1GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job 1 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJob2GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job 2 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJob3GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job 3 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJob4GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job 4 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJob5GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job 5 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfAction1GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action 1 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfAction2GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action 2 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfAction3GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action 3 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfAction4GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action 4 should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfAction5GetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action 5 should not have been purged");
        }
    }

    public void testPurgeWFWithSubWF3() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowActionBean subwfAction = this.addRecordToWfActionTable(subwfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        WorkflowJobGetJPAExecutor subwfJobGetCmd = new WorkflowJobGetJPAExecutor(subwfJob.getId());
        WorkflowActionGetJPAExecutor subwfActionGetCmd = new WorkflowActionGetJPAExecutor(subwfAction.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        subwfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobGetCmd);
        subwfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction.getStatus());
        new PurgeXCommand(7, 1, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobGetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionGetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testPurgeWFWithSubWF3MoreThanLimit() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction1 = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction2 = this.addRecordToWfActionTable(wfJob.getId(), "2", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction3 = this.addRecordToWfActionTable(wfJob.getId(), "3", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction4 = this.addRecordToWfActionTable(wfJob.getId(), "4", WorkflowAction.Status.OK);
        WorkflowActionBean wfAction5 = this.addRecordToWfActionTable(wfJob.getId(), "5", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob3 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob4 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowJobBean subwfJob5 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowActionBean subwfAction1 = this.addRecordToWfActionTable(subwfJob1.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfAction2 = this.addRecordToWfActionTable(subwfJob2.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfAction3 = this.addRecordToWfActionTable(subwfJob3.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfAction4 = this.addRecordToWfActionTable(subwfJob4.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfAction5 = this.addRecordToWfActionTable(subwfJob5.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfAction1GetCmd = new WorkflowActionGetJPAExecutor(wfAction1.getId());
        WorkflowActionGetJPAExecutor wfAction2GetCmd = new WorkflowActionGetJPAExecutor(wfAction2.getId());
        WorkflowActionGetJPAExecutor wfAction3GetCmd = new WorkflowActionGetJPAExecutor(wfAction3.getId());
        WorkflowActionGetJPAExecutor wfAction4GetCmd = new WorkflowActionGetJPAExecutor(wfAction4.getId());
        WorkflowActionGetJPAExecutor wfAction5GetCmd = new WorkflowActionGetJPAExecutor(wfAction5.getId());
        WorkflowJobGetJPAExecutor subwfJob1GetCmd = new WorkflowJobGetJPAExecutor(subwfJob1.getId());
        WorkflowJobGetJPAExecutor subwfJob2GetCmd = new WorkflowJobGetJPAExecutor(subwfJob2.getId());
        WorkflowJobGetJPAExecutor subwfJob3GetCmd = new WorkflowJobGetJPAExecutor(subwfJob3.getId());
        WorkflowJobGetJPAExecutor subwfJob4GetCmd = new WorkflowJobGetJPAExecutor(subwfJob4.getId());
        WorkflowJobGetJPAExecutor subwfJob5GetCmd = new WorkflowJobGetJPAExecutor(subwfJob5.getId());
        WorkflowActionGetJPAExecutor subwfAction1GetCmd = new WorkflowActionGetJPAExecutor(subwfAction1.getId());
        WorkflowActionGetJPAExecutor subwfAction2GetCmd = new WorkflowActionGetJPAExecutor(subwfAction2.getId());
        WorkflowActionGetJPAExecutor subwfAction3GetCmd = new WorkflowActionGetJPAExecutor(subwfAction3.getId());
        WorkflowActionGetJPAExecutor subwfAction4GetCmd = new WorkflowActionGetJPAExecutor(subwfAction4.getId());
        WorkflowActionGetJPAExecutor subwfAction5GetCmd = new WorkflowActionGetJPAExecutor(subwfAction5.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction1 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction1GetCmd);
        wfAction2 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction2GetCmd);
        wfAction3 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction3GetCmd);
        wfAction4 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction4GetCmd);
        wfAction5 = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfAction5GetCmd);
        subwfJob1 = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJob1GetCmd);
        subwfJob2 = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJob2GetCmd);
        subwfJob3 = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJob3GetCmd);
        subwfJob4 = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJob4GetCmd);
        subwfJob5 = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJob5GetCmd);
        subwfAction1 = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfAction1GetCmd);
        subwfAction2 = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfAction2GetCmd);
        subwfAction3 = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfAction3GetCmd);
        subwfAction4 = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfAction4GetCmd);
        subwfAction5 = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfAction5GetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction5.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob5.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction1.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction2.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction3.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction4.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction5.getStatus());
        new PurgeXCommand(7, 1, 1, 3).call();
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction1GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 1 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction2GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 2 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction3GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 3 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction4GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 4 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfAction5GetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action 5 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfJob1GetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Job 1 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfJob2GetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Job 2 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfJob3GetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Job 3 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfJob4GetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Job 4 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfJob5GetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Job 5 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfAction1GetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Action 1 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfAction2GetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Action 2 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfAction3GetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Action 3 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfAction4GetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Action 4 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfAction5GetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Action 5 should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testPurgeCoordWithWFChildWithSubWF1() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowActionBean subwfAction = this.addRecordToWfActionTable(subwfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        WorkflowJobGetJPAExecutor subwfJobGetCmd = new WorkflowJobGetJPAExecutor(subwfJob.getId());
        WorkflowActionGetJPAExecutor subwfActionGetCmd = new WorkflowActionGetJPAExecutor(subwfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        subwfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobGetCmd);
        subwfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        new PurgeXCommand(7, TestPurgeXCommand.getNumDaysToNotBePurged(coordJob.getLastModifiedTime()), 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action should not have been purged");
        }
    }

    public void testPurgeCoordWithWFChildWithSubWF2() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowActionBean subwfAction = this.addRecordToWfActionTable(subwfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        WorkflowJobGetJPAExecutor subwfJobGetCmd = new WorkflowJobGetJPAExecutor(subwfJob.getId());
        WorkflowActionGetJPAExecutor subwfActionGetCmd = new WorkflowActionGetJPAExecutor(subwfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        subwfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobGetCmd);
        subwfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        new PurgeXCommand(TestPurgeXCommand.getNumDaysToNotBePurged(wfJob.getEndTime()), 7, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action should not have been purged");
        }
    }

    public void testPurgeCoordWithWFChildWithSubWF3() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowActionBean subwfAction = this.addRecordToWfActionTable(subwfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        WorkflowJobGetJPAExecutor subwfJobGetCmd = new WorkflowJobGetJPAExecutor(subwfJob.getId());
        WorkflowActionGetJPAExecutor subwfActionGetCmd = new WorkflowActionGetJPAExecutor(subwfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        subwfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobGetCmd);
        subwfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        new PurgeXCommand(7, 7, 1, 10).call();
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobGetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionGetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testPurgeBundleWithCoordChildWithWFChildWithSubWF1() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowActionBean subwfAction = this.addRecordToWfActionTable(subwfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob.getId(), coordJob.getAppName(), 0, Job.Status.SUCCEEDED);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        WorkflowJobGetJPAExecutor subwfJobGetCmd = new WorkflowJobGetJPAExecutor(subwfJob.getId());
        WorkflowActionGetJPAExecutor subwfActionGetCmd = new WorkflowActionGetJPAExecutor(subwfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(bundleJob.getId());
        BundleActionGetJPAExecutor bundleActionGetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob.getAppName());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        subwfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobGetCmd);
        subwfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        bundleAction = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction.getStatus());
        new PurgeXCommand(7, 7, TestPurgeXCommand.getNumDaysToNotBePurged(bundleJob.getLastModifiedTime()), 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action should not have been purged");
        }
    }

    public void testPurgeBundleWithCoordChildWithWFChildWithSubWF2() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowActionBean subwfAction = this.addRecordToWfActionTable(subwfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob.getId(), coordJob.getAppName(), 0, Job.Status.SUCCEEDED);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        WorkflowJobGetJPAExecutor subwfJobGetCmd = new WorkflowJobGetJPAExecutor(subwfJob.getId());
        WorkflowActionGetJPAExecutor subwfActionGetCmd = new WorkflowActionGetJPAExecutor(subwfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(bundleJob.getId());
        BundleActionGetJPAExecutor bundleActionGetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob.getAppName());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        subwfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobGetCmd);
        subwfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        bundleAction = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction.getStatus());
        new PurgeXCommand(TestPurgeXCommand.getNumDaysToNotBePurged(wfJob.getEndTime()), TestPurgeXCommand.getNumDaysToNotBePurged(coordJob.getLastModifiedTime()), 7, 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action should not have been purged");
        }
    }

    public void testPurgeBundleWithCoordChildWithWFChildWithSubWF3() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobBean bundleJob = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean wfAction = this.addRecordToWfActionTable(wfJob.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJob.getId());
        WorkflowActionBean subwfAction = this.addRecordToWfActionTable(subwfJob.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob.getId(), "SUCCEEDED", 0);
        BundleActionBean bundleAction = this.addRecordToBundleActionTable(bundleJob.getId(), coordJob.getId(), coordJob.getAppName(), 0, Job.Status.SUCCEEDED);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(wfJob.getId());
        WorkflowActionGetJPAExecutor wfActionGetCmd = new WorkflowActionGetJPAExecutor(wfAction.getId());
        WorkflowJobGetJPAExecutor subwfJobGetCmd = new WorkflowJobGetJPAExecutor(subwfJob.getId());
        WorkflowActionGetJPAExecutor subwfActionGetCmd = new WorkflowActionGetJPAExecutor(subwfAction.getId());
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        CoordActionGetJPAExecutor coordActionGetCmd = new CoordActionGetJPAExecutor(coordAction.getId());
        BundleJobGetJPAExecutor bundleJobGetCmd = new BundleJobGetJPAExecutor(bundleJob.getId());
        BundleActionGetJPAExecutor bundleActionGetCmd = new BundleActionGetJPAExecutor(bundleJob.getId(), coordJob.getAppName());
        wfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        wfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionGetCmd);
        subwfJob = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobGetCmd);
        subwfAction = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionGetCmd);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionGetCmd);
        bundleJob = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetCmd);
        bundleAction = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordAction.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleJob.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleAction.getStatus());
        new PurgeXCommand(7, 7, 7, 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobGetCmd);
            TestPurgeXCommand.fail((String)"Bundle Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionGetCmd);
            TestPurgeXCommand.fail((String)"Bundle Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordJobGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordActionGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJobGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfActionGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobGetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Job should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionGetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Action should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    public void testPurgeLotsOfJobs() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestPurgeXCommand.assertNotNull((Object)jpaService);
        BundleJobBean bundleJobA = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-05-01T01:00Z"));
        BundleJobBean bundleJobB = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-06-01T01:00Z"));
        CoordinatorJobBean coordJobA = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        TestPurgeXCommand.setLastModifiedTime(coordJobA, "2011-03-01T01:00Z");
        CoordinatorJobBean coordJobB = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        TestPurgeXCommand.setLastModifiedTime(coordJobB, "2011-03-01T01:00Z");
        CoordinatorJobBean coordJobC = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        TestPurgeXCommand.setLastModifiedTime(coordJobC, "2011-07-01T01:00Z");
        CoordinatorJobBean coordJobD = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        TestPurgeXCommand.setLastModifiedTime(coordJobD, "2011-06-01T01:00Z");
        WorkflowJobBean wfJobA = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        TestPurgeXCommand.setEndTime(wfJobA, "2011-02-01T01:00Z");
        WorkflowJobBean wfJobB = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        TestPurgeXCommand.setEndTime(wfJobB, "2011-03-01T01:00Z");
        WorkflowJobBean wfJobC = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        TestPurgeXCommand.setEndTime(wfJobC, "2011-06-01T01:00Z");
        WorkflowJobBean wfJobD = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        TestPurgeXCommand.setEndTime(wfJobD, "2011-06-01T01:00Z");
        WorkflowJobBean wfJobE = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        TestPurgeXCommand.setEndTime(wfJobE, "2011-01-01T01:00Z");
        WorkflowJobBean wfJobF = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        TestPurgeXCommand.setEndTime(wfJobF, "2011-01-01T01:00Z");
        WorkflowActionBean wfActionA = this.addRecordToWfActionTable(wfJobA.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfActionB = this.addRecordToWfActionTable(wfJobB.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfActionC = this.addRecordToWfActionTable(wfJobC.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfActionD = this.addRecordToWfActionTable(wfJobD.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfActionE = this.addRecordToWfActionTable(wfJobE.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean wfActionF = this.addRecordToWfActionTable(wfJobF.getId(), "1", WorkflowAction.Status.OK);
        WorkflowJobBean subwfJobA = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJobA.getId());
        TestPurgeXCommand.setEndTime(subwfJobA, "2011-01-01T01:00Z");
        WorkflowJobBean subwfJobC = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJobC.getId());
        TestPurgeXCommand.setEndTime(subwfJobC, "2011-01-01T01:00Z");
        WorkflowJobBean subwfJobF = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, wfJobF.getId());
        TestPurgeXCommand.setEndTime(subwfJobF, "2011-04-01T01:00Z");
        WorkflowActionBean subwfActionA = this.addRecordToWfActionTable(subwfJobA.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfActionC = this.addRecordToWfActionTable(subwfJobC.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean subwfActionF = this.addRecordToWfActionTable(subwfJobF.getId(), "1", WorkflowAction.Status.OK);
        CoordinatorActionBean coordActionA = this.addRecordToCoordActionTable(coordJobA.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJobA.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordActionB = this.addRecordToCoordActionTable(coordJobB.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJobB.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordActionC = this.addRecordToCoordActionTable(coordJobC.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJobC.getId(), "SUCCEEDED", 0);
        CoordinatorActionBean coordActionD = this.addRecordToCoordActionTable(coordJobD.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJobD.getId(), "SUCCEEDED", 0);
        BundleActionBean bundleActionA = this.addRecordToBundleActionTable(bundleJobA.getId(), coordJobA.getId(), coordJobA.getAppName(), 0, Job.Status.SUCCEEDED);
        BundleActionBean bundleActionB = this.addRecordToBundleActionTable(bundleJobB.getId(), coordJobB.getId(), coordJobB.getAppName(), 0, Job.Status.SUCCEEDED);
        WorkflowJobGetJPAExecutor wfJobAGetCmd = new WorkflowJobGetJPAExecutor(wfJobA.getId());
        WorkflowJobGetJPAExecutor wfJobBGetCmd = new WorkflowJobGetJPAExecutor(wfJobB.getId());
        WorkflowJobGetJPAExecutor wfJobCGetCmd = new WorkflowJobGetJPAExecutor(wfJobC.getId());
        WorkflowJobGetJPAExecutor wfJobDGetCmd = new WorkflowJobGetJPAExecutor(wfJobD.getId());
        WorkflowJobGetJPAExecutor wfJobEGetCmd = new WorkflowJobGetJPAExecutor(wfJobE.getId());
        WorkflowJobGetJPAExecutor wfJobFGetCmd = new WorkflowJobGetJPAExecutor(wfJobF.getId());
        WorkflowActionGetJPAExecutor wfActionAGetCmd = new WorkflowActionGetJPAExecutor(wfActionA.getId());
        WorkflowActionGetJPAExecutor wfActionBGetCmd = new WorkflowActionGetJPAExecutor(wfActionB.getId());
        WorkflowActionGetJPAExecutor wfActionCGetCmd = new WorkflowActionGetJPAExecutor(wfActionC.getId());
        WorkflowActionGetJPAExecutor wfActionDGetCmd = new WorkflowActionGetJPAExecutor(wfActionD.getId());
        WorkflowActionGetJPAExecutor wfActionEGetCmd = new WorkflowActionGetJPAExecutor(wfActionE.getId());
        WorkflowActionGetJPAExecutor wfActionFGetCmd = new WorkflowActionGetJPAExecutor(wfActionF.getId());
        WorkflowJobGetJPAExecutor subwfJobAGetCmd = new WorkflowJobGetJPAExecutor(subwfJobA.getId());
        WorkflowJobGetJPAExecutor subwfJobCGetCmd = new WorkflowJobGetJPAExecutor(subwfJobC.getId());
        WorkflowJobGetJPAExecutor subwfJobFGetCmd = new WorkflowJobGetJPAExecutor(subwfJobF.getId());
        WorkflowActionGetJPAExecutor subwfActionAGetCmd = new WorkflowActionGetJPAExecutor(subwfActionA.getId());
        WorkflowActionGetJPAExecutor subwfActionCGetCmd = new WorkflowActionGetJPAExecutor(subwfActionC.getId());
        WorkflowActionGetJPAExecutor subwfActionFGetCmd = new WorkflowActionGetJPAExecutor(subwfActionF.getId());
        CoordJobGetJPAExecutor coordJobAGetCmd = new CoordJobGetJPAExecutor(coordJobA.getId());
        CoordJobGetJPAExecutor coordJobBGetCmd = new CoordJobGetJPAExecutor(coordJobB.getId());
        CoordJobGetJPAExecutor coordJobCGetCmd = new CoordJobGetJPAExecutor(coordJobC.getId());
        CoordJobGetJPAExecutor coordJobDGetCmd = new CoordJobGetJPAExecutor(coordJobD.getId());
        CoordActionGetJPAExecutor coordActionAGetCmd = new CoordActionGetJPAExecutor(coordActionA.getId());
        CoordActionGetJPAExecutor coordActionBGetCmd = new CoordActionGetJPAExecutor(coordActionB.getId());
        CoordActionGetJPAExecutor coordActionCGetCmd = new CoordActionGetJPAExecutor(coordActionC.getId());
        CoordActionGetJPAExecutor coordActionDGetCmd = new CoordActionGetJPAExecutor(coordActionD.getId());
        BundleJobGetJPAExecutor bundleJobAGetCmd = new BundleJobGetJPAExecutor(bundleJobA.getId());
        BundleJobGetJPAExecutor bundleJobBGetCmd = new BundleJobGetJPAExecutor(bundleJobB.getId());
        BundleActionGetJPAExecutor bundleActionAGetCmd = new BundleActionGetJPAExecutor(bundleJobA.getId(), coordJobA.getAppName());
        BundleActionGetJPAExecutor bundleActionBGetCmd = new BundleActionGetJPAExecutor(bundleJobB.getId(), coordJobB.getAppName());
        wfJobA = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobAGetCmd);
        wfJobB = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobBGetCmd);
        wfJobC = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobCGetCmd);
        wfJobD = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobDGetCmd);
        wfJobE = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobEGetCmd);
        wfJobF = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobFGetCmd);
        wfActionA = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionAGetCmd);
        wfActionB = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionBGetCmd);
        wfActionC = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionCGetCmd);
        wfActionD = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionDGetCmd);
        wfActionE = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionEGetCmd);
        wfActionF = (WorkflowActionBean)jpaService.execute((JPAExecutor)wfActionFGetCmd);
        subwfJobA = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobAGetCmd);
        subwfJobC = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobCGetCmd);
        subwfJobF = (WorkflowJobBean)jpaService.execute((JPAExecutor)subwfJobFGetCmd);
        subwfActionA = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionAGetCmd);
        subwfActionC = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionCGetCmd);
        subwfActionF = (WorkflowActionBean)jpaService.execute((JPAExecutor)subwfActionFGetCmd);
        coordJobA = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobAGetCmd);
        coordJobB = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobBGetCmd);
        coordJobC = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobCGetCmd);
        coordJobD = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobDGetCmd);
        coordActionA = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionAGetCmd);
        coordActionB = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionBGetCmd);
        coordActionC = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionCGetCmd);
        coordActionD = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordActionDGetCmd);
        bundleJobA = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobAGetCmd);
        bundleJobB = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobBGetCmd);
        bundleActionA = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionAGetCmd);
        bundleActionB = (BundleActionBean)jpaService.execute((JPAExecutor)bundleActionBGetCmd);
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJobA.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJobB.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJobC.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJobD.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJobE.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfJobF.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfActionA.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfActionB.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfActionC.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfActionD.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfActionE.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)wfActionF.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJobA.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJobC.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)subwfJobF.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfActionA.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfActionC.getStatus());
        TestPurgeXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)subwfActionF.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJobA.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJobB.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJobC.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJobD.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordActionA.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordActionB.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordActionC.getStatus());
        TestPurgeXCommand.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordActionD.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleJobA.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleJobB.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleActionA.getStatus());
        TestPurgeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)bundleActionB.getStatus());
        new PurgeXCommand(TestPurgeXCommand.getNumDaysToNotBePurged(wfJobB.getEndTime()), TestPurgeXCommand.getNumDaysToNotBePurged(coordJobC.getLastModifiedTime()), TestPurgeXCommand.getNumDaysToNotBePurged(bundleJobB.getLastModifiedTime()), 10).call();
        try {
            jpaService.execute((JPAExecutor)bundleJobAGetCmd);
            TestPurgeXCommand.fail((String)"Bundle Job A should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionAGetCmd);
            TestPurgeXCommand.fail((String)"Bundle Action A should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)bundleJobBGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Job B should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)bundleActionBGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Bundle Action B should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJobAGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Job A should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordActionAGetCmd);
            TestPurgeXCommand.fail((String)"Coordinator Action A should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)coordJobBGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job B should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionBGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action B should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJobCGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job C should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionCGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action C should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordJobDGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Job D should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)coordActionDGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Coordinator Action D should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobAGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job A should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfActionAGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action A should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJobBGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job B should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionBGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action B should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobCGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job C should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionCGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action C should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobDGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job D should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionDGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action D should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfJobEGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Job E should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfActionEGetCmd);
            TestPurgeXCommand.fail((String)"Workflow Action E should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)wfJobFGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Job F should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)wfActionFGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"Workflow Action F should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobAGetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Job A should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionAGetCmd);
            TestPurgeXCommand.fail((String)"SubWorkflow Action A should have been purged");
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobCGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job C should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionCGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action C should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfJobFGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Job F should not have been purged");
        }
        try {
            jpaService.execute((JPAExecutor)subwfActionFGetCmd);
        }
        catch (JPAExecutorException je) {
            TestPurgeXCommand.fail((String)"SubWorkflow Action F should not have been purged");
        }
    }

    protected WorkflowJobBean addRecordToWfJobTableForNegCase(WorkflowJob.Status jobStatus, WorkflowInstance.Status instanceStatus) throws Exception {
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        Configuration conf = new Configuration();
        Path appUri = new Path(this.getAppPath(), "workflow.xml");
        conf.set("oozie.wf.application.path", appUri.toString());
        conf.set("oozie.wf.log.token", "testToken");
        conf.set("user.name", TestPurgeXCommand.getTestUser());
        WorkflowJobBean wfBean = this.createWorkflow((WorkflowApp)app, conf, jobStatus, instanceStatus);
        wfBean.setStartTime(new Date(System.currentTimeMillis() + 8640000000L));
        wfBean.setEndTime(new Date(System.currentTimeMillis() + 8640000000L + 0x6DDD00L));
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestPurgeXCommand.assertNotNull((Object)jpaService);
            WorkflowJobInsertJPAExecutor wfInsertCmd = new WorkflowJobInsertJPAExecutor(wfBean);
            jpaService.execute((JPAExecutor)wfInsertCmd);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestPurgeXCommand.fail((String)"Unable to insert the test wf job record to table");
            throw ce;
        }
        return wfBean;
    }

    @Override
    protected WorkflowJobBean createWorkflow(WorkflowApp app, Configuration conf, WorkflowJob.Status jobStatus, WorkflowInstance.Status instanceStatus) throws Exception {
        WorkflowAppService wps = (WorkflowAppService)Services.get().get(WorkflowAppService.class);
        XConfiguration protoActionConf = wps.createProtoActionConf(conf, true);
        WorkflowLib workflowLib = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).getWorkflowLibWithNoDB();
        WorkflowInstance wfInstance = workflowLib.createInstance(app, conf);
        ((LiteWorkflowInstance)wfInstance).setStatus(instanceStatus);
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setId(((UUIDService)Services.get().get(UUIDService.class)).generateId(UUIDService.ApplicationType.WORKFLOW));
        workflow.setAppName(app.getName());
        workflow.setAppPath(conf.get("oozie.wf.application.path"));
        workflow.setConf(XmlUtils.prettyPrint((Configuration)conf).toString());
        workflow.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoActionConf).toString());
        workflow.setCreatedTime(new Date());
        workflow.setLogToken(conf.get("oozie.wf.log.token", ""));
        workflow.setStatus(jobStatus);
        workflow.setRun(0);
        workflow.setUser(conf.get("user.name"));
        workflow.setGroup(conf.get("group.name"));
        workflow.setWorkflowInstance(wfInstance);
        workflow.setStartTime(DateUtils.parseDateOozieTZ((String)"2009-12-18T01:00Z"));
        workflow.setEndTime(DateUtils.parseDateOozieTZ((String)"2009-12-18T03:00Z"));
        return workflow;
    }

    @Override
    protected CoordinatorJobBean addRecordToCoordJobTable(Job.Status status, boolean pending, boolean doneMatd) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, pending, doneMatd);
        coordJob.setLastModifiedTime(DateUtils.parseDateOozieTZ((String)"2009-12-18T01:00Z"));
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestPurgeXCommand.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestPurgeXCommand.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }

    protected BundleJobBean addRecordToBundleJobTable(Job.Status jobStatus, Date lastModifiedTime) throws Exception {
        BundleJobBean bundle = this.createBundleJob(jobStatus, false);
        bundle.setLastModifiedTime(lastModifiedTime);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestPurgeXCommand.assertNotNull((Object)jpaService);
            BundleJobInsertJPAExecutor bundleInsertjpa = new BundleJobInsertJPAExecutor(bundle);
            jpaService.execute((JPAExecutor)bundleInsertjpa);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestPurgeXCommand.fail((String)"Unable to insert the test bundle job record to table");
            throw je;
        }
        return bundle;
    }

    public static int getNumDaysToNotBePurged(Date jobDate) {
        int days = (int)((new Date().getTime() - jobDate.getTime()) / 1000L / 60L / 60L / 24L);
        return days + 5;
    }

    public static CoordinatorJobBean setLastModifiedTime(CoordinatorJobBean job, String date) throws Exception {
        job.setLastModifiedTime(DateUtils.parseDateOozieTZ((String)date));
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestPurgeXCommand.assertNotNull((Object)jpaService);
            CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_LAST_MODIFIED_TIME, job);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestPurgeXCommand.fail((String)"Unable to update coord job last modified time");
            throw je;
        }
        return job;
    }

    public static WorkflowJobBean setEndTime(WorkflowJobBean job, String date) throws Exception {
        job.setEndTime(DateUtils.parseDateOozieTZ((String)date));
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestPurgeXCommand.assertNotNull((Object)jpaService);
            WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_END, (Object)job);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestPurgeXCommand.fail((String)"Unable to update workflow job last modified time");
            throw je;
        }
        return job;
    }
}

