/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLACalculatorMemory;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XConfiguration;

public class TestSLAAlertXCommand
extends XDataTestCase {
    private Services services;
    SLACalculatorMemory slaCalcMemory;
    BundleJobBean bundle;
    CoordinatorJobBean coord1;
    CoordinatorJobBean coord2;
    final BundleEngine bundleEngine = new BundleEngine("u");
    Date startTime;
    final Date endTime = new Date(System.currentTimeMillis() + 3600000L);
    final int timeInSec = 60000;
    final String data = "2014-01-01T00:00Z";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        Configuration conf = ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
        conf.set("oozie.services.ext", "org.apache.oozie.service.EventHandlerService,org.apache.oozie.sla.service.SLAService");
        conf.setInt("oozie.sla.service.SLAService.check.interval", 600);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        this.services.destroy();
        super.tearDown();
    }

    public void testBundleSLAAlertCommands() throws Exception {
        this.setupSLAJobs();
        String jobIdsStr = this.bundle.getId();
        String actions = "1,2";
        String coords = null;
        this.bundleEngine.disableSLAAlert(jobIdsStr, actions, null, coords);
        this.checkSLAStatus(this.coord1.getId() + "@1", true);
        this.checkSLAStatus(this.coord1.getId() + "@2", true);
        this.checkSLAStatus(this.coord1.getId() + "@3", false);
        this.checkSLAStatus(this.coord1.getId() + "@5", false);
        this.checkSLAStatus(this.coord1.getId() + "@4", false);
        this.checkSLAStatus(this.coord2.getId() + "@1", true);
        this.checkSLAStatus(this.coord2.getId() + "@1", true);
        this.bundleEngine.enableSLAAlert(jobIdsStr, null, null, null);
        this.checkSLAStatus(this.coord1.getId() + "@1", false);
        this.checkSLAStatus(this.coord1.getId() + "@2", false);
        this.checkSLAStatus(this.coord1.getId() + "@3", false);
        this.checkSLAStatus(this.coord1.getId() + "@5", false);
        this.checkSLAStatus(this.coord1.getId() + "@4", false);
        this.checkSLAStatus(this.coord2.getId() + "@1", false);
        this.checkSLAStatus(this.coord2.getId() + "@2", false);
        CoordinatorJobBean job1 = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{this.coord1.getId()});
        XConfiguration xConf = new XConfiguration((Reader)new StringReader(job1.getConf()));
        TestSLAAlertXCommand.assertEquals((String)xConf.get("oozie.sla.disable.alerts"), null);
        CoordinatorJobBean job2 = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{this.coord2.getId()});
        xConf = new XConfiguration((Reader)new StringReader(job2.getConf()));
        TestSLAAlertXCommand.assertEquals((String)xConf.get("oozie.sla.disable.alerts"), null);
        this.bundleEngine.disableSLAAlert(jobIdsStr, null, null, "coord1");
        this.checkSLAStatus(this.coord1.getId() + "@1", true);
        this.checkSLAStatus(this.coord1.getId() + "@2", true);
        this.checkSLAStatus(this.coord1.getId() + "@3", true);
        this.checkSLAStatus(this.coord1.getId() + "@4", true);
        this.checkSLAStatus(this.coord1.getId() + "@5", true);
        this.checkSLAStatus(this.coord2.getId() + "@1", false);
        this.checkSLAStatus(this.coord2.getId() + "@2", false);
        job1 = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{this.coord1.getId()});
        xConf = new XConfiguration((Reader)new StringReader(job1.getConf()));
        TestSLAAlertXCommand.assertEquals((String)xConf.get("oozie.sla.disable.alerts"), (String)"ALL");
        this.bundleEngine.disableSLAAlert(jobIdsStr, null, null, "coord2");
        String dates = "2014-01-01T00:00Z::2014-01-03T00:00Z";
        this.bundleEngine.enableSLAAlert(jobIdsStr, null, dates, "coord1," + this.coord2.getId());
        this.checkSLAStatus(this.coord1.getId() + "@1", false);
        this.checkSLAStatus(this.coord1.getId() + "@2", false);
        this.checkSLAStatus(this.coord1.getId() + "@3", false);
        this.checkSLAStatus(this.coord1.getId() + "@4", true);
        this.checkSLAStatus(this.coord1.getId() + "@5", true);
        this.checkSLAStatus(this.coord2.getId() + "@1", false);
        this.checkSLAStatus(this.coord2.getId() + "@2", false);
        this.checkSLAStatus(this.coord2.getId() + "@3", false);
        this.checkSLAStatus(this.coord2.getId() + "@4", true);
        try {
            this.bundleEngine.disableSLAAlert(jobIdsStr, null, null, "dummy");
            TestSLAAlertXCommand.fail((String)"Should throw Exception");
        }
        catch (BaseEngineException e) {
            TestSLAAlertXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1026);
        }
    }

    public void testSLAChangeCommand() throws Exception {
        this.setupSLAJobs();
        String newParams = "sla-should-end=10";
        String jobIdsStr = this.bundle.getId();
        String coords = this.coord1.getAppName();
        this.bundleEngine.changeSLA(jobIdsStr, null, null, coords, newParams);
        TestSLAAlertXCommand.assertEquals((long)this.getSLACalcStatus(this.coord1.getId() + "@1").getExpectedEnd().getTime(), (long)(this.getSLACalcStatus(this.coord1.getId() + "@1").getNominalTime().getTime() + 600000L));
        TestSLAAlertXCommand.assertEquals((long)this.getSLACalcStatus(this.coord1.getId() + "@2").getExpectedEnd().getTime(), (long)(this.getSLACalcStatus(this.coord1.getId() + "@2").getNominalTime().getTime() + 600000L));
        TestSLAAlertXCommand.assertEquals((long)this.getSLACalcStatus(this.coord1.getId() + "@5").getExpectedEnd().getTime(), (long)(this.getSLACalcStatus(this.coord1.getId() + "@5").getNominalTime().getTime() + 600000L));
        newParams = "non-valid-param=10";
        try {
            this.bundleEngine.changeSLA(jobIdsStr, null, null, coords, newParams);
            TestSLAAlertXCommand.fail((String)"Should throw Exception");
        }
        catch (BaseEngineException e) {
            TestSLAAlertXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1027);
        }
        try {
            new CoordinatorEngine().changeSLA(this.coord1.getId(), null, null, null, newParams);
            TestSLAAlertXCommand.fail((String)"Should throw Exception");
        }
        catch (BaseEngineException e) {
            TestSLAAlertXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1027);
        }
    }

    public void testCoordSLAAlertCommands() throws Exception {
        this.setupSLAJobs();
        CoordinatorEngine engine = new CoordinatorEngine("u");
        String jobIdsStr = this.coord1.getId();
        String actions = "1-3,5";
        String coords = null;
        engine.disableSLAAlert(jobIdsStr, actions, null, coords);
        this.checkSLAStatus(this.coord1.getId() + "@1", true);
        this.checkSLAStatus(this.coord1.getId() + "@2", true);
        this.checkSLAStatus(this.coord1.getId() + "@3", true);
        this.checkSLAStatus(this.coord1.getId() + "@5", true);
        this.checkSLAStatus(this.coord1.getId() + "@4", false);
        actions = "1-3";
        engine.enableSLAAlert(jobIdsStr, actions, null, null);
        this.checkSLAStatus(this.coord1.getId() + "@1", false);
        this.checkSLAStatus(this.coord1.getId() + "@2", false);
        this.checkSLAStatus(this.coord1.getId() + "@3", false);
        this.checkSLAStatus(this.coord1.getId() + "@5", true);
        this.checkSLAStatus(this.coord1.getId() + "@4", false);
        engine.enableSLAAlert(jobIdsStr, null, null, null);
        this.checkSLAStatus(this.coord1.getId() + "@1", false);
        this.checkSLAStatus(this.coord1.getId() + "@2", false);
        this.checkSLAStatus(this.coord1.getId() + "@3", false);
        this.checkSLAStatus(this.coord1.getId() + "@5", false);
        this.checkSLAStatus(this.coord1.getId() + "@4", false);
        CoordinatorJobBean job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{jobIdsStr});
        XConfiguration xConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        TestSLAAlertXCommand.assertEquals((String)xConf.get("oozie.sla.disable.alerts"), null);
    }

    private void setupSLAJobs() throws Exception {
        this.coord1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, true, false);
        Date nominalTime1 = DateUtils.parseDateUTC((String)"2014-01-01T00:00Z");
        this.addRecordToCoordActionTable(this.coord1.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 1, nominalTime1);
        Date nominalTime2 = org.apache.commons.lang.time.DateUtils.addDays((Date)nominalTime1, (int)1);
        this.addRecordToCoordActionTable(this.coord1.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 1, nominalTime2);
        Date nominalTime3 = org.apache.commons.lang.time.DateUtils.addDays((Date)nominalTime1, (int)2);
        this.addRecordToCoordActionTable(this.coord1.getId(), 3, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 1, nominalTime3);
        Date nominalTime4 = org.apache.commons.lang.time.DateUtils.addDays((Date)nominalTime1, (int)3);
        this.addRecordToCoordActionTable(this.coord1.getId(), 4, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 1, nominalTime4);
        Date nominalTime5 = org.apache.commons.lang.time.DateUtils.addDays((Date)nominalTime1, (int)4);
        this.addRecordToCoordActionTable(this.coord1.getId(), 5, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 1, nominalTime5);
        this.coord2 = this.addRecordToCoordJobTable(Job.Status.RUNNING, true, false);
        this.addRecordToCoordActionTable(this.coord2.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, nominalTime1);
        this.addRecordToCoordActionTable(this.coord2.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, nominalTime2);
        this.addRecordToCoordActionTable(this.coord2.getId(), 3, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, nominalTime3);
        this.addRecordToCoordActionTable(this.coord2.getId(), 4, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, nominalTime4);
        this.bundle = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        this.coord1.setBundleId(this.bundle.getId());
        this.coord1.setAppName("coord1");
        this.coord1.setStartTime(nominalTime1);
        this.coord1.setMatThrottling(12);
        this.coord1.setLastActionNumber(5);
        this.coord2.setBundleId(this.bundle.getId());
        this.coord2.setAppName("coord2");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, this.coord1);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, this.coord2);
        this.registerSLABean(this.coord1.getId(), AppType.COORDINATOR_JOB, null, null);
        this.registerSLABean(this.coord2.getId(), AppType.COORDINATOR_JOB, null, null);
        this.registerSLABean(this.coord1.getId() + "@1", AppType.COORDINATOR_ACTION, this.coord1.getId(), nominalTime1);
        this.registerSLABean(this.coord1.getId() + "@2", AppType.COORDINATOR_ACTION, this.coord1.getId(), nominalTime2);
        this.registerSLABean(this.coord1.getId() + "@3", AppType.COORDINATOR_ACTION, this.coord1.getId(), nominalTime3);
        this.registerSLABean(this.coord1.getId() + "@4", AppType.COORDINATOR_ACTION, this.coord1.getId(), nominalTime4);
        this.registerSLABean(this.coord1.getId() + "@5", AppType.COORDINATOR_ACTION, this.coord1.getId(), nominalTime5);
        this.registerSLABean(this.coord2.getId() + "@1", AppType.COORDINATOR_ACTION, this.coord2.getId(), nominalTime1);
        this.registerSLABean(this.coord2.getId() + "@2", AppType.COORDINATOR_ACTION, this.coord2.getId(), nominalTime2);
        this.registerSLABean(this.coord2.getId() + "@3", AppType.COORDINATOR_ACTION, this.coord2.getId(), nominalTime3);
        this.registerSLABean(this.coord2.getId() + "@4", AppType.COORDINATOR_ACTION, this.coord2.getId(), nominalTime4);
        this.checkSLAStatus(this.coord1.getId() + "@1", false);
        this.checkSLAStatus(this.coord1.getId() + "@2", false);
        this.checkSLAStatus(this.coord1.getId() + "@3", false);
        this.checkSLAStatus(this.coord1.getId() + "@5", false);
        this.checkSLAStatus(this.coord1.getId() + "@4", false);
    }

    private void registerSLABean(String jobId, AppType appType, String parentId, Date nominalTime) throws Exception {
        SLARegistrationBean slaRegBean = new SLARegistrationBean();
        slaRegBean.setNominalTime(nominalTime);
        slaRegBean.setId(jobId);
        slaRegBean.setAppType(appType);
        this.startTime = new Date(System.currentTimeMillis() - 3600000L);
        slaRegBean.setExpectedStart(this.startTime);
        slaRegBean.setExpectedDuration(3600000L);
        slaRegBean.setParentId(parentId);
        slaRegBean.setExpectedEnd(this.endTime);
        ((SLAService)Services.get().get(SLAService.class)).addRegistrationEvent(slaRegBean);
    }

    private void checkSLAStatus(String id, boolean status) throws JPAExecutorException {
        TestSLAAlertXCommand.assertEquals((boolean)this.getSLACalcStatus(id).getSLAConfigMap().containsKey("oozie.sla.disable.alerts"), (boolean)status);
    }

    private SLACalcStatus getSLACalcStatus(String jobId) throws JPAExecutorException {
        return ((SLAService)Services.get().get(SLAService.class)).getSLACalculator().get(jobId);
    }
}

