/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command;

import junit.framework.Assert;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.XCommand;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;

public class TestXCommand
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Services services = new Services();
        services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testXCommandGetters() throws Exception {
        AXCommand command = new AXCommand(false);
        TestXCommand.assertEquals((String)"name", (String)command.getName());
        TestXCommand.assertEquals((String)"type", (String)command.getType());
        TestXCommand.assertEquals((int)1, (int)command.getPriority());
        TestXCommand.assertEquals((boolean)false, (boolean)command.isLockRequired());
        TestXCommand.assertEquals((String)"key", (String)command.getEntityKey());
    }

    public void testXCommandLifecycleNotLocking() throws Exception {
        LockGetter t = new LockGetter();
        t.start();
        AXCommand command = new AXCommand(false);
        command.call();
        TestXCommand.assertTrue((boolean)command.execute);
        t.interrupt();
    }

    public void testXCommandLifecycleLocking() throws Exception {
        AXCommand command = new AXCommand(true);
        command.call();
        TestXCommand.assertTrue((boolean)command.execute);
    }

    public void testXCommandLifecycleLockingFailingToLock() throws Exception {
        LockGetter t = new LockGetter();
        t.start();
        this.sleep(150);
        AXCommand command = new AXCommand(true);
        try {
            command.call();
            TestXCommand.fail();
        }
        catch (CommandException commandException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
        t.interrupt();
    }

    public void testXCommandeagerVerifyPreconditionFailing() throws Exception {
        AXCommand command = new AXCommand(false);
        command.mark_fail = true;
        try {
            command.call();
            TestXCommand.fail();
        }
        catch (CommandException commandException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testXCommandVerifyPreconditionFailing() throws Exception {
        AXCommand command = new AXCommand(true);
        command.mark_fail = true;
        try {
            command.call();
            TestXCommand.fail();
        }
        catch (CommandException commandException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testXCommandPossibleReleaseLockWithoutAcquireEdgeCase() throws Exception {
        AXCommand command = new AXCommand(true);
        command.setInterruptMode(false);
        command.call();
        TestXCommand.assertTrue((boolean)command.execute);
        command.resetCalledMethods();
        command.setInterruptMode(true);
        command.call();
        TestXCommand.assertTrue((boolean)command.execute);
    }

    private static class LockGetter
    extends Thread {
        private LockGetter() {
        }

        @Override
        public void run() {
            try {
                LockToken lock = ((MemoryLocksService)Services.get().get(MemoryLocksService.class)).getWriteLock("key", 1L);
                if (lock == null) {
                    Assert.fail();
                }
                LockGetter.sleep(150L);
            }
            catch (InterruptedException lock) {
            }
            catch (Exception ex) {
                Assert.fail();
            }
        }
    }

    public static class AXCommand
    extends XCommand {
        private boolean lockRequired;
        public boolean eagerLoadState;
        public boolean eagerVerifyPrecondition;
        public boolean loadState;
        public boolean verifyPrecondition;
        public boolean execute;
        public boolean mark_fail = false;

        public AXCommand(boolean lockRequired) {
            super("name", "type", 1);
            this.lockRequired = lockRequired;
        }

        public AXCommand(boolean lockRequired, boolean mark_fail) {
            super("name", "type", 1);
            this.lockRequired = lockRequired;
            this.mark_fail = mark_fail;
        }

        protected long getLockTimeOut() {
            Assert.assertEquals((long)5000L, (long)super.getLockTimeOut());
            return 100L;
        }

        protected long getRequeueDelay() {
            Assert.assertEquals((long)10000L, (long)super.getRequeueDelay());
            return 100L;
        }

        protected boolean isLockRequired() {
            return this.lockRequired;
        }

        protected boolean isReQueueRequired() {
            return false;
        }

        public String getEntityKey() {
            return "key";
        }

        protected void eagerLoadState() {
            Assert.assertFalse((boolean)this.eagerLoadState);
            Assert.assertFalse((boolean)this.eagerVerifyPrecondition);
            Assert.assertFalse((boolean)this.loadState);
            Assert.assertFalse((boolean)this.verifyPrecondition);
            Assert.assertFalse((boolean)this.execute);
            this.eagerLoadState = true;
        }

        protected void eagerVerifyPrecondition() throws CommandException {
            Assert.assertTrue((boolean)this.eagerLoadState);
            if (this.mark_fail) {
                throw new CommandException(ErrorCode.E0000, new Object[0]);
            }
            Assert.assertFalse((boolean)this.eagerVerifyPrecondition);
            Assert.assertFalse((boolean)this.loadState);
            Assert.assertFalse((boolean)this.verifyPrecondition);
            Assert.assertFalse((boolean)this.execute);
            this.eagerVerifyPrecondition = true;
        }

        protected void loadState() {
            Assert.assertTrue((boolean)this.eagerLoadState);
            Assert.assertTrue((boolean)this.eagerVerifyPrecondition);
            Assert.assertFalse((boolean)this.loadState);
            Assert.assertFalse((boolean)this.verifyPrecondition);
            Assert.assertFalse((boolean)this.execute);
            this.loadState = true;
        }

        protected void verifyPrecondition() throws CommandException {
            Assert.assertTrue((boolean)this.eagerLoadState);
            Assert.assertTrue((boolean)this.eagerVerifyPrecondition);
            Assert.assertTrue((boolean)this.loadState);
            if (this.mark_fail) {
                throw new CommandException(ErrorCode.E0000, new Object[0]);
            }
            Assert.assertFalse((boolean)this.verifyPrecondition);
            Assert.assertFalse((boolean)this.execute);
            this.verifyPrecondition = true;
        }

        protected Object execute() throws CommandException {
            Assert.assertTrue((boolean)this.eagerLoadState);
            Assert.assertTrue((boolean)this.eagerVerifyPrecondition);
            Assert.assertTrue((boolean)this.loadState);
            Assert.assertTrue((boolean)this.verifyPrecondition);
            Assert.assertFalse((boolean)this.execute);
            this.execute = true;
            return null;
        }

        private void resetCalledMethods() {
            this.eagerLoadState = false;
            this.eagerVerifyPrecondition = false;
            this.loadState = false;
            this.verifyPrecondition = false;
            this.execute = false;
        }
    }
}

