/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.bundle;

import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.bundle.BundleJobXCommand;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestBundleJobXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBundleJobInfo1() throws Exception {
        BundleJobBean job = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobXCommand.assertNotNull((Object)jpaService);
        BundleJobGetJPAExecutor bundleJobGetjpa = new BundleJobGetJPAExecutor(job.getId());
        job = (BundleJobBean)jpaService.execute((JPAExecutor)bundleJobGetjpa);
        TestBundleJobXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
        BundleJobBean bundleJob = (BundleJobBean)new BundleJobXCommand(job.getId()).call();
        TestBundleJobXCommand.assertEquals((int)0, (int)bundleJob.getCoordinators().size());
        TestBundleJobXCommand.assertEquals((Object)bundleJob.getStatus(), (Object)Job.Status.PREP);
        TestBundleJobXCommand.assertEquals((String)bundleJob.getId(), (String)job.getId());
    }

    public void testBundleJobInfoFailed() throws Exception {
        this.addRecordToBundleJobTable(Job.Status.PREP, false);
        try {
            new BundleJobXCommand("bundle-id").call();
            TestBundleJobXCommand.fail((String)"Job doesn't exist. Should fail.");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }
}

