/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.OperationType;
import org.apache.oozie.command.coord.BulkCoordXCommand;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;

public class TestBulkCoordXCommand
extends XDataTestCase {
    private Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBulkCoordSuspendResumeKillSuccess() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 0);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(job1.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 0);
        CoordinatorActionBean action2 = this.addRecordToCoordActionTable(job2.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        ArrayList<String> jobIds = new ArrayList<String>();
        jobIds.add(job1.getId());
        jobIds.add(job2.getId());
        ArrayList<String> actionIds = new ArrayList<String>();
        actionIds.add(action1.getId());
        actionIds.add(action2.getId());
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("COORD-TEST");
        map.put("name", names);
        new BulkCoordXCommand(map, 1, 50, OperationType.Suspend).call();
        this.verifyJobsStatus(jobIds, Job.Status.SUSPENDED);
        this.verifyActionsStatus(actionIds, CoordinatorAction.Status.SUSPENDED);
        new BulkCoordXCommand(map, 1, 50, OperationType.Resume).call();
        this.verifyJobsStatus(jobIds, Job.Status.RUNNING);
        this.verifyActionsStatus(actionIds, CoordinatorAction.Status.RUNNING);
        new BulkCoordXCommand(map, 1, 50, OperationType.Kill).call();
        this.verifyJobsStatus(jobIds, Job.Status.KILLED);
        this.verifyActionsStatus(actionIds, CoordinatorAction.Status.KILLED);
    }

    public void testBulkCoordKillNegative() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 0);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(job1.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("COORD");
        map.put("name", names);
        new BulkCoordXCommand(map, 1, 50, OperationType.Kill).call();
        ArrayList<String> jobIds = new ArrayList<String>();
        jobIds.add(job1.getId());
        ArrayList<String> actionIds = new ArrayList<String>();
        actionIds.add(action1.getId());
        this.verifyJobsStatus(jobIds, Job.Status.RUNNING);
        this.verifyActionsStatus(actionIds, CoordinatorAction.Status.RUNNING);
    }

    public void testBulkCoordKillNoOp() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, start, end, false, false, 0);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(job1.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("COORD-TEST");
        map.put("name", names);
        new BulkCoordXCommand(map, 1, 50, OperationType.Kill).call();
        ArrayList<String> jobIds = new ArrayList<String>();
        jobIds.add(job1.getId());
        ArrayList<String> actionIds = new ArrayList<String>();
        actionIds.add(action1.getId());
        this.verifyJobsStatus(jobIds, Job.Status.SUCCEEDED);
        this.verifyActionsStatus(actionIds, CoordinatorAction.Status.SUCCEEDED);
    }

    public void testBulkCoordSuspendNoOp() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.KILLED, start, end, false, false, 0);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(job1.getId(), 1, CoordinatorAction.Status.KILLED, "coord-action-get.xml", 0);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("COORD-TEST");
        map.put("name", names);
        new BulkCoordXCommand(map, 1, 50, OperationType.Suspend).call();
        ArrayList<String> jobIds = new ArrayList<String>();
        jobIds.add(job1.getId());
        ArrayList<String> actionIds = new ArrayList<String>();
        actionIds.add(action1.getId());
        this.verifyJobsStatus(jobIds, Job.Status.KILLED);
        this.verifyActionsStatus(actionIds, CoordinatorAction.Status.KILLED);
    }

    public void testBulkCoordSuspendNegative() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 0);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(job1.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("COORD");
        map.put("name", names);
        new BulkCoordXCommand(map, 1, 50, OperationType.Suspend).call();
        ArrayList<String> jobIds = new ArrayList<String>();
        jobIds.add(job1.getId());
        ArrayList<String> actionIds = new ArrayList<String>();
        actionIds.add(action1.getId());
        this.verifyJobsStatus(jobIds, Job.Status.RUNNING);
        this.verifyActionsStatus(actionIds, CoordinatorAction.Status.RUNNING);
    }

    public void testBulkCoordResumeNoOp() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 0);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(job1.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("COORD-TEST");
        map.put("name", names);
        new BulkCoordXCommand(map, 1, 50, OperationType.Resume).call();
        ArrayList<String> jobIds = new ArrayList<String>();
        jobIds.add(job1.getId());
        ArrayList<String> actionIds = new ArrayList<String>();
        actionIds.add(action1.getId());
        this.verifyJobsStatus(jobIds, Job.Status.RUNNING);
        this.verifyActionsStatus(actionIds, CoordinatorAction.Status.RUNNING);
    }

    public void testBulkCoordResumeNegative() throws Exception {
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job1 = this.addRecordToCoordJobTable(Job.Status.SUSPENDED, start, end, false, false, 0);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(job1.getId(), 1, CoordinatorAction.Status.SUSPENDED, "coord-action-get.xml", 0);
        HashMap map = new HashMap();
        ArrayList<String> names = new ArrayList<String>();
        names.add("COORD");
        map.put("name", names);
        new BulkCoordXCommand(map, 1, 50, OperationType.Resume).call();
        ArrayList<String> jobIds = new ArrayList<String>();
        jobIds.add(job1.getId());
        ArrayList<String> actionIds = new ArrayList<String>();
        actionIds.add(action1.getId());
        this.verifyJobsStatus(jobIds, Job.Status.SUSPENDED);
        this.verifyActionsStatus(actionIds, CoordinatorAction.Status.SUSPENDED);
    }

    private void verifyJobsStatus(List<String> jobIds, Job.Status status) throws Exception {
        for (String id : jobIds) {
            CoordinatorJobBean job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{id});
            TestBulkCoordXCommand.assertEquals((Object)status, (Object)job.getStatus());
        }
    }

    private void verifyActionsStatus(List<String> actionIds, CoordinatorAction.Status status) throws Exception {
        for (String id : actionIds) {
            CoordinatorActionBean action = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{id});
            TestBulkCoordXCommand.assertEquals((Object)status, (Object)action.getStatus());
        }
    }
}

