/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.coord.CoordActionReadyXCommand;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.junit.Test;

public class TestCoordActionReadyXCommand
extends XDataTestCase {
    protected Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testActionsInREADYLastOnly() throws Exception {
        this._testActionsInREADY(CoordinatorJob.Execution.LAST_ONLY);
    }

    @Test
    public void testActionsInREADYNone() throws Exception {
        ConfigurationService.set((String)"oozie.coord.execution.none.tolerance", (String)"5");
        this._testActionsInREADY(CoordinatorJob.Execution.NONE);
    }

    private void _testActionsInREADY(CoordinatorJob.Execution execPolicy) throws Exception {
        Date now = new Date();
        Date start = new Date(now.getTime() - 960000L);
        Date end = new Date(now.getTime() + 1200000L);
        CoordinatorJobBean job = this.createCoordJob(Job.Status.RUNNING, start, end, true, true, 5);
        job.setStartTime(start);
        job.setEndTime(end);
        job.setExecutionOrder(execPolicy);
        job.setFrequency("5");
        job.setTimeUnit(CoordinatorJob.Timeunit.MINUTE);
        job.setConcurrency(1);
        this.addRecordToCoordJobTable(job);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.RUNNING, "wf-no-op.xml", 1, start);
        CoordinatorActionBean action2 = this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.READY, "wf-no-op.xml", 1, new Date(start.getTime() + 300000L));
        CoordinatorActionBean action3 = this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.READY, "wf-no-op.xml", 1, new Date(start.getTime() + 600000L));
        CoordinatorActionBean action4 = this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.READY, "wf-no-op.xml", 1, new Date(start.getTime() + 900000L));
        CoordinatorActionBean action5 = this.addRecordToCoordActionTable(job.getId(), 5, CoordinatorAction.Status.WAITING, "wf-no-op.xml", 1, new Date(start.getTime() + 1200000L));
        this.checkCoordActionStatus(action1.getId(), CoordinatorAction.Status.RUNNING);
        this.checkCoordActionStatus(action2.getId(), CoordinatorAction.Status.READY);
        this.checkCoordActionStatus(action3.getId(), CoordinatorAction.Status.READY);
        this.checkCoordActionStatus(action4.getId(), CoordinatorAction.Status.READY);
        this.checkCoordActionStatus(action5.getId(), CoordinatorAction.Status.WAITING);
        new CoordActionReadyXCommand(job.getId()).call();
        this.checkCoordActionStatus(action1.getId(), CoordinatorAction.Status.RUNNING);
        this.checkCoordActionStatus(action2.getId(), CoordinatorAction.Status.SKIPPED);
        this.checkCoordActionStatus(action3.getId(), CoordinatorAction.Status.SKIPPED);
        this.checkCoordActionStatus(action4.getId(), CoordinatorAction.Status.READY);
        this.checkCoordActionStatus(action5.getId(), CoordinatorAction.Status.WAITING);
    }
}

