/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.coord.CoordActionsKillXCommand;
import org.apache.oozie.executor.jpa.CoordActionGetForCheckJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.StatusTransitService;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.WorkflowLib;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;

public class TestCoordActionsKillXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), new String[]{StatusTransitService.class.getCanonicalName()});
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testActionKillCommandActionNumbers() throws Exception {
        JPAService jpaService = (JPAService)this.services.get(JPAService.class);
        String[] ids = this.createDBRecords();
        new CoordActionsKillXCommand(ids[0], "action", "1,3").call();
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForCheckJPAExecutor(ids[1]));
        TestCoordActionsKillXCommand.assertEquals((Object)CoordinatorAction.Status.KILLED, (Object)action.getStatus());
        this.sleep(100);
        WorkflowJobBean wf = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_FOR_SLA, new Object[]{ids[3]});
        TestCoordActionsKillXCommand.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wf.getStatus());
        CoordinatorJobBean job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(ids[0]));
        TestCoordActionsKillXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(ids[0]));
        TestCoordActionsKillXCommand.assertEquals((Object)Job.Status.RUNNINGWITHERROR, (Object)job.getStatus());
    }

    public void testActionKillCommandDate() throws Exception {
        JPAService jpaService = (JPAService)this.services.get(JPAService.class);
        String[] ids = this.createDBRecords();
        System.out.println(DateUtils.parseDateOozieTZ((String)"2009-12-15T01:00Z"));
        System.out.println(DateUtils.parseDateOozieTZ((String)"2009-12-15T02:00Z"));
        new CoordActionsKillXCommand(ids[0], "date", "2009-12-15T01:00Z::2009-12-15T02:00Z").call();
        CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForCheckJPAExecutor(ids[1]));
        System.out.println(action.getNominalTime());
        TestCoordActionsKillXCommand.assertEquals((Object)CoordinatorAction.Status.KILLED, (Object)action.getStatus());
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForCheckJPAExecutor(ids[2]));
        System.out.println(action.getNominalTime());
        TestCoordActionsKillXCommand.assertEquals((Object)CoordinatorAction.Status.KILLED, (Object)action.getStatus());
        this.sleep(100);
        WorkflowJobBean wf = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_FOR_SLA, new Object[]{ids[3]});
        TestCoordActionsKillXCommand.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wf.getStatus());
        CoordinatorJobBean job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(ids[0]));
        TestCoordActionsKillXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)job.getStatus());
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(ids[0]));
        TestCoordActionsKillXCommand.assertEquals((Object)Job.Status.KILLED, (Object)job.getStatus());
    }

    private String[] createDBRecords() throws Exception {
        JPAService jpaService = (JPAService)this.services.get(JPAService.class);
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T23:59Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-08-02T23:59Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, false, true, 0);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        CoordinatorActionBean action2 = this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        action2.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-12-15T02:00Z"));
        action2.setExternalId(null);
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION, (Object)action2);
        WorkflowJobBean wf = new WorkflowJobBean();
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        wf.setId(action1.getExternalId());
        wf.setStatus(WorkflowJob.Status.RUNNING);
        WorkflowLib workflowLib = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).getWorkflowLibWithNoDB();
        WorkflowInstance wfInstance = workflowLib.createInstance((WorkflowApp)app, (Configuration)new XConfiguration());
        ((LiteWorkflowInstance)wfInstance).setStatus(WorkflowInstance.Status.RUNNING);
        wf.setWorkflowInstance(wfInstance);
        jpaService.execute((JPAExecutor)new WorkflowJobInsertJPAExecutor(wf));
        return new String[]{job.getId(), action1.getId(), action2.getId(), wf.getId()};
    }
}

