/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordChangeXCommand;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetActionByActionNumberJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLARegistrationQueryExecutor;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.SchedulerService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.StatusTransitService;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XCallable;

public class TestCoordChangeXCommand
extends XDataTestCase {
    private Services services;

    public static String convertDateToString(long timeStamp) {
        return DateUtils.formatDateOozieTZ((Date)new Date(timeStamp));
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.services.setService(FakeCallableQueueService.class);
        ((SchedulerService)this.services.get(SchedulerService.class)).destroy();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordChangeXCommand() throws StoreException, CommandException {
        String pauseTime;
        String jobId;
        block31: {
            block30: {
                block29: {
                    block28: {
                        System.out.println("Running Test");
                        jobId = "0000000-" + new Date().getTime() + "-testCoordChangeXCommand-C";
                        try {
                            this.addRecordToJobTable(jobId);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            TestCoordChangeXCommand.fail((String)("Exception thrown " + ex));
                        }
                        pauseTime = TestCoordChangeXCommand.convertDateToString(new Date().getTime() + 600000L);
                        String endTime = TestCoordChangeXCommand.convertDateToString(new Date().getTime() + 1200000L);
                        new CoordChangeXCommand(jobId, "endtime=" + endTime + ";concurrency=200").call();
                        try {
                            this.checkCoordJobs(jobId, DateUtils.parseDateOozieTZ((String)endTime), 200, null, false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            TestCoordChangeXCommand.fail((String)("Invalid date" + ex));
                        }
                        String changeValue = "endtime=" + endTime + ";concurrency=200;pausetime=" + pauseTime;
                        new CoordChangeXCommand(jobId, changeValue).call();
                        try {
                            this.checkCoordJobs(jobId, DateUtils.parseDateOozieTZ((String)endTime), 200, DateUtils.parseDateOozieTZ((String)pauseTime), true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            TestCoordChangeXCommand.fail((String)("Invalid date" + ex));
                        }
                        new CoordChangeXCommand(jobId, "endtime=" + endTime + ";concurrency=200;pausetime=").call();
                        try {
                            this.checkCoordJobs(jobId, DateUtils.parseDateOozieTZ((String)endTime), 200, null, true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            TestCoordChangeXCommand.fail((String)("Invalid date" + ex));
                        }
                        new CoordChangeXCommand(jobId, "endtime=" + endTime + ";pausetime=;concurrency=200").call();
                        try {
                            this.checkCoordJobs(jobId, DateUtils.parseDateOozieTZ((String)endTime), 200, null, true);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            TestCoordChangeXCommand.fail((String)("Invalid date" + ex));
                        }
                        new CoordChangeXCommand(jobId, "endtime=2012-12-20T05:00Z;concurrency=-200").call();
                        try {
                            this.checkCoordJobs(jobId, DateUtils.parseDateOozieTZ((String)"2012-12-20T05:00Z"), -200, null, false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            TestCoordChangeXCommand.fail((String)("Invalid date" + ex));
                        }
                        new CoordChangeXCommand(jobId, "endtime=2012-12-20T05:00Z").call();
                        try {
                            this.checkCoordJobs(jobId, DateUtils.parseDateOozieTZ((String)"2012-12-20T05:00Z"), null, null, false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            TestCoordChangeXCommand.fail((String)("Invalid date" + ex));
                        }
                        new CoordChangeXCommand(jobId, "concurrency=-1").call();
                        try {
                            this.checkCoordJobs(jobId, null, -1, null, false);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            TestCoordChangeXCommand.fail((String)("Invalid date" + ex));
                        }
                        try {
                            new CoordChangeXCommand(jobId, "a=1;b=-200").call();
                            TestCoordChangeXCommand.fail((String)"Should not reach here.");
                        }
                        catch (CommandException ex) {
                            if (ex.getErrorCode() == ErrorCode.E1015) break block28;
                            TestCoordChangeXCommand.fail((String)"Error code should be E1015.");
                        }
                    }
                    try {
                        new CoordChangeXCommand(jobId, "endtime=2012-12-20T05:00;concurrency=-200").call();
                        TestCoordChangeXCommand.fail((String)"Should not reach here.");
                    }
                    catch (CommandException ex) {
                        if (ex.getErrorCode() == ErrorCode.E1015) break block29;
                        TestCoordChangeXCommand.fail((String)"Error code should be E1015.");
                    }
                }
                try {
                    new CoordChangeXCommand(jobId, "endtime=2012-12-20T05:00Z;concurrency=2ac").call();
                    TestCoordChangeXCommand.fail((String)"Should not reach here.");
                }
                catch (CommandException ex) {
                    if (ex.getErrorCode() == ErrorCode.E1015) break block30;
                    TestCoordChangeXCommand.fail((String)"Error code should be E1015.");
                }
            }
            try {
                new CoordChangeXCommand(jobId, "endtime=1900-12-20T05:00Z").call();
            }
            catch (CommandException ex) {
                TestCoordChangeXCommand.fail((String)"Should not throw exception");
            }
            try {
                new CoordChangeXCommand(jobId, "pausetime=null").call();
                TestCoordChangeXCommand.fail((String)"Should not reach here.");
            }
            catch (CommandException ex) {
                if (ex.getErrorCode() == ErrorCode.E1015) break block31;
                TestCoordChangeXCommand.fail((String)"Error code should be E1015.");
            }
        }
        try {
            new CoordChangeXCommand(jobId, "pausetime=" + pauseTime).call();
        }
        catch (CommandException ex) {
            TestCoordChangeXCommand.fail((String)"Should not throw exception");
        }
    }

    public void testCoordChangeEndTime() throws Exception {
        Date startTime = new Date();
        Date endTime = new Date(startTime.getTime() + 1200000L);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, true, true, 0);
        String pauseTime = TestCoordChangeXCommand.convertDateToString(startTime.getTime() + 600000L);
        String newEndTime = TestCoordChangeXCommand.convertDateToString(startTime.getTime() + 2400000L);
        new CoordChangeXCommand(job.getId(), "endtime=" + newEndTime + ";pausetime=" + pauseTime).call();
        try {
            this.checkCoordJobs(job.getId(), DateUtils.parseDateOozieTZ((String)newEndTime), null, DateUtils.parseDateOozieTZ((String)pauseTime), true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestCoordChangeXCommand.fail((String)("Invalid date" + ex));
        }
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
        TestCoordChangeXCommand.assertFalse((boolean)coordJob.isDoneMaterialization());
    }

    public void testCoordChangeEndTime1() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        Date startTime = new Date();
        Date endTime = new Date(startTime.getTime() + 3000000L);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, true, true, 1);
        coordJob.setNextMaterializedTime(new Date(startTime.getTime() + 1800000L));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob);
        this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        TestCoordChangeXCommand.assertEquals((long)endTime.getTime(), (long)coordJob.getEndTime().getTime());
        String newEndTime = TestCoordChangeXCommand.convertDateToString(startTime.getTime() + 1800000L);
        new CoordChangeXCommand(coordJob.getId(), "endtime=" + newEndTime).call();
        try {
            this.checkCoordJobs(coordJob.getId(), DateUtils.parseDateOozieTZ((String)newEndTime), null, null, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestCoordChangeXCommand.fail((String)("Invalid date" + ex));
        }
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
        TestCoordChangeXCommand.assertEquals((String)newEndTime, (String)TestCoordChangeXCommand.convertDateToString(coordJob.getEndTime().getTime()));
        TestCoordChangeXCommand.assertTrue((boolean)coordJob.isPending());
        TestCoordChangeXCommand.assertTrue((boolean)coordJob.isDoneMaterialization());
        runnable.run();
        this.sleep(1000);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestCoordChangeXCommand.assertFalse((boolean)coordJob.isPending());
        TestCoordChangeXCommand.assertTrue((boolean)coordJob.isDoneMaterialization());
    }

    public void testCoordChangeEndTime2() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        Date startTime = new Date();
        Date endTime = new Date(startTime.getTime() + 3000000L);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, true, true, 1);
        coordJob.setNextMaterializedTime(new Date(startTime.getTime() + 1800000L));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob);
        this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        TestCoordChangeXCommand.assertTrue((boolean)coordJob.isDoneMaterialization());
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        String newEndTime = TestCoordChangeXCommand.convertDateToString(startTime.getTime() + 2400000L);
        new CoordChangeXCommand(coordJob.getId(), "endtime=" + newEndTime).call();
        try {
            this.checkCoordJobs(coordJob.getId(), DateUtils.parseDateOozieTZ((String)newEndTime), null, null, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestCoordChangeXCommand.fail((String)("Invalid date" + ex));
        }
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
        TestCoordChangeXCommand.assertTrue((boolean)coordJob.isPending());
        TestCoordChangeXCommand.assertFalse((boolean)coordJob.isDoneMaterialization());
        TestCoordChangeXCommand.assertEquals((String)newEndTime, (String)TestCoordChangeXCommand.convertDateToString(coordJob.getEndTime().getTime()));
    }

    public void testCoordChangeEndTime3() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        Date startTime = new Date();
        Date endTime = new Date(startTime.getTime() + 600000L);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, true, true, 1);
        coordJob.setNextMaterializedTime(new Date(startTime.getTime() + 2400000L));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob);
        this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestCoordChangeXCommand.assertFalse((boolean)coordJob.isPending());
        TestCoordChangeXCommand.assertTrue((boolean)coordJob.isDoneMaterialization());
        String newEndTime = TestCoordChangeXCommand.convertDateToString(startTime.getTime() + 1200000L);
        try {
            new CoordChangeXCommand(coordJob.getId(), "endtime=" + newEndTime).call();
        }
        catch (Exception e) {
            TestCoordChangeXCommand.assertTrue((boolean)e.getMessage().contains("Didn't change endtime. Endtime is in between coord end time and next materialization time"));
        }
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertFalse((Job.Status.RUNNING == coordJob.getStatus() ? 1 : 0) != 0);
        TestCoordChangeXCommand.assertFalse((boolean)coordJob.isPending());
        TestCoordChangeXCommand.assertTrue((boolean)coordJob.isDoneMaterialization());
    }

    public void testCoordChangeEndTime4() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        Date startTime = new Date();
        Date endTime = new Date(startTime.getTime() + 3000000L);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, true, true, 1);
        coordJob.setNextMaterializedTime(new Date(startTime.getTime() + 1800000L));
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, coordJob);
        StatusTransitService.StatusTransitRunnable runnable = new StatusTransitService.StatusTransitRunnable();
        runnable.run();
        this.sleep(1000);
        TestCoordChangeXCommand.assertEquals((long)endTime.getTime(), (long)coordJob.getEndTime().getTime());
        String newEndTime = TestCoordChangeXCommand.convertDateToString(startTime.getTime() + 1800000L);
        new CoordChangeXCommand(coordJob.getId(), "endtime=" + newEndTime).call();
        try {
            this.checkCoordJobs(coordJob.getId(), DateUtils.parseDateOozieTZ((String)newEndTime), null, null, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestCoordChangeXCommand.fail((String)("Invalid date" + ex));
        }
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(coordJob.getId());
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
        TestCoordChangeXCommand.assertEquals((String)newEndTime, (String)TestCoordChangeXCommand.convertDateToString(coordJob.getEndTime().getTime()));
        TestCoordChangeXCommand.assertTrue((boolean)coordJob.isPending());
        TestCoordChangeXCommand.assertTrue((boolean)coordJob.isDoneMaterialization());
        runnable.run();
        this.sleep(1000);
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        TestCoordChangeXCommand.assertFalse((boolean)coordJob.isPending());
        TestCoordChangeXCommand.assertTrue((boolean)coordJob.isDoneMaterialization());
    }

    public void testCoordChangeEndTimeDeleteAction() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T05:00Z");
        Date changeEndTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T02:00Z");
        String endTimeChangeStr = "endtime=" + DateUtils.formatDateOozieTZ((Date)changeEndTime);
        CoordinatorJobBean job = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.RUNNING, startTime, endTime, endTime, true, false, 4);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T00:00Z"));
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T01:00Z"));
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T02:00Z"));
        this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T03:00Z"));
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        new CoordChangeXCommand(job.getId(), endTimeChangeStr).call();
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((Object)coordJob.getEndTime(), (Object)changeEndTime);
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
        TestCoordChangeXCommand.assertEquals((int)2, (int)coordJob.getLastActionNumber());
        try {
            jpaService.execute((JPAExecutor)new CoordJobGetActionByActionNumberJPAExecutor(job.getId(), 2));
        }
        catch (JPAExecutorException jpae) {
            TestCoordChangeXCommand.fail((String)" Action should be there");
        }
        try {
            jpaService.execute((JPAExecutor)new CoordJobGetActionByActionNumberJPAExecutor(job.getId(), 3));
            TestCoordChangeXCommand.fail((String)"Expected to fail as action 3 should have been deleted");
        }
        catch (JPAExecutorException jpae) {
            TestCoordChangeXCommand.assertEquals((Object)ErrorCode.E0603, (Object)jpae.getErrorCode());
        }
        TestCoordChangeXCommand.assertEquals((Object)DateUtils.parseDateOozieTZ((String)"2013-08-01T02:00Z"), (Object)coordJob.getNextMaterializedTime());
        TestCoordChangeXCommand.assertEquals((Object)DateUtils.parseDateOozieTZ((String)"2013-08-01T02:00Z"), (Object)coordJob.getLastActionTime());
    }

    public void testProcessLookaheadActions() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-08-29T00:00Z");
        Date changeEndTime = DateUtils.parseDateOozieTZ((String)"2013-08-05T00:00Z");
        String endTimeChangeStr = "endtime=" + DateUtils.formatDateOozieTZ((Date)changeEndTime);
        CoordinatorJobBean job = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.SUSPENDED, startTime, endTime, endTime, true, false, 6);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T00:00Z"));
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-02T00:00Z"));
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-03T00:00Z"));
        this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-04T00:00Z"));
        this.addRecordToCoordActionTable(job.getId(), 5, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-05T00:00Z"));
        this.addRecordToCoordActionTable(job.getId(), 6, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-06T00:00Z"));
        job.setFrequency("1");
        job.setTimeUnit(CoordinatorJob.Timeunit.DAY);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        new CoordChangeXCommand(job.getId(), endTimeChangeStr).call();
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((Object)coordJob.getEndTime(), (Object)changeEndTime);
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.SUSPENDED, (Object)coordJob.getStatus());
        TestCoordChangeXCommand.assertEquals((int)4, (int)coordJob.getLastActionNumber());
        TestCoordChangeXCommand.assertEquals((Object)DateUtils.parseDateOozieTZ((String)"2013-08-05T00:00Z"), (Object)coordJob.getNextMaterializedTime());
        TestCoordChangeXCommand.assertEquals((Object)DateUtils.parseDateOozieTZ((String)"2013-08-05T00:00Z"), (Object)coordJob.getLastActionTime());
        TestCoordChangeXCommand.assertEquals((Object)changeEndTime, (Object)coordJob.getEndTime());
    }

    public void testCoordChangeEndTimeBeforeStart() throws Exception {
        Date start = new Date();
        Date end = new Date(start.getTime() + 14400000L);
        Date endTime = new Date(start.getTime() - 3000L);
        String endTimeChangeStr = "endtime=" + DateUtils.formatDateOozieTZ((Date)endTime);
        CoordinatorJobBean job = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.PREP, start, end, end, true, false, 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.PREP, (Object)coordJob.getStatus());
        TestCoordChangeXCommand.assertEquals((int)0, (int)coordJob.getLastActionNumber());
        new CoordChangeXCommand(job.getId(), endTimeChangeStr).call();
        coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((String)DateUtils.formatDateOozieTZ((Date)coordJob.getEndTime()), (String)DateUtils.formatDateOozieTZ((Date)endTime));
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        Date newEndTime = new Date(start.getTime() - 2000L);
        endTimeChangeStr = "endtime=" + DateUtils.formatDateOozieTZ((Date)newEndTime);
        new CoordChangeXCommand(job.getId(), endTimeChangeStr).call();
        coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((String)DateUtils.formatDateOozieTZ((Date)coordJob.getEndTime()), (String)DateUtils.formatDateOozieTZ((Date)newEndTime));
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        newEndTime = new Date(start.getTime() + 14400000L);
        endTimeChangeStr = "endtime=" + DateUtils.formatDateOozieTZ((Date)newEndTime);
        new CoordChangeXCommand(job.getId(), endTimeChangeStr).call();
        coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((String)DateUtils.formatDateOozieTZ((Date)coordJob.getEndTime()), (String)DateUtils.formatDateOozieTZ((Date)newEndTime));
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
        newEndTime = new Date(start.getTime() - 1000L);
        endTimeChangeStr = "endtime=" + DateUtils.formatDateOozieTZ((Date)newEndTime);
        new CoordChangeXCommand(job.getId(), endTimeChangeStr).call();
        coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((String)DateUtils.formatDateOozieTZ((Date)coordJob.getEndTime()), (String)DateUtils.formatDateOozieTZ((Date)newEndTime));
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
    }

    public void testCoordChangeStatus() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.services.init();
        ((SchedulerService)this.services.get(SchedulerService.class)).destroy();
        Date startTime = new Date();
        Date endTime = new Date(startTime.getTime() + 1200000L);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.FAILED, startTime, endTime, true, true, 0);
        String pauseTime = TestCoordChangeXCommand.convertDateToString(startTime.getTime() + 600000L);
        String newEndTime = TestCoordChangeXCommand.convertDateToString(startTime.getTime() + 2400000L);
        new CoordChangeXCommand(job.getId(), "endtime=" + newEndTime + ";pausetime=" + pauseTime).call();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.RUNNINGWITHERROR, (Object)coordJob.getStatus());
    }

    public void testCoordChangePauseTime() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T04:59Z");
        Date pauseTime = new Date(startTime.getTime() + 10800000L);
        String pauseTimeChangeStr = "pausetime=" + DateUtils.formatDateOozieTZ((Date)pauseTime);
        CoordinatorJobBean job = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.RUNNING, startTime, endTime, endTime, true, false, 4);
        CoordinatorActionBean ca1 = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        CoordinatorActionBean ca2 = this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T02:00Z"));
        CoordinatorActionBean ca3 = this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T03:00Z"));
        CoordinatorActionBean ca4 = this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T04:00Z"));
        SLARegistrationBean slaRegBean1 = new SLARegistrationBean();
        slaRegBean1.setId(ca1.getId());
        SLARegistrationBean slaRegBean2 = new SLARegistrationBean();
        slaRegBean2.setId(ca2.getId());
        SLARegistrationBean slaRegBean3 = new SLARegistrationBean();
        slaRegBean3.setId(ca3.getId());
        SLARegistrationBean slaRegBean4 = new SLARegistrationBean();
        slaRegBean4.setId(ca4.getId());
        SLASummaryBean slaSummaryBean1 = new SLASummaryBean();
        slaSummaryBean1.setId(ca1.getId());
        SLASummaryBean slaSummaryBean3 = new SLASummaryBean();
        slaSummaryBean3.setId(ca3.getId());
        ArrayList<Object> insertList = new ArrayList<Object>();
        insertList.add(slaRegBean1);
        insertList.add(slaRegBean2);
        insertList.add(slaRegBean3);
        insertList.add(slaRegBean4);
        insertList.add(slaSummaryBean1);
        insertList.add(slaSummaryBean3);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
        new CoordChangeXCommand(job.getId(), pauseTimeChangeStr).call();
        CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
        CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
        TestCoordChangeXCommand.assertEquals((String)DateUtils.formatDateOozieTZ((Date)coordJob.getPauseTime()), (String)DateUtils.formatDateOozieTZ((Date)pauseTime));
        TestCoordChangeXCommand.assertEquals((Object)Job.Status.RUNNING, (Object)coordJob.getStatus());
        TestCoordChangeXCommand.assertEquals((int)2, (int)coordJob.getLastActionNumber());
        try {
            jpaService.execute((JPAExecutor)new CoordJobGetActionByActionNumberJPAExecutor(job.getId(), 3));
            TestCoordChangeXCommand.fail((String)"Expected to fail as action 3 should have been deleted");
        }
        catch (JPAExecutorException jpae) {
            TestCoordChangeXCommand.assertEquals((Object)ErrorCode.E0603, (Object)jpae.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new CoordJobGetActionByActionNumberJPAExecutor(job.getId(), 4));
            TestCoordChangeXCommand.fail((String)"Expected to fail as action 4 should have been deleted");
        }
        catch (JPAExecutorException jpae) {
            TestCoordChangeXCommand.assertEquals((Object)ErrorCode.E0603, (Object)jpae.getErrorCode());
        }
        slaRegBean1 = (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, new Object[]{slaRegBean1.getId()});
        TestCoordChangeXCommand.assertNotNull((Object)slaRegBean1);
        slaRegBean2 = (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, new Object[]{slaRegBean2.getId()});
        TestCoordChangeXCommand.assertNotNull((Object)slaRegBean2);
        slaRegBean3 = (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, new Object[]{slaRegBean3.getId()});
        TestCoordChangeXCommand.assertNull((Object)slaRegBean3);
        slaRegBean4 = (SLARegistrationBean)SLARegistrationQueryExecutor.getInstance().get((Enum)SLARegistrationQueryExecutor.SLARegQuery.GET_SLA_REG_ALL, new Object[]{slaRegBean4.getId()});
        TestCoordChangeXCommand.assertNull((Object)slaRegBean4);
        slaSummaryBean3 = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{slaSummaryBean3.getId()});
        TestCoordChangeXCommand.assertNull((Object)slaSummaryBean3);
        slaSummaryBean1 = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{slaSummaryBean1.getId()});
        TestCoordChangeXCommand.assertNotNull((Object)slaSummaryBean1);
    }

    public void testCoordChangeConcurrency() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T04:59Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.RUNNING, startTime, endTime, endTime, true, false, 4);
        CoordinatorActionBean ca1 = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        CoordinatorActionBean ca2 = this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        CoordinatorActionBean ca3 = this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.READY, "coord-action-get.xml", 0);
        CoordinatorActionBean ca4 = this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.READY, "coord-action-get.xml", 0);
        new CoordChangeXCommand(job.getId(), "concurrency=4").call();
        Thread.sleep(100L);
        ca1 = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{job.getId() + "@1"});
        ca2 = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{job.getId() + "@2"});
        ca3 = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{job.getId() + "@3"});
        ca4 = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{job.getId() + "@4"});
        TestCoordChangeXCommand.assertEquals((String)CoordinatorAction.Status.RUNNING.toString(), (String)ca1.getStatusStr());
        TestCoordChangeXCommand.assertEquals((String)CoordinatorAction.Status.RUNNING.toString(), (String)ca2.getStatusStr());
        TestCoordChangeXCommand.assertEquals((String)CoordinatorAction.Status.READY.toString(), (String)ca3.getStatusStr());
        TestCoordChangeXCommand.assertEquals((String)CoordinatorAction.Status.READY.toString(), (String)ca4.getStatusStr());
    }

    public void testChangeTimeDeleteRunning() throws Exception {
        block5: {
            CoordinatorJobBean job;
            Date pauseTime;
            block4: {
                Date startTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T00:00Z");
                Date endTime = DateUtils.parseDateOozieTZ((String)"2013-08-01T04:59Z");
                pauseTime = new Date(startTime.getTime() + 0x6DDD00L);
                String pauseTimeChangeStr = "pausetime=" + DateUtils.formatDateOozieTZ((Date)pauseTime);
                job = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.RUNNING, startTime, endTime, endTime, true, false, 4);
                this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
                this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T02:00Z"));
                this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T03:00Z"));
                this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, DateUtils.parseDateOozieTZ((String)"2013-08-01T04:00Z"));
                try {
                    new CoordChangeXCommand(job.getId(), pauseTimeChangeStr).call();
                    TestCoordChangeXCommand.fail((String)"Should not reach here.");
                }
                catch (CommandException e) {
                    if (e.getErrorCode() == ErrorCode.E1022) break block4;
                    TestCoordChangeXCommand.fail((String)"Error code should be E1022");
                }
            }
            String endTimeChangeStr = "endtime=" + DateUtils.formatDateOozieTZ((Date)pauseTime);
            try {
                new CoordChangeXCommand(job.getId(), endTimeChangeStr).call();
                TestCoordChangeXCommand.fail((String)"Should not reach here.");
            }
            catch (CommandException e) {
                if (e.getErrorCode() == ErrorCode.E1022) break block5;
                TestCoordChangeXCommand.fail((String)"Error code should be E1022");
            }
        }
    }

    public void testCoordStatus_Ignored() throws Exception {
        Date start = new Date();
        Date end = new Date(start.getTime() + 18000000L);
        String statusToRUNNING = "status=RUNNING";
        String statusToIGNORED = "status=IGNORED";
        CoordinatorJobBean job1 = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.IGNORED, start, end, end, false, false, 4);
        CoordinatorJobBean job2 = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.KILLED, start, end, end, false, false, 4);
        CoordinatorJobBean job3 = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.RUNNING, start, end, end, false, false, 4);
        CoordinatorJobBean job4 = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.FAILED, start, end, end, true, false, 4);
        new CoordChangeXCommand(job1.getId(), statusToRUNNING).call();
        CoordinatorJobBean coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job1.getId()});
        TestCoordChangeXCommand.assertEquals((Object)coordJob.getStatus(), (Object)Job.Status.RUNNING);
        new CoordChangeXCommand(job2.getId(), statusToIGNORED).call();
        coordJob = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{job2.getId()});
        TestCoordChangeXCommand.assertEquals((Object)coordJob.getStatus(), (Object)Job.Status.IGNORED);
        try {
            new CoordChangeXCommand(job3.getId(), statusToIGNORED).call();
        }
        catch (CommandException ex) {
            TestCoordChangeXCommand.assertEquals((Object)ErrorCode.E1015, (Object)ex.getErrorCode());
            TestCoordChangeXCommand.assertTrue((ex.getMessage().indexOf("Only FAILED or KILLED non-pending job can be changed to IGNORED") > -1 ? 1 : 0) != 0);
        }
        try {
            new CoordChangeXCommand(job4.getId(), statusToIGNORED).call();
        }
        catch (CommandException ex) {
            TestCoordChangeXCommand.assertEquals((Object)ErrorCode.E1015, (Object)ex.getErrorCode());
            TestCoordChangeXCommand.assertTrue((ex.getMessage().indexOf("Only FAILED or KILLED non-pending job can be changed to IGNORED") > -1 ? 1 : 0) != 0);
        }
    }

    public void testCoordStatus_Failed() throws Exception {
        block2: {
            Date start = new Date();
            Date end = new Date(start.getTime() + 18000000L);
            String status = "status=RUNNING";
            CoordinatorJobBean job = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.FAILED, start, end, end, true, false, 4);
            this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
            this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
            this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
            this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
            try {
                new CoordChangeXCommand(job.getId(), status).call();
                JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
                CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
                TestCoordChangeXCommand.assertEquals((String)coordJob.getStatusStr(), (String)"RUNNING");
            }
            catch (CommandException e) {
                e.printStackTrace();
                if (e.getErrorCode() == ErrorCode.E1022) break block2;
                TestCoordChangeXCommand.fail((String)"Error code should be E1022");
            }
        }
    }

    public void testCoordStatus_Killed() throws Exception {
        block2: {
            Date start = new Date();
            Date end = new Date(start.getTime() + 18000000L);
            String status = "status=RUNNING";
            CoordinatorJobBean job = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.KILLED, start, end, end, true, false, 4);
            this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
            this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
            this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
            this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
            try {
                new CoordChangeXCommand(job.getId(), status).call();
                JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
                CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(job.getId());
                CoordinatorJobBean coordJob = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
                TestCoordChangeXCommand.assertEquals((String)coordJob.getStatusStr(), (String)"RUNNING");
            }
            catch (CommandException e) {
                e.printStackTrace();
                if (e.getErrorCode() == ErrorCode.E1022) break block2;
                TestCoordChangeXCommand.fail((String)"Error code should be E1022");
            }
        }
    }

    public void testCoordStatus_Changefailed() throws Exception {
        Date start = new Date();
        Date end = new Date(start.getTime() + 14400000L);
        String status = "status=RUNNING";
        CoordinatorJobBean job = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.SUCCEEDED, start, end, end, true, false, 4);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        try {
            new CoordChangeXCommand(job.getId(), status).call();
        }
        catch (CommandException e) {
            TestCoordChangeXCommand.assertTrue((boolean)e.getMessage().contains("Invalid coordinator job change value RUNNING"));
        }
    }

    public void testCoord_throwException() throws Exception {
        Date start = new Date();
        Date end = new Date(start.getTime() + 14400000L);
        String status = "status=RUNNING;pausetime=" + DateUtils.formatDateOozieTZ((Date)end);
        CoordinatorJobBean job = this.addRecordToCoordJobTableForPauseTimeTest(Job.Status.KILLED, start, end, end, true, false, 4);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), 4, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        try {
            new CoordChangeXCommand(job.getId(), status).call();
            TestCoordChangeXCommand.fail((String)"should throw Exception");
        }
        catch (CommandException e) {
            TestCoordChangeXCommand.assertTrue((boolean)e.getMessage().contains("Cannot change a killed coordinator job"));
        }
    }

    protected CoordinatorJobBean addRecordToCoordJobTableForPauseTimeTest(Job.Status status, Date start, Date end, Date lastActionTime, boolean pending, boolean doneMatd, int lastActionNum) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, start, end, pending, doneMatd, lastActionNum);
        coordJob.setFrequency("1");
        coordJob.setTimeUnit(CoordinatorJob.Timeunit.HOUR);
        coordJob.setLastActionNumber(lastActionNum);
        coordJob.setLastActionTime(lastActionTime);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordChangeXCommand.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestCoordChangeXCommand.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }

    private void addRecordToJobTable(String jobId) throws Exception {
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(jobId);
        coordJob.setAppName("testApp");
        coordJob.setAppPath("testAppPath");
        coordJob.setStatus(Job.Status.SUCCEEDED);
        coordJob.setCreatedTime(new Date());
        coordJob.setLastModifiedTime(DateUtils.parseDateOozieTZ((String)"2009-01-02T23:59Z"));
        coordJob.setTimeZone("UTC");
        coordJob.setTimeUnit(CoordinatorJob.Timeunit.MINUTE);
        coordJob.setUser("testUser");
        coordJob.setGroup("testGroup");
        String confStr = "<configuration></configuration>";
        coordJob.setConf(confStr);
        String appXml = "<coordinator-app xmlns='uri:oozie:coordinator:0.2' name='NAME' frequency=\"5\" start='2009-02-01T01:00Z' end='2009-02-01T01:09Z' timezone='UTC' freq_timeunit='MINUTE' end_of_duration='NONE'>";
        appXml = appXml + "<controls>";
        appXml = appXml + "<timeout>10</timeout>";
        appXml = appXml + "<concurrency>2</concurrency>";
        appXml = appXml + "<execution>LIFO</execution>";
        appXml = appXml + "</controls>";
        appXml = appXml + "<input-events>";
        appXml = appXml + "<data-in name='A' dataset='a'>";
        appXml = appXml + "<dataset name='a' frequency='5' initial-instance='2009-02-01T01:00Z' timezone='UTC' freq_timeunit='MINUTE' end_of_duration='NONE'>";
        appXml = appXml + "<uri-template>file:///tmp/coord/workflows/${YEAR}/${DAY}</uri-template>";
        appXml = appXml + "</dataset>";
        appXml = appXml + "<instance>${coord:latest(0)}</instance>";
        appXml = appXml + "</data-in>";
        appXml = appXml + "</input-events>";
        appXml = appXml + "<output-events>";
        appXml = appXml + "<data-out name='LOCAL_A' dataset='local_a'>";
        appXml = appXml + "<dataset name='local_a' frequency='5' initial-instance='2009-02-01T01:00Z' timezone='UTC' freq_timeunit='MINUTE' end_of_duration='NONE'>";
        appXml = appXml + "<uri-template>file:///tmp/coord/workflows/${YEAR}/${DAY}</uri-template>";
        appXml = appXml + "</dataset>";
        appXml = appXml + "<instance>${coord:current(-1)}</instance>";
        appXml = appXml + "</data-out>";
        appXml = appXml + "</output-events>";
        appXml = appXml + "<action>";
        appXml = appXml + "<workflow>";
        appXml = appXml + "<app-path>hdfs:///tmp/workflows/</app-path>";
        appXml = appXml + "<configuration>";
        appXml = appXml + "<property>";
        appXml = appXml + "<name>inputA</name>";
        appXml = appXml + "<value>${coord:dataIn('A')}</value>";
        appXml = appXml + "</property>";
        appXml = appXml + "<property>";
        appXml = appXml + "<name>inputB</name>";
        appXml = appXml + "<value>${coord:dataOut('LOCAL_A')}</value>";
        appXml = appXml + "</property>";
        appXml = appXml + "</configuration>";
        appXml = appXml + "</workflow>";
        appXml = appXml + "</action>";
        appXml = appXml + "</coordinator-app>";
        coordJob.setJobXml(appXml);
        coordJob.setLastActionNumber(0);
        coordJob.setFrequency("5");
        coordJob.setExecutionOrder(CoordinatorJob.Execution.FIFO);
        coordJob.setConcurrency(1);
        try {
            coordJob.setStartTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z"));
            coordJob.setEndTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T01:09Z"));
            coordJob.setLastActionTime(DateUtils.parseDateOozieTZ((String)"2009-02-01T01:10Z"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordChangeXCommand.fail((String)"Could not set Date/time");
        }
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordChangeXCommand.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestCoordChangeXCommand.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
    }

    private void checkCoordJobs(String jobId, Date endTime, Integer concurrency, Date pauseTime, boolean checkPauseTime) throws StoreException {
        try {
            int c;
            Date d;
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordChangeXCommand.assertNotNull((Object)jpaService);
            CoordJobGetJPAExecutor coordGetCmd = new CoordJobGetJPAExecutor(jobId);
            CoordinatorJobBean job = null;
            job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordGetCmd);
            if (endTime != null) {
                Job.Status status;
                d = job.getEndTime();
                if (d.compareTo(endTime) != 0) {
                    TestCoordChangeXCommand.fail((String)("Endtime is not updated properly job_end_time=" + d + ", expected_end_time=" + endTime));
                }
                if ((status = job.getStatus()) != Job.Status.RUNNING) {
                    TestCoordChangeXCommand.fail((String)"Coordinator job's status is not updated properly");
                }
            }
            if (concurrency != null && (c = job.getConcurrency()) != concurrency) {
                TestCoordChangeXCommand.fail((String)"Concurrency is not updated properly");
            }
            if (checkPauseTime) {
                d = job.getPauseTime();
                if (pauseTime == null) {
                    if (d != null) {
                        TestCoordChangeXCommand.fail((String)("Pausetime is not updated properly job_pause_time=" + d + ", expected_pause_time=" + pauseTime));
                    }
                } else if (d.compareTo(pauseTime) != 0) {
                    TestCoordChangeXCommand.fail((String)("Pausetime is not updated properly job_pause_time=" + d + ", expected_pause_time=" + pauseTime));
                }
            }
        }
        catch (JPAExecutorException e) {
            e.printStackTrace();
        }
    }

    static class FakeCallableQueueService
    extends CallableQueueService
    implements Service {
        FakeCallableQueueService() {
        }

        public void init(Services services) {
        }

        public void destroy() {
        }

        public synchronized boolean queueSerial(List<? extends XCallable<?>> callables, long delay) {
            return false;
        }
    }
}

