/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.coord.CoordCommandUtils;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestCoordCommandUtils
extends XDataTestCase {
    protected Services services;
    private String hcatServer;

    protected String getProcessingTZ() {
        return "UTC";
    }

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.processing.timezone", this.getProcessingTZ());
        this.services = super.setupServicesForHCatalog();
        this.services.init();
        this.hcatServer = this.getMetastoreAuthority();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testDryRunPushDependencies() {
        try {
            CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNING, false, true);
            Path appPath = new Path(this.getFsTestCaseDir(), "coord");
            String actionXml = this.getCoordActionXml(appPath, "coord-action-for-action-input-check.xml");
            CoordinatorActionBean actionBean = this.createCoordinatorActionBean((CoordinatorJob)job);
            String db = "default";
            String table = "tablename";
            String hcatDependency = this.getPushMissingDependencies(db, table);
            actionBean.setPushMissingDependencies(hcatDependency);
            Element eAction = this.createActionElement(actionXml);
            String newactionXml = CoordCommandUtils.dryRunCoord((Element)eAction, (CoordinatorActionBean)actionBean);
            eAction = XmlUtils.parseXml((String)newactionXml);
            Element configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
            List elementList = configElem.getChildren("property", configElem.getNamespace());
            Element e1 = (Element)elementList.get(0);
            Element e2 = (Element)elementList.get(1);
            TestCoordCommandUtils.assertEquals((String)"${coord:dataIn('A')}", (String)e1.getChild("value", e1.getNamespace()).getValue());
            TestCoordCommandUtils.assertEquals((String)"${coord:dataOut('LOCAL_A')}", (String)e2.getChild("value", e2.getNamespace()).getValue());
            this.populateTable(db, table);
            newactionXml = CoordCommandUtils.dryRunCoord((Element)eAction, (CoordinatorActionBean)actionBean);
            eAction = XmlUtils.parseXml((String)newactionXml);
            configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
            elementList = configElem.getChildren("property", configElem.getNamespace());
            e1 = (Element)elementList.get(0);
            e2 = (Element)elementList.get(1);
            TestCoordCommandUtils.assertEquals((String)"file://,testDir/2009/29,file://,testDir/2009/22,file://,testDir/2009/15,file://,testDir/2009/08", (String)e1.getChild("value", e1.getNamespace()).getValue());
            TestCoordCommandUtils.assertEquals((String)"file://,testDir/2009/29", (String)e2.getChild("value", e1.getNamespace()).getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordCommandUtils.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDryRunPullDeps() {
        try {
            CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-matd-hcat.xml", Job.Status.RUNNING, false, true);
            Path appPath = new Path(this.getFsTestCaseDir(), "coord");
            String actionXml = this.getCoordActionXml(appPath, "coord-action-for-action-input-check.xml");
            CoordinatorActionBean actionBean = this.createCoordinatorActionBean((CoordinatorJob)job);
            String testDir = this.getTestCaseDir();
            String missDeps = this.getPullMissingDependencies(testDir);
            actionBean.setMissingDependencies(missDeps);
            Element eAction = this.createActionElement(actionXml);
            String newactionXml = CoordCommandUtils.dryRunCoord((Element)eAction, (CoordinatorActionBean)actionBean);
            eAction = XmlUtils.parseXml((String)newactionXml);
            Element configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
            List elementList = configElem.getChildren("property", configElem.getNamespace());
            Element e1 = (Element)elementList.get(0);
            Element e2 = (Element)elementList.get(1);
            TestCoordCommandUtils.assertEquals((String)"${coord:dataIn('A')}", (String)e1.getChild("value", e1.getNamespace()).getValue());
            TestCoordCommandUtils.assertEquals((String)"${coord:dataOut('LOCAL_A')}", (String)e2.getChild("value", e2.getNamespace()).getValue());
            this.createDir(testDir + "/2009/29/");
            this.createDir(testDir + "/2009/22/");
            this.createDir(testDir + "/2009/15/");
            this.createDir(testDir + "/2009/08/");
            this.sleep(1000);
            newactionXml = CoordCommandUtils.dryRunCoord((Element)eAction, (CoordinatorActionBean)actionBean);
            eAction = XmlUtils.parseXml((String)newactionXml);
            configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
            elementList = configElem.getChildren("property", configElem.getNamespace());
            e1 = (Element)elementList.get(0);
            e2 = (Element)elementList.get(1);
            TestCoordCommandUtils.assertEquals((String)"file://,testDir/2009/29,file://,testDir/2009/22,file://,testDir/2009/15,file://,testDir/2009/08", (String)e1.getChild("value", e1.getNamespace()).getValue());
            TestCoordCommandUtils.assertEquals((String)"file://,testDir/2009/29", (String)e2.getChild("value", e1.getNamespace()).getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordCommandUtils.fail((String)e.getMessage());
        }
    }

    @Test
    public void testDryRunPullAndPushDeps() {
        try {
            CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-matd-hcat.xml", Job.Status.RUNNING, false, true);
            Path appPath = new Path(this.getFsTestCaseDir(), "coord");
            String actionXml = this.getCoordActionXml(appPath, "coord-action-for-action-input-check.xml");
            CoordinatorActionBean actionBean = this.createCoordinatorActionBean((CoordinatorJob)job);
            String testDir = this.getTestCaseDir();
            String missDeps = this.getPullMissingDependencies(testDir);
            actionBean.setMissingDependencies(missDeps);
            String db = "default";
            String table = "tablename";
            String hcatDependency = this.getPushMissingDependencies(db, table);
            actionBean.setPushMissingDependencies(hcatDependency);
            this.createDir(this.getTestCaseDir() + "/2009/29/");
            this.createDir(this.getTestCaseDir() + "/2009/22/");
            this.createDir(this.getTestCaseDir() + "/2009/15/");
            this.createDir(this.getTestCaseDir() + "/2009/08/");
            this.sleep(1000);
            Element eAction = this.createActionElement(actionXml);
            String newactionXml = CoordCommandUtils.dryRunCoord((Element)eAction, (CoordinatorActionBean)actionBean);
            eAction = XmlUtils.parseXml((String)newactionXml);
            Element configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
            List elementList = configElem.getChildren("property", configElem.getNamespace());
            Element e1 = (Element)elementList.get(0);
            Element e2 = (Element)elementList.get(1);
            TestCoordCommandUtils.assertEquals((String)"${coord:dataIn('A')}", (String)e1.getChild("value", e1.getNamespace()).getValue());
            TestCoordCommandUtils.assertEquals((String)"${coord:dataOut('LOCAL_A')}", (String)e2.getChild("value", e2.getNamespace()).getValue());
            this.populateTable(db, table);
            newactionXml = CoordCommandUtils.dryRunCoord((Element)eAction, (CoordinatorActionBean)actionBean);
            eAction = XmlUtils.parseXml((String)newactionXml);
            configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
            elementList = configElem.getChildren("property", configElem.getNamespace());
            e1 = (Element)elementList.get(0);
            e2 = (Element)elementList.get(1);
            TestCoordCommandUtils.assertEquals((String)"file://,testDir/2009/29,file://,testDir/2009/22,file://,testDir/2009/15,file://,testDir/2009/08", (String)e1.getChild("value", e1.getNamespace()).getValue());
            TestCoordCommandUtils.assertEquals((String)"file://,testDir/2009/29", (String)e2.getChild("value", e1.getNamespace()).getValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordCommandUtils.fail((String)e.getMessage());
        }
    }

    public void testGetNextValidActionTime() throws Exception {
        Date startTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:00Z");
        Date endTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T01:00Z");
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, "10,20 * * * *");
        Date actionTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:15Z");
        Date expectedDate = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:20Z");
        Date retDate = CoordCommandUtils.getNextValidActionTimeForCronFrequency((Date)actionTime, (CoordinatorJobBean)job);
        TestCoordCommandUtils.assertEquals((Object)expectedDate, (Object)retDate);
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, "10/20 * * 5-7 4,5");
        actionTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:15Z");
        expectedDate = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:30Z");
        retDate = CoordCommandUtils.getNextValidActionTimeForCronFrequency((Date)actionTime, (CoordinatorJobBean)job);
        TestCoordCommandUtils.assertEquals((Object)expectedDate, (Object)retDate);
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, "20-30 * 20 5-7 4,5");
        actionTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:20Z");
        expectedDate = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:21Z");
        retDate = CoordCommandUtils.getNextValidActionTimeForCronFrequency((Date)actionTime, (CoordinatorJobBean)job);
        TestCoordCommandUtils.assertEquals((Object)expectedDate, (Object)retDate);
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, "30 * 20 5-7 ?");
        actionTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:20Z");
        expectedDate = DateUtils.parseDateOozieTZ((String)"2013-07-20T00:30Z");
        retDate = CoordCommandUtils.getNextValidActionTimeForCronFrequency((Date)actionTime, (CoordinatorJobBean)job);
        TestCoordCommandUtils.assertEquals((Object)expectedDate, (Object)retDate);
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, "0 9-16 * * 2-6");
        actionTime = DateUtils.parseDateOozieTZ((String)"2013-07-20T00:20Z");
        expectedDate = DateUtils.parseDateOozieTZ((String)"2013-07-22T09:00Z");
        retDate = CoordCommandUtils.getNextValidActionTimeForCronFrequency((Date)actionTime, (CoordinatorJobBean)job);
        TestCoordCommandUtils.assertEquals((Object)expectedDate, (Object)retDate);
        retDate = CoordCommandUtils.getNextValidActionTimeForCronFrequency((Date)retDate, (CoordinatorJobBean)job);
        expectedDate = DateUtils.parseDateOozieTZ((String)"2013-07-22T10:00Z");
        TestCoordCommandUtils.assertEquals((Object)expectedDate, (Object)retDate);
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, "20-30 * * 1 *");
        actionTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:20Z");
        expectedDate = DateUtils.parseDateOozieTZ((String)"2014-01-01T00:20Z");
        retDate = CoordCommandUtils.getNextValidActionTimeForCronFrequency((Date)actionTime, (CoordinatorJobBean)job);
        TestCoordCommandUtils.assertEquals((Object)expectedDate, (Object)retDate);
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, startTime, endTime, "20-30 10 * * MON,WED");
        actionTime = DateUtils.parseDateOozieTZ((String)"2013-07-18T00:20Z");
        expectedDate = DateUtils.parseDateOozieTZ((String)"2013-07-22T10:20Z");
        retDate = CoordCommandUtils.getNextValidActionTimeForCronFrequency((Date)actionTime, (CoordinatorJobBean)job);
        TestCoordCommandUtils.assertEquals((Object)expectedDate, (Object)retDate);
    }

    @Test
    public void testCoordOffset() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-dataset-offset.xml", Job.Status.RUNNING, false, true);
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = this.getCoordActionXml(appPath, "coord-dataset-offset.xml");
        actionXml = actionXml.replace("-unit-", "DAY");
        actionXml = actionXml.replace("-frequency-", "1");
        CoordinatorActionBean actionBean = this.createCoordinatorActionBean((CoordinatorJob)job);
        XConfiguration jobConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        Element eAction = this.createActionElement(actionXml);
        jobConf.set("startInstance", "coord:offset(-4,DAY)");
        jobConf.set("endInstance", "coord:offset(0,DAY)");
        String output = CoordCommandUtils.materializeOneInstance((String)"jobId", (boolean)true, (Element)eAction, (Date)DateUtils.parseDateOozieTZ((String)"2009-08-20T10:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2009-08-20T10:00Z"), (int)1, (Configuration)jobConf, (CoordinatorActionBean)actionBean);
        eAction = XmlUtils.parseXml((String)output);
        Element e = (Element)((Element)eAction.getChildren("input-events", eAction.getNamespace()).get(0)).getChildren().get(0);
        TestCoordCommandUtils.assertEquals((String)e.getChild("uris", e.getNamespace()).getTextTrim(), (String)"hdfs:///tmp/workflows/2009/08/20/01;region=us#hdfs:///tmp/workflows/2009/08/19/01;region=us#hdfs:///tmp/workflows/2009/08/18/01;region=us#hdfs:///tmp/workflows/2009/08/17/01;region=us#hdfs:///tmp/workflows/2009/08/16/01;region=us");
        jobConf.set("startInstance", "coord:offset(-4,HOUR)");
        jobConf.set("endInstance", "coord:offset(0,HOUR)");
        actionXml = this.getCoordActionXml(appPath, "coord-dataset-offset.xml");
        actionXml = actionXml.replace("-unit-", "MINUTE");
        actionXml = actionXml.replace("-frequency-", "60");
        eAction = this.createActionElement(actionXml);
        output = CoordCommandUtils.materializeOneInstance((String)"jobId", (boolean)true, (Element)eAction, (Date)DateUtils.parseDateOozieTZ((String)"2009-08-20T01:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2009-08-20T01:00Z"), (int)1, (Configuration)jobConf, (CoordinatorActionBean)actionBean);
        eAction = XmlUtils.parseXml((String)output);
        e = (Element)((Element)eAction.getChildren("input-events", eAction.getNamespace()).get(0)).getChildren().get(0);
        TestCoordCommandUtils.assertEquals((String)e.getChild("uris", e.getNamespace()).getTextTrim(), (String)"hdfs:///tmp/workflows/2009/08/20/01;region=us#hdfs:///tmp/workflows/2009/08/20/00;region=us#hdfs:///tmp/workflows/2009/08/19/23;region=us#hdfs:///tmp/workflows/2009/08/19/22;region=us#hdfs:///tmp/workflows/2009/08/19/21;region=us");
    }

    @Test
    public void testCoordAbsolute() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-dataset-absolute.xml", Job.Status.RUNNING, false, true);
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = this.getCoordActionXml(appPath, "coord-dataset-absolute.xml");
        CoordinatorActionBean actionBean = this.createCoordinatorActionBean((CoordinatorJob)job);
        XConfiguration jobConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        Element eAction = this.createActionElement(actionXml);
        jobConf.set("startInstance", "coord:absolute(2009-08-20T01:00Z)");
        jobConf.set("endInstance", "coord:current(2)");
        String output = CoordCommandUtils.materializeOneInstance((String)"jobId", (boolean)true, (Element)eAction, (Date)DateUtils.parseDateOozieTZ((String)"2009-08-20T01:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2009-08-20T01:00Z"), (int)1, (Configuration)jobConf, (CoordinatorActionBean)actionBean);
        eAction = XmlUtils.parseXml((String)output);
        List elementList = ((Element)eAction.getChildren("input-events", eAction.getNamespace()).get(0)).getChildren();
        Element e1 = (Element)elementList.get(0);
        Element e2 = (Element)elementList.get(1);
        TestCoordCommandUtils.assertEquals((String)e1.getChild("uris", e1.getNamespace()).getTextTrim(), (String)"hdfs:///tmp/workflows/2009/09/03;region=us#hdfs:///tmp/workflows/2009/08/27;region=us#hdfs:///tmp/workflows/2009/08/20;region=us");
        TestCoordCommandUtils.assertEquals((String)e2.getChild("uris", e1.getNamespace()).getTextTrim(), (String)"hdfs:///tmp/workflows/2009/09/03;region=us#hdfs:///tmp/workflows/2009/08/27;region=us#hdfs:///tmp/workflows/2009/08/20;region=us");
        jobConf.set("startInstance", "coord:absolute(2009-08-20T01:00Z)");
        jobConf.set("endInstance", "coord:current(2)");
        eAction = this.createActionElement(actionXml);
        output = CoordCommandUtils.materializeOneInstance((String)"jobId", (boolean)true, (Element)eAction, (Date)DateUtils.parseDateOozieTZ((String)"2009-09-10T01:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2009-09-08T01:00Z"), (int)1, (Configuration)jobConf, (CoordinatorActionBean)actionBean);
        eAction = XmlUtils.parseXml((String)output);
        elementList = ((Element)eAction.getChildren("input-events", eAction.getNamespace()).get(0)).getChildren();
        e1 = (Element)elementList.get(1);
        TestCoordCommandUtils.assertEquals((String)e1.getChild("uris", e1.getNamespace()).getTextTrim(), (String)"hdfs:///tmp/workflows/2009/09/24;region=us#hdfs:///tmp/workflows/2009/09/17;region=us#hdfs:///tmp/workflows/2009/09/10;region=us#hdfs:///tmp/workflows/2009/09/03;region=us#hdfs:///tmp/workflows/2009/08/27;region=us#hdfs:///tmp/workflows/2009/08/20;region=us");
        jobConf.set("startInstance", "coord:absolute(2009-08-20T01:00Z)");
        jobConf.set("endInstance", "coord:current(2)");
        eAction = this.createActionElement(actionXml);
        output = CoordCommandUtils.materializeOneInstance((String)"jobId", (boolean)true, (Element)eAction, (Date)DateUtils.parseDateOozieTZ((String)"2009-08-14T01:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2009-08-14T01:00Z"), (int)1, (Configuration)jobConf, (CoordinatorActionBean)actionBean);
        eAction = XmlUtils.parseXml((String)output);
        elementList = ((Element)eAction.getChildren("input-events", eAction.getNamespace()).get(0)).getChildren();
        e1 = (Element)elementList.get(1);
        TestCoordCommandUtils.assertEquals((String)e1.getChild("uris", e1.getNamespace()).getTextTrim(), (String)"hdfs:///tmp/workflows/2009/08/27;region=us#hdfs:///tmp/workflows/2009/08/20;region=us");
        try {
            jobConf.set("startInstance", "coord:absolute(2009-08-27T01:00Z)");
            jobConf.set("endInstance", "coord:current(2)");
            eAction = this.createActionElement(actionXml);
            output = CoordCommandUtils.materializeOneInstance((String)"jobId", (boolean)true, (Element)eAction, (Date)DateUtils.parseDateOozieTZ((String)"2009-08-06T01:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2009-08-16T01:00Z"), (int)1, (Configuration)jobConf, (CoordinatorActionBean)actionBean);
            eAction = XmlUtils.parseXml((String)output);
            TestCoordCommandUtils.fail((String)"Should throw exception. Start-instance > end-instance ");
        }
        catch (Exception e) {
            TestCoordCommandUtils.assertTrue((boolean)e.getCause().getMessage().contains("start-instance should be equal or earlier than the end-instance"));
        }
        try {
            jobConf.set("startInstance", "coord:absolute(2009-07-01T01:00Z)");
            jobConf.set("endInstance", "coord:current(2)");
            eAction = this.createActionElement(actionXml);
            output = CoordCommandUtils.materializeOneInstance((String)"jobId", (boolean)true, (Element)eAction, (Date)DateUtils.parseDateOozieTZ((String)"2009-08-06T01:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2009-08-16T01:00Z"), (int)1, (Configuration)jobConf, (CoordinatorActionBean)actionBean);
            eAction = XmlUtils.parseXml((String)output);
            TestCoordCommandUtils.fail((String)"Should throw exception. Start-instance > end-instance ");
        }
        catch (Exception e) {
            TestCoordCommandUtils.assertTrue((boolean)e.getCause().getMessage().contains("intial-instance should be equal or earlier than the start-instance"));
        }
        try {
            jobConf.set("startInstance", "coord:absolute(2009-08-20T01:00Z)");
            jobConf.set("endInstance", "coord:latest(2)");
            eAction = this.createActionElement(actionXml);
            output = CoordCommandUtils.materializeOneInstance((String)"jobId", (boolean)true, (Element)eAction, (Date)DateUtils.parseDateOozieTZ((String)"2009-08-20T01:00Z"), (Date)DateUtils.parseDateOozieTZ((String)"2009-08-20T01:00Z"), (int)1, (Configuration)jobConf, (CoordinatorActionBean)actionBean);
            eAction = XmlUtils.parseXml((String)output);
            TestCoordCommandUtils.fail((String)"Should throw exception. Start-instance is absolute and end-instance is latest");
        }
        catch (Exception e) {
            TestCoordCommandUtils.assertTrue((boolean)e.getMessage().contains("Only start-instance as absolute and end-instance as current is supported"));
        }
    }

    @Test
    public void testComputeNextNominalTime() throws Exception {
        CoordinatorJobBean job = new CoordinatorJobBean();
        CoordinatorActionBean action = new CoordinatorActionBean();
        job.setFrequency("10 * * * *");
        job.setTimeUnit(CoordinatorJob.Timeunit.CRON);
        job.setTimeZone("America/Los_Angeles");
        job.setStartTime(DateUtils.parseDateOozieTZ((String)"2015-07-21T08:00Z"));
        job.setEndTime(DateUtils.parseDateOozieTZ((String)"2015-07-21T13:50Z"));
        job.setJobXml("<coordinator-app name=\"test\" end_of_duration='NONE'></coordinator-app>");
        action.setNominalTime(DateUtils.parseDateOozieTZ((String)"2015-07-21T12:10Z"));
        action.setActionNumber(5);
        TestCoordCommandUtils.assertEquals((Object)DateUtils.parseDateOozieTZ((String)"2015-07-21T13:10Z"), (Object)CoordCommandUtils.computeNextNominalTime((CoordinatorJobBean)job, (CoordinatorActionBean)action));
        job.setEndTime(DateUtils.parseDateOozieTZ((String)"2015-07-21T13:00Z"));
        TestCoordCommandUtils.assertNull((Object)CoordCommandUtils.computeNextNominalTime((CoordinatorJobBean)job, (CoordinatorActionBean)action));
        job = new CoordinatorJobBean();
        action = new CoordinatorActionBean();
        job.setFrequency("10");
        job.setTimeUnit(CoordinatorJob.Timeunit.HOUR);
        job.setTimeZone("America/Los_Angeles");
        job.setStartTime(DateUtils.parseDateOozieTZ((String)"2015-07-21T14:00Z"));
        job.setEndTime(DateUtils.parseDateOozieTZ((String)"2015-07-25T23:00Z"));
        job.setJobXml("<coordinator-app name=\"test\" end_of_duration='NONE'></coordinator-app>");
        action.setNominalTime(DateUtils.parseDateOozieTZ((String)"2015-07-23T06:00Z"));
        action.setActionNumber(5);
        TestCoordCommandUtils.assertEquals((Object)DateUtils.parseDateOozieTZ((String)"2015-07-23T16:00Z"), (Object)CoordCommandUtils.computeNextNominalTime((CoordinatorJobBean)job, (CoordinatorActionBean)action));
        job.setEndTime(DateUtils.parseDateOozieTZ((String)"2015-07-23T09:00Z"));
        TestCoordCommandUtils.assertNull((Object)CoordCommandUtils.computeNextNominalTime((CoordinatorJobBean)job, (CoordinatorActionBean)action));
        job = new CoordinatorJobBean();
        action = new CoordinatorActionBean();
        job.setFrequency("10");
        job.setTimeUnit(CoordinatorJob.Timeunit.END_OF_DAY);
        job.setTimeZone("America/Los_Angeles");
        job.setStartTime(DateUtils.parseDateOozieTZ((String)"2015-07-21T14:00Z"));
        job.setEndTime(DateUtils.parseDateOozieTZ((String)"2015-09-21T23:00Z"));
        job.setJobXml("<coordinator-app name=\"test\" end_of_duration='END_OF_DAY'></coordinator-app>");
        action.setNominalTime(DateUtils.parseDateOozieTZ((String)"2015-08-31T07:00Z"));
        action.setActionNumber(5);
        TestCoordCommandUtils.assertEquals((Object)DateUtils.parseDateOozieTZ((String)"2015-09-10T07:00Z"), (Object)CoordCommandUtils.computeNextNominalTime((CoordinatorJobBean)job, (CoordinatorActionBean)action));
        job.setEndTime(DateUtils.parseDateOozieTZ((String)"2015-09-08T23:00Z"));
        TestCoordCommandUtils.assertNull((Object)CoordCommandUtils.computeNextNominalTime((CoordinatorJobBean)job, (CoordinatorActionBean)action));
    }

    protected CoordinatorJobBean addRecordToCoordJobTable(Job.Status status, Date startTime, Date endTime, String freq) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, startTime, endTime, false, false, 0);
        coordJob.setStartTime(startTime);
        coordJob.setEndTime(endTime);
        coordJob.setFrequency(freq);
        coordJob.setTimeUnit(CoordinatorJob.Timeunit.MINUTE);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordCommandUtils.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException ex) {
            ex.printStackTrace();
            TestCoordCommandUtils.fail((String)"Unable to insert the test coord job record to table");
            throw ex;
        }
        return coordJob;
    }

    private String getPullMissingDependencies(String testDir) {
        String missDeps = this.getTestCaseFileUri("2009/29/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/22/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/15/_SUCCESS") + "#" + this.getTestCaseFileUri("2009/08/_SUCCESS") + "#";
        missDeps = missDeps.replaceAll("#testDir", testDir);
        return missDeps;
    }

    private String getPushMissingDependencies(String db, String table) throws Exception {
        String newHCatDependency1 = "hcat://" + this.hcatServer + "/" + db + "/" + table + "/dt=20120412;country=brazil";
        String newHCatDependency2 = "hcat://" + this.hcatServer + "/" + db + "/" + table + "/dt=20120430;country=usa";
        String newHCatDependency = newHCatDependency1 + "#" + newHCatDependency2;
        this.dropTable(db, table, true);
        this.dropDatabase(db, true);
        this.createDatabase(db);
        this.createTable(db, table, "dt,country");
        return newHCatDependency;
    }

    private Element createActionElement(String actionXml) throws JDOMException, ParseException {
        Element eAction = XmlUtils.parseXml((String)actionXml);
        eAction.removeAttribute("start");
        eAction.removeAttribute("end");
        eAction.setAttribute("instance-number", Integer.toString(1));
        eAction.setAttribute("action-nominal-time", DateUtils.formatDateOozieTZ((Date)DateUtils.parseDateOozieTZ((String)"2009-09-08T01:00Z")));
        eAction.setAttribute("action-actual-time", DateUtils.formatDateOozieTZ((Date)new Date()));
        return eAction;
    }

    private CoordinatorActionBean createCoordinatorActionBean(CoordinatorJob job) throws IOException {
        CoordinatorActionBean actionBean = new CoordinatorActionBean();
        String actionId = ((UUIDService)Services.get().get(UUIDService.class)).generateChildId(job.getId(), "1");
        actionBean.setJobId(job.getId());
        actionBean.setId(actionId);
        XConfiguration jobConf = new XConfiguration((Reader)new StringReader(job.getConf()));
        actionBean.setRunConf(XmlUtils.prettyPrint((Configuration)jobConf).toString());
        return actionBean;
    }

    private void createDir(String dir) {
        try {
            Process pr = Runtime.getRuntime().exec("mkdir -p " + dir + "/_SUCCESS");
            pr.waitFor();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void populateTable(String db, String table) throws Exception {
        this.addPartition(db, table, "dt=20120430;country=usa");
        this.addPartition(db, table, "dt=20120412;country=brazil");
        this.addPartition(db, table, "dt=20120413;country=brazil");
    }
}

