/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.File;
import java.util.Date;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;

public class TestCoordELExtensions
extends XDataTestCase {
    private Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        this.setSystemProperty("oozie.test.config.file", new File(OOZIE_SRC_DIR, "core/src/test/resources/oozie-site-coordel.xml").getAbsolutePath());
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordELActionMater() throws Exception {
        Date startTime = DateUtils.parseDateUTC((String)"2009-03-06T010:00Z");
        Date endTime = DateUtils.parseDateUTC((String)"2009-03-07T12:00Z");
        CoordinatorJobBean job = this.createCoordJob("coord-job-for-elext.xml", Job.Status.RUNNING, startTime, endTime, false, false, 0);
        this.addRecordToCoordJobTable(job);
        new CoordMaterializeTransitionXCommand(job.getId(), 3600).call();
        this.checkCoordAction(job.getId() + "@1");
    }

    protected CoordinatorActionBean checkCoordAction(String actionId) throws StoreException {
        try {
            CoordinatorActionBean action = this.getCoordinatorAction(actionId);
            TestCoordELExtensions.assertEquals((String)"file://#testDir/2009/03/06/00/_SUCCESS#file://#testDir/2009/03/05/23/_SUCCESS", (String)action.getMissingDependencies());
            return action;
        }
        catch (Exception se) {
            se.printStackTrace();
            TestCoordELExtensions.fail((String)("Action ID " + actionId + " was not stored properly in db"));
            return null;
        }
    }
}

