/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.coord.CoordActionInputCheckXCommand;
import org.apache.oozie.command.coord.CoordPushDependencyCheckXCommand;
import org.apache.oozie.dependency.DependencyChecker;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestCoordPushDependencyCheckXCommand
extends XDataTestCase {
    private String server;
    private Services services = null;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = super.setupServicesForHCatalog();
        this.services.init();
        this.server = this.getMetastoreAuthority();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    @Test
    public void testUpdateCoordTableSingleDep() throws Exception {
        String db = "default";
        String table = "tablename";
        String newHCatDependency = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=usa";
        this.populateTable(db, table);
        String actionId = this.addInitRecords(newHCatDependency);
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        new CoordPushDependencyCheckXCommand(actionId).call();
        this.checkCoordAction(actionId, "", CoordinatorAction.Status.READY);
    }

    @Test
    public void testUpdateCoordTableMultipleDepsV1() throws Exception {
        String db = "default";
        String table = "tablename";
        String newHCatDependency1 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120412;country=brazil";
        String newHCatDependency2 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=usa";
        String newHCatDependency = newHCatDependency1 + "#" + newHCatDependency2;
        this.populateTable(db, table);
        String actionId = this.addInitRecords(newHCatDependency);
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        new CoordPushDependencyCheckXCommand(actionId).call();
        this.checkCoordAction(actionId, "", CoordinatorAction.Status.READY);
    }

    @Test
    public void testUpdateCoordTableMultipleDepsV2() throws Exception {
        String db = "default";
        String table = "tablename";
        String newHCatDependency1 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=brazil";
        String newHCatDependency2 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=usa";
        String newHCatDependency = newHCatDependency1 + "#" + newHCatDependency2;
        this.populateTable(db, table);
        String actionId = this.addInitRecords(newHCatDependency);
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        new CoordPushDependencyCheckXCommand(actionId).call();
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        this.dropPartition(db, table, "dt=20120430;country=usa");
        this.addPartition(db, table, "dt=20120430;country=brazil");
        new CoordPushDependencyCheckXCommand(actionId).call();
        this.checkCoordAction(actionId, newHCatDependency2, CoordinatorAction.Status.WAITING);
        this.addPartition(db, table, "dt=20120430;country=usa");
        new CoordPushDependencyCheckXCommand(actionId).call();
        this.checkCoordAction(actionId, "", CoordinatorAction.Status.READY);
    }

    @Test
    public void testUpdateCoordTableMultipleDepsV3() throws Exception {
        String db = "default";
        String table = "tablename";
        String newHCatDependency1 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=brazil";
        String newHCatDependency2 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=usa";
        String newHCatDependency = newHCatDependency1 + "#" + newHCatDependency2;
        this.populateTable(db, table);
        String actionId = this.addInitRecords(newHCatDependency);
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        new CoordPushDependencyCheckXCommand(actionId, true).call();
        this.checkCoordAction(actionId, newHCatDependency1, CoordinatorAction.Status.WAITING);
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)pdms.getWaitingActions(new HCatURI(newHCatDependency1)).contains(actionId));
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)hcatService.isRegisteredForNotification(new HCatURI(newHCatDependency1)));
        TestCoordPushDependencyCheckXCommand.assertNull((Object)pdms.getWaitingActions(new HCatURI(newHCatDependency2)));
        this.addPartition(db, table, "dt=20120430;country=brazil");
        new CoordPushDependencyCheckXCommand(actionId).call();
        this.checkCoordAction(actionId, "", CoordinatorAction.Status.READY);
        TestCoordPushDependencyCheckXCommand.assertNull((Object)pdms.getWaitingActions(new HCatURI(newHCatDependency1)));
        TestCoordPushDependencyCheckXCommand.assertFalse((boolean)hcatService.isRegisteredForNotification(new HCatURI(newHCatDependency1)));
    }

    @Test
    public void testResolveCoordConfiguration() throws Exception {
        String db = "default";
        String table = "tablename";
        String newHCatDependency1 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120412;country=brazil";
        String newHCatDependency2 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=usa";
        String newHCatDependency = newHCatDependency1 + "#" + newHCatDependency2;
        this.populateTable(db, table);
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNING, false, true);
        CoordinatorActionBean action = this.addRecordToCoordActionTableForWaiting(job.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-for-action-push-check.xml", null, newHCatDependency, "Z");
        String actionId = action.getId();
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        new CoordPushDependencyCheckXCommand(actionId).call();
        CoordinatorActionBean caBean = this.checkCoordAction(actionId, "", CoordinatorAction.Status.READY);
        Element eAction = XmlUtils.parseXml((String)caBean.getActionXml());
        Element configElem = eAction.getChild("action", eAction.getNamespace()).getChild("workflow", eAction.getNamespace()).getChild("configuration", eAction.getNamespace());
        List elementList = configElem.getChildren("property", configElem.getNamespace());
        Element e1 = (Element)elementList.get(0);
        Element e2 = (Element)elementList.get(1);
        TestCoordPushDependencyCheckXCommand.assertEquals((String)"hcat://dummyhcat:1000/db1/table1/ds=/2009-29,hcat://dummyhcat:1000/db1/table1/ds=/2009-29,hcat://dummyhcat:1000/db1/table1/ds=/2009-29", (String)e1.getChild("value", e1.getNamespace()).getValue());
        TestCoordPushDependencyCheckXCommand.assertEquals((String)"hcat://dummyhcat:1000/db1/table1/ds=/2009-29", (String)e2.getChild("value", e1.getNamespace()).getValue());
    }

    @Test
    public void testTimeOut() throws Exception {
        String db = "default";
        String table = "tablename";
        String newHCatDependency1 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=brazil";
        String newHCatDependency2 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=usa";
        String newHCatDependency = newHCatDependency1 + "#" + newHCatDependency2;
        this.populateTable(db, table);
        String actionId = this.addInitRecords(newHCatDependency);
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        new CoordPushDependencyCheckXCommand(actionId, true).call();
        this.checkCoordAction(actionId, newHCatDependency1, CoordinatorAction.Status.WAITING);
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)pdms.getWaitingActions(new HCatURI(newHCatDependency1)).contains(actionId));
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)hcatService.isRegisteredForNotification(new HCatURI(newHCatDependency1)));
        long timeOutCreationTime = System.currentTimeMillis() - 720000L;
        this.setCoordActionCreationTime(actionId, timeOutCreationTime);
        new CoordPushDependencyCheckXCommand(actionId).call();
        Thread.sleep(100L);
        this.checkCoordAction(actionId, newHCatDependency1, CoordinatorAction.Status.TIMEDOUT);
        TestCoordPushDependencyCheckXCommand.assertNull((Object)pdms.getWaitingActions(new HCatURI(newHCatDependency1)));
        TestCoordPushDependencyCheckXCommand.assertFalse((boolean)hcatService.isRegisteredForNotification(new HCatURI(newHCatDependency1)));
    }

    @Test
    public void testTimeOutWithUnresolvedMissingDependencies() throws Exception {
        String db = "default";
        String table = "tablename";
        String newHCatDependency1 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=brazil";
        String newHCatDependency2 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=usa";
        String newHCatDependency3 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=uk";
        String newHCatDependency = newHCatDependency1 + "#" + newHCatDependency2;
        this.populateTable(db, table);
        String actionId = this.addInitRecords(newHCatDependency);
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        new CoordPushDependencyCheckXCommand(actionId, true).call();
        this.checkCoordAction(actionId, newHCatDependency1, CoordinatorAction.Status.WAITING);
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)pdms.getWaitingActions(new HCatURI(newHCatDependency1)).contains(actionId));
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)hcatService.isRegisteredForNotification(new HCatURI(newHCatDependency1)));
        long timeOutCreationTime = System.currentTimeMillis() - 720000L;
        this.setCoordActionCreationTime(actionId, timeOutCreationTime);
        this.setMissingDependencies(actionId, newHCatDependency + "#" + newHCatDependency3);
        this.addPartition(db, table, "dt=20120430;country=brazil");
        this.checkDependencies(actionId, newHCatDependency + "#" + newHCatDependency3, newHCatDependency1);
        new CoordPushDependencyCheckXCommand(actionId).call();
        Thread.sleep(1300L);
        this.checkDependencies(actionId, newHCatDependency3, "");
        TestCoordPushDependencyCheckXCommand.assertNull((Object)pdms.getWaitingActions(new HCatURI(newHCatDependency1)));
        TestCoordPushDependencyCheckXCommand.assertFalse((boolean)hcatService.isRegisteredForNotification(new HCatURI(newHCatDependency1)));
    }

    @Test
    public void testTimeOutWithException1() throws Exception {
        String newHCatDependency1 = "hcat://" + this.server + "/nodb/notable/dt=20120430;country=brazil";
        String newHCatDependency2 = "hcat://" + this.server + "/nodb/notable/dt=20120430;country=usa";
        String newHCatDependency = newHCatDependency1 + "#" + newHCatDependency2;
        String actionId = this.addInitRecords(newHCatDependency);
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        try {
            new CoordPushDependencyCheckXCommand(actionId, true).call();
            TestCoordPushDependencyCheckXCommand.fail();
        }
        catch (Exception e) {
            TestCoordPushDependencyCheckXCommand.assertTrue((boolean)e.getMessage().contains("NoSuchObjectException"));
        }
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        TestCoordPushDependencyCheckXCommand.assertNull((Object)pdms.getWaitingActions(new HCatURI(newHCatDependency1)));
        TestCoordPushDependencyCheckXCommand.assertFalse((boolean)hcatService.isRegisteredForNotification(new HCatURI(newHCatDependency1)));
        long timeOutCreationTime = System.currentTimeMillis() - 720000L;
        this.setCoordActionCreationTime(actionId, timeOutCreationTime);
        try {
            new CoordPushDependencyCheckXCommand(actionId).call();
            TestCoordPushDependencyCheckXCommand.fail();
        }
        catch (Exception e) {
            TestCoordPushDependencyCheckXCommand.assertTrue((boolean)e.getMessage().contains("NoSuchObjectException"));
        }
        Thread.sleep(100L);
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.TIMEDOUT);
    }

    @Test
    public void testTimeOutWithException2() throws Exception {
        String db = "default";
        String table = "tablename";
        String newHCatDependency1 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=brazil";
        String newHCatDependency2 = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=usa";
        String newHCatDependency = newHCatDependency1 + "#" + newHCatDependency2;
        this.populateTable(db, table);
        String actionId = this.addInitRecords(newHCatDependency);
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        new CoordPushDependencyCheckXCommand(actionId, true).call();
        this.checkCoordAction(actionId, newHCatDependency1, CoordinatorAction.Status.WAITING);
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)pdms.getWaitingActions(new HCatURI(newHCatDependency1)).contains(actionId));
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)hcatService.isRegisteredForNotification(new HCatURI(newHCatDependency1)));
        long timeOutCreationTime = System.currentTimeMillis() - 720000L;
        this.setCoordActionCreationTime(actionId, timeOutCreationTime);
        this.dropTable(db, table, true);
        try {
            new CoordPushDependencyCheckXCommand(actionId).call();
            TestCoordPushDependencyCheckXCommand.fail();
        }
        catch (Exception e) {
            TestCoordPushDependencyCheckXCommand.assertTrue((boolean)e.getMessage().contains("NoSuchObjectException"));
        }
        Thread.sleep(100L);
        this.checkCoordAction(actionId, newHCatDependency1, CoordinatorAction.Status.TIMEDOUT);
        TestCoordPushDependencyCheckXCommand.assertNull((Object)pdms.getWaitingActions(new HCatURI(newHCatDependency1)));
        TestCoordPushDependencyCheckXCommand.assertFalse((boolean)hcatService.isRegisteredForNotification(new HCatURI(newHCatDependency1)));
    }

    @Test
    public void testRequeueOnException() throws Exception {
        Services.get().getConf().setInt("oozie.service.RecoveryService.interval", 6000);
        String newHCatDependency1 = "hcat://" + this.server + "/nodb/notable/dt=20120430;country=brazil";
        String newHCatDependency2 = "hcat://" + this.server + "/nodb/notable/dt=20120430;country=usa";
        String newHCatDependency = newHCatDependency1 + "#" + newHCatDependency2;
        CoordinatorJobBean job = this.addRecordToCoordJobTableForWaiting("coord-job-for-action-input-check.xml", Job.Status.RUNNING, false, true);
        CoordinatorActionBean action = this.addRecordToCoordActionTableForWaiting(job.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-for-action-input-check.xml", null, newHCatDependency, "Z");
        String actionId = action.getId();
        this.checkCoordAction(actionId, newHCatDependency, CoordinatorAction.Status.WAITING);
        try {
            new CoordPushDependencyCheckXCommand(actionId, true).call();
            TestCoordPushDependencyCheckXCommand.fail();
        }
        catch (Exception e) {
            TestCoordPushDependencyCheckXCommand.assertTrue((boolean)e.getMessage().contains("NoSuchObjectException"));
        }
        CallableQueueService callableQueueService = (CallableQueueService)Services.get().get(CallableQueueService.class);
        TestCoordPushDependencyCheckXCommand.assertEquals((int)0, (int)callableQueueService.getQueueDump().size());
        new CoordActionInputCheckXCommand(actionId, job.getId()).call();
        callableQueueService = (CallableQueueService)Services.get().get(CallableQueueService.class);
        TestCoordPushDependencyCheckXCommand.assertEquals((int)0, (int)callableQueueService.getQueueDump().size());
        this.setMissingDependencies(actionId, newHCatDependency1);
        try {
            new CoordPushDependencyCheckXCommand(actionId, true).call();
            TestCoordPushDependencyCheckXCommand.fail();
        }
        catch (Exception e) {
            TestCoordPushDependencyCheckXCommand.assertTrue((boolean)e.getMessage().contains("NoSuchObjectException"));
        }
        List queueDump = callableQueueService.getQueueDump();
        TestCoordPushDependencyCheckXCommand.assertEquals((int)1, (int)callableQueueService.getQueueDump().size());
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)((String)queueDump.get(0)).contains("coord_push_dep_check"));
        this.log.info((Object)("Queue dump is " + queueDump.toString()));
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)((String)queueDump.get(0)).matches(".* delay=(599[0-9]{3}|600000)"));
    }

    @Test
    public void testLogMessagePrefix() throws Exception {
        Logger logger = Logger.getLogger(DependencyChecker.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SimpleLayout layout = new SimpleLayout();
        WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)out);
        logger.addAppender((Appender)appender);
        String db = "default";
        String table = "tablename";
        this.populateTable(db, table);
        String newHCatDependency = "hcat://" + this.server + "/" + db + "/" + table + "/dt=20120430;country=brazil";
        String actionId1 = this.addInitRecords(newHCatDependency);
        new CoordPushDependencyCheckXCommand(actionId1).call();
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)out.toString().contains("ACTION[" + actionId1 + "]"));
        out.reset();
        String actionId2 = this.addInitRecords(newHCatDependency);
        new CoordPushDependencyCheckXCommand(actionId2).call();
        TestCoordPushDependencyCheckXCommand.assertFalse((boolean)out.toString().contains("ACTION[" + actionId1 + "]"));
        TestCoordPushDependencyCheckXCommand.assertTrue((boolean)out.toString().contains("ACTION[" + actionId2 + "]"));
    }

    private void populateTable(String db, String table) throws Exception {
        this.dropTable(db, table, true);
        this.dropDatabase(db, true);
        this.createDatabase(db);
        this.createTable(db, table, "dt,country");
        this.addPartition(db, table, "dt=20120430;country=usa");
        this.addPartition(db, table, "dt=20120412;country=brazil");
        this.addPartition(db, table, "dt=20120413;country=brazil");
    }

    private CoordinatorActionBean checkCoordAction(String actionId, String expDeps, CoordinatorAction.Status stat) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
            String missDeps = action.getPushMissingDependencies();
            TestCoordPushDependencyCheckXCommand.assertEquals((String)expDeps, (String)missDeps);
            TestCoordPushDependencyCheckXCommand.assertEquals((Object)stat, (Object)action.getStatus());
            return action;
        }
        catch (JPAExecutorException se) {
            throw new Exception("Action ID " + actionId + " was not stored properly in db");
        }
    }

    private CoordinatorActionBean checkDependencies(String actionId, String expDeps, String expPushDeps) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
            TestCoordPushDependencyCheckXCommand.assertEquals((String)expDeps, (String)action.getMissingDependencies());
            TestCoordPushDependencyCheckXCommand.assertEquals((String)expPushDeps, (String)action.getPushMissingDependencies());
            return action;
        }
        catch (JPAExecutorException se) {
            throw new Exception("Action ID " + actionId + " was not stored properly in db");
        }
    }
}

