/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.net.URI;
import java.util.Date;
import java.util.Properties;
import java.util.regex.Matcher;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.action.oozie.JavaSleepAction;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.CoordinatorJob;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordActionStartXCommand;
import org.apache.oozie.command.coord.CoordRerunXCommand;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.executor.jpa.CoordActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;

public class TestCoordRerunXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordRerunActions1() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum = true;
        String actionId = jobId + "@" + 1;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        CoordinatorActionBean action1 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertEquals((Object)action1.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "action", Integer.toString(1), false, true);
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        TestCoordRerunXCommand.assertNull((Object)action2.getExternalId());
    }

    public void testCoordRerunActions2() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum1 = true;
        int actionNum2 = 2;
        String actionId1 = jobId + "@" + 1;
        String actionId2 = jobId + "@" + 2;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId1, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
            this.addRecordToActionTable(jobId, 2, actionId2, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action2.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        String rerunScope = Integer.toString(1) + "-" + Integer.toString(2);
        OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "action", rerunScope, false, true);
        CoordinatorActionBean action1 = this.getCoordinatorAction(actionId1);
        TestCoordRerunXCommand.assertNotSame((Object)action1.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId2);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
    }

    public void testCoordRerunActions3() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum1 = true;
        int actionNum2 = 2;
        String actionId1 = jobId + "@" + 1;
        String actionId2 = jobId + "@" + 2;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId1, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
            this.addRecordToActionTable(jobId, 2, actionId2, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action2.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        String rerunScope = Integer.toString(1) + "," + Integer.toString(2);
        OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "action", rerunScope, false, true);
        CoordinatorActionBean action1 = this.getCoordinatorAction(actionId1);
        TestCoordRerunXCommand.assertNotSame((Object)action1.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId2);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
    }

    public void testCoordRerunActionsNeg1() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum1 = true;
        int actionNum2 = 2;
        String actionId1 = jobId + "@" + 1;
        String actionId2 = jobId + "@" + 2;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId1, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
            this.addRecordToActionTable(jobId, 2, actionId2, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action2.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        String rerunScope = "1-3";
        try {
            OozieClient coordClient = LocalOozie.getCoordClient();
            coordClient.reRunCoord(jobId, "action", rerunScope, false, true);
        }
        catch (OozieClientException oozieClientException) {
            // empty catch block
        }
    }

    public void testCoordRerunActionsNeg2() throws Exception {
        String actionId;
        block4: {
            String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
            boolean actionNum = true;
            actionId = jobId + "@" + 1;
            try {
                this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
                this.addRecordToActionTable(jobId, 1, actionId, CoordinatorAction.Status.RUNNING, "coord-rerun-action1.xml");
            }
            catch (Exception e) {
                e.printStackTrace();
                TestCoordRerunXCommand.fail((String)"Could not update db.");
            }
            try {
                OozieClient coordClient = LocalOozie.getCoordClient();
                coordClient.reRunCoord(jobId, "action", Integer.toString(1), false, true);
                TestCoordRerunXCommand.fail((String)"Exception expected because action is not in terminal state.");
            }
            catch (OozieClientException ex) {
                if (ex.getErrorCode().equals(ErrorCode.E1018.toString())) break block4;
                TestCoordRerunXCommand.fail((String)"Error code should be E1018 when action is not in terminal state.");
            }
        }
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertEquals((Object)action2.getStatus(), (Object)CoordinatorAction.Status.RUNNING);
    }

    public void testCoordRerunDate1() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum = true;
        String actionId = jobId + "@" + 1;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        CoordinatorActionBean action1 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertEquals((Object)action1.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "date", "2009-12-15T01:00Z", false, true);
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
    }

    public void testCoordRerunDate2() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum1 = true;
        int actionNum2 = 2;
        String actionId1 = jobId + "@" + 1;
        String actionId2 = jobId + "@" + 2;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId1, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
            this.addRecordToActionTable(jobId, 2, actionId2, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action2.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        String rerunScope = "2009-12-15T01:00Z::2009-12-16T01:00Z";
        OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "date", rerunScope, false, true);
        CoordinatorActionBean action1 = this.getCoordinatorAction(actionId1);
        TestCoordRerunXCommand.assertNotSame((Object)action1.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId2);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
    }

    public void testCoordRerunDate3() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum1 = true;
        int actionNum2 = 2;
        String actionId1 = jobId + "@" + 1;
        String actionId2 = jobId + "@" + 2;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId1, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
            this.addRecordToActionTable(jobId, 2, actionId2, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action2.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        String rerunScope = "2009-12-15T01:00Z,2009-12-16T01:00Z";
        OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "date", rerunScope, false, true);
        CoordinatorActionBean action1 = this.getCoordinatorAction(actionId1);
        TestCoordRerunXCommand.assertNotSame((Object)action1.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId2);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
    }

    public void testCoordRerunDate4() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum1 = true;
        int actionNum2 = 2;
        String actionId1 = jobId + "@" + 1;
        String actionId2 = jobId + "@" + 2;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId1, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
            this.addRecordToActionTable(jobId, 2, actionId2, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action2.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        String rerunScope = "2009-12-15T01:00Z::2009-12-17T01:00Z";
        OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "date", rerunScope, false, true);
        CoordinatorActionBean action1 = this.getCoordinatorAction(actionId1);
        TestCoordRerunXCommand.assertNotSame((Object)action1.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId2);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
    }

    public void testCoordRerunDateNeg() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum1 = true;
        int actionNum2 = 2;
        String actionId1 = jobId + "@" + 1;
        String actionId2 = jobId + "@" + 2;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId1, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
            this.addRecordToActionTable(jobId, 2, actionId2, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action2.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        String rerunScope = "2009-12-15T01:00Z,2009-12-16T01:00Z,2009-12-17T01:00Z";
        try {
            OozieClient coordClient = LocalOozie.getCoordClient();
            coordClient.reRunCoord(jobId, "date", rerunScope, false, true);
            TestCoordRerunXCommand.fail((String)"Exception expected because one action is missing from db.");
        }
        catch (OozieClientException ex) {
            TestCoordRerunXCommand.assertTrue((ex.getErrorCode() == ErrorCode.E0605.toString() ? 1 : 0) != 0);
        }
    }

    public void testCoordRerunRefresh() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum = true;
        final String actionId = jobId + "@" + 1;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String inputDir = appPath.toString() + "/coord-input/2010/07/09/01/00";
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path(inputDir));
        fs.create(new Path(inputDir, "_SUCCESS"), true);
        final OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "action", Integer.toString(1), true, true);
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorAction bean = coordClient.getCoordActionInfo(actionId);
                return bean.getStatus() == CoordinatorAction.Status.READY || bean.getStatus() == CoordinatorAction.Status.SUBMITTED;
            }
        });
        CoordinatorActionBean action3 = this.getCoordinatorAction(actionId);
        String actionXml = action3.getActionXml();
        System.out.println("After refresh, action xml= " + actionXml);
        Element eAction = XmlUtils.parseXml((String)actionXml);
        String[] urls = this.getActionXmlUrls(eAction, TestCoordRerunXCommand.getTestUser(), TestCoordRerunXCommand.getTestGroup());
    }

    public void testCoordRerunCleanupOption() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum = true;
        final String actionId = jobId + "@" + 1;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action4.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String outputDir = appPath.toString() + "/coord-input/2009/12/14/11/00";
        Path success = new Path(outputDir, "_SUCCESS");
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path(outputDir));
        fs.create(success, true);
        TestCoordRerunXCommand.assertTrue((boolean)fs.exists(success));
        long beforeModifiedTime = fs.getFileStatus(success).getModificationTime();
        final OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "action", Integer.toString(1), false, false);
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorAction bean = coordClient.getCoordActionInfo(actionId);
                return bean.getStatus() == CoordinatorAction.Status.WAITING || bean.getStatus() == CoordinatorAction.Status.READY;
            }
        });
        TestCoordRerunXCommand.assertTrue((boolean)fs.exists(success));
        long afterModifiedTime = fs.getFileStatus(success).getModificationTime();
        TestCoordRerunXCommand.assertEquals((long)beforeModifiedTime, (long)afterModifiedTime);
    }

    public void testCoordRerunCleanup() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum = true;
        final String actionId = jobId + "@" + 1;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String outputDir = appPath.toString() + "/coord-input/2009/12/14/11/00";
        Path success = new Path(outputDir, "_SUCCESS");
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path(outputDir));
        fs.create(success, true);
        TestCoordRerunXCommand.assertTrue((boolean)fs.exists(success));
        final OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "action", Integer.toString(1), false, false);
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorAction bean = coordClient.getCoordActionInfo(actionId);
                return bean.getStatus() == CoordinatorAction.Status.WAITING || bean.getStatus() == CoordinatorAction.Status.READY;
            }
        });
        TestCoordRerunXCommand.assertFalse((boolean)fs.exists(success));
    }

    public void testCoordRerunCleanupForHCat() throws Exception {
        this.setSystemProperty("oozie.test.user.test", System.getProperty("user.name"));
        super.setupHCatalogServer();
        this.services = super.setupServicesForHCatalog();
        this.services.init();
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum = true;
        final String actionId = jobId + "@" + 1;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml", true);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        String db = "mydb";
        String table = "mytable";
        String server = this.getHCatalogServer().getMetastoreAuthority();
        String newHCatDependency = "hcat://" + server + "/" + db + "/" + table + "/ds=2009121411;region=usa";
        this.dropTable(db, table, true);
        this.dropDatabase(db, true);
        this.createDatabase(db);
        this.createTable(db, table, "ds,region");
        this.addPartition(db, table, "ds=2009121411;region=usa");
        Configuration conf = new Configuration();
        URIHandler handler = ((URIHandlerService)this.services.get(URIHandlerService.class)).getURIHandler(newHCatDependency);
        TestCoordRerunXCommand.assertTrue((boolean)handler.exists(new URI(newHCatDependency), conf, TestCoordRerunXCommand.getTestUser()));
        final OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "action", Integer.toString(1), false, false);
        CoordinatorActionBean action2 = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{actionId});
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorAction bean = coordClient.getCoordActionInfo(actionId);
                return bean.getStatus() == CoordinatorAction.Status.WAITING || bean.getStatus() == CoordinatorAction.Status.READY;
            }
        });
        TestCoordRerunXCommand.assertFalse((boolean)handler.exists(new URI(newHCatDependency), conf, TestCoordRerunXCommand.getTestUser()));
    }

    public void testCoordRerunCleanupNoOutputEvents() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum = true;
        final String actionId = jobId + "@" + 1;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action3.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        final OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "action", Integer.toString(1), false, false);
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorAction bean = coordClient.getCoordActionInfo(actionId);
                return bean.getStatus() == CoordinatorAction.Status.WAITING || bean.getStatus() == CoordinatorAction.Status.READY;
            }
        });
        CoordinatorAction bean = coordClient.getCoordActionInfo(actionId);
        TestCoordRerunXCommand.assertTrue((bean.getStatus() == CoordinatorAction.Status.WAITING || bean.getStatus() == CoordinatorAction.Status.READY ? 1 : 0) != 0);
    }

    public void testCoordRerunInFailed() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.FAILED, false, false);
        job = this.getCoordinatorJob(job.getId());
        TestCoordRerunXCommand.assertEquals((Object)Job.Status.FAILED, (Object)job.getStatus());
        try {
            new CoordRerunXCommand(job.getId(), "date", "2009-12-15T01:00Z", false, true, false, null).call();
            TestCoordRerunXCommand.fail((String)"Coordinator job is FAILED, rerun should throw exception");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }

    public void testCoordRerunInDoneWithError() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.states.without.error", "false");
        this.services = new Services();
        this.services.init();
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.DONEWITHERROR, false, false);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.FAILED, "coord-rerun-action1.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordRerunXCommand.assertNotNull((Object)jpaService);
        job = this.getCoordinatorJob(job.getId());
        TestCoordRerunXCommand.assertEquals((Object)Job.Status.DONEWITHERROR, (Object)job.getStatus());
        new CoordRerunXCommand(job.getId(), "date", "2009-12-15T01:00Z", false, true, false, null).call();
        job = this.getCoordinatorJob(job.getId());
        TestCoordRerunXCommand.assertEquals((Object)Job.Status.RUNNINGWITHERROR, (Object)job.getStatus());
    }

    public void testCoordRerunInPaused() throws Exception {
        Date curr = new Date();
        Date pauseTime = new Date(curr.getTime() - 1000L);
        CoordinatorJobBean job = this.addRecordToCoordJobTableWithPausedTime(Job.Status.PAUSED, false, false, pauseTime);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordRerunXCommand.assertNotNull((Object)jpaService);
        job = this.getCoordinatorJob(job.getId());
        TestCoordRerunXCommand.assertEquals((Object)Job.Status.PAUSED, (Object)job.getStatus());
        new CoordRerunXCommand(job.getId(), "date", "2009-12-15T01:00Z", false, true, false, null).call();
        job = this.getCoordinatorJob(job.getId());
        TestCoordRerunXCommand.assertEquals((Object)Job.Status.PAUSED, (Object)job.getStatus());
        TestCoordRerunXCommand.assertNotNull((Object)job.getPauseTime());
    }

    public void testCoordRerunInPausedWithError() throws Exception {
        Date curr = new Date();
        Date pauseTime = new Date(curr.getTime() - 1000L);
        CoordinatorJobBean job = this.addRecordToCoordJobTableWithPausedTime(Job.Status.PAUSEDWITHERROR, false, false, pauseTime);
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.FAILED, "coord-rerun-action1.xml", 0);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordRerunXCommand.assertNotNull((Object)jpaService);
        job = this.getCoordinatorJob(job.getId());
        TestCoordRerunXCommand.assertEquals((Object)Job.Status.PAUSEDWITHERROR, (Object)job.getStatus());
        new CoordRerunXCommand(job.getId(), "date", "2009-12-15T01:00Z", false, true, false, null).call();
        job = this.getCoordinatorJob(job.getId());
        TestCoordRerunXCommand.assertEquals((Object)Job.Status.PAUSEDWITHERROR, (Object)job.getStatus());
        TestCoordRerunXCommand.assertNotNull((Object)job.getPauseTime());
    }

    public void testCoordRerunKilledCoord() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum = true;
        String actionId = jobId + "@" + 1;
        try {
            this.addRecordToJobTable(jobId, Job.Status.KILLED);
            this.addRecordToActionTable(jobId, 1, actionId, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        try {
            OozieClient coordClient = LocalOozie.getCoordClient();
            coordClient.reRunCoord(jobId, "action", Integer.toString(1), false, true);
        }
        catch (OozieClientException ex) {
            ex.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Coord rerun failed");
        }
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertEquals((Object)action2.getStatus(), (Object)CoordinatorAction.Status.WAITING);
    }

    public void testCoordRerunFailedCoordAction() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum = true;
        String actionId = jobId + "@" + 1;
        try {
            this.addRecordToJobTable(jobId, Job.Status.RUNNING);
            this.addRecordToActionTable(jobId, 1, actionId, CoordinatorAction.Status.FAILED, "coord-rerun-action1.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        try {
            OozieClient coordClient = LocalOozie.getCoordClient();
            coordClient.reRunCoord(jobId, "action", Integer.toString(1), false, true);
        }
        catch (OozieClientException ex) {
            ex.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Coord rerun failed");
        }
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertEquals((Object)action2.getStatus(), (Object)CoordinatorAction.Status.WAITING);
        TestCoordRerunXCommand.assertEquals((String)action2.getErrorCode(), (String)"");
        TestCoordRerunXCommand.assertEquals((String)action2.getErrorMessage(), (String)"");
    }

    public void testCoordRerunForBackwardSupport1() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.coord.status", "true");
        this.services = new Services();
        this.services.init();
        Date start = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-02-02T23:59Z");
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, start, end, false, true, 3);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordRerunXCommand.assertNotNull((Object)jpaService);
        coordJob.setAppNamespace("uri:oozie:coordinator:0.1");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_APPNAMESPACE, coordJob);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.FAILED, "coord-rerun-action1.xml", 0);
        CoordinatorActionBean action2 = this.addRecordToCoordActionTable(coordJob.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml", 0);
        CoordinatorActionBean action3 = this.addRecordToCoordActionTable(coordJob.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml", 0);
        String rerunScope = Integer.toString(1) + "-" + Integer.toString(2);
        OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(coordJob.getId(), "action", rerunScope, false, true);
        coordJob = this.getCoordinatorJob(coordJob.getId());
        TestCoordRerunXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        action1 = this.getCoordinatorAction(action1.getId());
        TestCoordRerunXCommand.assertNotSame((Object)action1.getStatus(), (Object)CoordinatorAction.Status.FAILED);
        action2 = this.getCoordinatorAction(action2.getId());
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
    }

    public void testCoordRerunForBackwardSupport2() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.coord.status", "true");
        this.services = new Services();
        this.services.init();
        Date start = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-02-02T23:59Z");
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUSPENDED, start, end, false, true, 3);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordRerunXCommand.assertNotNull((Object)jpaService);
        coordJob.setAppNamespace("uri:oozie:coordinator:0.1");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_APPNAMESPACE, coordJob);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.FAILED, "coord-rerun-action1.xml", 0);
        CoordinatorActionBean action2 = this.addRecordToCoordActionTable(coordJob.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml", 0);
        CoordinatorActionBean action3 = this.addRecordToCoordActionTable(coordJob.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml", 0);
        String rerunScope = Integer.toString(1) + "-" + Integer.toString(2);
        OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(coordJob.getId(), "action", rerunScope, false, true);
        coordJob = this.getCoordinatorJob(coordJob.getId());
        TestCoordRerunXCommand.assertEquals((Object)Job.Status.SUSPENDED, (Object)coordJob.getStatus());
        action1 = this.getCoordinatorAction(action1.getId());
        TestCoordRerunXCommand.assertNotSame((Object)action1.getStatus(), (Object)CoordinatorAction.Status.FAILED);
        action2 = this.getCoordinatorAction(action2.getId());
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
    }

    public void testCoordRerunForBackwardSupport3() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.coord.status", "true");
        this.services = new Services();
        this.services.init();
        Date start = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-02-02T23:59Z");
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, start, end, false, false, 3);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordRerunXCommand.assertNotNull((Object)jpaService);
        coordJob.setAppNamespace("uri:oozie:coordinator:0.1");
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_APPNAMESPACE, coordJob);
        CoordinatorActionBean action1 = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml", 0);
        CoordinatorActionBean action2 = this.addRecordToCoordActionTable(coordJob.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml", 0);
        CoordinatorActionBean action3 = this.addRecordToCoordActionTable(coordJob.getId(), 3, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml", 0);
        String rerunScope = Integer.toString(1) + "-" + Integer.toString(2);
        OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(coordJob.getId(), "action", rerunScope, false, true);
        coordJob = this.getCoordinatorJob(coordJob.getId());
        TestCoordRerunXCommand.assertEquals((Object)Job.Status.SUCCEEDED, (Object)coordJob.getStatus());
        action1 = this.getCoordinatorAction(action1.getId());
        TestCoordRerunXCommand.assertNotSame((Object)action1.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        action2 = this.getCoordinatorAction(action2.getId());
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
    }

    protected CoordinatorJobBean addRecordToCoordJobTableWithPausedTime(Job.Status status, boolean pending, boolean doneMatd, Date pausedTime) throws Exception {
        CoordinatorJobBean coordJob = this.createCoordJob(status, pending, doneMatd);
        coordJob.setPauseTime(pausedTime);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordRerunXCommand.assertNotNull((Object)jpaService);
            CoordJobInsertJPAExecutor coordInsertCmd = new CoordJobInsertJPAExecutor(coordJob);
            jpaService.execute((JPAExecutor)coordInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Unable to insert the test coord job record to table");
            throw je;
        }
        return coordJob;
    }

    private void addRecordToJobTable(String jobId, Job.Status status) throws StoreException, IOException {
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String appXml = this.getCoordJobXml(appPath);
        FileSystem fs = this.getFileSystem();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(appPath + "/coordinator.xml")));
        byte[] bytes = appXml.getBytes("UTF-8");
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        InputStreamReader reader2 = new InputStreamReader(bais);
        IOUtils.copyCharStream((Reader)reader2, (Writer)writer);
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(jobId);
        coordJob.setAppName("COORD-TEST");
        coordJob.setAppPath(appPath.toString());
        coordJob.setStatus(status);
        coordJob.setCreatedTime(new Date());
        coordJob.setLastModifiedTime(new Date());
        coordJob.setUser(TestCoordRerunXCommand.getTestUser());
        coordJob.setGroup(TestCoordRerunXCommand.getTestGroup());
        Properties conf = this.getCoordProp(appPath);
        String confStr = XmlUtils.writePropToString((Properties)conf);
        coordJob.setConf(confStr);
        coordJob.setJobXml(appXml);
        coordJob.setLastActionNumber(0);
        coordJob.setFrequency("1");
        coordJob.setExecutionOrder(CoordinatorJob.Execution.FIFO);
        coordJob.setConcurrency(1);
        try {
            coordJob.setStartTime(DateUtils.parseDateOozieTZ((String)"2009-12-15T01:00Z"));
            coordJob.setEndTime(DateUtils.parseDateOozieTZ((String)"2009-12-17T01:00Z"));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not set Date/time");
        }
        try {
            this.addRecordToCoordJobTable(coordJob);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Unable to insert the test job record to table");
            throw new StoreException(ErrorCode.E1019, new Object[]{e.getMessage()});
        }
    }

    private void addRecordToActionTable(String jobId, int actionNum, String actionId, CoordinatorAction.Status status, String resourceXmlName) throws StoreException, IOException {
        this.addRecordToActionTable(jobId, actionNum, actionId, status, resourceXmlName, false);
    }

    private void addRecordToActionTable(String jobId, int actionNum, String actionId, CoordinatorAction.Status status, String resourceXmlName, boolean isHCatDep) throws StoreException, IOException {
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = null;
        actionXml = !isHCatDep ? this.getCoordActionXml(appPath, resourceXmlName) : this.getCoordActionXmlForHCat(appPath, resourceXmlName);
        String actionNomialTime = this.getActionNomialTime(actionXml);
        CoordinatorActionBean action = new CoordinatorActionBean();
        action.setJobId(jobId);
        action.setId(actionId);
        action.setActionNumber(actionNum);
        try {
            action.setNominalTime(DateUtils.parseDateOozieTZ((String)actionNomialTime));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Unable to get action nominal time");
            throw new IOException(e);
        }
        action.setLastModifiedTime(new Date());
        action.setStatus(status);
        action.setActionXml(actionXml);
        Properties conf = this.getCoordProp(appPath);
        String createdConf = XmlUtils.writePropToString((Properties)conf);
        action.setCreatedConf(createdConf);
        if (status.equals((Object)CoordinatorAction.Status.FAILED)) {
            action.setErrorCode("E1000");
            action.setErrorMessage("Error");
        }
        try {
            this.addRecordToCoordActionTable(action, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Unable to insert the test job record to table");
            throw new StoreException(ErrorCode.E1019, new Object[]{e.getMessage()});
        }
    }

    private Properties getCoordProp(Path appPath) throws IOException {
        Path wfAppPath = new Path(this.getFsTestCaseDir(), "workflow");
        OozieClient coordClient = LocalOozie.getCoordClient();
        Properties conf = coordClient.createConfiguration();
        conf.setProperty("oozie.coord.application.path", appPath.toString());
        conf.setProperty("jobTracker", this.getJobTrackerUri());
        conf.setProperty("nameNode", this.getNameNodeUri());
        conf.setProperty("wfAppPath", wfAppPath.toString());
        conf.remove("user.name");
        conf.setProperty("user.name", TestCoordRerunXCommand.getTestUser());
        String content = "<workflow-app xmlns='uri:oozie:workflow:0.1'  xmlns:sla='uri:oozie:sla:0.1' name='no-op-wf'>";
        content = content + "<start to='end' />";
        content = content + "<end name='end' /></workflow-app>";
        this.writeToFile(content, wfAppPath, "workflow.xml");
        return conf;
    }

    private String[] getActionXmlUrls(Element eAction, String user, String group) {
        Element outputList = eAction.getChild("input-events", eAction.getNamespace());
        for (Element data : outputList.getChildren("data-in", eAction.getNamespace())) {
            String uris;
            if (data.getChild("uris", data.getNamespace()) == null || (uris = data.getChild("uris", data.getNamespace()).getTextTrim()) == null) continue;
            String[] uriArr = uris.split("#");
            return uriArr;
        }
        return null;
    }

    @Override
    protected String getCoordJobXml(Path appPath) {
        String inputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        inputTemplate = Matcher.quoteReplacement(inputTemplate);
        String outputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        outputTemplate = Matcher.quoteReplacement(outputTemplate);
        try {
            Reader reader = IOUtils.getResourceAsReader((String)"coord-rerun-job.xml", (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            appXml = appXml.replaceAll("#inputTemplate", inputTemplate);
            appXml = appXml.replaceAll("#outputTemplate", outputTemplate);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)"Could not get coord-rerun-job.xml", (Object[])new Object[]{ioe}));
        }
    }

    @Override
    protected String getCoordActionXml(Path appPath, String resourceXmlName) {
        String inputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        inputTemplate = Matcher.quoteReplacement(inputTemplate);
        String outputTemplate = appPath + "/coord-input/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}";
        outputTemplate = Matcher.quoteReplacement(outputTemplate);
        String inputDir = appPath + "/coord-input/2010/07/05/01/00";
        inputDir = Matcher.quoteReplacement(inputDir);
        String outputDir = appPath + "/coord-input/2009/12/14/11/00";
        outputDir = Matcher.quoteReplacement(outputDir);
        try {
            Reader reader = IOUtils.getResourceAsReader((String)resourceXmlName, (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            appXml = appXml.replaceAll("#inputTemplate", inputTemplate);
            appXml = appXml.replaceAll("#outputTemplate", outputTemplate);
            appXml = appXml.replaceAll("#inputDir", inputDir);
            appXml = appXml.replaceAll("#outputDir", outputDir);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)("Could not get " + resourceXmlName), (Object[])new Object[]{ioe}));
        }
    }

    protected String getCoordActionXmlForHCat(Path appPath, String resourceXmlName) {
        String hcatServer = this.getHCatalogServer().getMetastoreAuthority();
        String inputTemplate = "hcat://" + hcatServer + "/mydb/mytable/ds=${YEAR}${MONTH}${DAY}${HOUR};region=usa";
        inputTemplate = Matcher.quoteReplacement(inputTemplate);
        String outputTemplate = "hcat://" + hcatServer + "/mydb/mytable/ds=${YEAR}${MONTH}${DAY}${HOUR};region=usa";
        outputTemplate = Matcher.quoteReplacement(outputTemplate);
        String inputDir = "hcat://" + hcatServer + "/mydb/mytable/ds=2010070501;region=usa";
        inputDir = Matcher.quoteReplacement(inputDir);
        String outputDir = "hcat://" + hcatServer + "/mydb/mytable/ds=2009121411;region=usa";
        outputDir = Matcher.quoteReplacement(outputDir);
        try {
            Reader reader = IOUtils.getResourceAsReader((String)resourceXmlName, (int)-1);
            String appXml = IOUtils.getReaderAsString((Reader)reader, (int)-1);
            appXml = appXml.replaceAll("#inputTemplate", inputTemplate);
            appXml = appXml.replaceAll("#outputTemplate", outputTemplate);
            appXml = appXml.replaceAll("#inputDir", inputDir);
            appXml = appXml.replaceAll("#outputDir", outputDir);
            return appXml;
        }
        catch (IOException ioe) {
            throw new RuntimeException(XLog.format((String)("Could not get " + resourceXmlName), (Object[])new Object[]{ioe}));
        }
    }

    private String getActionNomialTime(String actionXml) {
        Element eAction;
        try {
            eAction = XmlUtils.parseXml((String)actionXml);
        }
        catch (JDOMException je) {
            throw new RuntimeException(XLog.format((String)("Could not parse actionXml :" + actionXml), (Object[])new Object[]{je}));
        }
        String actionNomialTime = eAction.getAttributeValue("action-nominal-time");
        return actionNomialTime;
    }

    public void testActionStatusRunningWithWorkflow() throws Exception {
        Date start = DateUtils.parseDateOozieTZ((String)"2009-12-15T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-12-16T01:00Z");
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        CoordinatorActionBean action = this.addRecordToWithLazyAction(coordJob.getId(), 1, CoordinatorAction.Status.SUBMITTED, "coord-rerun-action1.xml");
        String actionId = action.getId();
        new CoordActionStartXCommand(actionId, TestCoordRerunXCommand.getTestUser(), "myapp", "myjob").call();
        action = this.getCoordinatorAction(actionId);
        if (action.getStatus() == CoordinatorAction.Status.SUBMITTED) {
            TestCoordRerunXCommand.fail((String)("CoordActionStartCommand didn't work because the status for action id" + actionId + " is :" + action.getStatus() + " expected to be NOT SUBMITTED (i.e. RUNNING)"));
        }
        final String wfId = action.getExternalId();
        final OozieClient wfClient = LocalOozie.getClient();
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(wfId).getStatus() == WorkflowJob.Status.RUNNING;
            }
        });
        wfClient.kill(wfId);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(wfId).getStatus() == WorkflowJob.Status.KILLED;
            }
        });
        TestCoordRerunXCommand.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfClient.getJobInfo(wfId).getStatus());
        Properties conf = wfClient.createConfiguration();
        conf.setProperty("oozie.wf.rerun.failnodes", "true");
        wfClient.reRun(wfId, conf);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(wfId).getStatus() == WorkflowJob.Status.RUNNING;
            }
        });
        TestCoordRerunXCommand.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)wfClient.getJobInfo(wfId).getStatus());
        OozieClient coordActionClient = LocalOozie.getCoordClient();
        TestCoordRerunXCommand.assertEquals((Object)CoordinatorAction.Status.RUNNING, (Object)coordActionClient.getCoordActionInfo(actionId).getStatus());
    }

    private CoordinatorActionBean addRecordToWithLazyAction(String jobId, int actionNum, CoordinatorAction.Status status, String resourceXmlName) throws IOException {
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String actionXml = this.getCoordActionXml(appPath, resourceXmlName);
        String actionNomialTime = this.getActionNomialTime(actionXml);
        CoordinatorActionBean action = new CoordinatorActionBean();
        action.setJobId(jobId);
        action.setId(((UUIDService)Services.get().get(UUIDService.class)).generateChildId(jobId, actionNum + ""));
        action.setActionNumber(actionNum);
        try {
            action.setNominalTime(DateUtils.parseDateOozieTZ((String)actionNomialTime));
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Unable to get action nominal time");
            throw new IOException(e);
        }
        action.setLastModifiedTime(new Date());
        action.setStatus(status);
        action.setActionXml(actionXml);
        Properties conf = this.getLazyWorkflowProp(appPath);
        String createdConf = XmlUtils.writePropToString((Properties)conf);
        action.setCreatedConf(createdConf);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordRerunXCommand.assertNotNull((Object)jpaService);
        CoordActionInsertJPAExecutor coordActionInsertCmd = new CoordActionInsertJPAExecutor(action);
        try {
            jpaService.execute((JPAExecutor)coordActionInsertCmd);
        }
        catch (JPAExecutorException e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Unable to insert the test coord action record to table");
        }
        return action;
    }

    private Properties getLazyWorkflowProp(Path appPath) throws IOException {
        Path wfAppPath = new Path(this.getFsTestCaseDir(), "workflow");
        OozieClient coordClient = LocalOozie.getCoordClient();
        Properties conf = coordClient.createConfiguration();
        conf.setProperty("oozie.coord.application.path", appPath.toString());
        conf.setProperty("jobTracker", this.getJobTrackerUri());
        conf.setProperty("nameNode", this.getNameNodeUri());
        conf.setProperty("wfAppPath", wfAppPath.toString());
        conf.remove("user.name");
        conf.setProperty("user.name", TestCoordRerunXCommand.getTestUser());
        this.writeToFile(this.getLazyWorkflow(), wfAppPath, "workflow.xml");
        return conf;
    }

    public String getLazyWorkflow() {
        return "<workflow-app xmlns='uri:oozie:workflow:0.1'  xmlns:sla='uri:oozie:sla:0.1' name='no-op-wf'><start to='java' />       <action name='java'><java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><main-class>" + JavaSleepAction.class.getName() + "</main-class><arg>exit0</arg></java><ok to='end' /><error to='fail' /></action><kill name='fail'><message>shell action fail, error message[${wf:errorMessage(wf:lastErrorNode())}]</message></kill><end name='end' /></workflow-app>";
    }

    public void testCoordRerunWithFailedOption() throws Exception {
        Date start = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-02-01T23:59Z");
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        CoordinatorActionBean action = this.addRecordToWithLazyAction(coordJob.getId(), 1, CoordinatorAction.Status.SUBMITTED, "coord-rerun-action1.xml");
        final String actionId = action.getId();
        new CoordActionStartXCommand(actionId, TestCoordRerunXCommand.getTestUser(), "myapp", "myjob").call();
        action = this.getCoordinatorAction(actionId);
        if (action.getStatus() == CoordinatorAction.Status.SUBMITTED) {
            TestCoordRerunXCommand.fail((String)("CoordActionStartCommand didn't work because the status for action id" + actionId + " is :" + action.getStatus() + " expected to be NOT SUBMITTED (i.e. RUNNING)"));
        }
        final OozieClient coordClient = LocalOozie.getCoordClient();
        OozieClient wclient = LocalOozie.getClient();
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return coordClient.getCoordActionInfo(actionId).getStatus() == CoordinatorAction.Status.RUNNING;
            }
        });
        wclient.kill(coordClient.getCoordActionInfo(actionId).getExternalId());
        this.waitFor(150000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return coordClient.getCoordActionInfo(actionId).getStatus() == CoordinatorAction.Status.KILLED;
            }
        });
        String externalId = coordClient.getCoordActionInfo(actionId).getExternalId();
        coordClient.reRunCoord(coordJob.getId(), "action", "1", false, true, true, new Properties());
        this.waitFor(150000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return coordClient.getCoordActionInfo(actionId).getStatus() == CoordinatorAction.Status.SUCCEEDED;
            }
        });
        TestCoordRerunXCommand.assertEquals((String)externalId, (String)coordClient.getCoordActionInfo(actionId).getExternalId());
        coordClient.reRunCoord(coordJob.getId(), "action", "1", false, true, false, new Properties());
        this.waitFor(150000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return coordClient.getCoordActionInfo(actionId).getStatus() == CoordinatorAction.Status.SUCCEEDED;
            }
        });
        TestCoordRerunXCommand.assertNotSame((Object)externalId, (Object)coordClient.getCoordActionInfo(actionId).getExternalId());
    }

    public void testCoordRerunWithFailedOptionDirectoryPresent() throws Exception {
        String jobId = "0000000-" + new Date().getTime() + "-testCoordRerun-C";
        boolean actionNum = true;
        final String actionId = jobId + "@" + 1;
        try {
            this.addRecordToJobTable(jobId, Job.Status.SUCCEEDED);
            this.addRecordToActionTable(jobId, 1, actionId, CoordinatorAction.Status.SUCCEEDED, "coord-rerun-action1.xml");
        }
        catch (Exception e) {
            e.printStackTrace();
            TestCoordRerunXCommand.fail((String)"Could not update db.");
        }
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        String outputDir = appPath.toString() + "/coord-input/2009/12/14/11/00";
        Path success = new Path(outputDir, "_SUCCESS");
        FileSystem fs = this.getFileSystem();
        fs.mkdirs(new Path(outputDir));
        fs.create(success, true);
        TestCoordRerunXCommand.assertTrue((boolean)fs.exists(success));
        final OozieClient coordClient = LocalOozie.getCoordClient();
        coordClient.reRunCoord(jobId, "action", Integer.toString(1), false, false, true, new Properties());
        CoordinatorActionBean action2 = this.getCoordinatorAction(actionId);
        TestCoordRerunXCommand.assertNotSame((Object)action2.getStatus(), (Object)CoordinatorAction.Status.SUCCEEDED);
        this.waitFor(120000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorAction bean = coordClient.getCoordActionInfo(actionId);
                return bean.getStatus() == CoordinatorAction.Status.WAITING || bean.getStatus() == CoordinatorAction.Status.READY;
            }
        });
        TestCoordRerunXCommand.assertTrue((boolean)fs.exists(success));
    }

    public void testCoordRerunWithConfOption() throws Exception {
        Date start = DateUtils.parseDateOozieTZ((String)"2009-02-01T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-02-01T23:59Z");
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        CoordinatorActionBean action = this.addRecordToWithLazyAction(coordJob.getId(), 1, CoordinatorAction.Status.SUBMITTED, "coord-rerun-action1.xml");
        final String actionId = action.getId();
        new CoordActionStartXCommand(actionId, TestCoordRerunXCommand.getTestUser(), "myapp", "myjob").call();
        action = this.getCoordinatorAction(actionId);
        if (action.getStatus() == CoordinatorAction.Status.SUBMITTED) {
            TestCoordRerunXCommand.fail((String)("CoordActionStartCommand didn't work because the status for action id" + actionId + " is :" + action.getStatus() + " expected to be NOT SUBMITTED (i.e. RUNNING)"));
        }
        final OozieClient coordClient = LocalOozie.getCoordClient();
        OozieClient wclient = LocalOozie.getClient();
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return coordClient.getCoordActionInfo(actionId).getStatus() == CoordinatorAction.Status.RUNNING;
            }
        });
        wclient.kill(coordClient.getCoordActionInfo(actionId).getExternalId());
        this.waitFor(150000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return coordClient.getCoordActionInfo(actionId).getStatus() == CoordinatorAction.Status.KILLED;
            }
        });
        Properties prop = new Properties();
        prop.setProperty("workflowConf", "foo");
        coordClient.reRunCoord(coordJob.getId(), "action", "1", false, true, true, prop);
        this.waitFor(150000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return coordClient.getCoordActionInfo(actionId).getStatus() == CoordinatorAction.Status.SUCCEEDED;
            }
        });
        WorkflowJob wfJob = wclient.getJobInfo(coordClient.getCoordActionInfo(actionId).getExternalId());
        XConfiguration conf = new XConfiguration((Reader)new StringReader(wfJob.getConf()));
        TestCoordRerunXCommand.assertEquals((Object)prop.get("workflowConf"), (Object)conf.get("workflowConf"));
    }
}

