/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.coord.CoordResumeXCommand;
import org.apache.oozie.command.coord.CoordSuspendXCommand;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordResumeXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordSuspendAndResumeForRunning() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordResumeXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
        new CoordSuspendXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUSPENDED);
        new CoordResumeXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
    }

    public void testCoordSuspendWithErrorAndResumeWithErrorForRunning() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNINGWITHERROR, false, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordResumeXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNINGWITHERROR);
        new CoordSuspendXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUSPENDEDWITHERROR);
        new CoordResumeXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNINGWITHERROR);
    }

    public void testCoordSuspendAndResumeForPrep() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, false, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordResumeXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
        new CoordSuspendXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREPSUSPENDED);
        new CoordResumeXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
    }

    public void testCoordSuspendAndResumeForPrepWithBackwardCompatibility() throws Exception {
        Services.get().destroy();
        this.setSystemProperty("oozie.service.StatusTransitService.backward.support.for.coord.status", "true");
        this.services = new Services();
        this.services.init();
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PREP, false, false);
        job.setAppNamespace("uri:oozie:coordinator:0.1");
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB_APPNAMESPACE, job);
        TestCoordResumeXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PREP);
        new CoordSuspendXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUSPENDED);
        new CoordResumeXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordResumeXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
    }
}

