/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.coord.CoordMaterializeTransitionXCommand;
import org.apache.oozie.command.coord.CoordSLAAlertsDisableXCommand;
import org.apache.oozie.command.coord.CoordSLAChangeXCommand;
import org.apache.oozie.command.coord.CoordSubmitXCommand;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLACalculator;
import org.apache.oozie.sla.SLAOperations;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.Namespace;

public class TestCoordSubmitXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.getConf().set("oozie.services.ext", EventHandlerService.class.getName() + "," + SLAService.class.getName());
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBasicSubmit() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"${appName}-foo\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("appName", "var-app-name");
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        CoordinatorJobBean job = this.checkCoordJobs(jobId);
        TestCoordSubmitXCommand.assertNotNull((Object)job);
        TestCoordSubmitXCommand.assertEquals((String)"var-app-name-foo", (String)job.getAppName());
        TestCoordSubmitXCommand.assertEquals((int)job.getTimeout(), (int)Services.get().getConf().getInt("oozie.service.coord.normal.default.timeout", -2));
        TestCoordSubmitXCommand.assertEquals((int)job.getConcurrency(), (int)Services.get().getConf().getInt("oozie.service.coord.default.concurrency", 1));
    }

    public void testBasicSubmitWithDryRun() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"${appName}-foo\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("appName", "var-app-name");
        CoordSubmitXCommand sc = new CoordSubmitXCommand(true, (Configuration)conf);
        String dryrunStr = (String)sc.call();
        String[] actions = dryrunStr.split("action for new instance");
        TestCoordSubmitXCommand.assertEquals((int)actions.length, (int)2);
    }

    public void testBasicSubmitWithStartTimeAfterEndTime() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2010-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Expected to catch errors due to incorrectly specified Start and End Time");
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.assertEquals((Object)sc.getJob().getStatus(), (Object)Job.Status.FAILED);
            TestCoordSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1003);
            TestCoordSubmitXCommand.assertTrue((boolean)e.getMessage().contains("Coordinator Start Time must be earlier than End Time."));
        }
    }

    public void testBasicSubmitWithCronFrequency() throws Exception {
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"0 10 * * *\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <execution>LIFO</execution> </controls>  <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> </workflow> </action> </coordinator-app>";
        this.testBasicSubmitWithCronFrequency(appXml, true);
        appXml = "<coordinator-app name=\"NAME\" frequency=\"* * 30 FEB *\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <execution>LIFO</execution> </controls>  <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> </workflow> </action> </coordinator-app>";
        this.testBasicSubmitWithCronFrequency(appXml, false);
    }

    private void testBasicSubmitWithCronFrequency(String appXml, Boolean isValidFrequency) throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        if (isValidFrequency.booleanValue()) {
            String jobId = (String)sc.call();
            TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
            CoordinatorJobBean job = (CoordinatorJobBean)sc.getJob();
            TestCoordSubmitXCommand.assertEquals((String)job.getTimeUnitStr(), (String)"CRON");
        } else {
            try {
                String jobId = (String)sc.call();
            }
            catch (Exception ex) {
                TestCoordSubmitXCommand.assertTrue((boolean)ex.getMessage().contains("Invalid coordinator cron frequency"));
            }
        }
    }

    public void testBasicSubmitWithIdenticalStartAndEndTime() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2010-02-01T01:00Z\" end=\"2010-02-01T01:00Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Expected to catch errors due to incorrectly specified Start and End Time");
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.assertEquals((Object)sc.getJob().getStatus(), (Object)Job.Status.FAILED);
            TestCoordSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1003);
            TestCoordSubmitXCommand.assertTrue((boolean)e.getMessage().contains("Coordinator Start Time must be earlier than End Time."));
        }
    }

    public void testBasicSubmitWithUnMaterializableFrequency() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"0/10 3 * * *\" start=\"2010-02-01T01:00Z\" end=\"2010-02-01T02:00Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2010-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2010-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Expected to catch errors due to bad combination of frequency and start and end time");
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.assertEquals((Object)sc.getJob().getStatus(), (Object)Job.Status.FAILED);
            TestCoordSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1003);
            TestCoordSubmitXCommand.assertTrue((boolean)e.getMessage().contains("materializes no actions between start and end time."));
        }
    }

    public void testBasicSubmitWithValidFrequency() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"0/10 1 * * *\" start=\"2010-02-01T01:00Z\" end=\"2010-02-01T02:00Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.fail((String)("Unexpected failure: " + (Object)((Object)e)));
        }
    }

    public void testBasicSubmitWithMultipleInstancesInputEvent() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"coord-multiple-input-instance1.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "coordinator.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Expected to catch errors due to incorrectly specified input data set instances");
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.assertEquals((Object)sc.getJob().getStatus(), (Object)Job.Status.FAILED);
            TestCoordSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1021);
            String string = e.getMessage();
            sc.getClass();
            TestCoordSubmitXCommand.assertTrue((string.contains("input-events") && e.getMessage().contains("per data-in instance") ? 1 : 0) != 0);
        }
        reader = IOUtils.getResourceAsReader((String)"coord-multiple-input-instance2.xml", (int)-1);
        writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Expected to catch errors due to incorrectly specified input data set instances");
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.assertEquals((Object)sc.getJob().getStatus(), (Object)Job.Status.FAILED);
            TestCoordSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1021);
            String string = e.getMessage();
            sc.getClass();
            TestCoordSubmitXCommand.assertTrue((string.contains("input-events") && e.getMessage().contains("is empty") ? 1 : 0) != 0);
        }
        reader = IOUtils.getResourceAsReader((String)"coord-multiple-input-instance3.xml", (int)-1);
        writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.fail((String)("Unexpected failure: " + (Object)((Object)e)));
        }
        reader = IOUtils.getResourceAsReader((String)"coord-multiple-input-instance4.xml", (int)-1);
        writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.fail((String)("Unexpected failure: " + (Object)((Object)e)));
        }
    }

    public void testBasicSubmitWithMultipleStartInstancesInputEvent() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"coord-multiple-input-start-instance1.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "coordinator.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Expected to catch errors due to incorrectly specified input data set start-instances");
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.assertEquals((Object)sc.getJob().getStatus(), (Object)Job.Status.FAILED);
            TestCoordSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1021);
            String string = e.getMessage();
            sc.getClass();
            TestCoordSubmitXCommand.assertTrue((string.contains("input-events") && e.getMessage().contains("Coordinator app definition should not have multiple start-instances") ? 1 : 0) != 0);
        }
        reader = IOUtils.getResourceAsReader((String)"coord-multiple-input-start-instance2.xml", (int)-1);
        writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.fail((String)("Unexpected failure: " + (Object)((Object)e)));
        }
    }

    public void testBasicSubmitWithMultipleEndInstancesInputEvent() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"coord-multiple-input-end-instance1.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "coordinator.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Expected to catch errors due to incorrectly specified input data set end-instances");
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.assertEquals((Object)sc.getJob().getStatus(), (Object)Job.Status.FAILED);
            TestCoordSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1021);
            String string = e.getMessage();
            sc.getClass();
            TestCoordSubmitXCommand.assertTrue((string.contains("input-events") && e.getMessage().contains("Coordinator app definition should not have multiple end-instances") ? 1 : 0) != 0);
        }
        reader = IOUtils.getResourceAsReader((String)"coord-multiple-input-end-instance2.xml", (int)-1);
        writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.fail((String)("Unexpected failure: " + (Object)((Object)e)));
        }
    }

    public void testBasicSubmitWithMultipleInstancesOutputEvent() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"coord-multiple-output-instance1.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "coordinator.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Expected to catch errors due to incorrectly specified output data set instances");
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.assertEquals((Object)sc.getJob().getStatus(), (Object)Job.Status.FAILED);
            TestCoordSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1021);
            String string = e.getMessage();
            sc.getClass();
            TestCoordSubmitXCommand.assertTrue((string.contains("output-events") && e.getMessage().contains("per data-out instance") ? 1 : 0) != 0);
        }
        reader = IOUtils.getResourceAsReader((String)"coord-multiple-output-instance2.xml", (int)-1);
        writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Expected to catch errors due to incorrectly specified output data set instances");
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.assertEquals((Object)sc.getJob().getStatus(), (Object)Job.Status.FAILED);
            TestCoordSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E1021);
            String string = e.getMessage();
            sc.getClass();
            TestCoordSubmitXCommand.assertTrue((string.contains("output-events") && e.getMessage().contains("is empty") ? 1 : 0) != 0);
        }
        reader = IOUtils.getResourceAsReader((String)"coord-multiple-output-instance3.xml", (int)-1);
        writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Expected to catch errors due to incorrectly specified output data set instances");
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.assertEquals((Object)sc.getJob().getStatus(), (Object)Job.Status.FAILED);
            TestCoordSubmitXCommand.assertEquals((Object)e.getErrorCode(), (Object)ErrorCode.E0701);
            TestCoordSubmitXCommand.assertTrue((boolean)e.getMessage().contains("No child element is expected at this point"));
        }
        reader = IOUtils.getResourceAsReader((String)"coord-multiple-output-instance4.xml", (int)-1);
        writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
        }
        catch (CommandException e) {
            TestCoordSubmitXCommand.fail((String)"Not expected to fail here");
        }
    }

    public void testELdataIO_xsd_4() throws Exception {
        XConfiguration conf = new XConfiguration();
        String appPath = new File(this.getTestCaseDir(), "coordinator.xml").toURI().toString();
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        Reader reader = IOUtils.getResourceAsReader((String)"coord-el-dataset-4.xml", (int)-1);
        FileWriter writer = new FileWriter(new URI(appPath).getPath());
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPath);
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("nameNode", "hdfs://localhost:9000");
        conf.set("queueName", "default");
        conf.set("jobTracker", "localhost:9001");
        conf.set("examplesRoot", "examples");
        conf.set("aggregated_logs", "aggregated-logs");
        conf.set("raw_logs", "raw-logs");
        sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
        }
        catch (CommandException e) {
            e.printStackTrace();
            TestCoordSubmitXCommand.fail((String)("should not throw exception " + e.getMessage()));
        }
    }

    public void testBasicSubmitWithBundleId() throws Exception {
        BundleJobBean coordJob = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        this.addRecordToBundleActionTable(coordJob.getId(), "COORD-NAME", 0, Job.Status.PREP);
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf, coordJob.getId(), "COORD-NAME");
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        CoordinatorJobBean job = this.checkCoordJobs(jobId);
        if (job != null) {
            TestCoordSubmitXCommand.assertEquals((String)coordJob.getId(), (String)job.getBundleId());
            TestCoordSubmitXCommand.assertEquals((String)"COORD-NAME", (String)job.getAppName());
            TestCoordSubmitXCommand.assertEquals((String)"uri:oozie:coordinator:0.2", (String)job.getAppNamespace());
        } else {
            TestCoordSubmitXCommand.fail();
        }
    }

    public void testBasicSubmitWithWrongNamespace() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.1\"> <controls> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        this.addRecordToBundleActionTable("OOZIE-B", "COORD-NAME", 0, Job.Status.PREP);
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf, "OOZIE-B", "COORD-NAME");
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Exception expected because namespace is too old when submit coordinator through bundle!");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }

    public void testBasicSubmitWithSLA() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns='uri:oozie:coordinator:0.2' xmlns:sla='uri:oozie:sla:0.1'> <controls> <timeout>${coord:minutes(10)}</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"Stats\" frequency=\"${coord:days(1)}\" initial-instance=\"2009-01-01T01:00Z\" timezone=\"UTC\"><uri-template>hcat://foo:11002/myOutputDatabase/myOutputTable/datestamp=${YEAR}${MONTH}${DAY}</uri-template></dataset></datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> <data-out name=\"aggregated-logs\" dataset=\"Stats\"><instance>${coord:current(0)}</instance></data-out></output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow>  <sla:info> <sla:app-name>test-app</sla:app-name> <sla:nominal-time>${coord:nominalTime()}</sla:nominal-time> <sla:should-start>${5 * MINUTES}</sla:should-start> <sla:should-end>${ SLA_OFFSET * HOURS}</sla:should-end> <sla:notification-msg>Notifying User for ${coord:nominalTime()}, ${coord:actualTime()},${coord:formatTime(coord:nominalTime(),'yyyy-MM-dd')},${coord:dateOffset(coord:nominalTime(), 1, 'DAY')}${coord:actionId()},${coord:name()}, ${coord:conf('nameNode')},${coord:user()},${coord:dataOut('LOCAL_A')}${coord:databaseOut('aggregated-logs')},${coord:tableOut('aggregated-logs')},${coord:dataOutPartitions('aggregated-logs')}</sla:notification-msg> <sla:alert-contact>abc@example.com</sla:alert-contact> <sla:dev-contact>abc@example.com</sla:dev-contact> <sla:qa-contact>abc@example.com</sla:qa-contact> <sla:se-contact>abc@example.com</sla:se-contact> <sla:alert-frequency>LAST_HOUR</sla:alert-frequency> <sla:alert-percentage>10</sla:alert-percentage></sla:info></action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("SLA_OFFSET", "10");
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        CoordinatorJobBean job = this.checkCoordJobs(jobId);
        TestCoordSubmitXCommand.assertEquals((int)job.getTimeout(), (int)10);
    }

    public void testSubmitFixedValues() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"10\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"60\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"120\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        this.checkCoordJobs(jobId);
    }

    public void testSchemaError() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequencyERROR=\"10\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"60\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"120\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Exception expected if schema has errors!");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }

    public void testSubmitNoDatasets() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"10\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>blah</value> </property> </configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        this.checkCoordJobs(jobId);
    }

    public void testSubmitNoUsername() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"10\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>blah</value> </property> </configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Exception expected if user.name is not set!");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }

    public void testSubmitNoControls() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"10\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>blah</value> </property> </configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        this.checkCoordJobs(jobId);
    }

    public void testSubmitWithDoneFlag() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>file:///tmp/coord/workflows/${YEAR}/${DAY}</uri-template> <done-flag>consume_me</done-flag> </dataset><dataset name=\"local_b\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>file:///tmp/coord/workflowsb/${YEAR}/${DAY}</uri-template> <done-flag>${MY_DONE_FLAG}</done-flag> </dataset></datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  <data-in name=\"B\" dataset=\"local_b\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("MY_DONE_FLAG", "complete");
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        this.checkCoordJobs(jobId);
    }

    public void testSubmitWithVarAppName() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"${NAME}\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.3\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>file:///tmp/coord/workflows/${YEAR}/${DAY}</uri-template> <done-flag>consume_me</done-flag> </dataset><dataset name=\"local_b\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>file:///tmp/coord/workflowsb/${YEAR}/${DAY}</uri-template> <done-flag>${MY_DONE_FLAG}</done-flag> </dataset></datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  <data-in name=\"B\" dataset=\"local_b\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("MY_DONE_FLAG", "complete");
        conf.set("NAME", "test_app_name");
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        CoordinatorJobBean job = this.checkCoordJobs(jobId);
        if (job != null) {
            TestCoordSubmitXCommand.assertEquals((String)job.getAppName(), (String)"test_app_name");
        }
    }

    public void testSubmitReservedVars() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"10\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>blah</value> </property> </configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("MINUTES", "1");
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        try {
            sc.call();
            TestCoordSubmitXCommand.fail((String)"Coord job submission should fail with reserved variable definitions.");
        }
        catch (CommandException commandException) {
            // empty catch block
        }
    }

    public void testSubmitDatasetInitialInstance() throws Exception {
        block2: {
            XConfiguration conf = new XConfiguration();
            File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
            Reader reader = IOUtils.getResourceAsReader((String)"coord-dataset-initial-instance.xml", (int)-1);
            FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "coordinator.xml"));
            IOUtils.copyCharStream((Reader)reader, (Writer)writer);
            conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
            conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
            CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
            try {
                sc.call();
                TestCoordSubmitXCommand.fail((String)"Expected to catch errors due to invalid dataset initial instance");
            }
            catch (CommandException cx) {
                TestCoordSubmitXCommand.assertEquals((Object)sc.getJob().getStatus(), (Object)Job.Status.FAILED);
                TestCoordSubmitXCommand.assertEquals((Object)cx.getErrorCode(), (Object)ErrorCode.E1021);
                if (cx.getMessage().contains("earlier than the default initial instance")) break block2;
                TestCoordSubmitXCommand.fail((String)("Unexpected failure - " + cx.getMessage()));
            }
        }
    }

    public void testBasicSubmitWithIncludeFile() throws Exception {
        XConfiguration conf = new XConfiguration();
        File includePathFile = new File(this.getTestCaseDir(), "include1.xml");
        String URI_TEMPLATE_INCLUDE_XML = "file:///tmp/include_xml/workflows/${YEAR}/${DAY}";
        String URI_TEMPLATE_COORD_XML = "file:///tmp/coord_xml/workflows/${YEAR}/${DAY}";
        String includeXml = "<datasets> <dataset name=\"A\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"><uri-template>file:///tmp/include_xml/workflows/${YEAR}/${DAY}</uri-template></dataset> </datasets>";
        this.writeToFile(includeXml, includePathFile);
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"${appName}-foo\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"><controls> <execution>LIFO</execution></controls><datasets> <include>" + includePathFile.toURI() + "</include><dataset name=\"B\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"><uri-template>" + "file:///tmp/coord_xml/workflows/${YEAR}/${DAY}" + "</uri-template></dataset> </datasets> <input-events> <data-in name=\"inputA\" dataset=\"A\"> <instance>${coord:latest(0)}</instance> </data-in>  <data-in name=\"inputB\" dataset=\"B\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <action><workflow><app-path>hdfs:///tmp/workflows/</app-path> <configuration><property> <name>inputA</name> <value>${coord:dataIn('inputB')}</value> </property> </configuration></workflow></action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("appName", "var-app-name");
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        CoordinatorJobBean job = this.checkCoordJobs(jobId);
        TestCoordSubmitXCommand.assertNotNull((Object)job);
        Element processedJobXml = XmlUtils.parseXml((String)job.getJobXml());
        Namespace namespace = processedJobXml.getNamespace();
        List datainElements = processedJobXml.getChild("input-events", namespace).getChildren("data-in", namespace);
        TestCoordSubmitXCommand.assertTrue((String)"<data-in> should be 2. One from coordinator.xml and the other from the include file", (datainElements.size() == 2 ? 1 : 0) != 0);
        TestCoordSubmitXCommand.assertEquals((String)"file:///tmp/include_xml/workflows/${YEAR}/${DAY}", (String)((Element)datainElements.get(0)).getChild("dataset", namespace).getChildText("uri-template", namespace));
        TestCoordSubmitXCommand.assertEquals((String)"file:///tmp/coord_xml/workflows/${YEAR}/${DAY}", (String)((Element)datainElements.get(1)).getChild("dataset", namespace).getChildText("uri-template", namespace));
    }

    public void testDuplicateDatasetNameInIncludeFile() throws Exception {
        XConfiguration conf = new XConfiguration();
        File includePathFile = new File(this.getTestCaseDir(), "include1.xml");
        String URI_TEMPLATE_INCLUDE_XML = "file:///tmp/include_xml/workflows/${YEAR}/${DAY}";
        String URI_TEMPLATE_COORD_XML = "file:///tmp/coord_xml/workflows/${YEAR}/${DAY}";
        String includeXml = "<datasets> <dataset name=\"B\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"><uri-template>file:///tmp/include_xml/workflows/${YEAR}/${DAY}</uri-template></dataset> </datasets>";
        this.writeToFile(includeXml, includePathFile);
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"${appName}-foo\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"><controls> <execution>LIFO</execution></controls><datasets> <include>" + includePathFile.toURI() + "</include><dataset name=\"B\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"><uri-template>" + "file:///tmp/coord_xml/workflows/${YEAR}/${DAY}" + "</uri-template></dataset> </datasets> <input-events> <data-in name=\"inputB\" dataset=\"B\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <action><workflow><app-path>hdfs:///tmp/workflows/</app-path> <configuration><property> <name>inputB</name> <value>${coord:dataIn('inputB')}</value> </property> </configuration></workflow></action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("appName", "var-app-name");
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        CoordinatorJobBean job = this.checkCoordJobs(jobId);
        TestCoordSubmitXCommand.assertNotNull((Object)job);
        Element processedJobXml = XmlUtils.parseXml((String)job.getJobXml());
        Namespace namespace = processedJobXml.getNamespace();
        List datasetElements = processedJobXml.getChild("input-events", namespace).getChild("data-in", namespace).getChildren("dataset", namespace);
        TestCoordSubmitXCommand.assertTrue((String)"<dataset> should not be duplicate", (datasetElements.size() == 1 ? 1 : 0) != 0);
        TestCoordSubmitXCommand.assertEquals((String)"file:///tmp/coord_xml/workflows/${YEAR}/${DAY}", (String)((Element)datasetElements.get(0)).getChildText("uri-template", namespace));
        TestCoordSubmitXCommand.assertFalse((String)"<uri-template> should not contain one from the include file", (boolean)job.getJobXml().contains("file:///tmp/include_xml/workflows/${YEAR}/${DAY}"));
    }

    public void testCheckMaximumFrequency() throws Exception {
        TestCoordSubmitXCommand.assertTrue((boolean)Services.get().getConf().getBoolean("oozie.service.coord.check.maximum.frequency", false));
        this._testCheckMaximumFrequencyHelper("5");
        this._testCheckMaximumFrequencyHelper("10");
        this._testCheckMaximumFrequencyHelper("${coord:hours(2)}");
        this._testCheckMaximumFrequencyHelper("${coord:days(3)}");
        this._testCheckMaximumFrequencyHelper("${coord:months(4)}");
        try {
            this._testCheckMaximumFrequencyHelper("3");
            TestCoordSubmitXCommand.fail();
        }
        catch (CommandException ce) {
            TestCoordSubmitXCommand.assertEquals((Object)ErrorCode.E1003, (Object)ce.getErrorCode());
            TestCoordSubmitXCommand.assertTrue((boolean)ce.getMessage().contains("Coordinator job with frequency [3] minutes is faster than allowed maximum of 5 minutes"));
        }
        try {
            Services.get().getConf().setBoolean("oozie.service.coord.check.maximum.frequency", false);
            this._testCheckMaximumFrequencyHelper("5");
            this._testCheckMaximumFrequencyHelper("10");
            this._testCheckMaximumFrequencyHelper("${coord:hours(2)}");
            this._testCheckMaximumFrequencyHelper("${coord:days(3)}");
            this._testCheckMaximumFrequencyHelper("${coord:months(4)}");
            this._testCheckMaximumFrequencyHelper("3");
        }
        finally {
            Services.get().getConf().setBoolean("oozie.service.coord.check.maximum.frequency", true);
        }
    }

    private void _testCheckMaximumFrequencyHelper(String freq) throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"" + freq + "\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>blah</value> </property> </configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        this.checkCoordJobs(jobId);
    }

    private void _testConfigDefaults(boolean withDefaults) throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"${startTime}\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.2\"> <controls> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> <dataset name=\"local_a\" frequency=\"${coord:days(7)}\" initial-instance=\"2009-02-01T01:00Z\" timezone=\"UTC\"> <uri-template>" + this.getTestCaseFileUri("coord/workflows/${YEAR}/${DAY}") + "</uri-template>  </dataset> </datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <instance>${coord:latest(0)}</instance> </data-in>  </input-events> <output-events> <data-out name=\"LOCAL_A\" dataset=\"local_a\"> <instance>${coord:current(-1)}</instance> </data-out> </output-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> <configuration> <property> <name>inputA</name> <value>${coord:dataIn('A')}</value> </property> <property> <name>inputB</name> <value>${coord:dataOut('LOCAL_A')}</value> </property></configuration> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        if (withDefaults) {
            String defaults = "<configuration><property><name>startTime</name><value>2009-02-01T01:00Z</value></property></configuration>";
            this.writeToFile(defaults, new File(this.getTestCaseDir(), "coord-config-default.xml"));
            String jobId = (String)sc.call();
            TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        } else {
            try {
                sc.call();
                TestCoordSubmitXCommand.fail();
            }
            catch (CommandException ex) {
                TestCoordSubmitXCommand.assertEquals((Object)ErrorCode.E1004, (Object)ex.getErrorCode());
            }
            catch (Exception ex) {
                TestCoordSubmitXCommand.fail();
            }
        }
    }

    public void testMissingConfigDefaults() throws Exception {
        this._testConfigDefaults(false);
    }

    public void testAvailConfigDefaults() throws Exception {
        this._testConfigDefaults(true);
    }

    private CoordinatorJobBean checkCoordJobs(String jobId) {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            CoordinatorJobBean job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)new CoordJobGetJPAExecutor(jobId));
            return job;
        }
        catch (JPAExecutorException e) {
            TestCoordSubmitXCommand.fail((String)("Job ID " + jobId + " was not stored properly in db"));
            return null;
        }
    }

    public void testSubmitWithTimeout() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml1 = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns='uri:oozie:coordinator:0.2'> <controls> <timeout>${coord:days(10)}</timeout> </controls> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml1, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        TestCoordSubmitXCommand.assertEquals((String)jobId.substring(jobId.length() - 2), (String)"-C");
        CoordinatorJobBean job = this.checkCoordJobs(jobId);
        TestCoordSubmitXCommand.assertEquals((int)job.getTimeout(), (int)14400);
        String appXml2 = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns='uri:oozie:coordinator:0.2'> <controls> <timeout>${coord:hours(10)}</timeout> </controls> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml2, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        sc = new CoordSubmitXCommand((Configuration)conf);
        jobId = (String)sc.call();
        job = this.checkCoordJobs(jobId);
        TestCoordSubmitXCommand.assertEquals((int)job.getTimeout(), (int)600);
        String appXml3 = "<coordinator-app name=\"NAME\" frequency=\"${coord:days(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns='uri:oozie:coordinator:0.2'> <controls> <timeout>${coord:minutes(10)}</timeout> </controls> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml3, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        sc = new CoordSubmitXCommand((Configuration)conf);
        jobId = (String)sc.call();
        job = this.checkCoordJobs(jobId);
        TestCoordSubmitXCommand.assertEquals((int)job.getTimeout(), (int)10);
        String appXml4 = "<coordinator-app name=\"NAME\" frequency=\"${coord:months(1)}\" start=\"2009-02-01T01:00Z\" end=\"2009-02-03T23:59Z\" timezone=\"UTC\" xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns='uri:oozie:coordinator:0.2'> <controls> <timeout>${coord:months(1)}</timeout> </controls> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml4, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        sc = new CoordSubmitXCommand((Configuration)conf);
        jobId = (String)sc.call();
        job = this.checkCoordJobs(jobId);
        TestCoordSubmitXCommand.assertEquals((int)job.getTimeout(), (int)43200);
    }

    public void testSubmitWithSLAAlertsDisable() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"coord-action-sla.xml", (int)-1);
        FileWriter writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("start", DateUtils.formatDateOozieTZ((Date)new Date()));
        conf.set("end", DateUtils.formatDateOozieTZ((Date)org.apache.commons.lang.time.DateUtils.addMonths((Date)new Date(), (int)1)));
        conf.set("frequency", "coord:days(1)");
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        reader = IOUtils.getResourceAsReader((String)"wf-credentials.xml", (int)-1);
        appPathFile = new File(this.getTestCaseDir(), "workflow.xml");
        writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("wfAppPath", appPathFile.getPath());
        Date nominalTime = new Date();
        conf.set("nominal_time", DateUtils.formatDateOozieTZ((Date)nominalTime));
        String coordId = (String)new CoordSubmitXCommand((Configuration)conf).call();
        new CoordMaterializeTransitionXCommand(coordId, 3600).call();
        SLAService slaService = (SLAService)this.services.get(SLAService.class);
        SLACalculator calc = slaService.getSLACalculator();
        SLACalcStatus slaCalc = calc.get(coordId + "@" + 1);
        TestCoordSubmitXCommand.assertFalse((boolean)Boolean.valueOf((String)slaCalc.getSLAConfigMap().get("oozie.sla.disable.alerts")));
        Configuration conf1 = new Configuration((Configuration)conf);
        conf1.set("oozie.sla.disable.alerts", "ALL");
        coordId = (String)new CoordSubmitXCommand(conf1).call();
        new CoordMaterializeTransitionXCommand(coordId, 3600).call();
        slaService = (SLAService)this.services.get(SLAService.class);
        calc = slaService.getSLACalculator();
        slaCalc = calc.get(coordId + "@" + 1);
        TestCoordSubmitXCommand.assertTrue((boolean)Boolean.valueOf((String)slaCalc.getSLAConfigMap().get("oozie.sla.disable.alerts")));
        Configuration conf2 = new Configuration((Configuration)conf);
        Date startRangeDate = new Date(nominalTime.getTime() - 3600000L);
        conf2.set("oozie.sla.disable.alerts", DateUtils.formatDateOozieTZ((Date)startRangeDate) + "::" + DateUtils.formatDateOozieTZ((Date)nominalTime));
        coordId = (String)new CoordSubmitXCommand(conf2).call();
        new CoordMaterializeTransitionXCommand(coordId, 3600).call();
        slaCalc = calc.get(coordId + "@" + 1);
        TestCoordSubmitXCommand.assertTrue((boolean)Boolean.valueOf((String)slaCalc.getSLAConfigMap().get("oozie.sla.disable.alerts")));
        Configuration conf3 = new Configuration((Configuration)conf);
        conf3.set("oozie.sla.disable.alerts.coord", "test-coord-sla-x");
        coordId = (String)new CoordSubmitXCommand(conf3).call();
        new CoordMaterializeTransitionXCommand(coordId, 3600).call();
        slaCalc = calc.get(coordId + "@" + 1);
        TestCoordSubmitXCommand.assertFalse((boolean)Boolean.valueOf((String)slaCalc.getSLAConfigMap().get("oozie.sla.disable.alerts")));
        Date otherNominalTime = new Date(nominalTime.getTime() - 262800000L);
        conf = new XConfiguration();
        appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("wfAppPath", appPathFile.getPath());
        conf.set("start", DateUtils.formatDateOozieTZ((Date)org.apache.commons.lang.time.DateUtils.addMonths((Date)new Date(), (int)-1)));
        conf.set("end", DateUtils.formatDateOozieTZ((Date)org.apache.commons.lang.time.DateUtils.addMonths((Date)new Date(), (int)1)));
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("nominal_time", DateUtils.formatDateOozieTZ((Date)otherNominalTime));
        conf.setInt("oozie.sla.disable.alerts.older.than", 72);
        coordId = (String)new CoordSubmitXCommand((Configuration)conf).call();
        new CoordMaterializeTransitionXCommand(coordId, 3600).call();
        slaCalc = calc.get(coordId + "@" + 1);
        TestCoordSubmitXCommand.assertTrue((boolean)Boolean.valueOf((String)slaCalc.getSLAConfigMap().get("oozie.sla.disable.alerts")));
        conf = new XConfiguration();
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("wfAppPath", appPathFile.getPath());
        conf.set("start", DateUtils.formatDateOozieTZ((Date)org.apache.commons.lang.time.DateUtils.addMonths((Date)new Date(), (int)-1)));
        conf.set("end", DateUtils.formatDateOozieTZ((Date)org.apache.commons.lang.time.DateUtils.addMonths((Date)new Date(), (int)1)));
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("nominal_time", DateUtils.formatDateOozieTZ((Date)org.apache.commons.lang.time.DateUtils.addMonths((Date)new Date(), (int)-1)));
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("nominal_time", DateUtils.formatDateOozieTZ((Date)org.apache.commons.lang.time.DateUtils.addMonths((Date)new Date(), (int)-1)));
        coordId = (String)new CoordSubmitXCommand((Configuration)conf).call();
        new CoordMaterializeTransitionXCommand(coordId, 3600).call();
        slaCalc = calc.get(coordId + "@" + 1);
        TestCoordSubmitXCommand.assertTrue((boolean)Boolean.valueOf((String)slaCalc.getSLAConfigMap().get("oozie.sla.disable.alerts")));
        conf = new XConfiguration();
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("wfAppPath", appPathFile.getPath());
        conf.set("start", DateUtils.formatDateOozieTZ((Date)new Date()));
        conf.set("end", DateUtils.formatDateOozieTZ((Date)org.apache.commons.lang.time.DateUtils.addMonths((Date)new Date(), (int)1)));
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("nominal_time", DateUtils.formatDateOozieTZ((Date)new Date()));
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("nominal_time", DateUtils.formatDateOozieTZ((Date)new Date()));
        coordId = (String)new CoordSubmitXCommand((Configuration)conf).call();
        new CoordMaterializeTransitionXCommand(coordId, 3600).call();
        slaCalc = calc.get(coordId + "@" + 1);
        TestCoordSubmitXCommand.assertFalse((boolean)Boolean.valueOf((String)slaCalc.getSLAConfigMap().get("oozie.sla.disable.alerts")));
    }

    public void testSLAAlertWithNewlyCreatedActions() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"coord-action-sla.xml", (int)-1);
        FileWriter writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("start", DateUtils.formatDateOozieTZ((Date)org.apache.commons.lang.time.DateUtils.addDays((Date)new Date(), (int)-1)));
        conf.set("end", DateUtils.formatDateOozieTZ((Date)org.apache.commons.lang.time.DateUtils.addMonths((Date)new Date(), (int)1)));
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        reader = IOUtils.getResourceAsReader((String)"wf-credentials.xml", (int)-1);
        appPathFile = new File(this.getTestCaseDir(), "workflow.xml");
        writer = new FileWriter(appPathFile);
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        conf.set("wfAppPath", appPathFile.getPath());
        Date nominalTime = new Date();
        conf.set("nominal_time", DateUtils.formatDateOozieTZ((Date)nominalTime));
        String coordId = (String)new CoordSubmitXCommand((Configuration)conf).call();
        CoordinatorJobBean job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coordId});
        job.setMatThrottling(1);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        new CoordMaterializeTransitionXCommand(coordId, 3600).call();
        SLAService slaService = (SLAService)this.services.get(SLAService.class);
        SLACalculator calc = slaService.getSLACalculator();
        SLACalcStatus slaCalc = calc.get(coordId + "@" + 1);
        TestCoordSubmitXCommand.assertFalse((boolean)Boolean.valueOf((String)slaCalc.getSLAConfigMap().get("oozie.sla.disable.alerts")));
        TestCoordSubmitXCommand.assertEquals((long)slaCalc.getExpectedDuration(), (long)1800000L);
        job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coordId});
        TestCoordSubmitXCommand.assertEquals((int)job.getLastActionNumber(), (int)1);
        String newParams = "sla-max-duration=${5 * MINUTES}";
        new CoordSLAChangeXCommand(coordId, null, null, JobUtils.parseChangeValue((String)newParams)).call();
        new CoordSLAAlertsDisableXCommand(coordId, null, null).call();
        job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coordId});
        job.setMatThrottling(2);
        CoordJobQueryExecutor.getInstance().executeUpdate(CoordJobQueryExecutor.CoordJobQuery.UPDATE_COORD_JOB, job);
        job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coordId});
        new CoordMaterializeTransitionXCommand(coordId, 3600).call();
        job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{coordId});
        slaCalc = calc.get(coordId + "@" + job.getLastActionNumber());
        TestCoordSubmitXCommand.assertEquals((long)slaCalc.getExpectedDuration(), (long)300000L);
        TestCoordSubmitXCommand.assertTrue((boolean)Boolean.valueOf((String)slaCalc.getSLAConfigMap().get("oozie.sla.disable.alerts")));
        Element eAction = XmlUtils.parseXml((String)job.getJobXml());
        Element eSla = eAction.getChild("action", eAction.getNamespace()).getChild("info", eAction.getNamespace("sla"));
        TestCoordSubmitXCommand.assertEquals((String)SLAOperations.getTagElement((Element)eSla, (String)"max-duration"), (String)"${5 * MINUTES}");
    }

    public void testSubmitDateOffset() throws Exception {
        XConfiguration conf = new XConfiguration();
        File appPathFile = new File(this.getTestCaseDir(), "coordinator.xml");
        String appXml = "<coordinator-app name=\"${NAME}\" frequency=\"${coord:days(1)}\" start=\"${startDate}\" end=\"${endDate}\" timezone=\"UTC\" xmlns=\"uri:oozie:coordinator:0.3\"> <controls> <timeout>10</timeout> <concurrency>2</concurrency> <execution>LIFO</execution> </controls> <datasets> <dataset name=\"a\" frequency=\"${coord:days(1)}\" initial-instance=\"${coord:dateOffset(startDate,-2,'DAY')}\" timezone=\"UTC\"> <uri-template>file:///tmp/coord/a/${YEAR}/${DAY}</uri-template>  </dataset> <dataset name=\"b\" frequency=\"${coord:days(1)}\" initial-instance=\"${coord:dateTzOffset(startDate,'UTC')}\" timezone=\"UTC\"> <uri-template>file:///tmp/coord/b/${YEAR}/${DAY}</uri-template> <done-flag>${MY_DONE_FLAG}</done-flag> </dataset></datasets> <input-events> <data-in name=\"A\" dataset=\"a\"> <start-instance>${coord:absolute(coord:dateOffset(startDate,-1,'DAY'))}</start-instance><end-instance>${coord:current(0)}</end-instance></data-in>  <data-in name=\"B\" dataset=\"b\"> <start-instance>${coord:absolute(coord:dateTzOffset(startDate,'UTC'))}</start-instance><end-instance>${coord:current(0)}</end-instance></data-in>  </input-events> <action> <workflow> <app-path>hdfs:///tmp/workflows/</app-path> </workflow> </action> </coordinator-app>";
        this.writeToFile(appXml, appPathFile);
        conf.set("oozie.coord.application.path", appPathFile.toURI().toString());
        conf.set("user.name", TestCoordSubmitXCommand.getTestUser());
        conf.set("MY_DONE_FLAG", "complete");
        conf.set("NAME", "test_app_name");
        conf.set("startDate", "2009-02-03T00:00Z");
        conf.set("endDate", "2009-03-03T00:00Z");
        CoordSubmitXCommand sc = new CoordSubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        CoordinatorJobBean job = CoordJobQueryExecutor.getInstance().get(CoordJobQueryExecutor.CoordJobQuery.GET_COORD_JOB, new Object[]{jobId});
        TestCoordSubmitXCommand.assertTrue((boolean)job.getJobXml().contains("dataset name=\"a\" frequency=\"1\" initial-instance=\"2009-02-01T00:00Z\""));
        TestCoordSubmitXCommand.assertTrue((boolean)job.getJobXml().contains("dataset name=\"b\" frequency=\"1\" initial-instance=\"2009-02-03T00:00Z\""));
        new CoordMaterializeTransitionXCommand(jobId, 3600).call();
        CoordinatorActionBean action = (CoordinatorActionBean)CoordActionQueryExecutor.getInstance().get((Enum)CoordActionQueryExecutor.CoordActionQuery.GET_COORD_ACTION, new Object[]{jobId + "@1"});
        action.getActionXml();
        TestCoordSubmitXCommand.assertTrue((boolean)action.getActionXml().contains("tmp/coord/a/2009/02"));
        TestCoordSubmitXCommand.assertTrue((boolean)action.getActionXml().contains("tmp/coord/b/2009/03"));
    }
}

