/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.coord;

import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.command.coord.CoordSuspendXCommand;
import org.apache.oozie.executor.jpa.CoordJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordSuspendXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordSuspendPostive() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordSuspendXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordSuspendXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNING);
        new CoordSuspendXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordSuspendXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUSPENDED);
    }

    public void testCoordSuspendWithErrorPostive() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNINGWITHERROR, false, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordSuspendXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordSuspendXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.RUNNINGWITHERROR);
        new CoordSuspendXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordSuspendXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUSPENDEDWITHERROR);
    }

    public void testCoordSuspendWithErrorPostive2() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.PAUSEDWITHERROR, false, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordSuspendXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordSuspendXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.PAUSEDWITHERROR);
        new CoordSuspendXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordSuspendXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUSPENDEDWITHERROR);
    }

    public void testCoordSuspendNegative() throws Exception {
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordSuspendXCommand.assertNotNull((Object)jpaService);
        CoordJobGetJPAExecutor coordJobGetCmd = new CoordJobGetJPAExecutor(job.getId());
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordSuspendXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCEEDED);
        new CoordSuspendXCommand(job.getId()).call();
        job = (CoordinatorJobBean)jpaService.execute((JPAExecutor)coordJobGetCmd);
        TestCoordSuspendXCommand.assertEquals((Object)job.getStatus(), (Object)Job.Status.SUCCEEDED);
    }
}

