/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.DagEngine;
import org.apache.oozie.ForTestingActionExecutor;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.CoordActionGetForExternalIdJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionsGetForJobJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.WorkflowStoreService;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestActionErrors
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.service.SchemaService.wf.ext.schemas", "wf-ext-schema.xsd");
        this.setSystemProperty("oozie.service.LiteWorkflowStoreService.user.retry.error.code.ext", "TEST_ERROR");
        this.services = new Services();
        this.services.init();
        ((ActionService)this.services.get(ActionService.class)).registerAndInitExecutor(ForTestingActionExecutor.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testStartNonTransient() throws Exception {
        this._testNonTransient("start.non-transient", WorkflowAction.Status.START_MANUAL, "start");
        TestActionErrors.assertTrue((boolean)true);
    }

    public void testStartNonTransientWithCoordActionUpdate() throws Exception {
        this._testNonTransientWithCoordActionUpdate("start.non-transient", WorkflowAction.Status.START_MANUAL, "start");
        TestActionErrors.assertTrue((boolean)true);
    }

    public void testEndNonTransient() throws Exception {
        this._testNonTransient("end.non-transient", WorkflowAction.Status.END_MANUAL, "end");
        TestActionErrors.assertTrue((boolean)true);
    }

    public void testEndNonTransientWithCoordActionUpdate() throws Exception {
        this._testNonTransientWithCoordActionUpdate("end.non-transient", WorkflowAction.Status.END_MANUAL, "end");
        TestActionErrors.assertTrue((boolean)true);
    }

    public void testStartTransient() throws Exception {
        this._testTransient("start.transient", WorkflowAction.Status.START_RETRY, WorkflowAction.Status.START_MANUAL, "start");
        TestActionErrors.assertTrue((boolean)true);
    }

    public void testEndTransient() throws Exception {
        this._testTransient("end.transient", WorkflowAction.Status.END_RETRY, WorkflowAction.Status.END_MANUAL, "end");
        TestActionErrors.assertTrue((boolean)true);
    }

    public void testStartError() throws Exception {
        this._testError("start.error", "error", "based_on_action_status");
        TestActionErrors.assertTrue((boolean)true);
    }

    public void testEndError() throws Exception {
        this._testError("end.error", "ok", "OK");
        TestActionErrors.assertTrue((boolean)true);
    }

    public void testStartErrorWithUserRetry() throws Exception {
        this._testErrorWithUserRetry("start.error", "error", "based_on_action_status");
        TestActionErrors.assertTrue((boolean)true);
    }

    public void testEndErrorWithUserRetry() throws Exception {
        this._testErrorWithUserRetry("end.error", "ok", "OK");
        TestActionErrors.assertTrue((boolean)true);
    }

    public void testExecutionDataNotSet() throws Exception {
        this._testDataNotSet("avoid-set-execution-data", "START_DATA_MISSING");
    }

    public void testEndDataNotSet() throws Exception {
        this._testDataNotSet("avoid-set-end-data", "END_DATA_MISSING");
    }

    public void testKillNodeErrorMessage() throws Exception {
        WorkflowActionBean killAction = this._testKillNodeErrorMessage("wf-test-kill-node-message.xml");
        TestActionErrors.assertEquals((String)"E0729", (String)killAction.getErrorCode());
        TestActionErrors.assertEquals((String)"[end]", (String)killAction.getErrorMessage());
        TestActionErrors.assertEquals((Object)WorkflowAction.Status.OK, (Object)killAction.getStatus());
    }

    public void testKillNodeErrorMessageError() throws Exception {
        WorkflowActionBean killAction = this._testKillNodeErrorMessage("wf-test-kill-node-message-error.xml");
        TestActionErrors.assertEquals((String)"E0756", (String)killAction.getErrorCode());
        TestActionErrors.assertEquals((String)"E0756: Exception parsing Kill node message [Encountered \"{\", expected one of [<INTEGER_LITERAL>, <FLOATING_POINT_LITERAL>, <STRING_LITERAL>, \"true\", \"false\", \"null\", \"(\", \"-\", \"not\", \"!\", \"empty\", <IDENTIFIER>]]", (String)killAction.getErrorMessage());
        TestActionErrors.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)killAction.getStatus());
    }

    public void testKillNodeErrorMessageError2() throws Exception {
        WorkflowActionBean killAction = this._testKillNodeErrorMessage("wf-test-kill-node-message-error2.xml");
        TestActionErrors.assertEquals((String)"E0756", (String)killAction.getErrorCode());
        TestActionErrors.assertEquals((String)"E0756: Exception parsing Kill node message [variable [bar] cannot be resolved]", (String)killAction.getErrorMessage());
        TestActionErrors.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)killAction.getStatus());
    }

    private WorkflowActionBean _testKillNodeErrorMessage(String workflowXmlFile) throws Exception {
        String workflowPath = this.getTestCaseFileUri("workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)workflowXmlFile, (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        DagEngine engine = new DagEngine("u");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", workflowPath);
        conf.set("user.name", TestActionErrors.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("error", "end.error");
        conf.set("external-status", "FAILED/KILLED");
        conf.set("signal-value", "fail");
        String jobId = engine.submitJob((Configuration)conf, true);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        final WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(jobId);
        this.waitFor(50000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJobBean job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
                return job.getWorkflowInstance().getStatus() == WorkflowInstance.Status.KILLED;
            }
        });
        WorkflowJobBean job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfJobGetCmd);
        TestActionErrors.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)job.getStatus());
        WorkflowActionsGetForJobJPAExecutor wfActionsGetCmd = new WorkflowActionsGetForJobJPAExecutor(jobId);
        List actions = (List)jpaService.execute((JPAExecutor)wfActionsGetCmd);
        WorkflowActionBean action = null;
        WorkflowActionBean killAction = null;
        for (WorkflowActionBean bean : actions) {
            if (bean.getType().equals("test")) {
                action = bean;
            }
            if (!bean.getType().equals(":KILL:")) continue;
            killAction = bean;
        }
        TestActionErrors.assertNotNull(action);
        TestActionErrors.assertEquals((String)"TEST_ERROR", (String)action.getErrorCode());
        TestActionErrors.assertEquals((String)"end", (String)action.getErrorMessage());
        TestActionErrors.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)action.getStatus());
        TestActionErrors.assertNotNull((Object)killAction);
        return killAction;
    }

    private void _testNonTransient(String errorType, WorkflowAction.Status expStatus1, String expErrorMsg) throws Exception {
        String workflowPath = this.getTestCaseFileUri("workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        final DagEngine engine = new DagEngine("u");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", workflowPath);
        conf.set("user.name", TestActionErrors.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("signal-value", "OK");
        conf.set("external-status", "ok");
        conf.set("error", errorType);
        final String jobId = engine.submitJob((Configuration)conf, true);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return engine.getJob(jobId).getStatus() == WorkflowJob.Status.SUSPENDED;
            }
        });
        WorkflowStore store = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        store.beginTrx();
        List actions = store.getActionsForWorkflow(jobId, true);
        int n = actions.size();
        WorkflowActionBean action = (WorkflowActionBean)actions.get(n - 1);
        TestActionErrors.assertEquals((String)"TEST_ERROR", (String)action.getErrorCode());
        TestActionErrors.assertEquals((String)expErrorMsg, (String)action.getErrorMessage());
        TestActionErrors.assertEquals((Object)expStatus1, (Object)action.getStatus());
        TestActionErrors.assertTrue((!action.isPending() ? 1 : 0) != 0);
        TestActionErrors.assertTrue((engine.getJob(jobId).getStatus() == WorkflowJob.Status.SUSPENDED ? 1 : 0) != 0);
        String actionConf = action.getConf();
        String fixedActionConf = actionConf.replaceAll(errorType, "none");
        action.setConf(fixedActionConf);
        store.updateAction(action);
        store.commitTrx();
        store.closeTrx();
        engine.resume(jobId);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return engine.getJob(jobId).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestActionErrors.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)engine.getJob(jobId).getStatus());
        WorkflowStore store2 = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        store2.beginTrx();
        actions = store2.getActionsForWorkflow(jobId, false);
        action = (WorkflowActionBean)actions.get(0);
        TestActionErrors.assertEquals(null, (String)action.getErrorCode());
        TestActionErrors.assertEquals(null, (String)action.getErrorMessage());
        TestActionErrors.assertEquals((Object)WorkflowAction.Status.OK, (Object)action.getStatus());
        store2.commitTrx();
        store2.closeTrx();
    }

    private void _testNonTransientWithCoordActionUpdate(String errorType, WorkflowAction.Status expStatus1, String expErrorMsg) throws Exception {
        String workflowPath = this.getTestCaseFileUri("workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        final DagEngine engine = new DagEngine("u");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", workflowPath);
        conf.set("user.name", TestActionErrors.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("signal-value", "OK");
        conf.set("external-status", "ok");
        conf.set("error", errorType);
        final String jobId = engine.submitJob((Configuration)conf, false);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean coordAction = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", jobId, "RUNNING", 0);
        engine.start(jobId);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return engine.getJob(jobId).getStatus() == WorkflowJob.Status.SUSPENDED;
            }
        });
        TestActionErrors.assertNotNull((Object)jpaService);
        WorkflowJobGetJPAExecutor wfGetCmd = new WorkflowJobGetJPAExecutor(jobId);
        WorkflowJobBean job = (WorkflowJobBean)jpaService.execute((JPAExecutor)wfGetCmd);
        WorkflowActionsGetForJobJPAExecutor actionsGetExe = new WorkflowActionsGetForJobJPAExecutor(jobId);
        List actionsList = (List)jpaService.execute((JPAExecutor)actionsGetExe);
        int n = actionsList.size();
        WorkflowActionBean action = (WorkflowActionBean)actionsList.get(n - 1);
        TestActionErrors.assertEquals((String)"TEST_ERROR", (String)action.getErrorCode());
        TestActionErrors.assertEquals((String)expErrorMsg, (String)action.getErrorMessage());
        TestActionErrors.assertEquals((Object)expStatus1, (Object)action.getStatus());
        TestActionErrors.assertFalse((boolean)action.isPending());
        TestActionErrors.assertEquals((Object)WorkflowJob.Status.SUSPENDED, (Object)job.getStatus());
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                CoordinatorActionBean coordAction2 = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForExternalIdJPAExecutor(jobId));
                return coordAction2.getStatus().equals((Object)CoordinatorAction.Status.SUSPENDED);
            }
        });
        coordAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetForExternalIdJPAExecutor(jobId));
        TestActionErrors.assertEquals((Object)CoordinatorAction.Status.SUSPENDED, (Object)coordAction.getStatus());
    }

    private void _testTransient(String errorType, WorkflowAction.Status expStatus1, final WorkflowAction.Status expStatus2, String expErrorMsg) throws Exception {
        String workflowPath = this.getTestCaseFileUri("workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        int maxRetries = 2;
        int retryInterval = 10;
        final DagEngine engine = new DagEngine("u");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", workflowPath);
        conf.set("user.name", TestActionErrors.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("signal-value", "OK");
        conf.set("external-status", "ok");
        conf.set("error", errorType);
        conf.setInt("oozie.wf.action.max.retries", 2);
        conf.setInt("oozie.wf.action.retry.interval", 10);
        String jobId = engine.submitJob((Configuration)conf, true);
        WorkflowAction.Status expectedStatus = expStatus1;
        int expectedRetryCount = 2;
        Thread.sleep(20000L);
        String aId = null;
        WorkflowStore store = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        store.beginTrx();
        for (int retryCount = 1; retryCount <= 2; ++retryCount) {
            List actions = store.getActionsForWorkflow(jobId, false);
            WorkflowActionBean action = null;
            for (WorkflowActionBean bean : actions) {
                if (!bean.getType().equals("test")) continue;
                action = bean;
                break;
            }
            TestActionErrors.assertNotNull(action);
            aId = action.getId();
            TestActionErrors.assertEquals((Object)expectedStatus, (Object)action.getStatus());
            TestActionErrors.assertEquals((int)expectedRetryCount, (int)action.getRetries());
            TestActionErrors.assertEquals((String)"TEST_ERROR", (String)action.getErrorCode());
            TestActionErrors.assertEquals((String)expErrorMsg, (String)action.getErrorMessage());
            if (action.getRetries() == 2) {
                expectedRetryCount = 0;
                expectedStatus = expStatus2;
                break;
            }
            ++expectedRetryCount;
            Thread.sleep(10000L);
        }
        store.commitTrx();
        store.closeTrx();
        Thread.sleep(5000L);
        final String actionId = aId;
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return engine.getWorkflowAction(actionId).getStatus() == expStatus2;
            }
        });
        WorkflowStore store2 = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        store2.beginTrx();
        WorkflowActionBean action = engine.getWorkflowAction(actionId);
        TestActionErrors.assertEquals((String)"TEST_ERROR", (String)action.getErrorCode());
        TestActionErrors.assertEquals((String)expErrorMsg, (String)action.getErrorMessage());
        TestActionErrors.assertEquals((Object)expStatus2, (Object)action.getStatus());
        TestActionErrors.assertTrue((!action.isPending() ? 1 : 0) != 0);
        TestActionErrors.assertEquals((Object)WorkflowJob.Status.SUSPENDED, (Object)engine.getJob(jobId).getStatus());
        store2.commitTrx();
        store2.closeTrx();
    }

    private void _testError(String errorType, String externalStatus, String signalValue) throws Exception {
        String workflowPath = this.getTestCaseFileUri("workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        DagEngine engine = new DagEngine("u");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", workflowPath);
        conf.set("user.name", TestActionErrors.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("error", errorType);
        conf.set("external-status", externalStatus);
        conf.set("signal-value", signalValue);
        final String jobId = engine.submitJob((Configuration)conf, true);
        final WorkflowStore store = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        store.beginTrx();
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJobBean bean = store.getWorkflow(jobId, false);
                return bean.getWorkflowInstance().getStatus() == WorkflowInstance.Status.KILLED;
            }
        });
        TestActionErrors.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)engine.getJob(jobId).getStatus());
        store.commitTrx();
        store.closeTrx();
    }

    private void _testErrorWithUserRetry(String errorType, String externalStatus, String signalValue) throws Exception {
        String workflowPath = this.getTestCaseFileUri("workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid-user-retry.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        DagEngine engine = new DagEngine("u");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", workflowPath);
        conf.set("user.name", TestActionErrors.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("error", errorType);
        conf.set("external-status", externalStatus);
        conf.set("signal-value", signalValue);
        String jobId = engine.submitJob((Configuration)conf, true);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowJobGetJPAExecutor wfJobGetCmd = new WorkflowJobGetJPAExecutor(jobId);
        final WorkflowActionsGetForJobJPAExecutor actionsGetExecutor = new WorkflowActionsGetForJobJPAExecutor(jobId);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                List actions = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
                WorkflowActionBean action = null;
                for (WorkflowActionBean bean : actions) {
                    if (!bean.getType().equals("test")) continue;
                    action = bean;
                    break;
                }
                return action != null && action.getUserRetryCount() == 2;
            }
        });
        List actions = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
        WorkflowActionBean action = null;
        for (WorkflowActionBean bean : actions) {
            if (!bean.getType().equals("test")) continue;
            action = bean;
            break;
        }
        TestActionErrors.assertNotNull(action);
        TestActionErrors.assertEquals((int)2, (int)action.getUserRetryCount());
    }

    private void _testDataNotSet(String avoidParam, String expActionErrorCode) throws Exception {
        String workflowPath = this.getTestCaseFileUri("workflow.xml");
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        DagEngine engine = new DagEngine("u");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", workflowPath);
        conf.set("user.name", TestActionErrors.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("external-status", "ok");
        conf.set("signal-value", "based_on_action_status");
        conf.set(avoidParam, "true");
        final String jobId = engine.submitJob((Configuration)conf, true);
        final WorkflowStore store = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        store.beginTrx();
        Thread.sleep(2000L);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJobBean bean = store.getWorkflow(jobId, false);
                return bean.getWorkflowInstance().getStatus() == WorkflowInstance.Status.FAILED;
            }
        });
        store.commitTrx();
        store.closeTrx();
        WorkflowStore store2 = ((WorkflowStoreService)Services.get().get(WorkflowStoreService.class)).create();
        store2.beginTrx();
        TestActionErrors.assertEquals((Object)WorkflowInstance.Status.FAILED, (Object)store2.getWorkflow(jobId, false).getWorkflowInstance().getStatus());
        TestActionErrors.assertEquals((Object)WorkflowJob.Status.FAILED, (Object)engine.getJob(jobId).getStatus());
        List actions = store2.getActionsForWorkflow(jobId, false);
        WorkflowActionBean action = null;
        for (WorkflowActionBean bean : actions) {
            if (!bean.getType().equals("test")) continue;
            action = bean;
            break;
        }
        TestActionErrors.assertNotNull(action);
        TestActionErrors.assertEquals((String)expActionErrorCode, (String)action.getErrorCode());
        store2.commitTrx();
        store2.closeTrx();
    }
}

