/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ForTestingActionExecutor;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.StartXCommand;
import org.apache.oozie.command.wf.SubmitXCommand;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionsGetForJobJPAExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.ExtendedCallableQueueService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;

public class TestActionUserRetry
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.service.SchemaService.wf.ext.schemas", "wf-ext-schema.xsd");
        this.setSystemProperty("oozie.service.LiteWorkflowStoreService.user.retry.error.code.ext", "TEST_ERROR");
        this.setSystemProperty("oozie.services.ext", ExtendedCallableQueueService.class.getName());
        this.services = new Services();
        this.services.init();
        ((ActionService)this.services.get(ActionService.class)).registerAndInitExecutor(ForTestingActionExecutor.class);
        ConfigurationService.setBoolean((String)"oozie.workflow.parallel.fork.action.start", (boolean)true);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testUserRetry() throws JPAExecutorException, IOException, CommandException {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns=\"uri:oozie:workflow:0.3\" name=\"wf-fork\"><start to=\"fork1\"/><fork name=\"fork1\"><path start=\"action1\"/><path start=\"action2\"/></fork><action name=\"action1\" retry-max=\"2\" retry-interval=\"0\"><test xmlns=\"uri:test\"><signal-value>${wf:conf('signal-value')}</signal-value><external-status>${wf:conf('external-status')}</external-status> <error>${wf:conf('error')}</error><avoid-set-execution-data>${wf:conf('avoid-set-execution-data')}</avoid-set-execution-data><avoid-set-end-data>${wf:conf('avoid-set-end-data')}</avoid-set-end-data><running-mode>${wf:conf('running-mode')}</running-mode></test><ok to=\"join1\"/><error to=\"kill\"/></action><action name=\"action2\"><fs></fs><ok to=\"join1\"/><error to=\"kill\"/></action><join name=\"join1\" to=\"end\"/><kill name=\"kill\"><message>killed</message></kill><end name=\"end\"/></workflow-app>";
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestActionUserRetry.getTestUser());
        conf.set("error", "start.error");
        conf.set("external-status", "error");
        conf.set("signal-value", "based_on_action_status");
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        new StartXCommand(jobId).call();
        final WorkflowActionsGetForJobJPAExecutor actionsGetExecutor = new WorkflowActionsGetForJobJPAExecutor(jobId);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        this.waitFor(20000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                List actions = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
                WorkflowActionBean action = null;
                for (WorkflowActionBean bean : actions) {
                    if (!bean.getType().equals("test")) continue;
                    action = bean;
                    break;
                }
                return action != null && action.getUserRetryCount() == 2;
            }
        });
        List actions = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
        WorkflowActionBean action = null;
        for (WorkflowActionBean bean : actions) {
            if (!bean.getType().equals("test")) continue;
            action = bean;
            break;
        }
        TestActionUserRetry.assertNotNull(action);
        TestActionUserRetry.assertEquals((int)2, (int)action.getUserRetryCount());
    }

    public void testUserRetryPolicy() throws JPAExecutorException, IOException, CommandException {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns=\"uri:oozie:workflow:0.5\" name=\"wf-fork\"><start to=\"fork1\"/><fork name=\"fork1\"><path start=\"action1\"/><path start=\"action2\"/></fork><action name=\"action1\" retry-max=\"2\" retry-interval=\"1\" retry-policy=\"exponential\"><test xmlns=\"uri:test\"><signal-value>${wf:conf('signal-value')}</signal-value><external-status>${wf:conf('external-status')}</external-status> <error>${wf:conf('error')}</error><avoid-set-execution-data>${wf:conf('avoid-set-execution-data')}</avoid-set-execution-data><avoid-set-end-data>${wf:conf('avoid-set-end-data')}</avoid-set-end-data><running-mode>${wf:conf('running-mode')}</running-mode></test><ok to=\"join1\"/><error to=\"kill\"/></action><action name=\"action2\"><fs></fs><ok to=\"join1\"/><error to=\"kill\"/></action><join name=\"join1\" to=\"end\"/><kill name=\"kill\"><message>killed</message></kill><end name=\"end\"/></workflow-app>";
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestActionUserRetry.getTestUser());
        conf.set("error", "start.error");
        conf.set("external-status", "error");
        conf.set("signal-value", "based_on_action_status");
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        String jobId = (String)sc.call();
        new StartXCommand(jobId).call();
        final WorkflowActionsGetForJobJPAExecutor actionsGetExecutor = new WorkflowActionsGetForJobJPAExecutor(jobId);
        final JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        int timeout = 180000;
        this.waitFor(timeout, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                List actions = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
                WorkflowActionBean action = null;
                for (WorkflowActionBean bean : actions) {
                    if (!bean.getType().equals("test")) continue;
                    action = bean;
                    break;
                }
                return action != null && action.getUserRetryCount() == 2;
            }
        });
        List actions = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
        WorkflowActionBean action = null;
        for (WorkflowActionBean bean : actions) {
            if (!bean.getType().equals("test")) continue;
            action = bean;
            break;
        }
        TestActionUserRetry.assertNotNull(action);
        TestActionUserRetry.assertEquals((int)2, (int)action.getUserRetryCount());
    }

    private void writeToFile(String appXml, String appPath) throws IOException {
        File wf = new File(URI.create(appPath));
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(wf));
            out.println(appXml);
        }
    }
}

