/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.ForTestingActionExecutor;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.StartXCommand;
import org.apache.oozie.command.wf.SubmitXCommand;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.ExtendedCallableQueueService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XConfiguration;

public class TestForkedActionStartXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.service.SchemaService.wf.ext.schemas", "wf-ext-schema.xsd");
        this.setSystemProperty("oozie.service.LiteWorkflowStoreService.user.retry.error.code.ext", "TEST_ERROR");
        this.setSystemProperty("oozie.services.ext", ExtendedCallableQueueService.class.getName());
        this.services = new Services();
        this.services.init();
        ((ActionService)this.services.get(ActionService.class)).registerAndInitExecutor(ForTestingActionExecutor.class);
        ConfigurationService.setBoolean((String)"oozie.workflow.parallel.fork.action.start", (boolean)true);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testWfSuccess() throws Exception {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns=\"uri:oozie:workflow:0.4\" name=\"wf-fork\"><start to=\"fork1\"/><fork name=\"fork1\"><path start=\"action1\"/><path start=\"action2\"/></fork><action name=\"action1\"><fs></fs><ok to=\"join1\"/><error to=\"kill\"/></action><action name=\"action2\"><fs></fs><ok to=\"join1\"/><error to=\"kill\"/></action><join name=\"join1\" to=\"end\"/><kill name=\"kill\"><message>killed</message></kill><end name=\"end\"/></workflow-app>";
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestForkedActionStartXCommand.getTestUser());
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        final String jobId = (String)sc.call();
        new StartXCommand(jobId).call();
        this.waitFor(20000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return ((WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{jobId})).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestForkedActionStartXCommand.assertEquals((Object)((WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{jobId})).getStatus(), (Object)WorkflowJob.Status.SUCCEEDED);
    }

    public void testWfFailure() throws Exception {
        XConfiguration conf = new XConfiguration();
        String workflowUri = this.getTestCaseFileUri("workflow.xml");
        String appXml = "<workflow-app xmlns=\"uri:oozie:workflow:0.4\" name=\"wf-fork\"><start to=\"fork1\"/><fork name=\"fork1\"><path start=\"action1\"/><path start=\"action2\"/></fork><action name=\"action1\"><fs></fs><ok to=\"kill\"/><error to=\"kill\"/></action><action name=\"action2\"><fs></fs><ok to=\"join1\"/><error to=\"kill\"/></action><join name=\"join1\" to=\"end\"/><kill name=\"kill\"><message>killed</message></kill><end name=\"end\"/></workflow-app>";
        this.writeToFile(appXml, workflowUri);
        conf.set("oozie.wf.application.path", workflowUri);
        conf.set("user.name", TestForkedActionStartXCommand.getTestUser());
        SubmitXCommand sc = new SubmitXCommand((Configuration)conf);
        final String jobId = (String)sc.call();
        new StartXCommand(jobId).call();
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return ((WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{jobId})).getStatus() == WorkflowJob.Status.KILLED;
            }
        });
        TestForkedActionStartXCommand.assertEquals((Object)((WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{jobId})).getStatus(), (Object)WorkflowJob.Status.KILLED);
    }

    private void writeToFile(String appXml, String appPath) throws IOException {
        File wf = new File(URI.create(appPath));
        try (PrintWriter out = null;){
            out = new PrintWriter(new FileWriter(wf));
            out.println(appXml);
        }
    }
}

