/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Properties;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.test.XTestCase;

public class TestLastModified
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozielastmod.log", "/tmp/oozielastmod.log");
    }

    public void TestLastModifiedInitDestroy() throws Exception {
        try {
            LocalOozie.stop();
            LocalOozie.getClient();
            TestLastModified.fail();
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (Exception ex) {
            TestLastModified.fail();
        }
        try {
            LocalOozie.start();
            LocalOozie.start();
            TestLastModified.fail();
        }
        catch (IllegalStateException ex) {
        }
        catch (Exception ex) {
            TestLastModified.fail();
        }
        try {
            LocalOozie.stop();
            LocalOozie.start();
            OozieClient wc = LocalOozie.getClient();
            TestLastModified.assertNotNull((Object)wc);
            TestLastModified.assertEquals((String)"localoozie", (String)wc.getOozieUrl());
        }
        finally {
            LocalOozie.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testWorkflowRun() throws Exception {
        String wfApp = "<workflow-app xmlns='uri:oozie:workflow:0.1' name='test-wf'>    <start to='end'/>    <end name='end'/></workflow-app>";
        FileSystem fs = this.getFileSystem();
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        fs.mkdirs(appPath);
        fs.mkdirs(new Path(appPath, "lib"));
        fs.mkdirs(new Path("input-data"));
        OutputStreamWriter inputWriter = new OutputStreamWriter((OutputStream)fs.create(new Path("input-data/data1.txt")));
        inputWriter.write("Hello. This is my input data set.");
        ((Writer)inputWriter).close();
        Path workflowPath = new Path(appPath, "workflow.xml");
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(workflowPath));
        writer.write(wfApp);
        ((Writer)writer).close();
        try {
            LocalOozie.start();
            final OozieClient wc = LocalOozie.getClient();
            Properties conf = wc.createConfiguration();
            conf.setProperty("oozie.wf.application.path", workflowPath.toString());
            conf.setProperty("user.name", TestLastModified.getTestUser());
            conf.setProperty("group.name", TestLastModified.getTestGroup());
            final String jobId = wc.submit(conf);
            TestLastModified.assertNotNull((Object)jobId);
            WorkflowJob wf = wc.getJobInfo(jobId);
            TestLastModified.assertNotNull((Object)wf);
            TestLastModified.assertEquals((Object)WorkflowJob.Status.PREP, (Object)wf.getStatus());
            boolean dateTest = wf.getLastModifiedTime().compareTo(wf.getCreatedTime()) >= 0;
            TestLastModified.assertEquals((boolean)true, (boolean)dateTest);
            wc.start(jobId);
            wf = wc.getJobInfo(jobId);
            Date lastModTime = wf.getLastModifiedTime();
            wc.suspend(jobId);
            wf = wc.getJobInfo(jobId);
            dateTest = wf.getLastModifiedTime().compareTo(lastModTime) >= 0;
            TestLastModified.assertEquals((boolean)true, (boolean)dateTest);
            lastModTime = wf.getLastModifiedTime();
            this.sleep(1000);
            wc.resume(jobId);
            wf = wc.getJobInfo(jobId);
            dateTest = wf.getLastModifiedTime().compareTo(lastModTime) >= 0;
            TestLastModified.assertEquals((boolean)true, (boolean)dateTest);
            this.waitFor(600000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    WorkflowJob wf = wc.getJobInfo(jobId);
                    return wf.getStatus() == WorkflowJob.Status.SUCCEEDED;
                }
            });
            wf = wc.getJobInfo(jobId);
            TestLastModified.assertNotNull((Object)wf);
            TestLastModified.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wf.getStatus());
            dateTest = wf.getLastModifiedTime().compareTo(wf.getEndTime()) >= 0;
            TestLastModified.assertEquals((boolean)true, (boolean)dateTest);
        }
        finally {
            LocalOozie.stop();
        }
    }
}

