/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.coord.CoordActionStartXCommand;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.SchemaService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;

public class TestReRunXCommand
extends XDataTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.log4j.file", "oozie-log4j.properties");
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        super.tearDown();
    }

    public void testRerun() throws IOException, OozieClientException {
        Reader reader = IOUtils.getResourceAsReader((String)"rerun-wf.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        Path path = this.getFsTestCaseDir();
        this.getFileSystem().create(new Path(path, "p2"));
        final OozieClient wfClient = LocalOozie.getClient();
        Properties conf = wfClient.createConfiguration();
        conf.setProperty("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        conf.setProperty("user.name", TestReRunXCommand.getTestUser());
        conf.setProperty("nnbase", path.toString());
        conf.setProperty("base", path.toUri().getPath());
        final String jobId1 = wfClient.submit(conf);
        wfClient.start(jobId1);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.KILLED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfClient.getJobInfo(jobId1).getStatus());
        conf.setProperty("oozie.wf.rerun.skip.nodes", "fs1,fs2,dec3");
        boolean failed = false;
        try {
            wfClient.reRun(jobId1, conf);
        }
        catch (OozieClientException e) {
            failed = true;
            TestReRunXCommand.assertTrue((boolean)e.getCause().getMessage().contains(ErrorCode.E0807.toString()));
        }
        TestReRunXCommand.assertEquals((boolean)true, (boolean)failed);
        this.getFileSystem().delete(new Path(path, "p2"), true);
        conf.setProperty("oozie.wf.rerun.skip.nodes", "fs1");
        wfClient.reRun(jobId1, conf);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfClient.getJobInfo(jobId1).getStatus());
    }

    public void testRerunFork() throws Exception {
        ConfigurationService.setBoolean((String)"oozie.workflow.parallel.fork.action.start", (boolean)true);
        this._testRerunFork();
        ConfigurationService.setBoolean((String)"oozie.workflow.parallel.fork.action.start", (boolean)false);
        this._testRerunFork();
    }

    public void _testRerunFork() throws Exception {
        Services.get().setService(ActionService.class);
        Services.get().getConf().set("oozie.service.SchemaService.wf.ext.schemas", "shell-action-0.3.xsd");
        Services.get().setService(SchemaService.class);
        Reader reader = IOUtils.getResourceAsReader((String)"rerun-wf-fork.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        final OozieClient wfClient = LocalOozie.getClient();
        Properties conf = wfClient.createConfiguration();
        conf.setProperty("nameNode", this.getNameNodeUri());
        conf.setProperty("jobTracker", this.getJobTrackerUri());
        conf.setProperty("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        conf.setProperty("user.name", TestReRunXCommand.getTestUser());
        conf.setProperty("cmd4", "echo1");
        final String jobId1 = wfClient.submit(conf);
        wfClient.start(jobId1);
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.KILLED;
            }
        });
        wfClient.kill(jobId1);
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfClient.getJobInfo(jobId1).getStatus());
        List actions = wfClient.getJobInfo(jobId1).getActions();
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)((WorkflowAction)actions.get(1)).getStatus());
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)((WorkflowAction)actions.get(2)).getStatus());
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)((WorkflowAction)actions.get(3)).getStatus());
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)((WorkflowAction)actions.get(4)).getStatus());
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)((WorkflowAction)actions.get(5)).getStatus());
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.ERROR, (Object)((WorkflowAction)actions.get(6)).getStatus());
        conf.setProperty("oozie.wf.rerun.failnodes", "true");
        conf.setProperty("cmd4", "echo");
        wfClient.reRun(jobId1, conf);
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfClient.getJobInfo(jobId1).getStatus());
        actions = wfClient.getJobInfo(jobId1).getActions();
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)((WorkflowAction)actions.get(1)).getStatus());
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)((WorkflowAction)actions.get(2)).getStatus());
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)((WorkflowAction)actions.get(3)).getStatus());
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)((WorkflowAction)actions.get(4)).getStatus());
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)((WorkflowAction)actions.get(5)).getStatus());
        TestReRunXCommand.assertEquals((Object)WorkflowAction.Status.OK, (Object)((WorkflowAction)actions.get(6)).getStatus());
    }

    public void testRerunVariableSub() throws IOException, OozieClientException {
        Reader reader = IOUtils.getResourceAsReader((String)"rerun-varsub-wf.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        Path path = this.getFsTestCaseDir();
        final OozieClient wfClient = LocalOozie.getClient();
        Properties conf = wfClient.createConfiguration();
        conf.setProperty("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        conf.setProperty("user.name", TestReRunXCommand.getTestUser());
        conf.setProperty("nnbase", path.toString());
        conf.setProperty("base", conf.getProperty("nnbase"));
        conf.setProperty("srcDir", "${base}/p1");
        conf.setProperty("dstDir", "${base}/p2");
        final String jobId1 = wfClient.submit(conf);
        wfClient.start(jobId1);
        wfClient.kill(jobId1);
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfClient.getJobInfo(jobId1).getStatus());
        this.getFileSystem().delete(new Path(path, "p2"), true);
        conf.setProperty("oozie.wf.rerun.failnodes", "false");
        wfClient.reRun(jobId1, conf);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfClient.getJobInfo(jobId1).getStatus());
    }

    public void testRerunFromFailNodes() throws IOException, OozieClientException {
        Reader reader = IOUtils.getResourceAsReader((String)"rerun-wf.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        Path path = this.getFsTestCaseDir();
        this.getFileSystem().create(new Path(path, "p2"));
        final OozieClient wfClient = LocalOozie.getClient();
        Properties conf = wfClient.createConfiguration();
        conf.setProperty("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        conf.setProperty("user.name", TestReRunXCommand.getTestUser());
        conf.setProperty("nnbase", path.toString());
        conf.setProperty("base", path.toUri().getPath());
        final String jobId1 = wfClient.submit(conf);
        wfClient.start(jobId1);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.KILLED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfClient.getJobInfo(jobId1).getStatus());
        this.getFileSystem().delete(new Path(path, "p2"), true);
        conf.setProperty("oozie.wf.rerun.failnodes", "true");
        wfClient.reRun(jobId1, conf);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfClient.getJobInfo(jobId1).getStatus());
    }

    public void testRedeploy() throws IOException, OozieClientException, InterruptedException {
        Reader reader = IOUtils.getResourceAsReader((String)"rerun-elerr-wf.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        final OozieClient wfClient = LocalOozie.getClient();
        Properties conf = wfClient.createConfiguration();
        conf.setProperty("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        conf.setProperty("user.name", TestReRunXCommand.getTestUser());
        conf.setProperty("inPath", this.getFsTestCaseDir().toString());
        conf.setProperty("checkDir", this.getFsTestCaseDir().toString() + "/check");
        final String jobId1 = wfClient.submit(conf);
        wfClient.start(jobId1);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.FAILED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.FAILED, (Object)wfClient.getJobInfo(jobId1).getStatus());
        reader = IOUtils.getResourceAsReader((String)"rerun-el-wf.xml", (int)-1);
        writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        this.sleep(5000);
        conf.setProperty("oozie.wf.rerun.skip.nodes", "hdfs11");
        conf.setProperty("WF_NAME", "wf_test");
        conf.setProperty("FEED_NAME", "feed_test");
        wfClient.reRun(jobId1, conf);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId1).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfClient.getJobInfo(jobId1).getStatus());
        TestReRunXCommand.assertEquals((String)"wf_test-feed_test", (String)wfClient.getJobInfo(jobId1).getAppName());
    }

    public void testRerunWithExistingConf() throws IOException, OozieClientException {
        Reader reader = IOUtils.getResourceAsReader((String)"rerun-wf.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        Path path = this.getFsTestCaseDir();
        this.getFileSystem().create(new Path(path, "p2"));
        final OozieClient wfClient = LocalOozie.getClient();
        Properties conf = wfClient.createConfiguration();
        conf.setProperty("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        conf.setProperty("user.name", TestReRunXCommand.getTestUser());
        conf.setProperty("nnbase", path.toString());
        conf.setProperty("base", path.toUri().getPath());
        Properties newConf = wfClient.createConfiguration();
        newConf.setProperty("base", path.toUri().getPath());
        final String jobId = wfClient.submit(conf);
        wfClient.start(jobId);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId).getStatus() == WorkflowJob.Status.KILLED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.KILLED, (Object)wfClient.getJobInfo(jobId).getStatus());
        try {
            wfClient.reRun(jobId, newConf);
        }
        catch (OozieClientException e) {
            TestReRunXCommand.assertTrue((boolean)e.getCause().getMessage().contains(ErrorCode.E0401.toString()));
        }
        newConf = wfClient.createConfiguration();
        this.getFileSystem().delete(new Path(path, "p2"), true);
        newConf.setProperty("oozie.wf.rerun.skip.nodes", "fs1");
        wfClient.reRun(jobId, newConf);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(jobId).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfClient.getJobInfo(jobId).getStatus());
    }

    public void testRerunWithExistingCoodConf() throws Exception {
        final OozieClient wfClient = LocalOozie.getClient();
        Date start = DateUtils.parseDateOozieTZ((String)"2009-12-15T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-12-16T01:00Z");
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUBMITTED, "coord-action-start-escape-strings.xml", 0);
        String actionId = action.getId();
        new CoordActionStartXCommand(actionId, TestReRunXCommand.getTestUser(), "myapp", "myjob").call();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
        if (action.getStatus() == CoordinatorAction.Status.SUBMITTED) {
            TestReRunXCommand.fail((String)("CoordActionStartCommand didn't work because the status for action id" + actionId + " is :" + action.getStatus() + " expected to be NOT SUBMITTED (i.e. RUNNING)"));
        }
        final String wfId = action.getExternalId();
        wfClient.kill(wfId);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(wfId).getStatus() == WorkflowJob.Status.KILLED;
            }
        });
        Properties newConf = wfClient.createConfiguration();
        newConf.setProperty("oozie.wf.rerun.failnodes", "true");
        wfClient.reRun(wfId, newConf);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(wfId).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfClient.getJobInfo(wfId).getStatus());
    }

    public void testRerunDisableForChild() throws Exception {
        final OozieClient wfClient = LocalOozie.getClient();
        Date start = DateUtils.parseDateOozieTZ((String)"2009-12-15T01:00Z");
        Date end = DateUtils.parseDateOozieTZ((String)"2009-12-16T01:00Z");
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 1);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(coordJob.getId(), 1, CoordinatorAction.Status.SUBMITTED, "coord-action-start-escape-strings.xml", 0);
        String actionId = action.getId();
        new CoordActionStartXCommand(actionId, TestReRunXCommand.getTestUser(), "myapp", "myjob").call();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(actionId));
        if (action.getStatus() == CoordinatorAction.Status.SUBMITTED) {
            TestReRunXCommand.fail((String)("CoordActionStartCommand didn't work because the status for action id" + actionId + " is :" + action.getStatus() + " expected to be NOT SUBMITTED (i.e. RUNNING)"));
        }
        final String wfId = action.getExternalId();
        wfClient.kill(wfId);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(wfId).getStatus() == WorkflowJob.Status.KILLED;
            }
        });
        Properties newConf = wfClient.createConfiguration();
        newConf.setProperty("oozie.wf.rerun.failnodes", "true");
        Services.get().getConf().setBoolean("oozie.wf.rerun.disablechild", true);
        try {
            wfClient.reRun(wfId, newConf);
            TestReRunXCommand.fail((String)("OozieClientException should have been thrown (" + ErrorCode.E0755 + " Rerun is not allowed through child workflow, please re-run through the parent)"));
        }
        catch (OozieClientException ex) {
            TestReRunXCommand.assertEquals((String)ErrorCode.E0755.toString(), (String)ex.getErrorCode());
        }
        Services.get().getConf().setBoolean("oozie.wf.rerun.disablechild", false);
        wfClient.reRun(wfId, newConf);
        this.waitFor(15000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return wfClient.getJobInfo(wfId).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        TestReRunXCommand.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfClient.getJobInfo(wfId).getStatus());
    }
}

