/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.log4j.Appender;
import org.apache.log4j.Layout;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.apache.log4j.WriterAppender;
import org.apache.oozie.DagEngine;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.command.wf.SignalXCommand;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;

public class TestSignalXCommand
extends XDataTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        ConfigurationService.setBoolean((String)"oozie.validate.ForkJoin", (boolean)false);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testJoinFail() throws Exception {
        ConfigurationService.setBoolean((String)"oozie.workflow.parallel.fork.action.start", (boolean)true);
        this._testJoinFail();
        ConfigurationService.setBoolean((String)"oozie.workflow.parallel.fork.action.start", (boolean)false);
        this._testJoinFail();
    }

    public void testSuspendPoints() throws Exception {
        ConfigurationService.setBoolean((String)"oozie.workflow.parallel.fork.action.start", (boolean)true);
        this._testSuspendPoints();
        this.services.destroy();
        this.services = new Services();
        this.services.init();
        ConfigurationService.setBoolean((String)"oozie.workflow.parallel.fork.action.start", (boolean)false);
        this._testSuspendPoints();
    }

    public void testSuspendPointsAll() throws Exception {
        ConfigurationService.setBoolean((String)"oozie.workflow.parallel.fork.action.start", (boolean)true);
        this._testSuspendPointsAll();
        this.services.destroy();
        this.services = new Services();
        this.services.init();
        ConfigurationService.setBoolean((String)"oozie.workflow.parallel.fork.action.start", (boolean)false);
        this._testSuspendPointsAll();
    }

    public void _testJoinFail() throws Exception {
        Logger logger = Logger.getLogger(SignalXCommand.class);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        SimpleLayout layout = new SimpleLayout();
        WriterAppender appender = new WriterAppender((Layout)layout, (OutputStream)out);
        logger.addAppender((Appender)appender);
        FileSystem fs = this.getFileSystem();
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        fs.mkdirs(appPath);
        Reader reader = IOUtils.getResourceAsReader((String)"wf-fork.xml", (int)-1);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(appPath, "workflow.xml")));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        ((Writer)writer).close();
        reader.close();
        DagEngine engine = new DagEngine("u");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", new Path(appPath, "workflow.xml").toString());
        conf.set("user.name", TestSignalXCommand.getTestUser());
        String jobId = engine.submitJob((Configuration)conf, false);
        TestSignalXCommand.assertNotNull((Object)jobId);
        engine.start(jobId);
        Thread.sleep(2000L);
        TestSignalXCommand.assertFalse((boolean)out.toString().contains("EntityExistsException"));
    }

    public void _testSuspendPoints() throws Exception {
        this.services.destroy();
        LocalOozie.start();
        FileSystem fs = this.getFileSystem();
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        fs.mkdirs(appPath);
        Reader reader = IOUtils.getResourceAsReader((String)"wf-suspendpoints.xml", (int)-1);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(appPath, "workflow.xml")));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        ((Writer)writer).close();
        reader.close();
        OozieClient oc = LocalOozie.getClient();
        Properties conf = oc.createConfiguration();
        conf.setProperty("oozie.wf.application.path", new Path(appPath, "workflow.xml").toString());
        conf.setProperty("user.name", TestSignalXCommand.getTestUser());
        conf.setProperty("oozie.suspend.on.nodes", "action1,nonexistant_action_name,decision1, action3,join1 ,fork1,action4b");
        String jobId = oc.submit(conf);
        TestSignalXCommand.assertNotNull((Object)jobId);
        WorkflowJob wf = oc.getJobInfo(jobId);
        TestSignalXCommand.assertEquals((Object)WorkflowJob.Status.PREP, (Object)wf.getStatus());
        long beforeStart = System.currentTimeMillis();
        oc.start(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"action1"}, new String[]{":start:"});
        long afterStart = System.currentTimeMillis();
        WorkflowJob wf1 = oc.getJobInfo(jobId);
        for (WorkflowAction action : wf1.getActions()) {
            WorkflowActionBean bean = (WorkflowActionBean)action;
            TestSignalXCommand.assertNotNull((Object)bean.getCreatedTime());
            TestSignalXCommand.assertTrue((bean.getCreatedTime().getTime() > beforeStart && bean.getCreatedTime().getTime() < afterStart ? 1 : 0) != 0);
        }
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"decision1"}, new String[]{":start:", "action1", "action2"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"action3"}, new String[]{":start:", "action1", "action2", "decision1"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"fork1"}, new String[]{":start:", "action1", "action2", "decision1", "action3"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"action4a", "action4b", "action4c"}, new String[]{":start:", "action1", "action2", "decision1", "action3", "fork1"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"join1"}, new String[]{":start:", "action1", "action2", "decision1", "action3", "fork1", "action4a", "action4b", "action4c"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUCCEEDED, new String[0], new String[]{":start:", "action1", "action2", "decision1", "action3", "fork1", "action4a", "action4b", "action4c", "join1", "end"});
        LocalOozie.stop();
    }

    public void _testSuspendPointsAll() throws Exception {
        this.services.destroy();
        LocalOozie.start();
        FileSystem fs = this.getFileSystem();
        Path appPath = new Path(this.getFsTestCaseDir(), "app");
        fs.mkdirs(appPath);
        Reader reader = IOUtils.getResourceAsReader((String)"wf-suspendpoints.xml", (int)-1);
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fs.create(new Path(appPath, "workflow.xml")));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        ((Writer)writer).close();
        reader.close();
        OozieClient oc = LocalOozie.getClient();
        Properties conf = oc.createConfiguration();
        conf.setProperty("oozie.wf.application.path", new Path(appPath, "workflow.xml").toString());
        conf.setProperty("user.name", TestSignalXCommand.getTestUser());
        conf.setProperty("oozie.suspend.on.nodes", "*");
        String jobId = oc.submit(conf);
        TestSignalXCommand.assertNotNull((Object)jobId);
        WorkflowJob wf = oc.getJobInfo(jobId);
        TestSignalXCommand.assertEquals((Object)WorkflowJob.Status.PREP, (Object)wf.getStatus());
        oc.start(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"action1"}, new String[]{":start:"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"action2"}, new String[]{":start:", "action1"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"decision1"}, new String[]{":start:", "action1", "action2"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"action3"}, new String[]{":start:", "action1", "action2", "decision1"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"fork1"}, new String[]{":start:", "action1", "action2", "decision1", "action3"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"action4a", "action4b", "action4c"}, new String[]{":start:", "action1", "action2", "decision1", "action3", "fork1"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"join1"}, new String[]{":start:", "action1", "action2", "decision1", "action3", "fork1", "action4a", "action4b", "action4c"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUSPENDED, new String[]{"end"}, new String[]{":start:", "action1", "action2", "decision1", "action3", "fork1", "action4a", "action4b", "action4c", "join1"});
        oc.resume(jobId);
        this.checkSuspendActions(wf, oc, jobId, WorkflowJob.Status.SUCCEEDED, new String[0], new String[]{":start:", "action1", "action2", "decision1", "action3", "fork1", "action4a", "action4b", "action4c", "join1", "end"});
        LocalOozie.stop();
    }

    private void checkSuspendActions(WorkflowJob wf, final OozieClient oc, final String jobId, final WorkflowJob.Status status, String[] prepActions, String[] okActions) throws Exception {
        this.waitFor(30000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                WorkflowJob wf = oc.getJobInfo(jobId);
                return wf.getStatus() == status;
            }
        });
        wf = oc.getJobInfo(jobId);
        TestSignalXCommand.assertEquals((Object)status, (Object)wf.getStatus());
        int numPrep = 0;
        int numOK = 0;
        for (WorkflowAction action : wf.getActions()) {
            boolean checked = false;
            for (String name : prepActions) {
                if (checked || !name.equals(action.getName())) continue;
                TestSignalXCommand.assertEquals((String)("action [" + action.getName() + "] had incorrect status"), (Object)WorkflowAction.Status.PREP, (Object)action.getStatus());
                ++numPrep;
                checked = true;
            }
            if (!checked) {
                for (String name : okActions) {
                    if (checked || !name.equals(action.getName())) continue;
                    TestSignalXCommand.assertEquals((String)("action [" + action.getName() + "] had incorrect status"), (Object)WorkflowAction.Status.OK, (Object)action.getStatus());
                    ++numOK;
                    checked = true;
                }
            }
            if (checked) continue;
            TestSignalXCommand.fail((String)("Unexpected action [" + action.getName() + "] with status [" + action.getStatus() + "]"));
        }
        TestSignalXCommand.assertEquals((int)prepActions.length, (int)numPrep);
        TestSignalXCommand.assertEquals((int)okActions.length, (int)numOK);
    }
}

