/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.action.hadoop.MapReduceMain;
import org.apache.oozie.command.wf.SubmitSqoopXCommand;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class TestSubmitSqoopXCommand
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.log4j.file", "oozie-log4j.properties");
        LocalOozie.start();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        super.tearDown();
    }

    public void testWFXmlGeneration() throws Exception {
        Configuration conf = new Configuration();
        conf.set("mapred.job.tracker", "jobtracker");
        conf.set("fs.default.name", "namenode");
        conf.set("oozie.libpath", "libpath");
        conf.set("oozie.sqoop.command", "import\n--connect\njdbc:mysql://localhost:3306/oozie");
        String sqoopArgsStr = "-Da=aaa -Db=bbb";
        String[] args = sqoopArgsStr.split(" ");
        MapReduceMain.setStrings((Configuration)conf, (String)"oozie.sqoop.options", (String[])args);
        SubmitSqoopXCommand submitSqoopCmd = new SubmitSqoopXCommand(conf);
        String xml = submitSqoopCmd.getWorkflowXml(conf);
        XLog.getLog(((Object)((Object)this)).getClass()).info((Object)("xml = " + xml));
        StringBuilder sb = new StringBuilder();
        sb.append("<workflow-app xmlns=\"uri:oozie:workflow:0.2\" name=\"oozie-sqoop\">");
        sb.append("<start to=\"sqoop1\" />");
        sb.append("<action name=\"sqoop1\">");
        sb.append("<sqoop xmlns=\"uri:oozie:sqoop-action:0.4\">");
        sb.append("<job-tracker>jobtracker</job-tracker>");
        sb.append("<name-node>namenode</name-node>");
        sb.append("<configuration>");
        sb.append("<property>");
        sb.append("<name>a</name>");
        sb.append("<value>aaa</value>");
        sb.append("</property>");
        sb.append("<property>");
        sb.append("<name>b</name>");
        sb.append("<value>bbb</value>");
        sb.append("</property>");
        sb.append("</configuration>");
        sb.append("<arg>import</arg>");
        sb.append("<arg>--connect</arg>");
        sb.append("<arg>jdbc:mysql://localhost:3306/oozie</arg>");
        sb.append("</sqoop>");
        sb.append("<ok to=\"end\" />");
        sb.append("<error to=\"fail\" />");
        sb.append("</action>");
        sb.append("<kill name=\"fail\">");
        sb.append("<message>sqoop failed, error message[${wf:errorMessage(wf:lastErrorNode())}]</message>");
        sb.append("</kill>");
        sb.append("<end name=\"end\" />");
        sb.append("</workflow-app>");
        Element root = XmlUtils.parseXml((String)sb.toString());
        String reference = XmlUtils.prettyPrint((Element)root).toString();
        XLog.getLog(((Object)((Object)this)).getClass()).info((Object)("reference xml = " + reference));
        TestSubmitSqoopXCommand.assertTrue((boolean)xml.equals(reference));
    }
}

