/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord;

import java.io.Reader;
import java.io.StringReader;
import java.util.Date;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.coord.CoordELEvaluator;
import org.apache.oozie.coord.CoordELFunctions;
import org.apache.oozie.coord.SyncCoordAction;
import org.apache.oozie.coord.TimeUnit;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.ELEvaluator;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;

public class TestCoordELEvaluator
extends XTestCase {
    @Override
    public void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        if (Services.get() != null) {
            Services.get().destroy();
        }
        super.tearDown();
    }

    public void testCreateFreqELValuator() throws Exception {
        XConfiguration conf = new XConfiguration((Reader)new StringReader(this.getConfString()));
        ELEvaluator eval = CoordELEvaluator.createELEvaluatorForGroup((Configuration)conf, (String)"coord-job-submit-freq");
        String expr = "<coordinator-app name=\"mycoordinator-app\" start=\"${start}\" end=\"${end}\" frequency=\"${coord:hours(12)}\"><data-in name=\"A\" dataset=\"a\"></data-in>";
        String reply = expr.replace("${start}", conf.get("start")).replace("${end}", conf.get("end")).replace("${coord:hours(12)}", "720");
        TestCoordELEvaluator.assertEquals((String)reply, (String)CoordELFunctions.evalAndWrap((ELEvaluator)eval, (String)expr));
        expr = "<coordinator-app name=\"mycoordinator-app\" start=\"${start}\" end=\"${end}\" frequency=\"${coord:days(7)}\"><data-in name=\"A\" dataset=\"a\"></data-in>";
        reply = expr.replace("${start}", conf.get("start")).replace("${end}", conf.get("end")).replace("${coord:days(7)}", "7");
        TestCoordELEvaluator.assertEquals((String)reply, (String)CoordELFunctions.evalAndWrap((ELEvaluator)eval, (String)expr));
        expr = "<coordinator-app name=\"mycoordinator-app\" start=\"${start}\" end=\"${end}\" frequency=\"${coord:months(1)}\"><data-in name=\"A\" dataset=\"a\"></data-in>";
        reply = expr.replace("${start}", conf.get("start")).replace("${end}", conf.get("end")).replace("${coord:months(1)}", "1");
        TestCoordELEvaluator.assertEquals((String)reply, (String)CoordELFunctions.evalAndWrap((ELEvaluator)eval, (String)expr));
        expr = "frequency=${coord:days(2)}";
        expr = "frequency=60";
        CoordELFunctions.evalAndWrap((ELEvaluator)eval, (String)expr);
        expr = "frequency=${coord:daysInMonth(2)}";
        try {
            CoordELFunctions.evalAndWrap((ELEvaluator)eval, (String)expr);
            TestCoordELEvaluator.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        expr = "frequency=${coord:hoursInDay(2)}";
        try {
            CoordELFunctions.evalAndWrap((ELEvaluator)eval, (String)expr);
            TestCoordELEvaluator.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        expr = "frequency=${coord:tzOffset()}";
        try {
            CoordELFunctions.evalAndWrap((ELEvaluator)eval, (String)expr);
            TestCoordELEvaluator.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        expr = "<frequency=120";
        TestCoordELEvaluator.assertEquals((String)expr, (String)CoordELFunctions.evalAndWrap((ELEvaluator)eval, (String)expr));
    }

    public void testCreateURIELEvaluator() throws Exception {
        ELEvaluator eval = CoordELEvaluator.createURIELEvaluator((String)"2009-08-09T23:59Z");
        String expr = "hdfs://p1/p2/${YEAR}/${MONTH}/${DAY}/${HOUR}/${MINUTE}/";
        TestCoordELEvaluator.assertEquals((String)"hdfs://p1/p2/2009/08/09/23/59/", (String)CoordELFunctions.evalAndWrap((ELEvaluator)eval, (String)expr));
        expr = "hdfs://p1/p2/${YEAR}/${MONTH}/${DAY}/${MINUTE}/";
        TestCoordELEvaluator.assertEquals((String)"hdfs://p1/p2/2009/08/09/59/", (String)CoordELFunctions.evalAndWrap((ELEvaluator)eval, (String)expr));
    }

    public void testCreateDataEvaluator() throws Exception {
        String jobXml = "<coordinator-app name=\"mycoordinator-app\" start=\"2009-02-01T01:00GMT\" end=\"2009-02-03T23:59GMT\" timezone=\"UTC\"";
        jobXml = jobXml + " frequency=\"720\" freq_timeunit=\"MINUTE\"";
        jobXml = jobXml + " action-nominal-time='2009-09-01T00:00Z' action-actual-time='2010-10-01T00:00Z'>";
        jobXml = jobXml + "<input-events><data-in name=\"A\" dataset=\"a\"><uris>file:///tmp/coord/US/2009/1/30|file:///tmp/coord/US/2009/1/31</uris>";
        jobXml = jobXml + "<dataset name=\"a\" frequency=\"1440\" initial-instance=\"2009-01-01T00:00Z\">";
        jobXml = jobXml + "<uri-template>file:///tmp/coord/US/${YEAR}/${MONTH}/${DAY}</uri-template></dataset></data-in></input-events>";
        jobXml = jobXml + "<action><workflow><url>http://foobar.com:8080/oozie</url><app-path>hdfs://foobarfoobar.com:9000/usr/tucu/mywf</app-path>";
        jobXml = jobXml + "<configuration><property><name>inputA</name><value>${coord:dataIn('A')}</value></property>";
        jobXml = jobXml + "<property><name>ACTIONID</name><value>${coord:actionId()}</value></property>";
        jobXml = jobXml + "<property><name>NAME</name><value>${coord:name()}</value></property>";
        jobXml = jobXml + "<property><name>NOMINALTIME</name><value>${coord:nominalTime()}</value></property>";
        jobXml = jobXml + "<property><name>ACTUALTIME</name><value>${coord:actualTime()}</value></property>";
        jobXml = jobXml + "</configuration></workflow></action></coordinator-app>";
        String reply = "<action><workflow><url>http://foobar.com:8080/oozie</url><app-path>hdfs://foobarfoobar.com:9000/usr/tucu/mywf</app-path>";
        reply = reply + "<configuration><property><name>inputA</name><value>file:///tmp/coord/US/2009/1/30|file:///tmp/coord/US/2009/1/31</value></property>";
        reply = reply + "<property><name>ACTIONID</name><value>00000-oozie-C@1</value></property>";
        reply = reply + "<property><name>NAME</name><value>mycoordinator-app</value></property>";
        reply = reply + "<property><name>NOMINALTIME</name><value>2009-09-01T00:00Z</value></property>";
        reply = reply + "<property><name>ACTUALTIME</name><value>2010-10-01T00:00Z</value></property>";
        reply = reply + "</configuration></workflow></action>";
        Element eJob = XmlUtils.parseXml((String)jobXml);
        XConfiguration conf = new XConfiguration((Reader)new StringReader(this.getConfString()));
        ELEvaluator eval = CoordELEvaluator.createDataEvaluator((Element)eJob, (Configuration)conf, (String)"00000-oozie-C@1");
        Element action = eJob.getChild("action", eJob.getNamespace());
        String str = XmlUtils.prettyPrint((Element)action).toString();
        TestCoordELEvaluator.assertEquals((String)XmlUtils.prettyPrint((Element)XmlUtils.parseXml((String)reply)).toString(), (String)CoordELFunctions.evalAndWrap((ELEvaluator)eval, (String)str));
    }

    public void testCreateInstancesELEvaluator() throws Exception {
        String dataEvntXML = "<data-in name=\"A\" dataset=\"a\"><uris>file:///tmp/coord/US/2009/1/30|file:///tmp/coord/US/2009/1/31</uris>";
        dataEvntXML = dataEvntXML + "<dataset name=\"a\" frequency=\"1440\" initial-instance=\"2009-01-01T00:00Z\" freq_timeunit=\"MINUTE\" timezone=\"UTC\" end_of_duration=\"NONE\">";
        dataEvntXML = dataEvntXML + "<uri-template>file:///tmp/coord/US/${YEAR}/${MONTH}/${DAY}</uri-template></dataset></data-in>";
        Element event = XmlUtils.parseXml((String)dataEvntXML);
        SyncCoordAction appInst = new SyncCoordAction();
        appInst.setNominalTime(DateUtils.parseDateOozieTZ((String)"2009-09-08T01:00Z"));
        appInst.setActualTime(DateUtils.parseDateOozieTZ((String)"2010-10-01T00:00Z"));
        appInst.setTimeUnit(TimeUnit.MINUTE);
        XConfiguration conf = new XConfiguration((Reader)new StringReader(this.getConfString()));
        ELEvaluator eval = CoordELEvaluator.createInstancesELEvaluator((Element)event, (SyncCoordAction)appInst, (Configuration)conf);
        String expr = "${coord:current(0)}";
        TestCoordELEvaluator.assertEquals((String)"2009-09-08T00:00Z", (String)((String)eval.evaluate(expr, String.class)));
    }

    public void testCreateLazyEvaluator() throws Exception {
        String testCaseDir = this.getTestCaseDir();
        XConfiguration conf = new XConfiguration((Reader)new StringReader(this.getConfString()));
        Date actualTime = DateUtils.parseDateOozieTZ((String)"2009-09-01T01:00Z");
        Date nominalTime = DateUtils.parseDateOozieTZ((String)"2009-09-01T00:00Z");
        String dataEvntXML = "<data-in name=\"A\" dataset=\"a\"><uris>" + this.getTestCaseFileUri("US/2009/1/30") + "|file:///tmp/coord/US/2009/1/31</uris>";
        dataEvntXML = dataEvntXML + "<dataset name=\"a\" frequency=\"1440\" initial-instance=\"2009-01-01T00:00Z\"  freq_timeunit=\"MINUTE\" timezone=\"UTC\" end_of_duration=\"NONE\">";
        dataEvntXML = dataEvntXML + "<uri-template>" + this.getTestCaseFileUri("${YEAR}/${MONTH}/${DAY}") + "</uri-template></dataset></data-in>";
        Element dEvent = XmlUtils.parseXml((String)dataEvntXML);
        ELEvaluator eval = CoordELEvaluator.createLazyEvaluator((Date)actualTime, (Date)nominalTime, (Element)dEvent, (Configuration)conf);
        this.createTestCaseSubDir("2009/01/02/_SUCCESS".split("/"));
        String expr = "${coord:latest(0)} ${coord:latest(-1)}";
        TestCoordELEvaluator.assertEquals((String)"2009-01-02T00:00Z ${coord:latest(-1)}", (String)((String)eval.evaluate(expr, String.class)));
        this.createTestCaseSubDir("2009/09/04/_SUCCESS".split("/"));
        this.createTestCaseSubDir("2009/09/05/_SUCCESS".split("/"));
        expr = "${coord:future(1, 30)}";
        TestCoordELEvaluator.assertEquals((String)"2009-09-05T00:00Z", (String)((String)eval.evaluate(expr, String.class)));
    }

    public void testCleanup() throws Exception {
        Services.get().destroy();
    }

    private String getConfString() {
        StringBuilder conf = new StringBuilder();
        conf.append("<configuration> <property><name>baseFsURI</name> <value>file:///tmp/coord/</value> </property>");
        conf.append("<property><name>language</name> <value>en</value> </property>");
        conf.append("<property> <name>country</name>  <value>US</value>  </property> <property> <name>market</name> <value>teens</value> </property> <property>  <name>app_path</name> <value>file:///tmp/coord/workflows</value> </property> <property> <name>start</name> <value>2009-02-01T01:00Z</value> </property><property> <name>end</name> <value>2009-02-03T23:59Z</value> </property> <property> <name>timezone</name> <value>UTC</value> </property> <property> <name>user.name</name> <value>test_user</value> </property> <property> <name>timeout</name>  <value>180</value>  </property> <property> <name>concurrency_level</name> <value>1</value> </property> <property> <name>execution_order</name> <value>LIFO</value> </property><property> <name>include_ds_files</name>  <value>file:///homes/" + TestCoordELEvaluator.getTestUser() + "/workspace/oozie-main/core/src/main/java/org/apache/oozie/coord/datasets.xml</value> </property></configuration>");
        return conf.toString();
    }
}

