/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.coord.input.logic;

import junit.framework.TestCase;
import org.apache.oozie.coord.input.logic.InputLogicParser;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.jdom.JDOMException;

public class TestInputLogicParser
extends TestCase {
    public void testAndOr() throws JDOMException {
        String xml = "<input-logic><and><or><data-in dataset=\"A\"/> <data-in dataset=\"B\"/> </or><or><data-in dataset=\"C\"/><data-in dataset=\"D\"/></or></and></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"((dependencyBuilder.input(\"A\").build() || dependencyBuilder.input(\"B\").build()) && (dependencyBuilder.input(\"C\").build() || dependencyBuilder.input(\"D\").build()))", (String)inputLogicParser.parse(root));
    }

    public void testAnd() throws JDOMException {
        String xml = "<input-logic><and><data-in dataset=\"A\"/> <data-in dataset=\"B\"/></and></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(dependencyBuilder.input(\"A\").build() && dependencyBuilder.input(\"B\").build())", (String)inputLogicParser.parse(root));
    }

    public void testOr() throws JDOMException {
        String xml = "<input-logic><or><data-in dataset=\"A\"/> <data-in dataset=\"B\"/></or></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(dependencyBuilder.input(\"A\").build() || dependencyBuilder.input(\"B\").build())", (String)inputLogicParser.parse(root));
    }

    public void testOrWithMin() throws JDOMException {
        String xml = "<input-logic><or><data-in dataset=\"A\" min=\"3\"/> <data-in dataset=\"B\"/></or></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(dependencyBuilder.input(\"A\").min(3).build() || dependencyBuilder.input(\"B\").build())", (String)inputLogicParser.parse(root));
    }

    public void testOrWithMinAtOr() throws JDOMException {
        String xml = "<input-logic><or min=\"10\"><data-in dataset=\"A\"/> <data-in dataset=\"B\"/></or></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(dependencyBuilder.input(\"A\").min(10).build() || dependencyBuilder.input(\"B\").min(10).build())", (String)inputLogicParser.parse(root));
    }

    public void testWithName() throws JDOMException {
        String xml = "<input-logic><or name =\"test\" min=\"10\"><data-in dataset=\"A\"/> <data-in dataset=\"B\"/></or></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(dependencyBuilder.input(\"A\").min(10).build() || dependencyBuilder.input(\"B\").min(10).build())", (String)inputLogicParser.parseWithName(root, "test"));
    }

    public void testCombine() throws JDOMException {
        String xml = "<input-logic><combine name =\"test\" min=\"10\"><data-in dataset=\"A\"/> <data-in dataset=\"B\"/></combine></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(dependencyBuilder.combine(\"A\",\"B\").min(10).build())", (String)inputLogicParser.parseWithName(root, "test"));
    }

    public void testWithNameNested() throws JDOMException {
        String xml = "<input-logic><and><or><data-in dataset=\"A\"/> <data-in dataset=\"B\"/> </or><or name=\"test\"><data-in dataset=\"C\"/><data-in dataset=\"D\"/></or></and></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(dependencyBuilder.input(\"C\").build() || dependencyBuilder.input(\"D\").build())", (String)inputLogicParser.parseWithName(root, "test"));
    }

    public void testDepth2() throws JDOMException {
        String xml = "<input-logic><and><and><or><data-in dataset=\"A\"/><data-in dataset=\"B\"/></or><or><data-in dataset=\"C\"/><data-in dataset=\"D\"/></or></and><and><data-in dataset=\"E\"/><data-in dataset=\"F\"/></and></and></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(((dependencyBuilder.input(\"A\").build() || dependencyBuilder.input(\"B\").build()) && (dependencyBuilder.input(\"C\").build() || dependencyBuilder.input(\"D\").build())) && (dependencyBuilder.input(\"E\").build() && dependencyBuilder.input(\"F\").build()))", (String)inputLogicParser.parse(root));
    }

    public void testDepth2WithCombine() throws JDOMException {
        String xml = "<input-logic><and><and><combine><data-in dataset=\"A\" /><data-in dataset=\"B\" /></combine><or><data-in dataset=\"C\" /><data-in dataset=\"D\" /></or></and><combine><data-in dataset=\"E\" /><data-in dataset=\"F\" /></combine></and></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(((dependencyBuilder.combine(\"A\",\"B\").build()) && (dependencyBuilder.input(\"C\").build() || dependencyBuilder.input(\"D\").build())) && (dependencyBuilder.combine(\"E\",\"F\").build()))", (String)inputLogicParser.parse(root));
    }

    public void testAndCombine() throws JDOMException {
        String xml = "<input-logic><and><combine><data-in dataset=\"A\" /><data-in dataset=\"B\" /></combine><combine><data-in dataset=\"C\" /><data-in dataset=\"D\" /></combine></and></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"((dependencyBuilder.combine(\"A\",\"B\").build()) && (dependencyBuilder.combine(\"C\",\"D\").build()))", (String)inputLogicParser.parse(root));
    }

    public void testComplex1() throws JDOMException {
        String xml = "<input-logic><and name=\"test\"><or><and><data-in dataset=\"A\" /><data-in dataset=\"B\" /></and><and><data-in dataset=\"C\" /><data-in dataset=\"D\" /></and></or><and><data-in dataset=\"A\" /><data-in dataset=\"B\" /></and></and></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(((dependencyBuilder.input(\"A\").build() && dependencyBuilder.input(\"B\").build()) || (dependencyBuilder.input(\"C\").build() && dependencyBuilder.input(\"D\").build())) && (dependencyBuilder.input(\"A\").build() && dependencyBuilder.input(\"B\").build()))", (String)inputLogicParser.parse(root));
    }

    public void testAllAnd() throws JDOMException {
        String xml = "<input-logic><and name=\"test\"><data-in dataset=\"A\" /><data-in dataset=\"B\" /><data-in dataset=\"C\" /><data-in dataset=\"D\" /><data-in dataset=\"E\" /><data-in dataset=\"F\" /></and></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(dependencyBuilder.input(\"A\").build() && dependencyBuilder.input(\"B\").build() && dependencyBuilder.input(\"C\").build() && dependencyBuilder.input(\"D\").build() && dependencyBuilder.input(\"E\").build() && dependencyBuilder.input(\"F\").build())", (String)inputLogicParser.parse(root));
    }

    public void testDataIn() throws JDOMException {
        String xml = "<input-logic><data-in dataset=\"A\" /></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"dependencyBuilder.input(\"A\").build()", (String)inputLogicParser.parse(root));
    }

    public void testMinWait() throws JDOMException {
        String xml = "<input-logic><and name=\"test\" min=\"3\" wait=\"10\"><data-in dataset=\"A\"/> <data-in dataset=\"B\"/></and></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"(dependencyBuilder.input(\"A\").min(3).inputWait(10).build() && dependencyBuilder.input(\"B\").min(3).inputWait(10).build())", (String)inputLogicParser.parseWithName(root, "test"));
        TestInputLogicParser.assertEquals((String)"(dependencyBuilder.input(\"A\").min(3).inputWait(10).build() && dependencyBuilder.input(\"B\").min(3).inputWait(10).build())", (String)inputLogicParser.parse(root));
    }

    public void testOrAndDataIn() throws JDOMException {
        String xml = "<input-logic><or><and><data-in dataset=\"A\"/> <data-in dataset=\"B\"/></and><data-in dataset=\"C\"/></or></input-logic>";
        Element root = XmlUtils.parseXml((String)xml);
        InputLogicParser inputLogicParser = new InputLogicParser();
        TestInputLogicParser.assertEquals((String)"((dependencyBuilder.input(\"A\").build() && dependencyBuilder.input(\"B\").build()) || dependencyBuilder.input(\"C\").build())", (String)inputLogicParser.parse(root));
    }
}

