/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.dependency;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.test.XFsTestCase;
import org.junit.Test;

public class TestFSURIHandler
extends XFsTestCase {
    private Services services = null;
    private URIHandlerService uriService;
    private JobConf conf;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.uriService = (URIHandlerService)this.services.get(URIHandlerService.class);
        this.conf = this.createJobConf();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testExists() throws Exception {
        Path path1 = new Path(this.getFsTestCaseDir() + "/2012/12/02/");
        Path path2 = new Path(this.getFsTestCaseDir() + "/2012/12/12/");
        this.getFileSystem().mkdirs(path1);
        URIHandler handler = this.uriService.getURIHandler(path1.toUri());
        TestFSURIHandler.assertTrue((boolean)handler.exists(path1.toUri(), (Configuration)this.conf, TestFSURIHandler.getTestUser()));
        TestFSURIHandler.assertFalse((boolean)handler.exists(path2.toUri(), (Configuration)this.conf, TestFSURIHandler.getTestUser()));
        handler = this.uriService.getURIHandler(path1.toUri(), false);
        TestFSURIHandler.assertTrue((boolean)handler.exists(new URI(path1.toUri().getPath()), (Configuration)this.conf, TestFSURIHandler.getTestUser()));
    }
}

