/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.dependency;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.dependency.FSURIHandler;
import org.apache.oozie.dependency.HCatURIHandler;
import org.apache.oozie.dependency.URIHandler;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.URIHandlerService;
import org.apache.oozie.test.XHCatTestCase;
import org.junit.Test;

public class TestHCatURIHandler
extends XHCatTestCase {
    private Services services;
    private URIHandlerService uriService;
    private JobConf conf;
    private static final String db = "db1";
    private static final String table = "table1";

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.getConf().set("oozie.service.URIHandlerService.uri.handlers", FSURIHandler.class.getName() + "," + HCatURIHandler.class.getName());
        this.services.setService(HCatAccessorService.class);
        this.services.init();
        this.conf = this.createJobConf();
        this.uriService = (URIHandlerService)Services.get().get(URIHandlerService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private void createTestTable() throws Exception {
        this.dropTable(db, table, true);
        this.dropDatabase(db, true);
        this.createDatabase(db);
        this.createTable(db, table, "year,month,dt,country");
    }

    private void dropTestTable() throws Exception {
        this.dropTable(db, table, false);
        this.dropDatabase(db, false);
    }

    @Test
    public void testExists() throws Exception {
        this.setSystemProperty("oozie.test.user.test", System.getProperty("user.name"));
        this.createTestTable();
        this.addPartition(db, table, "year=2012;month=12;dt=02;country=us");
        URI hcatURI = this.getHCatURI(db, table, "country=us;year=2012;month=12;dt=02");
        URIHandler handler = this.uriService.getURIHandler(hcatURI);
        TestHCatURIHandler.assertTrue((boolean)handler.exists(hcatURI, (Configuration)this.conf, TestHCatURIHandler.getTestUser()));
        hcatURI = this.getHCatURI(db, table, "year=2012;month=12");
        TestHCatURIHandler.assertTrue((boolean)handler.exists(hcatURI, (Configuration)this.conf, TestHCatURIHandler.getTestUser()));
        this.addPartition(db, table, "year=2012;month=12;dt=03;country=us");
        hcatURI = this.getHCatURI(db, table, "country=us;month=12");
        TestHCatURIHandler.assertTrue((boolean)handler.exists(hcatURI, (Configuration)this.conf, TestHCatURIHandler.getTestUser()));
        hcatURI = this.getHCatURI(db, table, "country=us");
        TestHCatURIHandler.assertTrue((boolean)handler.exists(hcatURI, (Configuration)this.conf, TestHCatURIHandler.getTestUser()));
        hcatURI = this.getHCatURI(db, table, "dt=02");
        TestHCatURIHandler.assertTrue((boolean)handler.exists(hcatURI, (Configuration)this.conf, TestHCatURIHandler.getTestUser()));
        hcatURI = this.getHCatURI(db, table, "dt=05");
        TestHCatURIHandler.assertFalse((boolean)handler.exists(hcatURI, (Configuration)this.conf, TestHCatURIHandler.getTestUser()));
        hcatURI = this.getHCatURI(db, table, "month=02;dt=02");
        TestHCatURIHandler.assertFalse((boolean)handler.exists(hcatURI, (Configuration)this.conf, TestHCatURIHandler.getTestUser()));
        this.addPartition(db, table, "year=2012;month=12;dt=04;country=us");
        hcatURI = this.getHCatURI(db, table, "country=us;year=2012;month=12;dt=04");
        TestHCatURIHandler.assertTrue((boolean)handler.exists(hcatURI, (Configuration)this.conf, TestHCatURIHandler.getTestUser()));
        ((HCatURIHandler)handler).delete(hcatURI, (Configuration)this.conf, TestHCatURIHandler.getTestUser());
        TestHCatURIHandler.assertFalse((boolean)handler.exists(hcatURI, (Configuration)this.conf, TestHCatURIHandler.getTestUser()));
        this.dropTestTable();
    }
}

