/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionGetForExternalIdJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordActionGetForExternalIdJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionGet() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.createCoordAction(job.getId(), actionNum, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        action.setSlaXml(XDataTestCase.slaXml);
        this.insertRecordCoordAction(action);
        this._testGetActionByExternalId(action.getId(), job.getId(), CoordinatorAction.Status.WAITING, 0, action.getId() + "_E", XDataTestCase.slaXml);
    }

    private void _testGetActionByExternalId(String actionId, String jobId, CoordinatorAction.Status status, int pending, String extId, String slaXml) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordActionGetForExternalIdJPAExecutor.assertNotNull((Object)jpaService);
            CoordActionGetForExternalIdJPAExecutor actionGetCmd = new CoordActionGetForExternalIdJPAExecutor(extId);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)actionGetCmd);
            TestCoordActionGetForExternalIdJPAExecutor.assertNotNull((Object)action);
            TestCoordActionGetForExternalIdJPAExecutor.assertEquals((String)actionId, (String)action.getId());
            TestCoordActionGetForExternalIdJPAExecutor.assertEquals((Object)status, (Object)action.getStatus());
            TestCoordActionGetForExternalIdJPAExecutor.assertEquals((int)pending, (int)action.getPending());
            TestCoordActionGetForExternalIdJPAExecutor.assertEquals((String)extId, (String)action.getExternalId());
            TestCoordActionGetForExternalIdJPAExecutor.assertEquals((String)slaXml, (String)action.getSlaXml());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestCoordActionGetForExternalIdJPAExecutor.fail((String)("Unable to GET a record for COORD Action By External ID. actionId =" + actionId + " extID =" + extId));
        }
    }
}

