/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionGetForTimeoutJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.XmlUtils;

public class TestCoordActionGetForTimeoutJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionGet() throws Exception {
        int actionNum = 1;
        String resourceXmlName = "coord-action-get.xml";
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.createCoordAction(job.getId(), actionNum, CoordinatorAction.Status.WAITING, resourceXmlName, 1);
        this.insertRecordCoordAction(action);
        Path appPath = new Path(this.getFsTestCaseDir(), "coord");
        Configuration conf = this.getCoordConf(appPath);
        this._testGetForInputCheckX(action.getId(), job.getId(), CoordinatorAction.Status.WAITING, XmlUtils.prettyPrint((Configuration)conf).toString(), 1);
    }

    private void _testGetForInputCheckX(String actionId, String jobId, CoordinatorAction.Status status, String runConf, int pending) throws Exception {
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordActionGetForTimeoutJPAExecutor.assertNotNull((Object)jpaService);
            CoordActionGetForTimeoutJPAExecutor actionGetCmd = new CoordActionGetForTimeoutJPAExecutor(actionId);
            CoordinatorActionBean action = (CoordinatorActionBean)jpaService.execute((JPAExecutor)actionGetCmd);
            TestCoordActionGetForTimeoutJPAExecutor.assertNotNull((Object)action);
            TestCoordActionGetForTimeoutJPAExecutor.assertEquals((String)actionId, (String)action.getId());
            TestCoordActionGetForTimeoutJPAExecutor.assertEquals((String)jobId, (String)action.getJobId());
            TestCoordActionGetForTimeoutJPAExecutor.assertEquals((Object)status, (Object)action.getStatus());
            TestCoordActionGetForTimeoutJPAExecutor.assertEquals((String)runConf, (String)action.getRunConf());
            TestCoordActionGetForTimeoutJPAExecutor.assertEquals((int)pending, (int)action.getPending());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            TestCoordActionGetForTimeoutJPAExecutor.fail((String)("Unable to GET a record for COORD Action By External ID. actionId =" + actionId));
        }
    }
}

